/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.metallurgy.blast_furnace;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.machinery.metallurgy.blast_furnace.BlastFurnaceHatchBlockEntity;
import com.drmangotea.tfmg.content.machinery.metallurgy.blast_furnace.util.BlastFurnaceValidator;
import com.drmangotea.tfmg.datagen.TFMGDamageSources;
import com.drmangotea.tfmg.recipes.IndustrialBlastingRecipe;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.simibubi.create.Create;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class BlastFurnaceOutputBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public SmartInventory inputInventory;
    public SmartInventory fluxInventory;
    public SmartInventory fuelInventory;
    public FluidTank primaryTank;
    public FluidTank secondaryTank;
    protected LazyOptional<IFluidHandler> fluidCapability;
    public LazyOptional<IItemHandlerModifiable> itemCapability;
    public int fuel = 0;
    public int fuelConsumeTimer = 0;
    public float duration;
    public int timer = -1;
    public BlockPos tuyerePos;
    public BlastFurnaceHatchBlockEntity tuyereBE = null;
    public static final int STORAGE_SPACE = 64;
    public LerpedFloat coalCokeHeight = LerpedFloat.linear();
    boolean isReinforced = false;
    boolean isActive = false;

    public BlastFurnaceOutputBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
        this.inputInventory = new SmartInventory(1, (SyncedBlockEntity)this).forbidInsertion().forbidExtraction().withMaxStackSize(64);
        this.fluxInventory = new SmartInventory(1, (SyncedBlockEntity)this).forbidInsertion().forbidExtraction().withMaxStackSize(64).whenContentsChanged(i -> this.onContentsChanged());
        this.fuelInventory = new SmartInventory(1, (SyncedBlockEntity)this).forbidInsertion().withMaxStackSize(64).whenContentsChanged(i -> this.onContentsChanged());
        this.primaryTank = new SmartFluidTank(4000, this::onFluidChanged);
        this.secondaryTank = new SmartFluidTank(4000, this::onFluidChanged);
        this.itemCapability = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.fluxInventory, this.fuelInventory}));
        this.fluidCapability = LazyOptional.of(() -> new CombinedTankWrapper(new IFluidHandler[]{this.primaryTank, this.secondaryTank}));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    private void onFluidChanged(FluidStack stack) {
        if (!this.m_58898_()) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.sendData();
        }
    }

    public void onContentsChanged() {
        if (!this.inputInventory.m_7983_() && this.timer == -1) {
            this.executeRecipe();
        }
    }

    private int calculateProcessingTime(IndustrialBlastingRecipe recipe) {
        int baseDuration = recipe.getProcessingDuration() * 20;
        double timeModifier = (double)((Integer)TFMGConfigs.common().machines.blastFurnaceMaxHeight.get()).intValue() / ((double)(baseDuration / 2) * (Double)TFMGConfigs.common().machines.blastFurnaceHeightSpeedModifier.get());
        int actualTicks = (int)((double)baseDuration - (double)this.getSize() / timeModifier);
        return this.isReinforced ? actualTicks / 2 : actualTicks;
    }

    private int[] findCleanRatio(IndustrialBlastingRecipe recipe) {
        int ticksPerFuel = (Integer)TFMGConfigs.common().machines.blastFurnaceFuelConsumption.get();
        int actualTicks = this.calculateProcessingTime(recipe);
        float exactRatio = (float)ticksPerFuel / (float)actualTicks;
        int maxIterations = 1000;
        float tolerance = 1.0E-4f;
        int a = 1;
        int b = 1;
        float currentError = Math.abs(exactRatio - (float)a / (float)b);
        for (int i = 0; i < maxIterations && currentError > tolerance; ++i) {
            if ((float)a / (float)b < exactRatio) {
                ++a;
            } else {
                ++b;
            }
            currentError = Math.abs(exactRatio - (float)a / (float)b);
        }
        boolean needsFlux = recipe.m_7527_().size() > 1;
        return new int[]{b, a, needsFlux ? a : 0};
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Optional recipeOpt;
        CreateLang.translate((String)"goggles.blast_furnace.stats", (Object[])new Object[]{this.inputInventory.getStackInSlot(0).m_41613_()}).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        CreateLang.translate((String)"goggles.blast_furnace.height", (Object[])new Object[]{this.getSize()}).forGoggles(tooltip, 1);
        CreateLang.translate((String)"goggles.blast_furnace.fuel_amount", (Object[])new Object[]{this.fuel}).forGoggles(tooltip, 1);
        if (this.timer != -1) {
            CreateLang.translate((String)"goggles.blast_furnace.timer", (Object[])new Object[]{this.timer}).style(ChatFormatting.GOLD).forGoggles(tooltip, 1);
        }
        if (this.isReinforced) {
            CreateLang.translate((String)"goggles.blast_furnace.reinforced", (Object[])new Object[0]).style(ChatFormatting.GREEN).forGoggles(tooltip);
        }
        if (!this.inputInventory.m_7983_() && (recipeOpt = TFMGRecipeTypes.INDUSTRIAL_BLASTING.find(new RecipeWrapper((IItemHandlerModifiable)this.inputInventory), this.f_58857_)).isPresent()) {
            IndustrialBlastingRecipe recipe = (IndustrialBlastingRecipe)((Object)recipeOpt.get());
            int[] batch = this.findCleanRatio(recipe);
            CreateLang.translate((String)"goggles.blast_furnace.batch_header", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            CreateLang.translate((String)"goggles.blast_furnace.batch_ratio", (Object[])new Object[]{batch[0], batch[1], batch[2]}).style(ChatFormatting.AQUA).forGoggles(tooltip);
            if (batch[1] > 64) {
                CreateLang.translate((String)"goggles.blast_furnace.batch_warning", (Object[])new Object[0]).style(ChatFormatting.YELLOW).forGoggles(tooltip);
            }
        }
        TFMGUtils.createFluidTooltip((BlockEntity)this, tooltip);
        TFMGUtils.createItemTooltip((BlockEntity)this, tooltip);
        return true;
    }

    public void executeRecipe() {
        Optional optional = TFMGRecipeTypes.INDUSTRIAL_BLASTING.find(new RecipeWrapper((IItemHandlerModifiable)this.inputInventory), this.f_58857_);
        if (optional.isEmpty()) {
            return;
        }
        IndustrialBlastingRecipe recipe = (IndustrialBlastingRecipe)((Object)optional.get());
        if (recipe.m_7527_().size() > 1 && !((Ingredient)recipe.m_7527_().get(1)).test(this.fluxInventory.m_8020_(0))) {
            return;
        }
        if (this.fluxInventory.m_8020_(0).m_41613_() < recipe.m_7527_().size() - 1) {
            return;
        }
        int baseDuration = recipe.getProcessingDuration() * 20;
        int heigth = this.getSize();
        int maxHeigth = (Integer)TFMGConfigs.common().machines.blastFurnaceMaxHeight.get();
        double maxTimeModifier = (Double)TFMGConfigs.common().machines.blastFurnaceHeightSpeedModifier.get();
        double timeModifier = (double)maxHeigth / ((double)(baseDuration / 2) * maxTimeModifier);
        this.timer = (int)((double)baseDuration - (double)heigth / timeModifier);
        if (this.isReinforced) {
            this.timer /= 2;
        }
    }

    private boolean isActuallyActive(IndustrialBlastingRecipe recipe) {
        return !(this.timer <= 0 || this.fuel <= 0 || !recipe.getFluidResults().isEmpty() && this.primaryTank.getSpace() < recipe.getPrimaryResult().getAmount() || recipe.getFluidResults().size() >= 2 && this.secondaryTank.getSpace() < recipe.getSecondaryResult().getAmount() || recipe.hotAirUsage > 0 && (this.tuyereBE == null || this.tuyereBE.tank.getFluidAmount() < recipe.hotAirUsage || !this.tuyereBE.tank.getFluid().getFluid().m_6212_((Fluid)TFMGFluids.HOT_AIR.getSource())));
    }

    public void tick() {
        ItemStack fuelStack;
        super.tick();
        if (this.f_58857_.f_46443_) {
            this.coalCokeHeight.chase((double)Math.min(this.fuel + this.inputInventory.getStackInSlot(0).m_41613_(), 24), (double)0.1f, LerpedFloat.Chaser.EXP);
            this.coalCokeHeight.tickChaser();
        }
        if (this.inputInventory.m_7983_()) {
            return;
        }
        if (this.getSize() < 3) {
            return;
        }
        Optional<IndustrialBlastingRecipe> optionalRecipe = TFMGRecipeTypes.INDUSTRIAL_BLASTING.find(new RecipeWrapper((IItemHandlerModifiable)this.inputInventory), this.f_58857_);
        if (this.fuel <= 0 && !this.fuelInventory.m_8020_(0).m_41619_() && (fuelStack = this.fuelInventory.m_8020_(0)).m_204117_(TFMGTags.TFMGItemTags.BLAST_FURNACE_FUEL.tag)) {
            int fuelValue = 1;
            int toConsume = Math.min(fuelStack.m_41613_(), 64 - this.fuel);
            this.fuel += toConsume * fuelValue;
            fuelStack.m_41774_(toConsume);
            this.m_6596_();
        }
        if (this.fuelConsumeTimer >= (Integer)TFMGConfigs.common().machines.blastFurnaceFuelConsumption.get() && this.fuel > 0) {
            this.fuelConsumeTimer = 0;
            --this.fuel;
        }
        if (this.timer > -1) {
            if (optionalRecipe.isEmpty()) {
                this.timer = -1;
                return;
            }
            IndustrialBlastingRecipe recipe = (IndustrialBlastingRecipe)((Object)optionalRecipe.get());
            if (this.timer == 0 && this.canProcess(recipe)) {
                if (this.primaryTank.getSpace() < recipe.getPrimaryResult().getAmount()) {
                    return;
                }
                if (recipe.getFluidResults().size() > 1 && this.secondaryTank.getSpace() < recipe.getSecondaryResult().getAmount()) {
                    return;
                }
                this.inputInventory.m_8020_(0).m_41774_(1);
                if (recipe.m_7527_().size() > 1) {
                    this.fluxInventory.m_8020_(0).m_41774_(recipe.m_7527_().size() - 1);
                }
                this.primaryTank.fill(recipe.getPrimaryResult(), IFluidHandler.FluidAction.EXECUTE);
                if (recipe.getFluidResults().size() > 1) {
                    this.secondaryTank.fill(recipe.getSecondaryResult(), IFluidHandler.FluidAction.EXECUTE);
                }
                this.timer = -1;
                this.sendData();
                this.m_6596_();
            }
            if (this.timer > 0 && this.fuel > 0) {
                BlockEntity blockEntity;
                if (recipe.hotAirUsage > 0) {
                    if (this.tuyerePos == null || !this.f_58857_.m_8055_(this.tuyerePos).m_60713_((Block)TFMGBlocks.BLAST_FURNACE_HATCH.get())) {
                        this.tuyereBE = null;
                        return;
                    }
                    if (this.tuyereBE == null) {
                        BlockEntity blockEntity2 = this.f_58857_.m_7702_(this.tuyerePos);
                        if (!(blockEntity2 instanceof BlastFurnaceHatchBlockEntity)) {
                            return;
                        }
                        BlastFurnaceHatchBlockEntity hatch = (BlastFurnaceHatchBlockEntity)blockEntity2;
                        this.tuyereBE = hatch;
                    }
                    if (this.tuyereBE.tank.getFluidAmount() < recipe.hotAirUsage || !this.tuyereBE.tank.getFluid().getFluid().m_6212_((Fluid)TFMGFluids.HOT_AIR.getSource())) {
                        return;
                    }
                    if (this.tuyereBE != null) {
                        this.tuyereBE.tank.getFluidInTank(0).setAmount(Math.max(this.tuyereBE.tank.getFluidInTank(0).getAmount() - recipe.hotAirUsage, 0));
                    }
                }
                if (!recipe.getGasByproduct().isEmpty() && (blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_()).m_6630_(this.getSize()))) instanceof BlastFurnaceHatchBlockEntity) {
                    BlastFurnaceHatchBlockEntity chargeHatchBE = (BlastFurnaceHatchBlockEntity)blockEntity;
                    chargeHatchBE.tank.fill(recipe.getGasByproduct(), IFluidHandler.FluidAction.EXECUTE);
                }
                if (this.f_58857_.m_5776_()) {
                    this.makeParticles();
                }
                this.hurtEntities();
                --this.timer;
                ++this.fuelConsumeTimer;
                if (!this.f_58857_.f_46443_) {
                    this.m_6596_();
                    this.sendData();
                }
            }
        }
        this.isActive = optionalRecipe.map(this::isActuallyActive).orElse(false);
    }

    public void makeParticles() {
        Random random = Create.RANDOM;
        Direction direction = ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_();
        BlockPos pos = this.m_58899_().m_7494_().m_121945_(direction);
        int shouldSpawnSmoke = random.nextInt(7);
        if (shouldSpawnSmoke == 0) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123778_, (double)((float)pos.m_123341_() + random.nextFloat(0.6f)) + 0.2, (double)(pos.m_123342_() + 1), (double)((float)pos.m_123343_() + random.nextFloat(0.6f)) + 0.2, 0.0, 0.08, 0.0);
        }
    }

    private boolean canProcess(IndustrialBlastingRecipe recipe) {
        if (!this.primaryTank.getFluid().isEmpty() && !this.primaryTank.getFluid().getFluid().m_6212_(recipe.getPrimaryResult().getFluid())) {
            return false;
        }
        return this.secondaryTank.getFluid().isEmpty() || this.secondaryTank.getFluid().getFluid().m_6212_(recipe.getSecondaryResult().getFluid());
    }

    public void lazyTick() {
        super.lazyTick();
        this.onContentsChanged();
        this.collectItems();
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_165893_((double)(this.m_58899_().m_123342_() + 2));
    }

    public void hurtEntities() {
        List entities = this.f_58857_.m_45976_(LivingEntity.class, new AABB(this.m_58899_().m_121945_(((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_()).m_7494_()));
        for (LivingEntity entity : entities) {
            if (entity.m_5825_()) continue;
            entity.m_20254_(15);
            if (!entity.m_6469_(TFMGDamageSources.blastFurnace(this.f_58857_), 4.0f)) continue;
            entity.m_5496_(SoundEvents.f_11909_, 0.4f, 2.0f + entity.m_217043_().m_188501_() * 0.4f);
        }
    }

    public void collectItems() {
        List items = this.f_58857_.m_45976_(ItemEntity.class, new AABB(this.m_58899_().m_121945_(((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_()).m_7494_()));
        if (items.isEmpty()) {
            return;
        }
        ItemStack itemStack = ((ItemEntity)items.get(0)).m_32055_();
        for (int i = 0; i < 64; ++i) {
            if (itemStack.m_41619_()) {
                return;
            }
            if (itemStack.m_204117_(TFMGTags.TFMGItemTags.BLAST_FURNACE_FUEL.tag)) {
                if (this.fuel >= 64) {
                    if (this.fuelInventory.m_8020_(0).m_41619_() || this.fuelInventory.m_8020_(0).m_150930_(itemStack.m_41720_()) && this.fuelInventory.m_8020_(0).m_41613_() < this.fuelInventory.m_8020_(0).m_41741_()) {
                        int added = Math.min(itemStack.m_41613_(), this.fuelInventory.m_8020_(0).m_41741_() - this.fuelInventory.m_8020_(0).m_41613_());
                        if (this.fuelInventory.m_8020_(0).m_41619_()) {
                            this.fuelInventory.m_6836_(0, new ItemStack((ItemLike)itemStack.m_41720_(), added));
                        } else {
                            this.fuelInventory.m_8020_(0).m_41769_(added);
                        }
                        itemStack.m_41774_(added);
                        continue;
                    }
                } else {
                    int toAdd = Math.min(itemStack.m_41613_(), 64 - this.fuel);
                    this.fuel += toAdd;
                    itemStack.m_41774_(toAdd);
                    continue;
                }
            }
            if (itemStack.m_204117_(TFMGTags.TFMGItemTags.FLUX.tag) && this.fluxInventory.m_8020_(0).m_41613_() < itemStack.m_41741_() && (this.fluxInventory.m_7983_() || this.fluxInventory.m_8020_(0).m_150930_(itemStack.m_41720_()))) {
                this.fluxInventory.m_6836_(0, new ItemStack((ItemLike)itemStack.m_41720_(), this.fluxInventory.m_8020_(0).m_41613_() + 1));
                itemStack.m_41774_(1);
                continue;
            }
            if (this.inputInventory.m_8020_(0).m_41613_() >= itemStack.m_41741_() || !this.inputInventory.m_7983_() && !this.inputInventory.m_8020_(0).m_150930_(itemStack.m_41720_())) continue;
            this.inputInventory.m_6836_(0, new ItemStack((ItemLike)itemStack.m_41720_(), this.inputInventory.m_8020_(0).m_41613_() + 1));
            itemStack.m_41774_(1);
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.isReinforced = compound.m_128471_("IsReinforce");
        this.inputInventory.deserializeNBT(compound.m_128469_("InputItems"));
        this.fluxInventory.deserializeNBT(compound.m_128469_("Flux"));
        this.fuelInventory.deserializeNBT(compound.m_128469_("FuelItems"));
        this.timer = compound.m_128451_("Timer");
        this.fuel = compound.m_128451_("Fuel");
        this.fuelConsumeTimer = compound.m_128451_("FuelConsumeTimer");
        this.primaryTank.readFromNBT(compound.m_128469_("PrimaryTankContent"));
        this.secondaryTank.readFromNBT(compound.m_128469_("SecondaryTankContent"));
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128379_("IsReinforce", this.isReinforced);
        compound.m_128365_("InputItems", (Tag)this.inputInventory.serializeNBT());
        compound.m_128365_("Flux", (Tag)this.fluxInventory.serializeNBT());
        compound.m_128365_("FuelItems", (Tag)this.fuelInventory.serializeNBT());
        compound.m_128405_("Timer", this.timer);
        compound.m_128405_("Fuel", this.fuel);
        compound.m_128405_("FuelConsumeTimer", this.fuelConsumeTimer);
        compound.m_128365_("PrimaryTankContent", (Tag)this.primaryTank.writeToNBT(new CompoundTag()));
        compound.m_128365_("SecondaryTankContent", (Tag)this.secondaryTank.writeToNBT(new CompoundTag()));
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inputInventory);
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.fluxInventory);
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.fuelInventory);
    }

    public int getSize() {
        if (this.m_58901_()) {
            return 0;
        }
        BlastFurnaceValidator validator = new BlastFurnaceValidator(this.m_58899_(), this.f_58857_);
        BlastFurnaceValidator.ValidationResult result = validator.validateFurnace();
        this.isReinforced = result.isReinforced();
        this.tuyerePos = validator.getTuyerePos();
        return result.height();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }
}

