/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.types.regular_engine;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.engines.base.EngineProperties;
import com.drmangotea.tfmg.content.engines.types.AbstractSmallEngineBlockEntity;
import com.drmangotea.tfmg.content.engines.types.regular_engine.PistonPosition;
import com.drmangotea.tfmg.content.engines.types.regular_engine.RegularEngineBlock;
import com.drmangotea.tfmg.content.engines.types.turbine_engine.TurbineEngineBlockEntity;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.drmangotea.tfmg.registry.TFMGSoundEvents;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class RegularEngineBlockEntity
extends AbstractSmallEngineBlockEntity {
    public EngineType type = this.getDefaultEngineType();
    public SmartInventory pistonInventory;
    List<TagKey<Fluid>> supportedFuels = new ArrayList<TagKey<Fluid>>();
    protected int soundTimer = 0;
    boolean updateFuel = true;

    public RegularEngineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.pistonInventory = this.createInventory();
    }

    public EngineType getDefaultEngineType() {
        return EngineType.I;
    }

    public void updateInventory() {
        this.pistonInventory = this.createInventory();
    }

    public SmartInventory createInventory() {
        return new SmartInventory(this.type.pistons.size(), (SyncedBlockEntity)this).withMaxStackSize(1).whenContentsChanged(this::onInventoryChanged);
    }

    private void onInventoryChanged(int integer) {
        this.refreshFuels();
        this.updateRotation();
        this.sendData();
        this.m_6596_();
    }

    public void refreshFuels() {
        CompoundTag fuelsToAllow = this.pistonInventory.m_8020_(0).m_41784_().m_128469_("Fuels");
        ArrayList fuelsFound = new ArrayList();
        for (String key : fuelsToAllow.m_128431_()) {
            String id = fuelsToAllow.m_128461_(key);
            TagKey tag = TFMGTags.optionalTag(ForgeRegistries.FLUIDS, new ResourceLocation(id));
            fuelsFound.add(tag);
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof RegularEngineBlockEntity) {
            RegularEngineBlockEntity be = (RegularEngineBlockEntity)blockEntity;
            be.supportedFuels = new ArrayList<TagKey<Fluid>>(fuelsFound);
            for (Long position : be.engines) {
                BlockPos pos = BlockPos.m_122022_((long)position);
                BlockEntity blockEntity2 = this.f_58857_.m_7702_(pos);
                if (!(blockEntity2 instanceof RegularEngineBlockEntity)) continue;
                RegularEngineBlockEntity be1 = (RegularEngineBlockEntity)blockEntity2;
                be1.supportedFuels = new ArrayList<TagKey<Fluid>>(fuelsFound);
            }
        }
    }

    @Override
    public List<TagKey<Fluid>> getSupportedFuels() {
        return this.supportedFuels;
    }

    @Override
    public boolean canWork() {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof RegularEngineBlockEntity) {
            RegularEngineBlockEntity controller = (RegularEngineBlockEntity)blockEntity;
            for (Long position : controller.getAllEngines()) {
                BlockEntity blockEntity2 = this.f_58857_.m_7702_(BlockPos.m_122022_((long)position));
                if (!(blockEntity2 instanceof RegularEngineBlockEntity)) continue;
                RegularEngineBlockEntity be = (RegularEngineBlockEntity)blockEntity2;
                for (int i = 0; i < be.pistonInventory.getSlots(); ++i) {
                    if (!be.pistonInventory.m_8020_(i).m_41619_()) continue;
                    return false;
                }
            }
            return super.canWork();
        }
        return false;
    }

    public boolean hasAllPistons() {
        for (Long position : this.getControllerBE().getAllEngines()) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(BlockPos.m_122022_((long)position));
            if (!(blockEntity instanceof RegularEngineBlockEntity)) continue;
            RegularEngineBlockEntity be = (RegularEngineBlockEntity)blockEntity;
            for (int i = 0; i < be.pistonInventory.getSlots(); ++i) {
                if (!be.pistonInventory.m_8020_(i).m_41619_()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public float calculateAddedStressCapacity() {
        float stress = super.calculateAddedStressCapacity() + this.torque;
        return this.hasTwoShafts() ? stress / 2.0f : (stress *= (float)this.pistonInventory.getSlots() / 2.0f);
    }

    @Override
    public boolean insertItem(ItemStack itemStack, boolean shifting, Player player, InteractionHand hand) {
        BlockEntity blockEntity;
        int i;
        if (itemStack.m_150930_((Item)AllItems.EMPTY_SCHEMATIC.get())) {
            if (this.type == EngineType.RADIAL || this.type == EngineType.TURBINE) {
                return false;
            }
            boolean next = false;
            if (this.type == EngineType.BOXER) {
                BlockEntity blockEntity2 = this.f_58857_.m_7702_(this.controller);
                if (blockEntity2 instanceof RegularEngineBlockEntity) {
                    RegularEngineBlockEntity be = (RegularEngineBlockEntity)blockEntity2;
                    be.updateEngineType(EngineType.I);
                }
                AllSoundEvents.CONFIRM.play(this.f_58857_, null, (Vec3i)this.m_58899_(), 1.0f, 1.0f);
                return true;
            }
            for (EngineType engineType : EngineType.values()) {
                if (next) {
                    BlockEntity blockEntity3 = this.f_58857_.m_7702_(this.controller);
                    if (blockEntity3 instanceof RegularEngineBlockEntity) {
                        RegularEngineBlockEntity be = (RegularEngineBlockEntity)blockEntity3;
                        be.updateEngineType(engineType);
                    }
                    AllSoundEvents.CONFIRM.play(this.f_58857_, null, (Vec3i)this.m_58899_(), 1.0f, 1.0f);
                    return true;
                }
                if (engineType != this.type) continue;
                next = true;
            }
        }
        if (itemStack.m_150930_((Item)TFMGItems.SCREWDRIVER.get())) {
            if (!this.pistonInventory.m_7983_()) {
                for (i = 0; i < this.pistonInventory.getSlots(); ++i) {
                    if (this.pistonInventory.m_8020_(i).m_41619_()) continue;
                    this.dropItem(this.pistonInventory.m_8020_(i));
                    this.pistonInventory.m_6836_(i, ItemStack.f_41583_);
                    this.playRemovalSound();
                    this.updateRotation();
                    this.m_6596_();
                    this.sendData();
                    return true;
                }
            }
            for (i = this.componentsInventory.components.size() - 1; i >= 0; --i) {
                if (this.componentsInventory.m_8020_(i).m_41619_()) continue;
                this.dropItem(this.componentsInventory.m_8020_(i));
                this.componentsInventory.m_6836_(i, ItemStack.f_41583_);
                this.playRemovalSound();
                this.updateRotation();
                this.m_6596_();
                this.sendData();
                return true;
            }
        }
        if (this.hasAllComponents() && this.isCorrectCylinder(itemStack) && this.isCylinderSame(itemStack)) {
            for (i = this.pistonInventory.getSlots() - 1; i >= 0; --i) {
                if (!this.pistonInventory.m_8020_(i).m_41619_()) continue;
                ItemStack toInsert = itemStack.m_41777_();
                toInsert.m_41764_(1);
                this.pistonInventory.m_6836_(i, toInsert);
                itemStack.m_41774_(1);
                this.playInsertionSound();
                this.updateRotation();
                this.m_6596_();
                this.sendData();
                return true;
            }
        }
        if (this.nextComponent().test(itemStack) && !this.isController() && (blockEntity = this.f_58857_.m_7702_(this.controller)) instanceof AbstractSmallEngineBlockEntity) {
            AbstractSmallEngineBlockEntity be = (AbstractSmallEngineBlockEntity)blockEntity;
            return be.insertItem(itemStack, shifting, player, hand);
        }
        return super.insertItem(itemStack, shifting, player, hand);
    }

    @Override
    public void remove() {
        super.remove();
        for (int i = 0; i < this.pistonInventory.getSlots(); ++i) {
            ItemStack stack = this.pistonInventory.m_8020_(i);
            this.dropItem(stack);
        }
    }

    public boolean isCorrectCylinder(ItemStack itemStack) {
        return itemStack.m_150930_((Item)TFMGItems.ENGINE_CYLINDER.get()) || itemStack.m_150930_((Item)TFMGItems.SIMPLE_ENGINE_CYLINDER.get()) || itemStack.m_150930_((Item)TFMGItems.DIESEL_ENGINE_CYLINDER.get());
    }

    public boolean isCylinderSame(ItemStack stack) {
        if (stack.m_150930_((Item)TFMGItems.TURBINE_BLADE.get())) {
            return true;
        }
        CompoundTag tag = stack.m_41784_().m_128469_("Fuels");
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof RegularEngineBlockEntity) {
            RegularEngineBlockEntity controller = (RegularEngineBlockEntity)blockEntity;
            ArrayList<Long> engines = new ArrayList<Long>(controller.engines);
            engines.add(this.controller.m_121878_());
            for (int i = 0; i < controller.engineLength() + 1; ++i) {
                BlockPos pos = BlockPos.m_122022_((long)((Long)engines.get(i)));
                BlockEntity blockEntity2 = this.f_58857_.m_7702_(pos);
                if (!(blockEntity2 instanceof RegularEngineBlockEntity)) continue;
                RegularEngineBlockEntity be = (RegularEngineBlockEntity)blockEntity2;
                for (int y = 0; y < be.pistonInventory.getSlots(); ++y) {
                    CompoundTag tagInside;
                    if (!be.pistonInventory.m_8020_(y).m_150930_((Item)TFMGItems.ENGINE_CYLINDER.get()) || (tagInside = be.pistonInventory.m_8020_(y).m_41784_().m_128469_("Fuels")).toString().equals(tag.toString())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            this.makeSound();
        }
        if (this.updateFuel) {
            this.refreshFuels();
            this.updateFuel = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void makeSound() {
        ++this.soundTimer;
        if (!this.isController()) {
            return;
        }
        if ((double)this.soundTimer > 1.0 / Math.min(6000.0, (double)this.rpm * 2.0E-4 * (double)this.pistonInventory.getSlots())) {
            this.soundTimer = 0;
            float randomPitch = (this.f_58857_.m_213780_().m_188501_() - 0.5f) * 0.05f;
            if (this instanceof TurbineEngineBlockEntity) {
                TFMGSoundEvents.ENGINE.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.06f * TFMGConfigs.common().machines.engineLoudness.getF(), 1.5f, false);
            } else {
                TFMGSoundEvents.ENGINE.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.1f * TFMGConfigs.common().machines.engineLoudness.getF(), 0.7f + randomPitch, false);
            }
        }
    }

    public boolean updateEngineType(EngineType newType) {
        RegularEngineBlockEntity be;
        BlockEntity blockEntity;
        BlockPos pos;
        int i;
        Direction updateDirection = (Direction)this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING);
        BlockEntity blockEntity2 = this.f_58857_.m_7702_(this.m_58899_().m_121945_(updateDirection));
        if (blockEntity2 instanceof RegularEngineBlockEntity) {
            RegularEngineBlockEntity be2 = (RegularEngineBlockEntity)blockEntity2;
            return be2.updateEngineType(newType);
        }
        for (i = 0; i <= this.engineLength(); ++i) {
            pos = this.m_58899_().m_5484_(updateDirection.m_122424_(), i);
            blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof RegularEngineBlockEntity)) continue;
            be = (RegularEngineBlockEntity)blockEntity;
            if (be.pistonInventory.m_7983_()) continue;
            return false;
        }
        for (i = 0; i <= this.engineLength(); ++i) {
            pos = this.m_58899_().m_5484_(updateDirection.m_122424_(), i);
            blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof RegularEngineBlockEntity)) continue;
            be = (RegularEngineBlockEntity)blockEntity;
            be.type = newType;
            be.updateInventory();
            this.f_58857_.m_46597_(pos, (BlockState)be.m_58900_().m_61124_((Property)RegularEngineBlock.EXTENDED, (Comparable)Boolean.valueOf(newType == EngineType.I || newType == EngineType.U)));
        }
        return true;
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128359_("Type", this.type.name);
        compound.m_128365_("Cylinders", (Tag)this.pistonInventory.serializeNBT());
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        for (EngineType engineType : EngineType.values()) {
            if (!engineType.name.matches(compound.m_128461_("Type"))) continue;
            this.type = engineType;
            break;
        }
        this.pistonInventory.deserializeNBT(compound.m_128469_("Cylinders"));
    }

    @Override
    public float efficiencyModifier() {
        return this.type.effeciencyModifier * this.getFuelType().getEfficiency() * this.getUpgradeEfficiencyModifier();
    }

    @Override
    public float speedModifier() {
        return this.type.speedModifier * this.getFuelType().getSpeed() * this.getUpgradeSpeedModifier();
    }

    @Override
    public float torqueModifier() {
        return this.type.torqueModifier * this.getFuelType().getStress() * this.getUpgradeTorqueModifier();
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!this.isController()) {
            return this.getControllerBE().addToGoggleTooltip(tooltip, isPlayerSneaking);
        }
        CreateLang.translate((String)"goggles.engine.header", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        if (this.nextComponent() != Ingredient.f_43901_) {
            CreateLang.translate((String)"goggles.engine.unfinished", (Object[])new Object[0]).color(14569552).forGoggles(tooltip);
            CreateLang.translate((String)"goggles.engine.next_component", (Object[])new Object[0]).add(Component.m_237119_().m_7220_(this.nextComponent().m_43908_()[0].m_41786_())).color(16773696).forGoggles(tooltip);
            CreateLang.translate((String)"goggles.engine.type", (Object[])new Object[0]).add(CreateLang.text((String)this.type.name())).color(16559363).forGoggles(tooltip);
            return true;
        }
        if (!this.hasAllPistons()) {
            CreateLang.translate((String)(this instanceof TurbineEngineBlockEntity ? "goggles.engine.turbines_missing" : "goggles.engine.pistons_missing"), (Object[])new Object[0]).color(14569552).forGoggles(tooltip);
            return true;
        }
        CreateLang.translate((String)"goggles.engine.type", (Object[])new Object[0]).add(CreateLang.text((String)this.type.name())).color(16559363).forGoggles(tooltip);
        CreateLang.translate((String)"goggles.engine.rpm", (Object[])new Object[0]).add(CreateLang.text((String)((int)this.rpm + " rpm"))).color(10710784).forGoggles(tooltip);
        CreateLang.translate((String)"goggles.engine.signal", (Object[])new Object[0]).add(CreateLang.text((String)String.valueOf(this.highestSignal))).color(16559363).forGoggles(tooltip);
        CreateLang.translate((String)"goggles.engine.torque", (Object[])new Object[0]).add(CreateLang.text((String)String.valueOf((int)this.torque))).color(10710784).forGoggles(tooltip);
        CreateLang.translate((String)"goggles.engine.fuel_consumption", (Object[])new Object[0]).add(CreateLang.text((String)((float)this.getFuelConsumption() / 1.5f + " mb/s"))).color(16559363).forGoggles(tooltip);
        if (this.oil > 0) {
            CreateLang.translate((String)"goggles.engine.oil", (Object[])new Object[0]).add(CreateLang.number((double)this.oil)).color(16112962).forGoggles(tooltip);
        }
        if (this.coolingFluid > 0) {
            CreateLang.translate((String)"goggles.engine.cooling_fluid", (Object[])new Object[0]).add(CreateLang.number((double)this.coolingFluid)).color(5356985).forGoggles(tooltip);
        }
        TFMGUtils.createFluidTooltip((BlockEntity)this, tooltip);
        return true;
    }

    @Override
    public int getFuelConsumption() {
        return super.getFuelConsumption() * (this.pistonInventory.getSlots() / 2);
    }

    @Override
    public String engineId() {
        return this.type.name;
    }

    public static enum EngineType {
        I("engine_i", EngineProperties.pistonsI(), 1.0f, 1.0f, 1.0f, true),
        V("engine_v", EngineProperties.pistonsV(), 1.2f, 1.3f, 0.8f),
        W("engine_w", EngineProperties.pistonsW(), 1.3f, 1.1f, 0.5f),
        U("engine_u", EngineProperties.pistonsU(), 1.0f, 1.5f, 0.9f, true),
        BOXER("engine_boxer", EngineProperties.pistonsBoxer(), 1.0f, 0.8f, 1.2f),
        RADIAL("radial", EngineProperties.pistonsRadial(), 1.0f, 0.8f, 1.2f),
        TURBINE("turbine", EngineProperties.pistonsTurbine(), 1.5f, 1.5f, 0.5f);

        public final float speedModifier;
        public final float torqueModifier;
        public final float effeciencyModifier;
        public final List<PistonPosition> pistons;
        public final List<Fluid> fluidBlacklist;
        public final String name;
        public final boolean upgradesOnSide;

        private EngineType(String name, List<PistonPosition> positions, float speedModifier, float torqueModifier, float efficiencyModifier, boolean upgradesOnSide) {
            this(name, positions, speedModifier, torqueModifier, efficiencyModifier, upgradesOnSide, new ArrayList<Fluid>());
        }

        private EngineType(String name, List<PistonPosition> positions, float speedModifier, float torqueModifier, float efficiencyModifier) {
            this(name, positions, speedModifier, torqueModifier, efficiencyModifier, false, new ArrayList<Fluid>());
        }

        private EngineType(String name, List<PistonPosition> positions, float speedModifier, float torqueModifier, float efficiencyModifier, boolean upgradesOnSide, List<Fluid> fluidBlacklist) {
            this.name = name;
            this.pistons = positions;
            this.speedModifier = speedModifier;
            this.torqueModifier = torqueModifier;
            this.effeciencyModifier = efficiencyModifier;
            this.fluidBlacklist = fluidBlacklist;
            this.upgradesOnSide = upgradesOnSide;
        }
    }
}

