/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.electric_switch;

import com.drmangotea.tfmg.content.electricity.utilities.diode.ElectricDiodeBlockEntity;
import com.drmangotea.tfmg.registry.TFMGSoundEvents;
import com.simibubi.create.Create;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ElectricSwitchBlockEntity
extends ElectricDiodeBlockEntity {
    int signal;
    boolean signalChanged;

    public ElectricSwitchBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.neighbourChanged();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.signalChanged) {
            this.signalChanged = false;
            this.analogSignalChanged(this.f_58857_.m_277086_(this.f_58858_));
        }
    }

    protected void analogSignalChanged(int newSignal) {
        this.signal = newSignal;
        this.updateInFrontNextTick();
        this.updateNextTick();
        if (this.f_58857_.m_5776_()) {
            if (this.signal == 0) {
                TFMGSoundEvents.SWITCH_OFF.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.8f + Create.RANDOM.nextFloat() * 0.4f, 0.8f + Create.RANDOM.nextFloat() * 0.4f, false);
            } else {
                TFMGSoundEvents.SWITCH_ON.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.8f + Create.RANDOM.nextFloat() * 0.4f, 0.8f + Create.RANDOM.nextFloat() * 0.4f, false);
            }
        }
    }

    public void neighbourChanged() {
        if (!this.m_58898_()) {
            return;
        }
        int power = this.f_58857_.m_277086_(this.f_58858_);
        if (power != this.signal) {
            this.signalChanged = true;
        }
    }

    @Override
    public int getOutputVoltage() {
        return (int)((float)this.data.getVoltage() * ((float)this.signal / 15.0f));
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_)).m_122424_();
    }
}

