/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.storage;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.storage.TFMGForgeEnergyStorage;
import com.drmangotea.tfmg.content.electricity.utilities.converter.ConverterBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class AccumulatorBlockEntity
extends ElectricBlockEntity {
    public TFMGForgeEnergyStorage energy = this.createEnergyStorage(1);
    private LazyOptional<IEnergyStorage> energyCapability = LazyOptional.empty();
    public int length = 1;
    boolean refreshNextTick = true;
    public BlockPos controller = this.m_58899_();
    int signal;
    boolean signalChanged;

    public AccumulatorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.energyCapability = LazyOptional.of(() -> this.energy);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.neighbourChanged();
    }

    public void neighbourChanged() {
        BlockEntity blockEntity;
        int power;
        if (!this.m_58898_()) {
            return;
        }
        if (this.isController() && (power = this.f_58857_.m_277086_(this.f_58858_)) != this.signal) {
            this.signalChanged = true;
        }
        if ((blockEntity = this.f_58857_.m_7702_(this.controller)) instanceof AccumulatorBlockEntity) {
            AccumulatorBlockEntity be = (AccumulatorBlockEntity)blockEntity;
            int power2 = this.f_58857_.m_277086_(this.f_58858_);
            if (power2 != be.signal) {
                be.signalChanged = true;
            }
        }
    }

    @Override
    public void remove() {
        super.remove();
        this.refreshController();
    }

    @Override
    public void onPlaced() {
        super.onPlaced();
        this.refreshController();
    }

    @Override
    public boolean makeMultimeterTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        BlockEntity blockEntity;
        if (!this.isController() && (blockEntity = this.f_58857_.m_7702_(this.controller)) instanceof AccumulatorBlockEntity) {
            AccumulatorBlockEntity be = (AccumulatorBlockEntity)blockEntity;
            return be.makeMultimeterTooltip(tooltip, isPlayerSneaking);
        }
        super.makeMultimeterTooltip(tooltip, isPlayerSneaking);
        CreateLang.text((String)"Capacity ").add(Component.m_237113_((String)TFMGUtils.formatUnits(this.energy.getEnergyStored(), "FE"))).color(1210265).forGoggles(tooltip, 1);
        CreateLang.text((String)"Charging Rate ").add(CreateLang.number((double)this.getChargingRate())).color(1210265).forGoggles(tooltip, 1);
        CreateLang.text((String)"Max Capacity ").add(CreateLang.number((double)this.getMaxCapacity())).color(1210265).forGoggles(tooltip, 1);
        return true;
    }

    public void refreshController() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_);
        for (int i = 0; i < 15; ++i) {
            AccumulatorBlockEntity otherBE;
            AccumulatorBlockEntity be;
            BlockPos pos = this.m_58899_().m_5484_((Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_), i);
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof AccumulatorBlockEntity) || (be = (AccumulatorBlockEntity)blockEntity).m_58900_().m_61143_((Property)DirectionalBlock.f_52588_) != facing || (blockEntity = this.f_58857_.m_7702_(pos.m_121945_(facing))) instanceof AccumulatorBlockEntity && (otherBE = (AccumulatorBlockEntity)blockEntity).m_58900_().m_61143_((Property)DirectionalBlock.f_52588_) == facing) continue;
            be.refreshMultiblock();
        }
    }

    public void refreshMultiblock() {
        AccumulatorBlockEntity be;
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_);
        this.refreshCapability();
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (!(blockEntity instanceof AccumulatorBlockEntity) || (be = (AccumulatorBlockEntity)blockEntity).m_58900_().m_61143_((Property)DirectionalBlock.f_52588_) != facing) {
            AccumulatorBlockEntity otherBe;
            BlockPos pos;
            BlockEntity blockEntity2;
            int newLength = 1;
            this.controller = this.m_58899_();
            for (int i = 1; i < 15 && (blockEntity2 = this.f_58857_.m_7702_(pos = this.m_58899_().m_5484_(((Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_)).m_122424_(), i))) instanceof AccumulatorBlockEntity && (otherBe = (AccumulatorBlockEntity)blockEntity2).m_58900_().m_61143_((Property)DirectionalBlock.f_52588_) == this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_); ++i) {
                otherBe.controller = this.m_58899_();
                otherBe.refreshCapability();
                otherBe.length = 0;
                otherBe.energy.setEnergy(0);
                ++newLength;
            }
            this.length = newLength;
            int oldEnergy = this.energy.getEnergyStored();
            this.energy = this.createEnergyStorage(this.length);
            this.energy.setEnergy(Math.min(oldEnergy, this.energy.getMaxEnergyStored() * this.length));
            this.refreshCapability();
            this.updateNextTick();
            for (int i = 1; i < this.length; ++i) {
                BlockPos pos2 = this.m_58899_().m_5484_(((Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_)).m_122424_(), i);
                BlockEntity blockEntity3 = this.f_58857_.m_7702_(pos2);
                if (!(blockEntity3 instanceof AccumulatorBlockEntity)) continue;
                AccumulatorBlockEntity be2 = (AccumulatorBlockEntity)blockEntity3;
                be2.refreshCapability();
                be2.sendStuff();
            }
            this.sendStuff();
        }
    }

    public void refreshCapability() {
        LazyOptional<IEnergyStorage> oldCap = this.energyCapability;
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof AccumulatorBlockEntity) {
            AccumulatorBlockEntity be = (AccumulatorBlockEntity)blockEntity;
            this.energyCapability = LazyOptional.of(() -> be.energy);
        } else {
            this.energyCapability = LazyOptional.of(() -> this.energy);
        }
        oldCap.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY && side == null) {
            return this.energyCapability.cast();
        }
        if (cap == ForgeCapabilities.ENERGY && this.hasElectricitySlot(side)) {
            return this.energyCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean isController() {
        return this.controller == this.m_58899_();
    }

    public TFMGForgeEnergyStorage createEnergyStorage(int multiplier) {
        return new TFMGForgeEnergyStorage(this.getMaxCapacity() * multiplier, 10000){

            @Override
            public void onEnergyChanged(int amount, int oldAmount) {
                if (oldAmount == 0 && amount > 0 || this.energy == 0) {
                    AccumulatorBlockEntity.this.updateNextTick();
                }
                AccumulatorBlockEntity.this.sendStuff();
            }
        };
    }

    public void setCapacity(ItemStack stack) {
        this.energy.setEnergy(stack.m_41784_().m_128451_("Storage"));
    }

    protected void analogSignalChanged() {
        if (!this.isController()) {
            this.signal = this.f_58857_.m_277086_(this.controller);
            return;
        }
        int newSignal = 0;
        for (int i = 0; i < this.length; ++i) {
            BlockPos pos = this.m_58899_().m_5484_(((Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_)).m_122424_(), i);
            newSignal = Math.max(newSignal, this.f_58857_.m_277086_(pos));
        }
        this.updateNextTick();
        this.signal = newSignal;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.signalChanged) {
            this.signalChanged = false;
            this.analogSignalChanged();
        }
        if (!this.isController()) {
            return;
        }
        if (this.refreshNextTick) {
            this.refreshMultiblock();
            this.refreshNextTick = false;
        }
        if (this.getData().getVoltage() > (Integer)TFMGConfigs.common().machines.accumulatorVoltage.get() * this.length) {
            this.energy.receiveEnergy((int)((double)this.getChargingRate() / (Double)TFMGConfigs.common().machines.FEtoWattTickConversionRate.get()), false);
            return;
        }
        if (this.canPower()) {
            int energyToExtract = this.data.networkPowerGeneration == 0 ? this.getNetworkPowerUsage() : (int)Math.max(0.0f, Math.max((float)this.powerGeneration() / (float)this.data.networkPowerGeneration * (float)this.getNetworkPowerUsage(), 0.0f));
            energyToExtract = (int)((double)energyToExtract / (Double)TFMGConfigs.common().machines.FEtoWattTickConversionRate.get());
            this.energy.extractEnergy(Math.max(energyToExtract, 1), false);
            if (this.energy.getEnergyStored() == 0) {
                this.updateNextTick();
            }
        }
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("ForgeEnergy", this.energy.getEnergyStored());
        compound.m_128405_("Length", this.length);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.length = compound.m_128451_("Length");
        this.energy.setEnergy(compound.m_128451_("ForgeEnergy"));
    }

    @Override
    public float resistance() {
        if (this.voltageGeneration() > 0) {
            return 0.0f;
        }
        if (!this.isController()) {
            return 0.0f;
        }
        int power = 0;
        for (IElectric member : this.getOrCreateElectricNetwork().members) {
            if (member instanceof ConverterBlockEntity || member instanceof AccumulatorBlockEntity) continue;
            power += member.getPowerUsage();
        }
        if (this.energy.getEnergyStored() == this.getMaxCapacity() || this.getData().getVoltage() <= this.getOutputVoltage() || this.canPower()) {
            return 0.0f;
        }
        if (Math.min(Math.max(this.data.networkPowerGeneration - power, 0), this.getMaxChargingRate()) == 0) {
            return 0.0f;
        }
        return (float)Math.min(Math.pow(this.data.voltage, 2.0) / (double)Math.min(Math.max(this.data.networkPowerGeneration - power, 0), this.getMaxChargingRate()), 750.0);
    }

    public boolean canPower() {
        return this.getData().networkResistance > 0 && this.getData().getVoltage() <= this.getOutputVoltage() && this.energy.getEnergyStored() > 0 && this.signal == 0;
    }

    public int getChargingRate() {
        if (this.energy.getEnergyStored() >= this.getMaxCapacity() || this.getData().getVoltage() < this.getOutputVoltage() || this.canPower() || this.data.notEnoughtPower) {
            return 0;
        }
        return this.getMaxChargingRate();
    }

    @Override
    public int powerGeneration() {
        if (this.canPower()) {
            return this.getData().networkResistance > 0 ? this.maxPowerOutput() : 0;
        }
        return 0;
    }

    public int maxPowerOutput() {
        return this.getOutputVoltage() * (Integer)TFMGConfigs.common().machines.accumulatorMaxAmpOutput.get();
    }

    public int getMaxCapacity() {
        return (Integer)TFMGConfigs.common().machines.accumulatorStorage.get() * this.length;
    }

    public int getMaxChargingRate() {
        return (Integer)TFMGConfigs.common().machines.accumulatorChargingRate.get();
    }

    public int getOutputVoltage() {
        return (Integer)TFMGConfigs.common().machines.accumulatorVoltage.get() * this.length;
    }

    @Override
    public int voltageGeneration() {
        return this.canPower() ? this.getOutputVoltage() : 0;
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction.m_122434_() == ((Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_)).m_122434_();
    }
}

