/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.base;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.content.electricity.base.ElectricBlockValues;
import com.drmangotea.tfmg.content.electricity.base.ElectricNetworkManager;
import com.drmangotea.tfmg.content.electricity.base.ElectricalGroup;
import com.drmangotea.tfmg.content.electricity.base.ElectricalNetwork;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.base.NetworkUpdatePacket;
import com.drmangotea.tfmg.content.electricity.base.VoltageAlteringBlockEntity;
import com.drmangotea.tfmg.registry.TFMGPackets;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class ElectricBlockEntity
extends SmartBlockEntity
implements IElectric,
IHaveHoveringInformation {
    public ElectricBlockValues data = new ElectricBlockValues(this.getPos());

    public ElectricBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.data.connectNextTick = true;
        if (!this.canBeInGroups()) {
            this.data.group = new ElectricalGroup(-1);
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    public LevelAccessor getLevelAccessor() {
        return this.f_58857_;
    }

    @Override
    public boolean destroyed() {
        return this.data.destroyed;
    }

    @Override
    public ElectricalNetwork getOrCreateElectricNetwork() {
        if (this.f_58857_.m_7702_(BlockPos.m_122022_((long)this.data.electricalNetworkId)) instanceof IElectric) {
            return TFMG.NETWORK_MANAGER.getOrCreateNetworkFor((IElectric)this.f_58857_.m_7702_(BlockPos.m_122022_((long)this.data.electricalNetworkId)));
        }
        ElectricNetworkManager.networks.get(this.m_58904_()).remove(this.data.electricalNetworkId);
        return TFMG.NETWORK_MANAGER.getOrCreateNetworkFor(this);
    }

    public void lazyTick() {
        super.lazyTick();
        this.lazyTickElectricity();
    }

    @Override
    public ElectricBlockValues getData() {
        return this.data;
    }

    @Override
    public float resistance() {
        return 0.0f;
    }

    @Override
    public int voltageGeneration() {
        int voltageGeneration = 0;
        for (Direction direction : Direction.values()) {
            VoltageAlteringBlockEntity be;
            BlockEntity blockEntity;
            if (!this.hasElectricitySlot(direction) || !((blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction))) instanceof VoltageAlteringBlockEntity) || (be = (VoltageAlteringBlockEntity)blockEntity).getData().getId() == this.getData().getId() || be.getData().getVoltage() == 0 || !be.hasElectricitySlot(direction)) continue;
            voltageGeneration = Math.max(voltageGeneration, be.getOutputVoltage());
            this.data.getsOutsidePower = true;
        }
        if (voltageGeneration == 0) {
            this.data.getsOutsidePower = false;
        }
        return voltageGeneration;
    }

    @Override
    public int powerGeneration() {
        int powerGeneration = 0;
        for (Direction direction : Direction.values()) {
            VoltageAlteringBlockEntity be;
            BlockEntity blockEntity;
            if (!this.hasElectricitySlot(direction) || !((blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction))) instanceof VoltageAlteringBlockEntity) || !(be = (VoltageAlteringBlockEntity)blockEntity).canWork() || be.getData().getId() == this.getData().getId() || be.getData().getVoltage() == 0 || !be.hasElectricitySlot(direction) || (powerGeneration = Math.max(powerGeneration, be.getPowerUsage()) + 1) <= be.getNetworkPowerGeneration()) continue;
            powerGeneration = 0;
            be.data.updatePowerNextTick = true;
        }
        return powerGeneration;
    }

    @Override
    public int frequencyGeneration() {
        return 0;
    }

    @Override
    public void updateNextTick() {
        this.data.updateNextTick = true;
    }

    @Override
    public void updateNetwork() {
        this.getOrCreateElectricNetwork().updateNetwork();
        if (!this.f_58857_.f_46443_) {
            TFMGPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new NetworkUpdatePacket(BlockPos.m_122022_((long)this.getPos())));
        }
        this.sendData();
    }

    @Override
    public void sendStuff() {
        this.sendData();
    }

    @Override
    public void setVoltage(int newVoltage) {
        if (this.canBeInGroups()) {
            this.data.voltage = (int)(this.resistance() / this.data.group.resistance * (float)this.data.voltageSupply);
            return;
        }
        this.data.voltage = newVoltage;
    }

    @Override
    public void setFrequency(int newFrequency) {
        this.data.frequency = newFrequency;
    }

    @Override
    public void setNetworkResistance(int newUsage) {
        this.data.networkResistance = newUsage;
    }

    @Override
    public int getNetworkResistance() {
        return this.data.networkResistance;
    }

    @Override
    public void setNetwork(long network) {
        this.data.electricalNetworkId = network;
        if (network != this.getPos()) {
            ElectricNetworkManager.networks.get(this.m_58904_()).remove(this.getPos());
        }
    }

    public boolean networkUndersupplied() {
        return this.getNetworkPowerUsage() > this.data.networkPowerGeneration;
    }

    @Override
    public long getPos() {
        return this.m_58899_().m_121878_();
    }

    public void remove() {
        super.remove();
        this.data.destroyed = true;
        for (Direction d : Direction.values()) {
            IElectric be;
            BlockEntity blockEntity;
            if (!this.hasElectricitySlot(d) || !((blockEntity = this.getLevelAccessor().m_7702_(BlockPos.m_122022_((long)this.getPos()).m_121945_(d))) instanceof IElectric) || !(be = (IElectric)blockEntity).hasElectricitySlot(d.m_122424_())) continue;
            ElectricNetworkManager.networks.get(this.m_58904_()).remove(be.getPos());
            be.setNetwork(be.getPos());
            be.onPlaced();
            be.updateNextTick();
        }
        if (this.data.electricalNetworkId != this.getPos()) {
            this.getOrCreateElectricNetwork().getMembers().remove(this);
        }
        if (this.data.electricalNetworkId == this.getPos()) {
            ElectricNetworkManager.networks.get(this.m_58904_()).remove(this.getData().getId());
        }
    }

    public void tick() {
        super.tick();
        this.tickElectricity();
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("GroupId", this.data.group.id);
        compound.m_128350_("GroupResistance", this.data.group.resistance);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.data.group = new ElectricalGroup(compound.m_128451_("GroupId"));
        this.data.group.resistance = compound.m_128457_("GroupResistance");
        if (!clientPacket) {
            this.data.connectNextTick = true;
        }
    }
}

