/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.api.util;

import com.ldtteam.structurize.api.util.ItemStackUtils;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemStorage {
    private final ItemStack stack;
    private final boolean shouldIgnoreDamageValue;
    private final boolean shouldIgnoreNBTValue;
    private int amount;

    public ItemStorage(ItemStack stack, int amount, boolean ignoreDamageValue, boolean shouldIgnoreNBTValue) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = ignoreDamageValue;
        this.shouldIgnoreNBTValue = shouldIgnoreNBTValue;
        this.amount = amount;
    }

    public ItemStorage(ItemStack stack, boolean ignoreDamageValue, boolean shouldIgnoreNBTValue) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = ignoreDamageValue;
        this.shouldIgnoreNBTValue = shouldIgnoreNBTValue;
    }

    public ItemStorage(ItemStack stack, boolean ignoreDamageValue) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = ignoreDamageValue;
        this.shouldIgnoreNBTValue = ignoreDamageValue;
        this.amount = ItemStackUtils.getSize(stack);
    }

    public ItemStorage(ItemStack stack) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = false;
        this.shouldIgnoreNBTValue = false;
        this.amount = ItemStackUtils.getSize(stack);
    }

    public ItemStorage(FriendlyByteBuf buf) {
        this.stack = buf.m_130267_();
        this.shouldIgnoreDamageValue = buf.readBoolean();
        this.shouldIgnoreNBTValue = buf.readBoolean();
        this.amount = buf.readInt();
    }

    public static ItemStorage getItemStackOfListMatchingPredicate(List<ItemStorage> list, Predicate<ItemStack> predicate) {
        for (ItemStorage stack : list) {
            if (!predicate.test(stack.getItemStack())) continue;
            return stack;
        }
        return null;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public boolean ignoreDamageValue() {
        return this.shouldIgnoreDamageValue;
    }

    public boolean ignoreNBTValue() {
        return this.shouldIgnoreNBTValue;
    }

    public int hashCode() {
        return Objects.hash(this.stack.m_41720_()) + (this.shouldIgnoreDamageValue ? 0 : this.stack.m_41773_() * 31) + (this.shouldIgnoreNBTValue ? 0 : (this.stack.serializeNBT() == null ? 0 : this.stack.serializeNBT().hashCode()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStorage that = (ItemStorage)o;
        return ItemStackUtils.compareItemStacksIgnoreStackSize(that.getItemStack(), this.getItemStack(), !this.shouldIgnoreDamageValue && !that.shouldIgnoreDamageValue, !this.shouldIgnoreNBTValue && !that.shouldIgnoreNBTValue);
    }

    public Item getItem() {
        return this.stack.m_41720_();
    }

    public int getDamageValue() {
        return this.stack.m_41773_();
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130055_(this.getItemStack());
        buf.writeBoolean(this.ignoreDamageValue());
        buf.writeBoolean(this.ignoreNBTValue());
        buf.writeInt(this.getAmount());
    }
}

