/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.util;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ParticleUtil {
    private static final double RANDOM_HORIZ = 0.8;
    private static final double RANDOM_VERT = 1.5;

    public static void spawnParticleBeam(Level world, ParticleOptions sparkle, BlockPos start, BlockPos end, int count) {
        float dX = end.m_123341_() - start.m_123341_();
        float dY = end.m_123342_() - start.m_123342_();
        float dZ = end.m_123343_() - start.m_123343_();
        for (float t = 0.0f; t < 1.0f; t += 0.09f) {
            float x = (float)start.m_123341_() + dX * t;
            float y = (float)start.m_123342_() + dY * t;
            float z = (float)start.m_123343_() + dZ * t;
            ParticleUtil.spawnParticle(world, sparkle, x, y, z, count);
        }
    }

    private static double getVertRandom(Level world, double rando) {
        return world.f_46441_.m_188500_() * rando - 0.1;
    }

    private static double getHorizRandom(Level world, double rando) {
        return (world.f_46441_.m_188500_() - 0.5) * rando;
    }

    public static void spawnParticle(Level world, ParticleOptions sparkle, BlockPos pos, int count) {
        if (world.f_46443_) {
            ParticleUtil.spawnParticle(world, sparkle, (float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f, count);
        }
    }

    private static void spawnParticle(Level world, ParticleOptions sparkle, float x, float y, float z, int count) {
        for (int countparticles = 0; countparticles <= count; ++countparticles) {
            Minecraft.m_91087_().f_91061_.m_107370_(sparkle, (double)x + ParticleUtil.getHorizRandom(world, 0.8), (double)y + ParticleUtil.getVertRandom(world, 1.5), (double)z + ParticleUtil.getHorizRandom(world, 0.8), 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnBlockParticles(SimpleParticleType partIn, Level worldIn, BlockPos pos, RandomSource rand) {
        double x = (double)pos.m_123341_() + rand.m_188500_();
        double y = (double)pos.m_123342_() + rand.m_188500_();
        double z = (double)pos.m_123343_() + rand.m_188500_();
        double xSp = (rand.m_188500_() - 0.5) * 0.5;
        double ySp = (rand.m_188500_() - 0.5) * 0.5;
        double zSp = (rand.m_188500_() - 0.5) * 0.5;
        worldIn.m_7106_((ParticleOptions)partIn, x, y, z, xSp, ySp, zSp);
    }

    public static void doFireworks(Player player, Level world, double z, double y, double x) {
        FireworkRocketEntity rocket = new FireworkRocketEntity(world, new ItemStack((ItemLike)Items.f_42688_), (LivingEntity)player);
        rocket.m_6034_(x, y, z);
        world.m_7967_((Entity)rocket);
    }

    public static void doSmoke(Level world, double z, double y, double x) {
        for (int i = 0; i < 20; ++i) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.2, 0.0);
        }
    }
}

