/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.heartbalance;

import com.lothrazar.heartbalance.ConfigRegistryHearts;
import com.lothrazar.heartbalance.ModRegistry;
import com.lothrazar.heartbalance.item.ItemHeart;
import com.lothrazar.library.events.EventFlib;
import com.lothrazar.library.util.LevelWorldUtil;
import com.lothrazar.library.util.SoundUtil;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HeartEvents
extends EventFlib {
    public static final UUID ID = UUID.fromString("55550aa2-eff2-4a81-b92b-a1cb95f15555");

    private static void forceHearts(Player player) {
        AttributeInstance healthAttribute = player.m_21051_(Attributes.f_22276_);
        if (healthAttribute == null) {
            return;
        }
        AttributeModifier oldHealthModifier = healthAttribute.m_22111_(ID);
        if (oldHealthModifier != null) {
            healthAttribute.m_22130_(oldHealthModifier);
        }
        int h = 2 * (Integer)ConfigRegistryHearts.INIT_HEARTS.get();
        AttributeModifier healthModifier = new AttributeModifier(ID, "heartbalance", (double)h, AttributeModifier.Operation.ADDITION);
        healthAttribute.m_22125_(healthModifier);
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            HeartEvents.forceHearts(player);
        }
    }

    @SubscribeEvent
    public void onPlayerCloneDeath(PlayerEvent.Clone event) {
        HeartEvents.forceHearts(event.getEntity());
    }

    @SubscribeEvent
    public void onPlayerPickup(EntityItemPickupEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = event.getEntity();
            ItemEntity itemEntity = event.getItem();
            ItemStack resultStack = itemEntity.m_32055_();
            if (!resultStack.m_41619_() && resultStack.m_41720_() instanceof ItemHeart) {
                ItemHeart heart = (ItemHeart)resultStack.m_41720_();
                boolean healed = false;
                while (!resultStack.m_41619_() && player.m_36325_()) {
                    player.m_5634_((float)heart.getHealing());
                    resultStack.m_41774_(1);
                    itemEntity.m_32045_(resultStack);
                    healed = true;
                }
                if (healed && ((Boolean)ConfigRegistryHearts.DO_SOUND_PICKUP.get()).booleanValue()) {
                    SoundUtil.playSoundFromServer((ServerPlayer)((ServerPlayer)player), (SoundEvent)((SoundEvent)ModRegistry.HEART_SOUND.get()), (float)0.3f, (float)0.95f);
                }
                if (!((Boolean)ConfigRegistryHearts.DO_PICKUP.get()).booleanValue() || itemEntity.m_32055_().m_41619_()) {
                    itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        Level world = event.getEntity().m_9236_();
        if (world.f_46443_ || event.getSource() == null || world.f_46441_.m_188500_() >= (Double)ConfigRegistryHearts.CHANCE.get()) {
            return;
        }
        Entity trueSource = event.getSource().m_7639_();
        if (trueSource instanceof Player && !(trueSource instanceof FakePlayer) && event.getEntity().m_6095_().m_20674_() == MobCategory.MONSTER) {
            BlockPos pos = event.getEntity().m_20183_();
            LevelWorldUtil.dropItemStackRandomMotion((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModRegistry.HALF_HEART.get()), (float)0.03f);
        }
    }
}

