/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.textures;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.Sampler2D;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureOps;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Respriter {
    private final TextureImage imageToRecolor;
    private final Palette originalPalette;
    @Nullable
    private final Sampler2D recoloringMask;

    public static Respriter of(TextureImage imageToRecolor) {
        return new Respriter(imageToRecolor, Palette.fromImage(imageToRecolor, null, 0.0f), null);
    }

    public static Respriter masked(TextureImage imageToRecolor, TextureImage colorMask) {
        return new Respriter(imageToRecolor, Palette.fromImage(imageToRecolor, colorMask, 0.0f), colorMask);
    }

    @Deprecated(forRemoval=true)
    public static Respriter ofPalette(TextureImage imageToRecolor, List<Palette> colorsToSwap) {
        return new Respriter(imageToRecolor, Palette.merge((Palette[])colorsToSwap.toArray(Palette[]::new)), null);
    }

    public static Respriter ofPalette(TextureImage imageToRecolor, Palette colorsToSwap) {
        return new Respriter(imageToRecolor, colorsToSwap, null);
    }

    private Respriter(TextureImage imageToRecolor, Palette colorsToSwap, @Nullable Sampler2D recoloringMask) {
        if (colorsToSwap.isEmpty()) {
            throw new UnsupportedOperationException("Respriter must have a non empty target palette");
        }
        this.imageToRecolor = imageToRecolor;
        this.originalPalette = colorsToSwap;
        this.recoloringMask = recoloringMask;
    }

    public TextureImage recolorWithAnimationOf(TextureImage textureImage) {
        return this.recolorWithAnimation(List.of(Palette.fromImage(textureImage)), textureImage.getMcMeta());
    }

    @Deprecated(forRemoval=true)
    public TextureImage recolorWithAnimation(List<Palette> targetPalettes, @Nullable AnimationMetadataSection targetAnimationData) {
        return this.recolorWithAnimation(targetPalettes, targetAnimationData == null ? null : McMetaFile.of(targetAnimationData));
    }

    public TextureImage recolorWithAnimation(List<Palette> targetPalettes, @Nullable McMetaFile targetAnimationData) {
        if (targetPalettes.isEmpty()) {
            Moonlight.crashIfInDev("Respriter was given no palettes!");
            return this.imageToRecolor.makeCopy();
        }
        @Nullable McMetaFile mergedAnimationData = McMetaFile.merge(this.imageToRecolor.getMcMeta(), targetAnimationData);
        int originalFrameCount = this.imageToRecolor.frameCount();
        TextureImage outputTexture = originalFrameCount == 1 && mergedAnimationData != null ? TextureOps.createSingleFrameAnimation(this.imageToRecolor, mergedAnimationData) : this.imageToRecolor.makeCopy();
        FrameColorRemapper colorRemapper = FrameColorRemapper.of(this.originalPalette, originalFrameCount, targetPalettes, outputTexture.frameCount());
        outputTexture.forEachPixel(pixel -> {
            int ind = pixel.frameIndex();
            if (this.recoloringMask != null && FastColor.ABGR32.m_266503_((int)this.recoloringMask.sample(pixel.globalX, pixel.globalY)) != 0) {
                return;
            }
            Integer newColor = colorRemapper.remapColor(ind, pixel.getValue());
            if (newColor != null) {
                pixel.setValue(newColor);
            }
        });
        return outputTexture;
    }

    public TextureImage recolor(List<Palette> targetPalettes) {
        return this.recolorWithAnimation(targetPalettes, (McMetaFile)null);
    }

    public TextureImage recolor(Palette targetPalette) {
        return this.recolor(List.of(targetPalette));
    }

    @FunctionalInterface
    private static interface FrameColorRemapper {
        public static FrameColorRemapper of(Palette originalPalette, int originalFrameCount, List<Palette> targetPalettes, int targetFrameCount) {
            boolean invalidSize;
            boolean bl = invalidSize = targetFrameCount > targetPalettes.size();
            if (originalFrameCount != 1 || invalidSize) {
                if (invalidSize) {
                    Moonlight.crashIfInDev("Respriter was given less palettes than needed!");
                }
                Color2ColorMap singleColorMap = Color2ColorMap.create(originalPalette, targetPalettes.get(0));
                return (frameIndex, color) -> singleColorMap.mapColor(color);
            }
            final ArrayList<Color2ColorMap> mappingPerFrame = new ArrayList<Color2ColorMap>();
            for (int i = 0; i < targetFrameCount; ++i) {
                Palette toPalette = targetPalettes.get(i);
                mappingPerFrame.add(Color2ColorMap.create(originalPalette, toPalette));
            }
            return new FrameColorRemapper(){

                @Override
                @Nullable
                public Integer remapColor(int frameIndex, int color) {
                    Color2ColorMap colorMap = (Color2ColorMap)mappingPerFrame.get(frameIndex);
                    if (colorMap != null) {
                        return colorMap.mapColor(color);
                    }
                    return null;
                }
            };
        }

        @Nullable
        public Integer remapColor(int var1, int var2);
    }

    private record Color2ColorMap(Int2ObjectArrayMap<Integer> map) {
        static final Color2ColorMap EMPTY = new Color2ColorMap((Int2ObjectArrayMap<Integer>)new Int2ObjectArrayMap(0));

        @Nullable
        public Integer mapColor(int color) {
            return (Integer)this.map.get(color);
        }

        @NotNull
        public static Color2ColorMap create(Palette originalPalette, Palette toPalette) {
            toPalette = toPalette.copy();
            toPalette.matchSize(originalPalette.size(), Float.valueOf(originalPalette.getAverageLuminanceStep()));
            if (toPalette.size() != originalPalette.size()) {
                Moonlight.LOGGER.error("Failed to create Color2ColorMap. Too few colors in toPalette");
                return EMPTY;
            }
            return new Color2ColorMap(Color2ColorMap.zipToMap(originalPalette.getValues(), toPalette.getValues()));
        }

        private static Int2ObjectArrayMap<Integer> zipToMap(List<PaletteColor> keys, List<PaletteColor> values) {
            Int2ObjectArrayMap map = new Int2ObjectArrayMap(keys.size());
            for (int i = 0; i < keys.size(); ++i) {
                map.put(keys.get(i).value(), (Object)values.get(i).value());
            }
            return map;
        }
    }
}

