/*
 * Decompiled with CFR 0.152.
 */
package com.biomemusic.environment;

import com.biomemusic.BiomeMusic;
import com.biomemusic.config.CommonConfiguration;
import com.biomemusic.environment.MusicType;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;

public enum MusicEnvironment {
    CAVE,
    WATER,
    NIGHT,
    OVERWORLD,
    NETHER,
    END,
    OTHERDIMENSIONS;

    public static Object2BooleanOpenHashMap<MusicEnvironment> environment;

    public static boolean canPlay(MusicType musicType) {
        MusicType.MusicTypeData musicTypeData = ((CommonConfiguration)BiomeMusic.config.getCommonConfig()).musicConditions.get((Object)musicType);
        if (musicTypeData == null) {
            return false;
        }
        for (MusicEnvironment requiredEnv : musicTypeData.required) {
            if (environment.getBoolean((Object)requiredEnv)) continue;
            return false;
        }
        for (MusicEnvironment disallowedEnv : musicTypeData.disallowed) {
            if (!environment.getBoolean((Object)disallowedEnv)) continue;
            return false;
        }
        return true;
    }

    public static boolean setEnvironmentFor(MusicEnvironment env, boolean enabled) {
        boolean old = environment.getBoolean((Object)env);
        if (old != enabled) {
            environment.put((Object)env, enabled);
            return true;
        }
        return false;
    }

    static {
        environment = new Object2BooleanOpenHashMap();
    }
}

