/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.util;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureUtil;
import sfiomn.legendarysurvivaloverhaul.common.integration.artifacts.ArtifactsUtil;
import sfiomn.legendarysurvivaloverhaul.common.integration.beachparty.BeachpartyUtil;
import sfiomn.legendarysurvivaloverhaul.common.integration.eclipticseasons.EclipticSeasonsUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;

public final class WorldUtil {
    private static Pair<BlockPos, Float> undergroundEffect = new ImmutablePair((Object)new BlockPos(0, 0, 0), (Object)Float.valueOf(0.0f));

    private WorldUtil() {
    }

    public static BlockPos getSidedBlockPos(Level world, Entity entity) {
        if (!world.f_46443_) {
            return entity.m_20183_();
        }
        if (entity instanceof Player) {
            return BlockPos.m_274446_((Position)entity.m_20182_().m_82520_(0.0, 0.5, 0.0));
        }
        if (entity instanceof ItemFrame) {
            return BlockPos.m_274446_((Position)entity.m_20182_().m_82520_(0.0, -0.45, 0.0));
        }
        return entity.m_20183_();
    }

    public static boolean isChunkLoaded(Level world, BlockPos pos) {
        if (world.f_46443_) {
            return true;
        }
        return world.m_7726_().m_5563_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    public static boolean isPlayerOrPosUndercover(Level level, Player player, BlockPos pos) {
        if (LegendarySurvivalOverhaul.beachpartyLoaded && BeachpartyUtil.isUnderParasol(level, player, pos)) {
            return true;
        }
        if (LegendarySurvivalOverhaul.artifactsLoaded && ArtifactsUtil.isHoldingUmbrella(player)) {
            return true;
        }
        return !level.m_45527_(pos) || level.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() > pos.m_123342_();
    }

    public static Biome.Precipitation getPrecipitationAt(Level level, Player player, BlockPos pos) {
        if (WorldUtil.isPlayerOrPosUndercover(level, player, pos)) {
            return Biome.Precipitation.NONE;
        }
        if (LegendarySurvivalOverhaul.eclipticSeasonsLoaded) {
            return EclipticSeasonsUtil.getPrecipitation(level, pos);
        }
        if (!level.m_46471_()) {
            return Biome.Precipitation.NONE;
        }
        return ((Biome)level.m_204166_(pos).get()).m_264600_(pos);
    }

    public static boolean isRainingOrSnowingAt(Level level, BlockPos pos) {
        if (LegendarySurvivalOverhaul.eclipticSeasonsLoaded) {
            return EclipticSeasonsUtil.getPrecipitation(level, pos) != Biome.Precipitation.NONE;
        }
        if (!level.m_46471_()) {
            return false;
        }
        if (!level.m_45527_(pos)) {
            return false;
        }
        return level.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() <= pos.m_123342_();
    }

    public static float calculateClientWorldEntityTemperature(Level world, Entity entity) {
        return TemperatureUtil.getWorldTemperature(world, WorldUtil.getSidedBlockPos(world, entity));
    }

    public static float toFahrenheit(float temperature) {
        return 32.0f + temperature * 1.8f;
    }

    public static float getUndergroundEffectAtPos(Level level, BlockPos pos) {
        if (!((BlockPos)undergroundEffect.getKey()).m_123344_().equals(pos.m_123344_())) {
            Vec3i[] posOffsets;
            float averageDepthUnderground = 0.0f;
            for (Vec3i offset : posOffsets = new Vec3i[]{new Vec3i(0, 0, 0), new Vec3i(10, 0, 0), new Vec3i(-10, 0, 0), new Vec3i(0, 0, 10), new Vec3i(0, 0, -10), new Vec3i(7, 0, 7), new Vec3i(7, 0, -7), new Vec3i(-7, 0, 7), new Vec3i(-7, 0, -7)}) {
                BlockPos posOffset = pos.m_121955_(offset);
                int surfaceDistance = level.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, posOffset).m_123342_() - posOffset.m_123342_();
                if (surfaceDistance < Config.Baked.undergroundEffectStartDistanceToWS) continue;
                if (surfaceDistance >= Config.Baked.undergroundEffectEndDistanceToWS) {
                    averageDepthUnderground += 1.0f;
                    continue;
                }
                averageDepthUnderground += (float)(surfaceDistance - Config.Baked.undergroundEffectStartDistanceToWS) / (float)(Config.Baked.undergroundEffectEndDistanceToWS - Config.Baked.undergroundEffectStartDistanceToWS);
            }
            undergroundEffect = new ImmutablePair((Object)pos, (Object)Float.valueOf(averageDepthUnderground / (float)posOffsets.length));
        }
        return ((Float)undergroundEffect.getValue()).floatValue();
    }

    public static Entity getEntityLookedAt(Player player, double finalDistance) {
        AABB expandedPlayerBound;
        Entity foundEntity = null;
        HitResult positionLookedAt = player.m_19907_(finalDistance, 0.0f, false);
        Vec3 eyePosition = player.m_20299_(0.0f);
        double distanceFromEye = positionLookedAt.m_82450_().m_82554_(eyePosition);
        Vec3 lookVector = player.m_20154_();
        Vec3 reachVector = eyePosition.m_82520_(lookVector.f_82479_ * distanceFromEye, lookVector.f_82480_ * distanceFromEye, lookVector.f_82481_ * distanceFromEye);
        EntityHitResult entityRayTraceResult = ProjectileUtil.m_37287_((Entity)player, (Vec3)eyePosition, (Vec3)reachVector, (AABB)(expandedPlayerBound = player.m_20191_().m_82363_(lookVector.f_82479_ * distanceFromEye, lookVector.f_82480_ * distanceFromEye, lookVector.f_82481_ * distanceFromEye)), entity -> !entity.m_5833_() && entity.m_6087_(), (double)(distanceFromEye * distanceFromEye));
        if (entityRayTraceResult != null) {
            foundEntity = entityRayTraceResult.m_82443_();
        }
        return foundEntity;
    }

    public static String timeInGame(Minecraft mc) {
        int dayTime;
        int dayCount = 0;
        int n = dayTime = mc.f_91073_ != null ? (int)mc.f_91073_.m_8044_() : 0;
        while (dayTime > 24000) {
            dayTime -= 24000;
            ++dayCount;
        }
        dayTime = (dayTime + 6000) % 24000;
        String hourOfTheDay = String.format("%2s", dayTime / 1000).replace(' ', '0');
        String minuteOfTheDay = String.format("%2s", dayTime % 1000 * 6 / 100).replace(' ', '0');
        return "Day " + dayCount + ", " + hourOfTheDay + ":" + minuteOfTheDay;
    }

    public static Vec3i getOppositeVector(Vec3i originalVector) {
        return new Vec3i(-originalVector.m_123341_(), -originalVector.m_123342_(), -originalVector.m_123343_());
    }
}

