/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.packets;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonThirstConsumable;
import sfiomn.legendarysurvivaloverhaul.common.listeners.ThirstConsumableListener;
import sfiomn.legendarysurvivaloverhaul.network.NetworkHandler;

public class SyncThirstConsumablesPacket {
    private final Map<ResourceLocation, List<JsonThirstConsumable>> thirstConsumables;
    private final int size;

    public SyncThirstConsumablesPacket(Map<ResourceLocation, List<JsonThirstConsumable>> thirstConsumables) {
        this.thirstConsumables = Map.copyOf(thirstConsumables);
        this.size = thirstConsumables.size();
    }

    public static void encode(SyncThirstConsumablesPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.size);
        for (Map.Entry<ResourceLocation, List<JsonThirstConsumable>> e : message.thirstConsumables.entrySet()) {
            buffer.m_130085_(e.getKey());
            buffer.writeInt(e.getValue().size());
            DataResult r = JsonThirstConsumable.LIST_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, e.getValue());
            r.result().ifPresent(j -> ((ListTag)j).forEach(k -> buffer.m_130079_((CompoundTag)k)));
        }
    }

    public static SyncThirstConsumablesPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<ResourceLocation, List<JsonThirstConsumable>> thirstConsumables = new HashMap<ResourceLocation, List<JsonThirstConsumable>>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = buffer.m_130281_();
            int jtcSize = buffer.readInt();
            ArrayList jtcList = new ArrayList();
            for (int j = 0; j < jtcSize; ++j) {
                CompoundTag tag = buffer.m_130260_();
                if (tag == null) continue;
                DataResult r = JsonThirstConsumable.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag);
                r.result().ifPresent(jtcList::add);
            }
            thirstConsumables.put(key, jtcList);
        }
        return new SyncThirstConsumablesPacket(thirstConsumables);
    }

    public static void handle(SyncThirstConsumablesPacket message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SyncThirstConsumablesPacket.syncThirstConsumables(message.thirstConsumables)));
        supplier.get().setPacketHandled(true);
    }

    public static DistExecutor.SafeRunnable syncThirstConsumables(final Map<ResourceLocation, List<JsonThirstConsumable>> thirstBlocks) {
        return new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 1L;

            public void run() {
                ThirstConsumableListener.acceptServerThirstConsumables(thirstBlocks);
            }
        };
    }

    public static void sendTo(PacketDistributor.PacketTarget packetDistributor, Map<ResourceLocation, List<JsonThirstConsumable>> thirstConsumables) {
        NetworkHandler.INSTANCE.send(packetDistributor, (Object)new SyncThirstConsumablesPacket(thirstConsumables));
    }
}

