/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.packets;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonHealingConsumable;
import sfiomn.legendarysurvivaloverhaul.common.listeners.BodyDamageHealingConsumableListener;
import sfiomn.legendarysurvivaloverhaul.network.NetworkHandler;

public class SyncBodyDamageHealingConsumablesPacket {
    private final Map<ResourceLocation, JsonHealingConsumable> healingConsumables;
    private final int size;

    public SyncBodyDamageHealingConsumablesPacket(Map<ResourceLocation, JsonHealingConsumable> healingConsumables) {
        this.healingConsumables = Map.copyOf(healingConsumables);
        this.size = healingConsumables.size();
    }

    public static void encode(SyncBodyDamageHealingConsumablesPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.size);
        for (Map.Entry<ResourceLocation, JsonHealingConsumable> e : message.healingConsumables.entrySet()) {
            buffer.m_130085_(e.getKey());
            DataResult r = JsonHealingConsumable.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)e.getValue());
            r.result().ifPresent(j -> buffer.m_130079_((CompoundTag)j));
        }
    }

    public static SyncBodyDamageHealingConsumablesPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<ResourceLocation, JsonHealingConsumable> healingConsumables = new HashMap<ResourceLocation, JsonHealingConsumable>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = buffer.m_130281_();
            CompoundTag tag = buffer.m_130260_();
            if (tag == null) continue;
            DataResult r = JsonHealingConsumable.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag);
            r.result().ifPresent(t -> healingConsumables.put(key, (JsonHealingConsumable)t));
        }
        return new SyncBodyDamageHealingConsumablesPacket(healingConsumables);
    }

    public static void handle(SyncBodyDamageHealingConsumablesPacket message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SyncBodyDamageHealingConsumablesPacket.syncTemperatureItems(message.healingConsumables)));
        supplier.get().setPacketHandled(true);
    }

    public static DistExecutor.SafeRunnable syncTemperatureItems(final Map<ResourceLocation, JsonHealingConsumable> healingConsumables) {
        return new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 1L;

            public void run() {
                BodyDamageHealingConsumableListener.acceptServerHealingConsumables(healingConsumables);
            }
        };
    }

    public static void sendTo(PacketDistributor.PacketTarget packetDistributor, Map<ResourceLocation, JsonHealingConsumable> healingConsumables) {
        NetworkHandler.INSTANCE.send(packetDistributor, (Object)new SyncBodyDamageHealingConsumablesPacket(healingConsumables));
    }
}

