/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureEnum;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureUtil;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.temperature.TemperatureCapability;
import sfiomn.legendarysurvivaloverhaul.common.commands.CommandBase;
import sfiomn.legendarysurvivaloverhaul.util.CapabilityUtil;
import sfiomn.legendarysurvivaloverhaul.util.MathUtil;

public class TemperatureCommand
extends CommandBase {
    public TemperatureCommand() {
        super((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"temperature").requires(p_198521_0_ -> p_198521_0_.m_6761_(2))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"Temperature", (ArgumentType)IntegerArgumentType.integer((int)TemperatureEnum.FROSTBITE.getLowerBound(), (int)TemperatureEnum.HEAT_STROKE.getUpperBound())).executes(src -> new TemperatureCommand().set((CommandSourceStack)src.getSource(), IntegerArgumentType.getInteger((CommandContext)src, (String)"Temperature")))))).then(Commands.m_82127_((String)"get").executes(src -> new TemperatureCommand().get((CommandSourceStack)src.getSource())))));
    }

    @Override
    public int get(CommandSourceStack source) {
        try {
            if (source.m_81373_() instanceof Player) {
                Player player = (Player)source.m_81373_();
                float targetTemperature = TemperatureUtil.getPlayerTargetTemperature(player);
                TemperatureCapability cap = CapabilityUtil.getTempCapability(player);
                float playerTemp = MathUtil.round(cap.getTemperatureLevel(), 2);
                float worldTemp = TemperatureUtil.getWorldTemperature(player.m_9236_(), player.m_20183_());
                String reply = "Temp: " + playerTemp + "\nTarget Temp: " + targetTemperature + "\nWorld Temp: " + worldTemp;
                source.m_288197_(() -> Component.m_237113_((String)reply), false);
            }
        }
        catch (Exception e) {
            LegendarySurvivalOverhaul.LOGGER.error(e.getMessage());
        }
        return 1;
    }

    private int set(CommandSourceStack src, int temp) throws CommandSyntaxException {
        CapabilityUtil.getTempCapability((Player)src.m_81375_()).setTemperatureLevel(temp);
        return 1;
    }
}

