/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.capabilities.bodydamage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import org.apache.commons.lang3.tuple.Pair;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyDamageUtil;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyPartEnum;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.IBodyDamageCapability;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.MalusBodyPartEnum;
import sfiomn.legendarysurvivaloverhaul.api.health.HealthUtil;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.bodydamage.BodyPart;
import sfiomn.legendarysurvivaloverhaul.common.integration.curios.CuriosUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.ItemRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.SoundRegistry;
import sfiomn.legendarysurvivaloverhaul.util.EnumUtil;
import sfiomn.legendarysurvivaloverhaul.util.MathUtil;

public class BodyDamageCapability
implements IBodyDamageCapability {
    private Map<BodyPartEnum, BodyPart> bodyParts;
    private int headacheTimer;
    private int expectedBrokenHearts;
    private float healingTickTimer;
    private MobEffectInstance headacheEffect;
    private boolean hasFirstAidSupplies;
    private boolean hasFirstAidSuppliesBoosted;
    private MobEffectInstance passiveLimbRegenerationEffects;
    private boolean passiveLimbRegenerationEnabled;
    private int oldExpectedBrokenHearts;
    private int updateTickTimer;
    private float playerMaxHealth;
    private boolean manualDirty;
    private int packetTimer;
    private Map<MobEffect, Integer> malus;

    public BodyDamageCapability() {
        this.init();
    }

    public void init() {
        this.headacheEffect = null;
        this.hasFirstAidSupplies = false;
        this.hasFirstAidSuppliesBoosted = false;
        this.passiveLimbRegenerationEffects = null;
        this.updateTickTimer = 20;
        this.headacheTimer = 0;
        this.expectedBrokenHearts = 0;
        this.playerMaxHealth = 0.0f;
        this.manualDirty = false;
        this.healingTickTimer = 0.0f;
        this.bodyParts = new HashMap<BodyPartEnum, BodyPart>();
        this.malus = new HashMap<MobEffect, Integer>();
        this.bodyParts.put(BodyPartEnum.HEAD, new BodyPart(BodyPartEnum.HEAD, (float)Config.Baked.headPartHealth));
        this.bodyParts.put(BodyPartEnum.RIGHT_ARM, new BodyPart(BodyPartEnum.RIGHT_ARM, (float)Config.Baked.armsPartHealth));
        this.bodyParts.put(BodyPartEnum.LEFT_ARM, new BodyPart(BodyPartEnum.LEFT_ARM, (float)Config.Baked.armsPartHealth));
        this.bodyParts.put(BodyPartEnum.CHEST, new BodyPart(BodyPartEnum.CHEST, (float)Config.Baked.chestPartHealth));
        this.bodyParts.put(BodyPartEnum.RIGHT_LEG, new BodyPart(BodyPartEnum.RIGHT_LEG, (float)Config.Baked.legsPartHealth));
        this.bodyParts.put(BodyPartEnum.RIGHT_FOOT, new BodyPart(BodyPartEnum.RIGHT_FOOT, (float)Config.Baked.feetPartHealth));
        this.bodyParts.put(BodyPartEnum.LEFT_LEG, new BodyPart(BodyPartEnum.LEFT_LEG, (float)Config.Baked.legsPartHealth));
        this.bodyParts.put(BodyPartEnum.LEFT_FOOT, new BodyPart(BodyPartEnum.LEFT_FOOT, (float)Config.Baked.feetPartHealth));
        if (Config.Baked.bodyPartHealthMode != EnumUtil.bodyPartHealthMode.DYNAMIC) {
            for (BodyPart part : this.bodyParts.values()) {
                part.setMaxHealth(part.getHealthMultiplier());
            }
        }
    }

    @Override
    public void setManualDirty() {
        this.manualDirty = true;
    }

    @Override
    public boolean isDirty() {
        for (BodyPart bodyPart : this.bodyParts.values()) {
            if (!bodyPart.isDirty()) continue;
            return true;
        }
        return this.manualDirty || this.expectedBrokenHearts != this.oldExpectedBrokenHearts;
    }

    @Override
    public void setClean() {
        for (BodyPart bodyPart : this.bodyParts.values()) {
            bodyPart.setClean();
        }
        this.manualDirty = false;
        this.oldExpectedBrokenHearts = this.expectedBrokenHearts;
    }

    @Override
    public int getPacketTimer() {
        return this.packetTimer;
    }

    @Override
    public void tickUpdate(Player player, Level level, TickEvent.Phase phase) {
        if (phase == TickEvent.Phase.START) {
            ++this.packetTimer;
            return;
        }
        if (this.updateTickTimer++ >= 19) {
            this.updateTickTimer = 0;
            double playerMaxHealthCheckUpdate = HealthUtil.getPlayerStableMaxHealth(player);
            if (Config.Baked.bodyPartHealthMode == EnumUtil.bodyPartHealthMode.DYNAMIC && (double)this.playerMaxHealth != playerMaxHealthCheckUpdate) {
                this.playerMaxHealth = (float)playerMaxHealthCheckUpdate;
                this.updateBodyPartDynamicMaxHealth(this.playerMaxHealth);
            }
            HashMap<MobEffect, Integer> newMalus = new HashMap<MobEffect, Integer>();
            for (MalusBodyPartEnum malusBodyPart : MalusBodyPartEnum.values()) {
                List<Object> malusEffects = new ArrayList();
                if (!player.m_21023_((MobEffect)MobEffectRegistry.PAINKILLER.get())) {
                    malusEffects = BodyDamageUtil.getEffects(malusBodyPart, this.getHealthRatioForMalusBodyPart(malusBodyPart));
                }
                for (Pair malusEffect : malusEffects) {
                    Integer alreadyAppliedEffectAmplifier = (Integer)newMalus.get(malusEffect.getLeft());
                    if (alreadyAppliedEffectAmplifier != null && alreadyAppliedEffectAmplifier >= (Integer)malusEffect.getRight()) continue;
                    newMalus.put((MobEffect)malusEffect.getLeft(), (Integer)malusEffect.getRight());
                }
            }
            for (Map.Entry entry : this.malus.entrySet()) {
                MobEffect oldEffect = (MobEffect)entry.getKey();
                MobEffectInstance playerOldEffect = player.m_21124_(oldEffect);
                if (playerOldEffect == null || newMalus.containsKey(oldEffect) && playerOldEffect.m_19564_() <= (Integer)entry.getValue()) continue;
                player.m_21195_(oldEffect);
                if (oldEffect != MobEffectRegistry.HEADACHE.get()) continue;
                player.m_21195_(MobEffects.f_19610_);
            }
            this.malus = newMalus;
            for (Map.Entry entry : this.malus.entrySet()) {
                player.m_7292_(new MobEffectInstance((MobEffect)entry.getKey(), -1, ((Integer)entry.getValue()).intValue(), false, false, true));
            }
            for (Map.Entry entry : this.bodyParts.entrySet()) {
                BodyPart bodyPart = (BodyPart)entry.getValue();
                if (bodyPart.getRemainingHealingTicks() <= 0) continue;
                int healingTick = Math.min(20, bodyPart.getRemainingHealingTicks());
                this.healWithFoodExhaustion(player, (BodyPartEnum)((Object)entry.getKey()), (float)healingTick * bodyPart.getHealingPerTicks());
                if (bodyPart.isMaxHealth()) {
                    bodyPart.reduceRemainingHealingTicks(bodyPart.getRemainingHealingTicks());
                    continue;
                }
                bodyPart.reduceRemainingHealingTicks(healingTick);
            }
            this.updateBrokenHearts(player);
        }
        if (this.updateTickTimer % 10 == 0) {
            this.headacheEffect = player.m_21124_((MobEffect)MobEffectRegistry.HEADACHE.get());
            this.hasFirstAidSupplies = CuriosUtil.isCurioItemEquipped(player, (Item)ItemRegistry.FIRST_AID_SUPPLIES.get());
            if (this.hasFirstAidSupplies) {
                this.hasFirstAidSuppliesBoosted = BodyDamageUtil.hasPlayerFirstAidSuppliesBoostingEffect(player);
            } else {
                this.passiveLimbRegenerationEffects = BodyDamageUtil.getPlayerPassiveLimbRegenerationEffect(player);
                boolean bl = this.passiveLimbRegenerationEnabled = this.passiveLimbRegenerationEffects != null || Config.Baked.passiveLimbRegenerationOnFullHealth && HealthUtil.getPlayerStableMaxHealth(player) == (double)player.m_21223_();
            }
        }
        if (this.headacheEffect != null) {
            if (this.headacheTimer-- < 0) {
                this.applyHeadache(player, this.headacheEffect.m_19564_());
            }
        } else {
            this.headacheTimer = 0;
        }
        if (this.hasFirstAidSupplies) {
            boolean boostedHealingTickTimer = false;
            if (Config.Baked.firstAidSuppliesBoostedTickTimerMultiplier < 1.0) {
                boostedHealingTickTimer = this.hasFirstAidSuppliesBoosted;
            }
            this.healingTickTimer += boostedHealingTickTimer ? MathUtil.round((float)(1.0 / Config.Baked.firstAidSuppliesBoostedTickTimerMultiplier), 2) : 1.0f;
            if (this.healingTickTimer >= (float)Config.Baked.firstAidSuppliesTickTimer) {
                this.healingTickTimer = 0.0f;
                this.healMostDamaged(player, Config.Baked.limbRegenerationMode, (float)Config.Baked.firstAidSuppliesLimbHealthRegenerated, Config.Baked.firstAidSuppliesHealingOverflow, Config.Baked.firstAidSuppliesExhaustsFood);
            }
        } else if (this.passiveLimbRegenerationEnabled) {
            int passiveTickTimer = Config.Baked.passiveLimbRegenerationTickTimer;
            if (this.passiveLimbRegenerationEffects != null && Config.Baked.passiveLimbRegenerationAmplificationEnabled) {
                passiveTickTimer = Config.Baked.passiveLimbRegenerationTickTimer >> this.passiveLimbRegenerationEffects.m_19564_();
            }
            float f = this.healingTickTimer;
            this.healingTickTimer = f + 1.0f;
            if (f >= (float)passiveTickTimer) {
                this.healingTickTimer = 0.0f;
                this.healMostDamaged(player, EnumUtil.limbRegenerationMode.SIMPLE, (float)Config.Baked.passiveLimbHealthRegenerated, true, true);
            }
        } else {
            this.healingTickTimer = 0.0f;
        }
    }

    private void applyHeadache(Player player, int amplifier) {
        player.m_9236_().m_245747_(player.m_20183_(), (SoundEvent)SoundRegistry.HEADACHE_HEARTBEAT.get(), SoundSource.PLAYERS, 1.0f, 1.0f, false);
        int blindnessTime = (40 + player.m_217043_().m_188503_(100)) * Math.min(amplifier + 1, 4);
        this.headacheTimer = blindnessTime + Math.round((float)(200 + player.m_217043_().m_188503_(400)) / (float)Math.min(amplifier + 1, 4));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, blindnessTime, 0, false, false, true));
    }

    private void healMostDamaged(Player player, EnumUtil.limbRegenerationMode healingMode, float healingValue, boolean overflow, boolean exhaustFood) {
        BodyPart mostDamaged = this.getLowestHealthBodyPart();
        float damage = mostDamaged.getDamage();
        float actualHealingValue = healingMode == EnumUtil.limbRegenerationMode.PLAYER_DYNAMIC ? MathUtil.ceil(healingValue * player.m_21233_(), 2) : (healingMode == EnumUtil.limbRegenerationMode.LIMB_DYNAMIC ? MathUtil.ceil(healingValue * mostDamaged.getMaxHealth(), 2) : healingValue);
        BiConsumer<BodyPartEnum, Float> healingFunction = (part, amount) -> {
            if (exhaustFood) {
                this.healWithFoodExhaustion(player, (BodyPartEnum)((Object)part), amount.floatValue());
            } else {
                this.heal((BodyPartEnum)((Object)part), amount.floatValue());
            }
        };
        healingFunction.accept(mostDamaged.getBodyPartEnum(), Float.valueOf(actualHealingValue));
        float overflowHealing = actualHealingValue - damage;
        if (overflow && overflowHealing > 0.0f && healingMode != EnumUtil.limbRegenerationMode.LIMB_DYNAMIC) {
            mostDamaged = this.getLowestHealthBodyPart();
            healingFunction.accept(mostDamaged.getBodyPartEnum(), Float.valueOf(overflowHealing));
        }
    }

    private BodyPart getLowestHealthBodyPart() {
        return this.bodyParts.entrySet().stream().min((entry1, entry2) -> Float.compare(this.getBodyPartHealthRatio((BodyPartEnum)((Object)((Object)entry1.getKey()))), this.getBodyPartHealthRatio((BodyPartEnum)((Object)((Object)entry2.getKey()))))).map(Map.Entry::getValue).orElse(null);
    }

    @Override
    public void updateBrokenHearts(Player player) {
        if (Config.Baked.brokenHeartsPerInjuredLimb == 0.0) {
            return;
        }
        int expectedBrokenHearts = 0;
        for (Map.Entry<BodyPartEnum, BodyPart> bodyPartPair : this.bodyParts.entrySet()) {
            BodyPart bodyPart = bodyPartPair.getValue();
            if (!Config.Baked.healthOverhaulEnabled || !(bodyPart.getDamage() >= bodyPart.getMaxHealth())) continue;
            expectedBrokenHearts += (switch (Config.Baked.brokenHeartsPerInjuredLimbMode) {
                case EnumUtil.brokenHeartsPerInjuredLimbMode.PLAYER_DYNAMIC -> (int)(Config.Baked.brokenHeartsPerInjuredLimb * (double)this.playerMaxHealth / 2.0);
                case EnumUtil.brokenHeartsPerInjuredLimbMode.LIMB_DYNAMIC -> (int)(Config.Baked.brokenHeartsPerInjuredLimb * (double)bodyPart.getMaxHealth() / 2.0);
                default -> (int)(Config.Baked.brokenHeartsPerInjuredLimb / 2.0);
            });
        }
        this.expectedBrokenHearts = expectedBrokenHearts;
        BodyDamageUtil.updatePlayerBrokenHeartAttribute(player);
    }

    @Override
    public boolean isWoundedBelow(float healthPercent) {
        for (BodyPart part : this.bodyParts.values()) {
            if (!(this.getBodyPartHealthRatio(part.getBodyPartEnum()) < healthPercent)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getExpectedBrokenHearts() {
        return this.expectedBrokenHearts;
    }

    @Override
    public float getBodyPartDamage(BodyPartEnum part) {
        return this.bodyParts.get((Object)part).getDamage();
    }

    @Override
    public float getBodyPartMaxHealth(BodyPartEnum part) {
        return this.bodyParts.get((Object)part).getMaxHealth();
    }

    @Override
    public void setBodyPartDamage(BodyPartEnum part, float damageValue) {
        this.bodyParts.get((Object)part).setDamage(damageValue);
    }

    @Override
    public void setBodyPartMaxHealth(BodyPartEnum part, float maxHealthValue) {
        this.bodyParts.get((Object)part).setMaxHealth(maxHealthValue);
    }

    @Override
    public void healWithFoodExhaustion(Player player, BodyPartEnum part, float healingValue) {
        float exceedHeal = Math.max(healingValue - this.bodyParts.get((Object)part).getDamage(), 0.0f);
        this.heal(part, healingValue);
        if (Config.Baked.bodyHealingFoodExhaustion > 0.0 && player.m_36324_().m_38702_() > Config.Baked.minFoodOnBodyHealing) {
            player.m_36324_().m_38703_((float)((double)(healingValue - exceedHeal) * Config.Baked.bodyHealingFoodExhaustion));
        }
    }

    @Override
    public void heal(BodyPartEnum part, float healingValue) {
        this.bodyParts.get((Object)part).heal(healingValue);
    }

    @Override
    public void hurt(BodyPartEnum part, float damageValue) {
        this.bodyParts.get((Object)part).hurt(damageValue);
    }

    @Override
    public void applyHealingTime(BodyPartEnum part, int healingTicks, float healingPerTick) {
        this.bodyParts.get((Object)part).setHealing(healingTicks, healingPerTick);
    }

    @Override
    public float getBodyPartHealthRatio(BodyPartEnum part) {
        BodyPart bodyPart = this.bodyParts.get((Object)part);
        return MathUtil.round((bodyPart.getMaxHealth() - bodyPart.getDamage()) / bodyPart.getMaxHealth(), 2);
    }

    @Override
    public int getRemainingHealingTicks(BodyPartEnum part) {
        return this.bodyParts.get((Object)part).getRemainingHealingTicks();
    }

    @Override
    public float getHealingPerTicks(BodyPartEnum part) {
        return this.bodyParts.get((Object)part).getHealingPerTicks();
    }

    @Override
    public float getHealthRatioForMalusBodyPart(MalusBodyPartEnum part) {
        return switch (part) {
            default -> throw new IncompatibleClassChangeError();
            case MalusBodyPartEnum.HEAD -> this.getBodyPartHealthRatio(BodyPartEnum.HEAD);
            case MalusBodyPartEnum.ARMS -> Math.min(this.getBodyPartHealthRatio(BodyPartEnum.RIGHT_ARM), this.getBodyPartHealthRatio(BodyPartEnum.LEFT_ARM));
            case MalusBodyPartEnum.BOTH_ARMS -> Math.max(this.getBodyPartHealthRatio(BodyPartEnum.RIGHT_ARM), this.getBodyPartHealthRatio(BodyPartEnum.LEFT_ARM));
            case MalusBodyPartEnum.CHEST -> this.getBodyPartHealthRatio(BodyPartEnum.CHEST);
            case MalusBodyPartEnum.LEGS -> Math.min(this.getBodyPartHealthRatio(BodyPartEnum.RIGHT_LEG), this.getBodyPartHealthRatio(BodyPartEnum.LEFT_LEG));
            case MalusBodyPartEnum.BOTH_LEGS -> Math.max(this.getBodyPartHealthRatio(BodyPartEnum.RIGHT_LEG), this.getBodyPartHealthRatio(BodyPartEnum.LEFT_LEG));
            case MalusBodyPartEnum.FEET -> Math.min(this.getBodyPartHealthRatio(BodyPartEnum.RIGHT_FOOT), this.getBodyPartHealthRatio(BodyPartEnum.LEFT_FOOT));
            case MalusBodyPartEnum.BOTH_FEET -> Math.max(this.getBodyPartHealthRatio(BodyPartEnum.RIGHT_FOOT), this.getBodyPartHealthRatio(BodyPartEnum.LEFT_FOOT));
        };
    }

    private void updateBodyPartDynamicMaxHealth(float maxHealth) {
        for (BodyPart bodyPart : this.bodyParts.values()) {
            float newMaxHealth = (float)Math.round(bodyPart.getHealthMultiplier() * maxHealth * 100.0f) / 100.0f;
            float oldMaxHealth = bodyPart.getMaxHealth();
            bodyPart.setMaxHealth(newMaxHealth);
            if (oldMaxHealth == 0.0f) continue;
            bodyPart.setDamage(bodyPart.getDamage() + newMaxHealth - oldMaxHealth);
        }
    }

    public CompoundTag writeNBT() {
        CompoundTag compound = new CompoundTag();
        for (BodyPart bodyPart : this.bodyParts.values()) {
            compound = bodyPart.writeNbt(compound);
        }
        compound.m_128405_("headacheTimer", this.headacheTimer);
        compound.m_128405_("expectedBrokenHearts", this.expectedBrokenHearts);
        compound.m_128350_("healingTickTimer", this.healingTickTimer);
        return compound;
    }

    public void readNBT(CompoundTag compound) {
        this.init();
        for (BodyPart bodyPart : this.bodyParts.values()) {
            bodyPart.readNBT(compound);
        }
        this.headacheTimer = compound.m_128451_("headacheTimer");
        this.expectedBrokenHearts = compound.m_128451_("expectedBrokenHearts");
        this.healingTickTimer = compound.m_128457_("healingTickTimer");
    }
}

