/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.render;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.wetness.WetnessCapability;
import sfiomn.legendarysurvivaloverhaul.common.integration.curios.CuriosUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.util.CapabilityUtil;

public class RenderWetnessGui {
    private static WetnessCapability WETNESS_CAP = null;
    private static final Random rand = new Random();
    private static final ResourceLocation ICONS = new ResourceLocation("legendarysurvivaloverhaul", "textures/gui/overlay.png");
    private static final int WETNESS_TEXTURE_POS_Y = 96;
    private static final int WETNESS_TEXTURE_WIDTH = 10;
    private static final int WETNESS_TEXTURE_HEIGHT = 10;
    private static int frameCounter = -1;
    private static boolean startAnimation = false;
    private static WetnessIcon lastWetnessIcon;
    private static int flashCounter;
    public static IGuiOverlay WETNESS_GUI;

    public static void drawWetness(GuiGraphics gui, Player player, int width, int height) {
        WetnessIcon wetnessIcon;
        int wetness;
        if (WETNESS_CAP == null || player.f_19797_ % 20 == 0) {
            WETNESS_CAP = CapabilityUtil.getWetnessCapability(player);
        }
        if ((wetness = WETNESS_CAP.getWetness()) == 0) {
            return;
        }
        int x = width / 2 - 5 + Config.Baked.wetnessIndicatorOffsetX;
        int y = height - 61 + Config.Baked.wetnessIndicatorOffsetY;
        if (CuriosUtil.isThermometerEquipped && Config.Baked.wetnessIndicatorOffsetY == 0) {
            y += 10;
        }
        if (lastWetnessIcon != (wetnessIcon = WetnessIcon.get(wetness))) {
            flashCounter = 3;
            lastWetnessIcon = wetnessIcon;
        }
        gui.m_280218_(ICONS, x, y, wetnessIcon.getXTextureOffset(), wetnessIcon.getYTextureOffset(flashCounter >= 0), 10, 10);
    }

    public static void updateTimer() {
        if (frameCounter >= 0) {
            --frameCounter;
        }
        if (flashCounter >= 0) {
            --flashCounter;
        }
        if (startAnimation) {
            frameCounter = 24;
            startAnimation = false;
        }
    }

    static {
        flashCounter = -1;
        WETNESS_GUI = (forgeGui, guiGraphics, partialTicks, width, height) -> {
            LocalPlayer player;
            if (Config.Baked.wetnessEnabled && !Minecraft.m_91087_().f_91066_.f_92062_ && forgeGui.shouldDrawSurvivalElements() && (player = forgeGui.getMinecraft().f_91074_) != null) {
                rand.setSeed((long)player.f_19797_ * 445L);
                forgeGui.setupOverlayRenderState(true, false);
                Minecraft.m_91087_().m_91307_().m_6180_("wetness_gui");
                RenderWetnessGui.drawWetness(guiGraphics, (Player)player, width, height);
                Minecraft.m_91087_().m_91307_().m_7238_();
            }
        };
    }

    private static enum WetnessIcon {
        WETNESS_0(0),
        WETNESS_1(1),
        WETNESS_2(2),
        WETNESS_3(3);

        public final int iconIndexX;

        private WetnessIcon(int iconIndexX) {
            this.iconIndexX = iconIndexX;
        }

        public int getXTextureOffset() {
            return this.iconIndexX * 10;
        }

        public int getYTextureOffset(boolean isFlash) {
            return 96 + (isFlash ? 10 : 0);
        }

        public static WetnessIcon get(int wetness) {
            float wetnessRation = (float)wetness / 400.0f;
            if (wetnessRation <= 0.25f) {
                return WETNESS_0;
            }
            if (wetnessRation <= 0.5f) {
                return WETNESS_1;
            }
            if (wetnessRation <= 0.75f) {
                return WETNESS_2;
            }
            return WETNESS_3;
        }
    }
}

