/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.world;

import com.talhanation.recruits.world.RecruitsFaction;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class RecruitsPlayerInfo {
    private UUID uuid;
    private String name;
    @Nullable
    private final RecruitsFaction recruitsFaction;

    public RecruitsPlayerInfo(UUID uuid, String name) {
        this(uuid, name, null);
    }

    public RecruitsPlayerInfo(UUID uuid, String name, @Nullable RecruitsFaction recruitsFaction) {
        this.uuid = uuid;
        this.name = name;
        this.recruitsFaction = recruitsFaction;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    public RecruitsFaction getRecruitsTeam() {
        return this.recruitsFaction;
    }

    public String toString() {
        return "{, uuid=" + this.uuid + ", name=" + this.name + ", team=" + this.recruitsFaction + "}";
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("UUID", this.uuid);
        nbt.m_128359_("Name", this.name);
        if (this.recruitsFaction != null) {
            nbt.m_128365_("RecruitsTeam", (Tag)this.recruitsFaction.toNBT());
        }
        return nbt;
    }

    public static RecruitsPlayerInfo getFromNBT(CompoundTag nbt) {
        if (nbt == null || nbt.m_128456_()) {
            return null;
        }
        UUID uuid = nbt.m_128342_("UUID");
        String name = nbt.m_128461_("Name");
        RecruitsFaction team = RecruitsFaction.fromNBT(nbt.m_128469_("RecruitsTeam"));
        return new RecruitsPlayerInfo(uuid, name, team);
    }

    public static CompoundTag toNBT(List<RecruitsPlayerInfo> list) {
        CompoundTag nbt = new CompoundTag();
        ListTag playerList = new ListTag();
        for (RecruitsPlayerInfo playerInfo : list) {
            CompoundTag playerTag = playerInfo.toNBT();
            playerList.add((Object)playerTag);
        }
        nbt.m_128365_("Players", (Tag)playerList);
        return nbt;
    }

    public static List<RecruitsPlayerInfo> getListFromNBT(CompoundTag nbt) {
        ArrayList<RecruitsPlayerInfo> list = new ArrayList<RecruitsPlayerInfo>();
        ListTag playerList = nbt.m_128437_("Players", 10);
        for (int i = 0; i < playerList.size(); ++i) {
            CompoundTag playerTag = playerList.m_128728_(i);
            RecruitsPlayerInfo playerInfo = RecruitsPlayerInfo.getFromNBT(playerTag);
            list.add(playerInfo);
        }
        return list;
    }
}

