/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.world;

import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.init.ModEntityTypes;
import com.talhanation.recruits.world.RecruitsHireTrade;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class RecruitsHireTradesRegistry {
    public static int totalTraderTypes = 2;
    private static final Component TITLE_RECRUIT = Component.m_237115_((String)"description.recruits.title.recruit");
    private static final Component TITLE_SHIELDMAN = Component.m_237115_((String)"description.recruits.title.shieldman");
    private static final Component TITLE_BOWMAN = Component.m_237115_((String)"description.recruits.title.bowman");
    private static final Component TITLE_CROSSBOWMAN = Component.m_237115_((String)"description.recruits.title.crossbowman");
    private static final Component TITLE_NOMAD = Component.m_237115_((String)"description.recruits.title.nomad");
    private static final Component TITLE_HORSEMAN = Component.m_237115_((String)"description.recruits.title.horseman");
    private static final Component TITLE_MESSENGER = Component.m_237115_((String)"description.recruits.title.messenger");
    private static final Component TITLE_SCOUT = Component.m_237115_((String)"description.recruits.title.scout");
    private static final Component TITLE_CAPTAIN = Component.m_237115_((String)"description.recruits.title.captain");
    private static final Component TITLE_PATROL_LEADER = Component.m_237115_((String)"description.recruits.title.commander");
    private static final Component DESCRIPTION_RECRUIT = Component.m_237115_((String)"description.recruits.recruit");
    private static final Component DESCRIPTION_SHIELDMAN = Component.m_237115_((String)"description.recruits.shieldman");
    private static final Component DESCRIPTION_BOWMAN = Component.m_237115_((String)"description.recruits.bowman");
    private static final Component DESCRIPTION_CROSSBOWMAN = Component.m_237115_((String)"description.recruits.crossbowman");
    private static final Component DESCRIPTION_NOMAD = Component.m_237115_((String)"description.recruits.nomad");
    private static final Component DESCRIPTION_HORSEMAN = Component.m_237115_((String)"description.recruits.horseman");
    private static final Component DESCRIPTION_MESSENGER = Component.m_237115_((String)"description.recruits.messenger");
    private static final Component DESCRIPTION_SCOUT = Component.m_237115_((String)"description.recruits.scout");
    private static final Component DESCRIPTION_CAPTAIN = Component.m_237115_((String)"description.recruits.captain");
    private static final Component DESCRIPTION_PATROL_LEADER = Component.m_237115_((String)"description.recruits.commander");
    public static RecruitsHireTrade RECRUIT = new RecruitsHireTrade(ModEntityTypes.RECRUIT.getId(), (Integer)RecruitsServerConfig.RecruitCost.get(), TITLE_RECRUIT, DESCRIPTION_RECRUIT);
    public static RecruitsHireTrade SHIELDMAN = new RecruitsHireTrade(ModEntityTypes.RECRUIT_SHIELDMAN.getId(), (Integer)RecruitsServerConfig.ShieldmanCost.get(), TITLE_SHIELDMAN, DESCRIPTION_SHIELDMAN);
    public static RecruitsHireTrade BOWMAN = new RecruitsHireTrade(ModEntityTypes.BOWMAN.getId(), (Integer)RecruitsServerConfig.BowmanCost.get(), TITLE_BOWMAN, DESCRIPTION_BOWMAN);
    public static RecruitsHireTrade CROSSBOWMAN = new RecruitsHireTrade(ModEntityTypes.CROSSBOWMAN.getId(), (Integer)RecruitsServerConfig.CrossbowmanCost.get(), TITLE_CROSSBOWMAN, DESCRIPTION_CROSSBOWMAN);
    public static RecruitsHireTrade NOMAD = new RecruitsHireTrade(ModEntityTypes.NOMAD.getId(), (Integer)RecruitsServerConfig.NomadCost.get(), TITLE_NOMAD, DESCRIPTION_NOMAD);
    public static RecruitsHireTrade HORSEMAN = new RecruitsHireTrade(ModEntityTypes.HORSEMAN.getId(), (Integer)RecruitsServerConfig.HorsemanCost.get(), TITLE_HORSEMAN, DESCRIPTION_HORSEMAN);
    public static RecruitsHireTrade MESSENGER = new RecruitsHireTrade(ModEntityTypes.MESSENGER.getId(), 32, TITLE_MESSENGER, DESCRIPTION_MESSENGER);
    public static RecruitsHireTrade SCOUT = new RecruitsHireTrade(ModEntityTypes.SCOUT.getId(), 32, TITLE_SCOUT, DESCRIPTION_SCOUT);
    public static RecruitsHireTrade CAPTAIN = new RecruitsHireTrade(ModEntityTypes.CAPTAIN.getId(), 64, TITLE_CAPTAIN, DESCRIPTION_CAPTAIN);
    public static RecruitsHireTrade PATROL_LEADER = new RecruitsHireTrade(ModEntityTypes.PATROL_LEADER.getId(), 64, TITLE_PATROL_LEADER, DESCRIPTION_PATROL_LEADER);
    private static final Map<String, Map<Integer, List<RecruitsHireTrade>>> TRADES = new HashMap<String, Map<Integer, List<RecruitsHireTrade>>>();

    public static void registerTrades() {
        RecruitsHireTradesRegistry.addTrade("infantry", 1, RECRUIT, SHIELDMAN);
        RecruitsHireTradesRegistry.addTrade("infantry", 2, HORSEMAN);
        RecruitsHireTradesRegistry.addTrade("infantry", 3, CAPTAIN, PATROL_LEADER);
        RecruitsHireTradesRegistry.addTrade("ranged", 1, RECRUIT, BOWMAN);
        RecruitsHireTradesRegistry.addTrade("ranged", 2, NOMAD);
        RecruitsHireTradesRegistry.addTrade("ranged", 3, MESSENGER, SCOUT);
        RecruitsHireTradesRegistry.addTrade("ranged2", 1, RECRUIT, CROSSBOWMAN);
        RecruitsHireTradesRegistry.addTrade("ranged2", 2, SHIELDMAN);
        RecruitsHireTradesRegistry.addTrade("ranged2", 3, MESSENGER, SCOUT);
    }

    public static void addTrade(String traderType, int level, RecruitsHireTrade ... units) {
        TRADES.computeIfAbsent(traderType, k -> new HashMap()).put(level, Arrays.asList(units));
    }

    public static List<RecruitsHireTrade> getTrades(String traderType, int level) {
        return TRADES.getOrDefault(traderType, Collections.emptyMap()).getOrDefault(level, Collections.emptyList());
    }

    public static List<String> getAllTraderTypes() {
        ArrayList<String> list = new ArrayList<String>(TRADES.keySet());
        Collections.sort(list);
        return list;
    }

    @Nullable
    public static RecruitsHireTrade getByResourceLocation(ResourceLocation resourceLocation) {
        for (Map<Integer, List<RecruitsHireTrade>> levelMap : TRADES.values()) {
            for (List<RecruitsHireTrade> tradeList : levelMap.values()) {
                for (RecruitsHireTrade trade : tradeList) {
                    if (trade == null || !resourceLocation.equals((Object)trade.resourceLocation)) continue;
                    return trade;
                }
            }
        }
        return null;
    }
}

