/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.world;

import com.talhanation.recruits.world.RecruitsPlayerInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class RecruitsGroup {
    public static List<ResourceLocation> IMAGES = new ArrayList<ResourceLocation>(Arrays.asList(new ResourceLocation("recruits", "textures/gui/image/group/sword.png"), new ResourceLocation("recruits", "textures/gui/image/group/shield.png"), new ResourceLocation("recruits", "textures/gui/image/group/bow.png"), new ResourceLocation("recruits", "textures/gui/image/group/crossbow.png"), new ResourceLocation("recruits", "textures/gui/image/group/arrow.png"), new ResourceLocation("recruits", "textures/gui/image/group/horse.png"), new ResourceLocation("recruits", "textures/gui/image/group/horse_arrow.png"), new ResourceLocation("recruits", "textures/gui/image/group/house.png"), new ResourceLocation("recruits", "textures/gui/image/group/tower.png"), new ResourceLocation("recruits", "textures/gui/image/group/fort.png"), new ResourceLocation("recruits", "textures/gui/image/group/tent.png"), new ResourceLocation("recruits", "textures/gui/image/group/ship.png"), new ResourceLocation("recruits", "textures/gui/image/group/ship2.png"), new ResourceLocation("recruits", "textures/gui/image/group/catapult.png"), new ResourceLocation("recruits", "textures/gui/image/group/axe.png"), new ResourceLocation("recruits", "textures/gui/image/group/hoe.png"), new ResourceLocation("recruits", "textures/gui/image/group/pickaxe.png"), new ResourceLocation("recruits", "textures/gui/image/group/sword2.png"), new ResourceLocation("recruits", "textures/gui/image/group/arrow2.png"), new ResourceLocation("recruits", "textures/gui/image/group/3arrow.png")));
    private UUID uuid;
    public List<UUID> members = new ArrayList<UUID>();
    private int size;
    private int count;
    private UUID playerUUID;
    private String playerName;
    private String name;
    private boolean disabled;
    public boolean removed;
    public DisbandContext disbandContext;
    private int image;
    public BlockPos upkeep;
    public int aggroState;
    public int followState;
    public UUID protectUUID;
    public UUID leaderUUID;
    public boolean allowRanged;
    public boolean allowRest;
    public int groupMorale;
    public int groupHealth;

    public RecruitsGroup(String name, RecruitsPlayerInfo playerInfo, int image) {
        this(name, playerInfo.getUUID(), playerInfo.getName(), image);
    }

    public RecruitsGroup(String name, Player player, int image) {
        this(name, player.m_20148_(), player.m_7755_().getString(), image);
    }

    public RecruitsGroup(String name, UUID playerUUID, String playerName, int image) {
        this.name = name;
        this.playerUUID = playerUUID;
        this.playerName = playerName;
        this.uuid = UUID.randomUUID();
        this.image = image;
    }

    private RecruitsGroup(String name, UUID playerUUID, String playerName, int size, int image, DisbandContext disbandContext) {
        this.name = name;
        this.playerUUID = playerUUID;
        this.playerName = playerName;
        this.size = size;
        this.image = image;
        this.disbandContext = disbandContext;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPlayer(RecruitsPlayerInfo playerInfo) {
        this.playerUUID = playerInfo.getUUID();
        this.playerName = playerInfo.getName();
    }

    public void setPlayer(Player player) {
        this.playerUUID = player.m_20148_();
        this.playerName = player.m_7755_().getString();
    }

    public void addMember(UUID member) {
        this.members.add(member);
        this.size = this.members.size();
    }

    public void removeMember(UUID member) {
        this.members.remove(member);
        this.size = this.members.size();
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setSize(int x) {
        this.size = x;
    }

    public int getSize() {
        return this.size;
    }

    public int getImage() {
        return this.image;
    }

    public int getCount() {
        return this.count;
    }

    public void setImage(int x) {
        this.image = x;
    }

    public void setCount(int x) {
        this.count = x;
    }

    public void setDisabled(boolean x) {
        this.disabled = x;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisbandContext(DisbandContext disbandContext) {
        this.disbandContext = disbandContext;
    }

    public RecruitsGroup copy() {
        return new RecruitsGroup(this.name, this.playerUUID, this.playerName, this.size, this.image, this.disbandContext);
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("uuid", this.uuid);
        tag.m_128359_("name", this.name);
        tag.m_128362_("playerUUID", this.playerUUID);
        tag.m_128359_("playerName", this.playerName);
        tag.m_128405_("size", this.size);
        tag.m_128379_("disabled", this.disabled);
        tag.m_128379_("removed", this.removed);
        tag.m_128405_("image", this.image);
        if (this.leaderUUID != null) {
            tag.m_128362_("leaderUUID", this.leaderUUID);
        }
        ListTag uuidList = new ListTag();
        for (UUID id : this.members) {
            CompoundTag entry = new CompoundTag();
            entry.m_128362_("id", id);
            uuidList.add((Object)entry);
        }
        tag.m_128365_("members", (Tag)uuidList);
        return tag;
    }

    public static RecruitsGroup fromNBT(CompoundTag tag) {
        if (tag == null || tag.m_128456_()) {
            return null;
        }
        UUID uuid = tag.m_128342_("uuid");
        String name = tag.m_128461_("name");
        String playerName = tag.m_128461_("playerName");
        UUID playerUUID = tag.m_128342_("playerUUID");
        int size = tag.m_128451_("size");
        int image = tag.m_128451_("image");
        boolean removed = tag.m_128471_("removed");
        DisbandContext disbandContext = DisbandContext.fromNBT(tag);
        RecruitsGroup group = new RecruitsGroup(name, playerUUID, playerName, size, image, disbandContext);
        group.setUUID(uuid);
        group.removed = removed;
        if (tag.m_128441_("leaderUUID")) {
            group.leaderUUID = tag.m_128342_("leaderUUID");
        }
        if (tag.m_128425_("members", 9)) {
            ListTag uuidList = tag.m_128437_("members", 10);
            for (Tag entry : uuidList) {
                CompoundTag uuidTag = (CompoundTag)entry;
                UUID recruitID = uuidTag.m_128342_("id");
                group.members.add(recruitID);
            }
        }
        return group;
    }

    public static CompoundTag listToNbt(List<RecruitsGroup> groups) {
        CompoundTag compound = new CompoundTag();
        if (groups == null) {
            return compound;
        }
        ListTag list = new ListTag();
        for (RecruitsGroup t : groups) {
            list.add((Object)t.toNBT());
        }
        compound.m_128365_("Groups", (Tag)list);
        return compound;
    }

    public static List<RecruitsGroup> listFromNbt(CompoundTag compound) {
        ArrayList<RecruitsGroup> out = new ArrayList<RecruitsGroup>();
        if (compound == null || !compound.m_128425_("Groups", 9)) {
            return out;
        }
        ListTag list = compound.m_128437_("Groups", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.m_128728_(i);
            out.add(RecruitsGroup.fromNBT(entry));
        }
        return out;
    }

    public static class DisbandContext {
        public boolean disband;
        public boolean keepTeam;
        public boolean increaseCost;

        public DisbandContext(boolean disband, boolean keepTeam, boolean increaseCost) {
            this.disband = disband;
            this.keepTeam = keepTeam;
            this.increaseCost = increaseCost;
        }

        public CompoundTag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("disband", this.disband);
            tag.m_128379_("keepTeam", this.keepTeam);
            tag.m_128379_("increaseCost", this.increaseCost);
            return tag;
        }

        public static DisbandContext fromNBT(CompoundTag tag) {
            boolean disband = tag.m_128471_("disband");
            boolean keepTeam = tag.m_128471_("keepTeam");
            boolean increaseCost = tag.m_128471_("increaseCost");
            return new DisbandContext(disband, keepTeam, increaseCost);
        }
    }
}

