/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.world;

import com.talhanation.recruits.FactionEvents;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.network.MessageToClientSetDiplomaticToast;
import com.talhanation.recruits.network.MessageToClientUpdateDiplomacyList;
import com.talhanation.recruits.world.RecruitsDiplomacySaveData;
import com.talhanation.recruits.world.RecruitsFaction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class RecruitsDiplomacyManager {
    public Map<String, Map<String, DiplomacyStatus>> diplomacyMap = new HashMap<String, Map<String, DiplomacyStatus>>();

    public void load(ServerLevel level) {
        RecruitsDiplomacySaveData data = RecruitsDiplomacySaveData.get(level);
        this.diplomacyMap = data.getDiplomacyMap();
    }

    public void save(ServerLevel level) {
        RecruitsDiplomacySaveData data = RecruitsDiplomacySaveData.get(level);
        for (Map.Entry<String, Map<String, DiplomacyStatus>> entry : this.diplomacyMap.entrySet()) {
            String team = entry.getKey();
            Map<String, DiplomacyStatus> relations = entry.getValue();
            for (Map.Entry<String, DiplomacyStatus> relationEntry : relations.entrySet()) {
                data.setRelation(team, relationEntry.getKey(), relationEntry.getValue().getByteValue());
            }
        }
        data.m_77762_();
        this.broadcastDiplomacyMapToAll(level);
    }

    public void setRelation(String team, String otherTeam, DiplomacyStatus relation, ServerLevel level) {
        DiplomacyStatus currentRelation = this.getRelation(team, otherTeam);
        if (currentRelation == relation) {
            return;
        }
        this.diplomacyMap.computeIfAbsent(team, k -> new HashMap()).put(otherTeam, relation);
        this.notifyPlayersInTeam(team, otherTeam, relation, level);
        this.save(level);
    }

    public DiplomacyStatus getRelation(String team, String otherTeam) {
        return ((Map)this.diplomacyMap.getOrDefault(team, new HashMap())).getOrDefault(otherTeam, DiplomacyStatus.NEUTRAL);
    }

    public void notifyPlayersInTeam(String teamName, String otherTeamName, DiplomacyStatus relation, ServerLevel level) {
        RecruitsFaction team = FactionEvents.recruitsFactionManager.getTeamByStringID(teamName);
        RecruitsFaction otherTeam = FactionEvents.recruitsFactionManager.getTeamByStringID(otherTeamName);
        if (team != null && otherTeam != null) {
            List<ServerPlayer> playersInTeam = FactionEvents.recruitsFactionManager.getPlayersInTeam(team.getStringID(), level);
            for (ServerPlayer player : playersInTeam) {
                Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageToClientSetDiplomaticToast(relation.getByteValue(), otherTeam));
            }
            List<ServerPlayer> playersInTeam2 = FactionEvents.recruitsFactionManager.getPlayersInTeam(otherTeam.getStringID(), level);
            for (ServerPlayer player : playersInTeam2) {
                Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageToClientSetDiplomaticToast(relation.getByteValue() + 4, team));
            }
        }
    }

    public static CompoundTag mapToNbt(Map<String, Map<String, DiplomacyStatus>> diplomacyMap) {
        CompoundTag nbt = new CompoundTag();
        diplomacyMap.forEach((team, relations) -> {
            CompoundTag teamTag = new CompoundTag();
            relations.forEach((otherTeam, status) -> teamTag.m_128344_(otherTeam, status.getByteValue()));
            nbt.m_128365_(team, (Tag)teamTag);
        });
        return nbt;
    }

    public static Map<String, Map<String, DiplomacyStatus>> mapFromNbt(CompoundTag nbt) {
        HashMap<String, Map<String, DiplomacyStatus>> diplomacyMap = new HashMap<String, Map<String, DiplomacyStatus>>();
        for (String team : nbt.m_128431_()) {
            CompoundTag teamTag = nbt.m_128469_(team);
            HashMap<String, DiplomacyStatus> relations = new HashMap<String, DiplomacyStatus>();
            for (String otherTeam : teamTag.m_128431_()) {
                byte statusByte = teamTag.m_128445_(otherTeam);
                DiplomacyStatus status = DiplomacyStatus.fromByte(statusByte);
                relations.put(otherTeam, status);
            }
            diplomacyMap.put(team, relations);
        }
        return diplomacyMap;
    }

    public void broadcastDiplomacyMapToPlayer(Player player) {
        if (player == null) {
            return;
        }
        Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageToClientUpdateDiplomacyList(this.diplomacyMap));
    }

    public void broadcastDiplomacyMapToAll(ServerLevel serverLevel) {
        if (serverLevel == null) {
            return;
        }
        for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
            Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MessageToClientUpdateDiplomacyList(this.diplomacyMap));
        }
    }

    public static enum DiplomacyStatus {
        NEUTRAL(0),
        ALLY(1),
        ENEMY(2);

        private final byte byteValue;

        private DiplomacyStatus(byte byteValue) {
            this.byteValue = byteValue;
        }

        public byte getByteValue() {
            return this.byteValue;
        }

        public static DiplomacyStatus fromByte(byte value) {
            return switch (value) {
                case 1 -> ALLY;
                case 2 -> ENEMY;
                default -> NEUTRAL;
            };
        }
    }
}

