/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.util;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.util.FormationUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;

public class RecruitCommanderUtil {
    public static void setRecruitsFollow(List<AbstractRecruitEntity> recruits, @Nullable UUID leaderUUID) {
        if (recruits == null || recruits.isEmpty()) {
            return;
        }
        for (AbstractRecruitEntity recruit : recruits) {
            if (recruit == null || !recruit.m_6084_()) continue;
            if (leaderUUID == null) {
                recruit.setProtectUUID(Optional.empty());
                continue;
            }
            recruit.setProtectUUID(Optional.of(leaderUUID));
            recruit.setFollowState(5);
        }
    }

    public static void setRecruitsHoldPos(List<AbstractRecruitEntity> recruits) {
        if (recruits == null || recruits.isEmpty()) {
            return;
        }
        for (AbstractRecruitEntity recruit : recruits) {
            if (recruit == null || !recruit.m_6084_()) continue;
            recruit.setFollowState(2);
        }
    }

    public static void setRecruitsMove(List<AbstractRecruitEntity> recruits, BlockPos pos) {
        if (recruits == null || recruits.isEmpty()) {
            return;
        }
        for (AbstractRecruitEntity recruit : recruits) {
            if (recruit == null || !recruit.m_6084_()) continue;
            recruit.setMovePos(pos);
            recruit.setFollowState(0);
            recruit.setShouldMovePos(true);
        }
    }

    public static void setRecruitsMoveSpeed(List<AbstractRecruitEntity> recruits, float speed) {
        if (recruits == null || recruits.isEmpty()) {
            return;
        }
        for (AbstractRecruitEntity recruit : recruits) {
            if (recruit == null || !recruit.m_6084_()) continue;
            recruit.moveSpeed = speed;
        }
    }

    public static void setRecruitsPatrolMoveSpeed(List<AbstractRecruitEntity> recruits, float speed, float range) {
        if (recruits == null || recruits.isEmpty()) {
            return;
        }
        for (AbstractRecruitEntity recruit : recruits) {
            if (recruit == null || !recruit.m_6084_()) continue;
            double distance = recruit.m_20238_(recruit.getHoldPos());
            if (distance <= (double)range) {
                recruit.moveSpeed = speed;
                continue;
            }
            recruit.moveSpeed = 1.0f;
        }
    }

    public static void setRecruitsClearTargets(List<AbstractRecruitEntity> recruits) {
        if (recruits == null || recruits.isEmpty()) {
            return;
        }
        for (AbstractRecruitEntity recruit : recruits) {
            if (recruit == null || !recruit.m_6084_()) continue;
            recruit.m_6710_(null);
        }
    }

    public static void setRecruitsWanderFreely(List<AbstractRecruitEntity> recruits) {
        if (recruits == null || recruits.isEmpty()) {
            return;
        }
        for (AbstractRecruitEntity recruit : recruits) {
            if (recruit == null || !recruit.m_6084_()) continue;
            recruit.clearHoldPos();
            recruit.setFollowState(0);
        }
    }

    public static void setRecruitsShields(List<AbstractRecruitEntity> recruits, boolean shields) {
        if (recruits == null || recruits.isEmpty()) {
            return;
        }
        for (AbstractRecruitEntity recruit : recruits) {
            if (recruit == null || !recruit.m_6084_()) continue;
            recruit.clearHoldPos();
            recruit.setShouldBlock(shields);
        }
    }

    public static void setRecruitsMoveAndHold(List<AbstractRecruitEntity> recruits, Vec3 target, Vec3 linePos) {
        if (recruits == null || recruits.isEmpty()) {
            return;
        }
        for (AbstractRecruitEntity recruit : recruits) {
            if (recruit == null || !recruit.m_6084_()) continue;
            recruit.reachedMovePos = false;
            Vec3 pos = FormationUtils.calculateLineBlockPosition(target, linePos, recruits.size(), recruits.indexOf((Object)recruit), recruit.m_20193_());
            recruit.setFollowState(0);
            recruit.setShouldMovePos(true);
        }
    }

    public static void setRecruitsUpkeep(List<AbstractRecruitEntity> recruits, BlockPos upkeepPos, UUID upkeepUUID) {
        if (recruits == null || recruits.isEmpty()) {
            return;
        }
        for (AbstractRecruitEntity recruit : recruits) {
            if (recruit == null || !recruit.m_6084_()) continue;
            recruit.clearUpkeepEntity();
            recruit.clearUpkeepPos();
            recruit.setUpkeepPos(upkeepPos);
            recruit.setUpkeepUUID(Optional.ofNullable(upkeepUUID));
            recruit.setUpkeepTimer(0);
            recruit.m_6710_(null);
            recruit.forcedUpkeep = true;
        }
    }

    public static void clearRecruitsUpkeep(List<AbstractRecruitEntity> recruits) {
        if (recruits == null || recruits.isEmpty()) {
            return;
        }
        for (AbstractRecruitEntity recruit : recruits) {
            if (recruit == null || !recruit.m_6084_()) continue;
            recruit.clearUpkeepEntity();
            recruit.clearUpkeepPos();
            recruit.setUpkeepTimer(0);
        }
    }

    public static void setRecruitsMount(List<AbstractRecruitEntity> recruits, UUID mountUUID) {
        if (recruits == null || recruits.isEmpty()) {
            return;
        }
        for (AbstractRecruitEntity recruit : recruits) {
            if (recruit == null || !recruit.m_6084_()) continue;
            recruit.shouldMount(true, mountUUID);
            recruit.dismount = 0;
        }
    }

    public static void setRecruitsDismount(List<AbstractRecruitEntity> recruits) {
        if (recruits == null || recruits.isEmpty()) {
            return;
        }
        for (AbstractRecruitEntity recruit : recruits) {
            if (recruit == null || !recruit.m_6084_()) continue;
            recruit.shouldMount(false, null);
            if (!recruit.m_20159_()) continue;
            recruit.m_8127_();
            recruit.dismount = 180;
        }
    }

    public static void setRecruitsAggroState(List<AbstractRecruitEntity> recruits, int state) {
        if (recruits == null || recruits.isEmpty()) {
            return;
        }
        for (AbstractRecruitEntity recruit : recruits) {
            if (recruit == null || !recruit.m_6084_()) continue;
            recruit.setAggroState(state);
        }
    }

    public static void setTypedRecruitsFollow(List<AbstractRecruitEntity> recruits, EntityType<?> type) {
        if (recruits == null || recruits.isEmpty()) {
            return;
        }
        for (AbstractRecruitEntity recruit : recruits) {
            if (recruit == null || !recruit.m_6084_() || !recruit.m_6095_().equals(type)) continue;
            recruit.setFollowState(5);
        }
    }

    public static void setTypedRecruitsHoldPos(List<AbstractRecruitEntity> recruits, EntityType<?> type) {
        if (recruits == null || recruits.isEmpty()) {
            return;
        }
        for (AbstractRecruitEntity recruit : recruits) {
            if (recruit == null || !recruit.m_6084_() || !recruit.m_6095_().equals(type)) continue;
            recruit.setFollowState(2);
        }
    }

    public static void setTypedRecruitsMove(List<AbstractRecruitEntity> recruits, BlockPos pos, EntityType<?> type) {
        if (recruits == null || recruits.isEmpty()) {
            return;
        }
        for (AbstractRecruitEntity recruit : recruits) {
            if (recruit == null || !recruit.m_6084_() || !recruit.m_6095_().equals(type)) continue;
            recruit.setMovePos(pos);
            recruit.setFollowState(0);
            recruit.setShouldMovePos(true);
        }
    }

    public static void setTypedRecruitsMoveAndHold(List<AbstractRecruitEntity> recruits, Vec3 target, Vec3 linePos, EntityType<?> type) {
        if (recruits == null || recruits.isEmpty()) {
            return;
        }
        List<AbstractRecruitEntity> typedRecruits = recruits.stream().filter(recruit -> recruit != null && recruit.m_6084_() && recruit.m_6095_().equals(type)).toList();
        for (AbstractRecruitEntity recruit2 : typedRecruits) {
            recruit2.reachedMovePos = false;
            recruit2.setFollowState(0);
            recruit2.setShouldMovePos(true);
        }
    }

    public static void setRecruitsListen(List<AbstractRecruitEntity> recruits, boolean listen) {
        if (recruits == null || recruits.isEmpty()) {
            return;
        }
        for (AbstractRecruitEntity recruit : recruits) {
            if (recruit == null || !recruit.m_6084_()) continue;
            recruit.setListen(listen);
        }
    }

    public static void setRecruitsMoveToDirection(List<AbstractRecruitEntity> recruits, Vec3 direction) {
        if (recruits == null || recruits.isEmpty()) {
            return;
        }
        for (AbstractRecruitEntity recruit : recruits) {
            Vec3 pos = recruit.m_20182_().m_82549_(direction.m_82490_(20.0));
            BlockPos blockPos = FormationUtils.getPositionOrSurface(recruit.m_20193_(), new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_));
            Vec3 targetPos = new Vec3(pos.f_82479_, (double)blockPos.m_123342_(), pos.f_82481_);
            recruit.setHoldPos(targetPos);
            recruit.setFollowState(3);
        }
    }
}

