/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.client.ClientManager;
import com.talhanation.recruits.world.RecruitsGroup;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageToClientUpdateGroups
implements Message<MessageToClientUpdateGroups> {
    private CompoundTag nbt;

    public MessageToClientUpdateGroups() {
    }

    public MessageToClientUpdateGroups(CompoundTag nbt) {
        this.nbt = nbt;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.CLIENT;
    }

    @Override
    public void executeClientSide(NetworkEvent.Context context) {
        List<RecruitsGroup> updated = RecruitsGroup.listFromNbt(this.nbt);
        HashMap<UUID, RecruitsGroup> updatedMap = new HashMap<UUID, RecruitsGroup>();
        for (RecruitsGroup group : updated) {
            updatedMap.put(group.getUUID(), group);
        }
        ClientManager.groups.removeIf(clientGroup -> !updatedMap.containsKey(clientGroup.getUUID()));
        for (RecruitsGroup updatedGroup : updated) {
            RecruitsGroup existing = null;
            for (RecruitsGroup clientGroup2 : ClientManager.groups) {
                if (!clientGroup2.getUUID().equals(updatedGroup.getUUID())) continue;
                existing = clientGroup2;
                break;
            }
            if (existing == null) {
                ClientManager.groups.add(updatedGroup);
                continue;
            }
            existing.leaderUUID = updatedGroup.leaderUUID;
            existing.members = updatedGroup.members;
            existing.setSize(updatedGroup.getSize());
            existing.setName(updatedGroup.getName());
            existing.setCount(updatedGroup.getCount());
        }
    }

    @Override
    public MessageToClientUpdateGroups fromBytes(FriendlyByteBuf buf) {
        this.nbt = buf.m_130260_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.nbt);
    }
}

