/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.client.ClientManager;
import com.talhanation.recruits.world.RecruitsFaction;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageToClientUpdateFactions
implements Message<MessageToClientUpdateFactions> {
    private CompoundTag nbt;
    private boolean editing;
    private boolean managing;
    private ItemStack currency;
    private int factionCreationPrice;
    private int factionMaxRecruitsPerPlayerConfigSetting;

    public MessageToClientUpdateFactions() {
    }

    public MessageToClientUpdateFactions(List<RecruitsFaction> teamList, String ownFaction, boolean editing, boolean managing, int factionCreationPrice, int factionMaxRecruitsPerPlayerConfigSetting, ItemStack currency) {
        this.nbt = RecruitsFaction.toNBT(teamList);
        this.editing = editing;
        this.managing = managing;
        this.currency = currency;
        this.factionCreationPrice = factionCreationPrice;
        this.factionMaxRecruitsPerPlayerConfigSetting = factionMaxRecruitsPerPlayerConfigSetting;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.CLIENT;
    }

    @Override
    public void executeClientSide(NetworkEvent.Context context) {
        ClientManager.factions = RecruitsFaction.getListFromNBT(this.nbt);
        ClientManager.isFactionEditingAllowed = this.editing;
        ClientManager.isFactionManagingAllowed = this.managing;
        ClientManager.currency = this.currency;
        ClientManager.factionCreationPrice = this.factionCreationPrice;
        ClientManager.factionMaxRecruitsPerPlayerConfigSetting = this.factionMaxRecruitsPerPlayerConfigSetting;
    }

    @Override
    public MessageToClientUpdateFactions fromBytes(FriendlyByteBuf buf) {
        this.nbt = buf.m_130260_();
        this.editing = buf.readBoolean();
        this.managing = buf.readBoolean();
        this.currency = buf.m_130267_();
        this.factionCreationPrice = buf.readInt();
        this.factionMaxRecruitsPerPlayerConfigSetting = buf.readInt();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.nbt);
        buf.writeBoolean(this.editing);
        buf.writeBoolean(this.managing);
        buf.m_130055_(this.currency);
        buf.writeInt(this.factionCreationPrice);
        buf.writeInt(this.factionMaxRecruitsPerPlayerConfigSetting);
    }
}

