/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.FactionEvents;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.world.RecruitsPlayerInfo;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageAssignRecruitToPlayer
implements Message<MessageAssignRecruitToPlayer> {
    private UUID recruit;
    private UUID newOwner;

    public MessageAssignRecruitToPlayer() {
    }

    public MessageAssignRecruitToPlayer(UUID recruit, UUID newOwner) {
        this.recruit = recruit;
        this.newOwner = newOwner;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        List list = Objects.requireNonNull(context.getSender()).m_20193_().m_45976_(AbstractRecruitEntity.class, context.getSender().m_20191_().m_82400_(64.0));
        ServerLevel serverLevel = (ServerLevel)serverPlayer.m_20193_();
        for (AbstractRecruitEntity recruit : list) {
            if (!recruit.m_20148_().equals(this.recruit)) continue;
            recruit.assignToPlayer(this.newOwner, null);
            FactionEvents.notifyPlayer(serverLevel, new RecruitsPlayerInfo(this.newOwner, ""), 0, serverPlayer.m_7755_().getString());
            break;
        }
    }

    @Override
    public MessageAssignRecruitToPlayer fromBytes(FriendlyByteBuf buf) {
        this.recruit = buf.m_130259_();
        this.newOwner = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.recruit);
        buf.m_130077_(this.newOwner);
    }
}

