/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.RecruitEvents;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.world.RecruitsGroup;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageAssignNearbyRecruitsInGroup
implements Message<MessageAssignNearbyRecruitsInGroup> {
    private UUID groupUUID;

    public MessageAssignNearbyRecruitsInGroup() {
    }

    public MessageAssignNearbyRecruitsInGroup(UUID group) {
        this.groupUUID = group;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = Objects.requireNonNull(context.getSender());
        RecruitsGroup newGroup = RecruitEvents.recruitsGroupsManager.getGroup(this.groupUUID);
        if (newGroup == null) {
            return;
        }
        player.m_20193_().m_6443_(AbstractRecruitEntity.class, player.m_20191_().m_82400_(100.0), recruit -> recruit.isEffectedByCommand(player.m_20148_())).forEach(recruit -> this.setGroup((AbstractRecruitEntity)((Object)recruit), newGroup));
        RecruitEvents.recruitsGroupsManager.addOrUpdateGroup(player.m_284548_(), player, newGroup);
        RecruitEvents.recruitsGroupsManager.broadCastGroupsToPlayer((Player)player);
    }

    public void setGroup(AbstractRecruitEntity recruit, RecruitsGroup group) {
        if (recruit.getGroupUUID().isPresent() && recruit.getGroupUUID().get().equals(group)) {
            return;
        }
        group.addMember(recruit.m_20148_());
        RecruitsGroup oldGroup = RecruitEvents.recruitsGroupsManager.getGroup(recruit.getGroup());
        if (oldGroup != null) {
            oldGroup.removeMember(recruit.m_20148_());
        }
        recruit.setGroupUUID(this.groupUUID);
    }

    @Override
    public MessageAssignNearbyRecruitsInGroup fromBytes(FriendlyByteBuf buf) {
        this.groupUUID = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.groupUUID);
    }
}

