/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.init;

import com.talhanation.recruits.client.gui.AssassinLeaderScreen;
import com.talhanation.recruits.client.gui.CommandScreen;
import com.talhanation.recruits.client.gui.DebugInvScreen;
import com.talhanation.recruits.client.gui.PatrolLeaderScreen;
import com.talhanation.recruits.client.gui.PromoteScreen;
import com.talhanation.recruits.client.gui.RecruitHireScreen;
import com.talhanation.recruits.client.gui.RecruitInventoryScreen;
import com.talhanation.recruits.client.gui.faction.TeamEditScreen;
import com.talhanation.recruits.entities.AbstractLeaderEntity;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.AssassinLeaderEntity;
import com.talhanation.recruits.inventory.AssassinLeaderMenu;
import com.talhanation.recruits.inventory.CommandMenu;
import com.talhanation.recruits.inventory.DebugInvMenu;
import com.talhanation.recruits.inventory.DisbandContainer;
import com.talhanation.recruits.inventory.PatrolLeaderContainer;
import com.talhanation.recruits.inventory.PromoteContainer;
import com.talhanation.recruits.inventory.RecruitHireMenu;
import com.talhanation.recruits.inventory.RecruitInventoryMenu;
import com.talhanation.recruits.inventory.TeamEditMenu;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModScreens {
    private static final Logger logger = LogManager.getLogger((String)"recruits");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"recruits");
    public static final RegistryObject<MenuType<RecruitInventoryMenu>> RECRUIT_CONTAINER_TYPE = MENU_TYPES.register("recruit_container", () -> IForgeMenuType.create((windowId, inv, data) -> {
        try {
            UUID workerId = data.m_130259_();
            logger.info("{} is opening hire container for {}", (Object)inv.f_35978_.m_5446_().getString(), (Object)workerId);
            AbstractRecruitEntity rec = ModScreens.getRecruitByUUID(inv.f_35978_, workerId);
            logger.info("Recruit is {}", (Object)rec);
            if (rec == null) {
                return null;
            }
            return new RecruitInventoryMenu(windowId, rec, inv);
        }
        catch (Exception e) {
            logger.error("Error in recruit_container: ");
            logger.error(e.getMessage());
            logger.error(e.getStackTrace().toString());
            return null;
        }
    }));
    public static final RegistryObject<MenuType<CommandMenu>> COMMAND_CONTAINER_TYPE = MENU_TYPES.register("command_container", () -> IForgeMenuType.create((windowId, inv, data) -> {
        try {
            UUID player_uuid = inv.f_35978_.m_20148_();
            logger.info("{} is opening command container for {}", (Object)inv.f_35978_.m_5446_().getString(), (Object)player_uuid);
            Player playerEntity = inv.f_35978_;
            logger.info("Player is {}", (Object)playerEntity);
            if (playerEntity == null) {
                return null;
            }
            return new CommandMenu(windowId, playerEntity);
        }
        catch (Exception e) {
            logger.error("Error in command_container: ");
            logger.error(e.getMessage());
            logger.error(e.getStackTrace().toString());
            return null;
        }
    }));
    public static final RegistryObject<MenuType<AssassinLeaderMenu>> ASSASSIN_CONTAINER_TYPE = MENU_TYPES.register("assassin_container", () -> IForgeMenuType.create((windowId, inv, data) -> {
        try {
            UUID workerId = data.m_130259_();
            AssassinLeaderEntity rec = ModScreens.getAssassinByUUID(inv.f_35978_, workerId);
            logger.info("{} is opening assassin container for {}", (Object)inv.f_35978_.m_5446_().getString(), (Object)workerId);
            if (rec == null) {
                return null;
            }
            logger.info("Player is {}", (Object)rec);
            if (rec == null) {
                return null;
            }
            return new AssassinLeaderMenu(windowId, rec, inv);
        }
        catch (Exception e) {
            logger.error("Error in assassin_container: ");
            logger.error(e.getMessage());
            logger.error(e.getStackTrace().toString());
            return null;
        }
    }));
    public static final RegistryObject<MenuType<RecruitHireMenu>> HIRE_CONTAINER_TYPE = MENU_TYPES.register("hire_container", () -> IForgeMenuType.create((windowId, inv, data) -> {
        try {
            UUID workerId = data.m_130259_();
            Player playerEntity = inv.f_35978_;
            AbstractRecruitEntity rec = ModScreens.getRecruitByUUID(playerEntity, workerId);
            logger.info("{} is opening hire container for {}", (Object)playerEntity.m_5446_().getString(), (Object)workerId);
            if (rec == null) {
                return null;
            }
            logger.info("Player is {}", (Object)playerEntity);
            if (playerEntity == null) {
                return null;
            }
            return new RecruitHireMenu(windowId, playerEntity, rec, inv);
        }
        catch (Exception e) {
            logger.error("Error in hire_container: ");
            logger.error(e.getMessage());
            logger.error(e.getStackTrace().toString());
            return null;
        }
    }));
    public static final RegistryObject<MenuType<DebugInvMenu>> DEBUG_CONTAINER_TYPE = MENU_TYPES.register("debug_container", () -> IForgeMenuType.create((windowId, inv, data) -> {
        try {
            UUID workerId = data.m_130259_();
            Player playerEntity = inv.f_35978_;
            AbstractRecruitEntity rec = ModScreens.getRecruitByUUID(playerEntity, workerId);
            logger.info("{} is opening hire container for {}", (Object)playerEntity.m_5446_().getString(), (Object)workerId);
            if (rec == null) {
                return null;
            }
            logger.info("Recruit is {}", (Object)rec);
            if (playerEntity == null) {
                return null;
            }
            return new DebugInvMenu(windowId, rec, inv);
        }
        catch (Exception e) {
            logger.error("Error in debug_container: ");
            logger.error(e.getMessage());
            logger.error(e.getStackTrace().toString());
            return null;
        }
    }));
    public static final RegistryObject<MenuType<TeamEditMenu>> TEAM_EDIT_TYPE = MENU_TYPES.register("team_edit", () -> IForgeMenuType.create((windowId, inv, data) -> new TeamEditMenu(windowId, inv)));
    public static final RegistryObject<MenuType<DisbandContainer>> DISBAND = MENU_TYPES.register("disband_container", () -> IForgeMenuType.create((windowId, inv, data) -> {
        try {
            UUID workerId = data.m_130259_();
            Player playerEntity = inv.f_35978_;
            AbstractRecruitEntity rec = ModScreens.getRecruitByUUID(playerEntity, workerId);
            return new DisbandContainer(windowId, playerEntity, rec.m_20148_());
        }
        catch (Exception e) {
            logger.error("Error in disband_container: ");
            logger.error(e.getMessage());
            logger.error(e.getStackTrace().toString());
            return null;
        }
    }));
    public static final RegistryObject<MenuType<PromoteContainer>> PROMOTE = MENU_TYPES.register("promote_container", () -> IForgeMenuType.create((windowId, inv, data) -> {
        try {
            UUID workerId = data.m_130259_();
            Player playerEntity = inv.f_35978_;
            AbstractRecruitEntity rec = ModScreens.getRecruitByUUID(playerEntity, workerId);
            return new PromoteContainer(windowId, playerEntity, rec);
        }
        catch (Exception e) {
            logger.error("Error in promote_container: ");
            logger.error(e.getMessage());
            logger.error(e.getStackTrace().toString());
            return null;
        }
    }));
    public static final RegistryObject<MenuType<PatrolLeaderContainer>> PATROL_LEADER = MENU_TYPES.register("patrol_leader_container", () -> IForgeMenuType.create((windowId, inv, data) -> {
        try {
            UUID workerId = data.m_130259_();
            Player playerEntity = inv.f_35978_;
            AbstractRecruitEntity rec = ModScreens.getRecruitByUUID(playerEntity, workerId);
            return new PatrolLeaderContainer(windowId, playerEntity, (AbstractLeaderEntity)rec);
        }
        catch (Exception e) {
            logger.error("Error in disband_container: ");
            logger.error(e.getMessage());
            logger.error(e.getStackTrace().toString());
            return null;
        }
    }));

    public static void registerMenus() {
        ModScreens.registerMenu((MenuType)RECRUIT_CONTAINER_TYPE.get(), RecruitInventoryScreen::new);
        ModScreens.registerMenu((MenuType)DEBUG_CONTAINER_TYPE.get(), DebugInvScreen::new);
        ModScreens.registerMenu((MenuType)COMMAND_CONTAINER_TYPE.get(), CommandScreen::new);
        ModScreens.registerMenu((MenuType)ASSASSIN_CONTAINER_TYPE.get(), AssassinLeaderScreen::new);
        ModScreens.registerMenu((MenuType)HIRE_CONTAINER_TYPE.get(), RecruitHireScreen::new);
        ModScreens.registerMenu((MenuType)TEAM_EDIT_TYPE.get(), TeamEditScreen::new);
        ModScreens.registerMenu((MenuType)PROMOTE.get(), PromoteScreen::new);
        ModScreens.registerMenu((MenuType)PATROL_LEADER.get(), PatrolLeaderScreen::new);
        logger.info("MenuScreens registered");
    }

    private static <M extends AbstractContainerMenu, U extends Screen> void registerMenu(MenuType<? extends M> menuType, MenuScreens.ScreenConstructor<M, U> screenConstructor) {
        MenuScreens.m_96206_(menuType, (menu, inventory, title) -> {
            try {
                return screenConstructor.m_96214_(menu, inventory, title);
            }
            catch (Exception e) {
                logger.error("Could not instantiate {}", (Object)screenConstructor.getClass().getSimpleName());
                logger.error(e.getMessage());
                logger.error(Arrays.toString(e.getStackTrace()));
                return null;
            }
        });
    }

    @Nullable
    public static AbstractRecruitEntity getRecruitByUUID(Player player, UUID uuid) {
        double distance = 10.0;
        return player.m_20193_().m_6443_(AbstractRecruitEntity.class, new AABB(player.m_20185_() - distance, player.m_20186_() - distance, player.m_20189_() - distance, player.m_20185_() + distance, player.m_20186_() + distance, player.m_20189_() + distance), entity -> entity.m_20148_().equals(uuid)).stream().findAny().orElse(null);
    }

    @Nullable
    public static AssassinLeaderEntity getAssassinByUUID(Player player, UUID uuid) {
        double distance = 10.0;
        return player.m_20193_().m_6443_(AssassinLeaderEntity.class, new AABB(player.m_20185_() - distance, player.m_20186_() - distance, player.m_20189_() - distance, player.m_20185_() + distance, player.m_20186_() + distance, player.m_20189_() + distance), entity -> entity.m_20148_().equals(uuid)).stream().findAny().orElse(null);
    }
}

