/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.HorsemanEntity;
import com.talhanation.recruits.pathfinding.AsyncPathfinderMob;
import com.talhanation.recruits.util.AttackUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.common.ToolActions;

public class UseShield
extends Goal {
    public final AsyncPathfinderMob entity;

    public UseShield(AsyncPathfinderMob recruit) {
        this.entity = recruit;
    }

    public boolean m_8036_() {
        AsyncPathfinderMob asyncPathfinderMob = this.entity;
        if (asyncPathfinderMob instanceof AbstractRecruitEntity) {
            AbstractRecruitEntity recruit = (AbstractRecruitEntity)asyncPathfinderMob;
            boolean forced = recruit.getShouldBlock();
            boolean normal = this.canRaiseShield() && !recruit.isFollowing() && recruit.canBlock() && !recruit.getShouldMovePos();
            return (forced || normal) && this.hasShieldInHand() && !this.entity.f_20911_;
        }
        return this.canRaiseShield() && this.hasShieldInHand() && !this.entity.f_20911_;
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8056_() {
        if (this.entity.m_21206_().m_41720_().canPerformAction(this.entity.m_21206_(), ToolActions.SHIELD_BLOCK)) {
            this.entity.m_6672_(InteractionHand.OFF_HAND);
            this.entity.m_21051_(Attributes.f_22279_).m_22100_(0.12);
        }
    }

    public boolean hasShieldInHand() {
        AsyncPathfinderMob asyncPathfinderMob = this.entity;
        if (asyncPathfinderMob instanceof AbstractRecruitEntity) {
            AbstractRecruitEntity recruit = (AbstractRecruitEntity)asyncPathfinderMob;
            recruit.switchOffHandItem(itemStack -> itemStack.m_41720_().canPerformAction(this.entity.m_21206_(), ToolActions.SHIELD_BLOCK));
        }
        return this.entity.m_21206_().m_41720_().canPerformAction(this.entity.m_21206_(), ToolActions.SHIELD_BLOCK);
    }

    public void m_8041_() {
        this.entity.m_21051_(Attributes.f_22279_).m_22100_(0.3);
        this.entity.m_5810_();
    }

    public void m_8037_() {
        if (this.entity.m_7655_() == InteractionHand.OFF_HAND) {
            this.entity.m_21051_(Attributes.f_22279_).m_22100_(0.16);
        } else {
            this.entity.m_21051_(Attributes.f_22279_).m_22100_(0.3);
        }
    }

    public boolean canRaiseShield() {
        boolean isSelfTargeted = false;
        LivingEntity target = this.entity.m_5448_();
        if (target != null && target.m_6084_()) {
            boolean isDanger;
            HorsemanEntity horseman;
            if (target instanceof Mob) {
                Mob mobTarget = (Mob)target;
                isSelfTargeted = mobTarget.m_5448_() != null && mobTarget.m_5448_().m_7306_((Entity)this.entity);
            } else if (target instanceof Player) {
                Player player = (Player)target;
                LivingEntity lastHurtMob = player.m_21214_();
                isSelfTargeted = lastHurtMob != null && lastHurtMob.m_7306_((Entity)this.entity);
            }
            ItemStack itemStackInHand = target.m_21120_(InteractionHand.MAIN_HAND);
            double ownReach = AttackUtil.getAttackReachSqr((LivingEntity)this.entity);
            Item itemInHand = itemStackInHand.m_41720_();
            double distanceToTarget = this.entity.m_20280_((Entity)target);
            AsyncPathfinderMob asyncPathfinderMob = this.entity;
            boolean isTargetInReachToBlock = asyncPathfinderMob instanceof HorsemanEntity && (horseman = (HorsemanEntity)asyncPathfinderMob).m_20202_() instanceof AbstractHorse ? 70.0 > distanceToTarget : 120.0 > distanceToTarget;
            boolean bl = isDanger = itemInHand instanceof AxeItem || itemInHand instanceof PickaxeItem || itemInHand instanceof SwordItem;
            if (isSelfTargeted) {
                if (target instanceof RangedAttackMob || itemInHand instanceof CrossbowItem && CrossbowItem.m_40932_((ItemStack)itemStackInHand) || itemInHand instanceof BowItem && target.m_21252_() > 0) {
                    return distanceToTarget > ownReach * 1.5;
                }
                return (isDanger || target instanceof Monster) && isTargetInReachToBlock;
            }
        }
        return false;
    }
}

