/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai;

import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.NomadEntity;
import java.util.EnumSet;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.phys.Vec3;

public class NomadAttackAI
extends Goal {
    private final NomadEntity nomad;
    private LivingEntity target;
    private NomadEntity.State state;
    private int seeTime;
    private int attackTime = -1;
    private boolean consumeArrows;

    public NomadAttackAI(NomadEntity recruit) {
        this.nomad = recruit;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.consumeArrows = (Boolean)RecruitsServerConfig.RangedRecruitsNeedArrowsToShoot.get();
    }

    public boolean m_8036_() {
        return this.nomad.m_20202_() instanceof AbstractHorse && this.nomad.m_5448_() != null && !this.nomad.needsToGetFood() && !this.nomad.getShouldMount() && this.isHoldingBow() && this.nomad.getShouldRanged();
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.state = NomadEntity.State.SELECT_TARGET;
        this.nomad.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.nomad.m_21561_(false);
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
        this.nomad.m_5810_();
    }

    protected boolean isHoldingBow() {
        String name = this.nomad.m_21205_().m_41778_();
        if (this.nomad.m_21093_(bow -> bow.m_150930_(Items.f_42411_))) {
            return true;
        }
        if (this.nomad.m_21093_(bow -> bow.m_41720_() instanceof BowItem)) {
            return true;
        }
        if (this.nomad.m_21093_(bow -> bow.m_41720_() instanceof ProjectileWeaponItem)) {
            return true;
        }
        return name.contains("bow");
    }

    private boolean hasArrows() {
        return !this.consumeArrows || this.nomad.getInventory().m_216874_(item -> item.m_204117_(ItemTags.f_13161_));
    }

    public void m_8037_() {
        if (this.nomad.getFollowState() == 0) {
            switch (this.state) {
                case SELECT_TARGET: {
                    this.target = this.nomad.m_5448_();
                    if (this.target == null || !this.target.m_6084_() || !this.hasArrows()) break;
                    this.state = NomadEntity.State.CIRCLE_TARGET;
                    break;
                }
                case CIRCLE_TARGET: {
                    if (this.target != null && this.target.m_6084_()) {
                        Vec3 toTarget = this.target.m_20182_().m_82546_(this.nomad.m_20182_()).m_82541_();
                        Vec3 moveVec = toTarget.m_82524_(-90.0f).m_82541_();
                        Vec3 movePos = this.target.m_20182_().m_82549_(moveVec.m_82490_(20.0));
                        if (this.nomad.m_20238_(movePos) > 3.0) {
                            this.nomad.m_21573_().m_26519_(movePos.f_82479_, movePos.f_82480_, movePos.f_82481_, 1.0);
                        }
                        this.nomad.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
                        break;
                    }
                    this.state = NomadEntity.State.SELECT_TARGET;
                }
            }
        } else {
            this.target = this.nomad.m_5448_();
        }
        if (this.target != null && this.target.m_6084_() && this.nomad.m_6779_(this.target) && this.nomad.getState() != 3) {
            boolean canSee = this.nomad.m_21574_().m_148306_((Entity)this.target);
            this.seeTime = canSee ? ++this.seeTime : 0;
            double d0 = this.nomad.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            if (this.nomad.m_6117_()) {
                int i;
                if (!canSee && this.seeTime < -60) {
                    this.nomad.m_5810_();
                } else if (canSee && (i = this.nomad.m_21252_()) >= 20) {
                    this.nomad.m_5810_();
                    this.nomad.m_6504_(this.target, BowItem.m_40661_((int)i));
                    float f = Mth.m_14116_((float)((float)d0)) / 32.0f;
                    int attackIntervalMax = 20;
                    int attackIntervalMin = 10;
                    this.attackTime = Mth.m_14143_((float)(f * (float)(attackIntervalMax - attackIntervalMin) + (float)attackIntervalMin));
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60 && this.hasArrows()) {
                this.nomad.m_6672_(InteractionHand.MAIN_HAND);
            }
        }
    }
}

