/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.AbstractInventoryEntity;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.ai.UseShield;
import com.talhanation.recruits.network.MessageToClientOpenNobleTradeScreen;
import com.talhanation.recruits.pathfinding.AsyncGroundPathNavigation;
import com.talhanation.recruits.world.RecruitsHireTrade;
import com.talhanation.recruits.world.RecruitsHireTradesRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.PacketDistributor;

public class VillagerNobleEntity
extends AbstractRecruitEntity {
    private static final EntityDataAccessor<CompoundTag> TRADES = SynchedEntityData.m_135353_(VillagerNobleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Integer> TRADER_PROGRESS = SynchedEntityData.m_135353_(VillagerNobleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TRADER_LEVEL = SynchedEntityData.m_135353_(VillagerNobleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> TYPE = SynchedEntityData.m_135353_(VillagerNobleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final Predicate<ItemEntity> ALLOWED_ITEMS = item -> !item.m_32063_() && item.m_6084_() && this.getInventory().m_19183_(item.m_32055_()) && this.m_7243_(item.m_32055_());
    private int restoreTimer;
    public boolean isTrading;
    public boolean needsNewTrades;
    public int restoreTimeLongTime;

    public VillagerNobleEntity(EntityType<? extends AbstractRecruitEntity> entityType, Level world) {
        super((EntityType<? extends AbstractInventoryEntity>)entityType, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TRADES, (Object)new CompoundTag());
        this.f_19804_.m_135372_(TRADER_PROGRESS, (Object)0);
        this.f_19804_.m_135372_(TRADER_LEVEL, (Object)1);
        this.f_19804_.m_135372_(TYPE, (Object)"");
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.needsNewTrades) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123748_);
        }
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.f_19797_ % 20 == 0 && this.m_5448_() == null) {
            this.switchMainHandItem(ItemStack::m_41619_);
            this.switchOffHandItem(ItemStack::m_41619_);
        }
        if (this.restoreTimer > 0) {
            --this.restoreTimer;
        }
        if (++this.restoreTimeLongTime > 12000) {
            this.restoreTradesLongTime();
        }
        if (this.needsNewTrades && !this.isTrading) {
            this.updateUsesOfTrades();
            this.setupTrades();
            this.needsNewTrades = false;
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new UseShield(this));
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("Trades", (Tag)RecruitsHireTrade.listToNbt(this.getTrades()));
        nbt.m_128405_("TraderProgress", this.getTraderProgress());
        nbt.m_128405_("TraderLevel", this.getTraderLevel());
        nbt.m_128359_("Type", this.getTraderType());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setTrades(RecruitsHireTrade.listFromNbt(nbt.m_128469_("Trades")));
        this.setTraderProgress(nbt.m_128451_("TraderProgress"));
        this.setTraderLevel(nbt.m_128451_("TraderLevel"));
        this.setTraderType(nbt.m_128461_("Type"));
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.3).m_22268_(Attributes.f_22278_, 0.1).m_22268_(Attributes.f_22281_, 0.5).m_22268_(Attributes.f_22277_, 32.0).m_22268_((Attribute)ForgeMod.ENTITY_REACH.get(), 0.0).m_22266_(Attributes.f_22283_);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag nbt) {
        RandomSource randomsource = world.m_213780_();
        SpawnGroupData ilivingentitydata = super.m_6518_(world, difficultyInstance, reason, data, nbt);
        ((AsyncGroundPathNavigation)this.m_21573_()).setCanOpenDoors(true);
        this.m_213946_(randomsource, difficultyInstance);
        this.initSpawn();
        return ilivingentitydata;
    }

    @Override
    public boolean canBeHired() {
        return false;
    }

    @Override
    public void initSpawn() {
        this.m_6593_((Component)Component.m_237113_((String)"Noble Villager"));
        this.setCost(64);
        this.setEquipment();
        this.setDropEquipment();
        this.setRandomSpawnBonus();
        this.m_21530_();
        AbstractRecruitEntity.applySpawnValues(this);
        this.needsNewTrades = true;
        this.setupTraderType();
    }

    @Override
    public boolean m_7243_(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof SwordItem && this.m_21205_().m_41619_() || itemStack.m_41720_() instanceof ShieldItem && this.m_21206_().m_41619_()) {
            return !this.hasSameTypeOfItem(itemStack);
        }
        return super.m_7243_(itemStack);
    }

    @Override
    public Predicate<ItemEntity> getAllowedItems() {
        return this.ALLOWED_ITEMS;
    }

    public boolean m_7252_(ItemStack itemStack) {
        return !(itemStack.m_41720_() instanceof CrossbowItem) && !(itemStack.m_41720_() instanceof BowItem);
    }

    @Override
    public List<List<String>> getEquipment() {
        return (List)RecruitsServerConfig.ShieldmanStartEquipments.get();
    }

    public void openTradeGUI(Player player) {
        this.isTrading(true);
        Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageToClientOpenNobleTradeScreen(this.m_20148_()));
    }

    @Override
    public void addXpLevel(int level) {
        super.addXpLevel(level);
        this.addTraderProgress(20);
    }

    public void setupTrades() {
        if (this.m_20193_().m_5776_()) {
            return;
        }
        List<RecruitsHireTrade> possibleTrades = RecruitsHireTradesRegistry.getTrades(this.getTraderType(), this.getTraderLevel());
        if (possibleTrades == null || possibleTrades.isEmpty()) {
            return;
        }
        List<RecruitsHireTrade> current = this.getTrades();
        if (current == null) {
            current = new ArrayList<RecruitsHireTrade>();
        }
        Random rnd = new Random();
        for (RecruitsHireTrade trade : possibleTrades) {
            RecruitsHireTrade copy = trade.copy();
            copy.uses = copy.maxUses = 2 + rnd.nextInt(3);
            current.add(copy);
        }
        this.setTrades(current);
    }

    public int getTraderLevel() {
        return (Integer)this.f_19804_.m_135370_(TRADER_LEVEL);
    }

    public int getTraderProgress() {
        return (Integer)this.f_19804_.m_135370_(TRADER_PROGRESS);
    }

    public void setTraderProgress(int x) {
        this.f_19804_.m_135381_(TRADER_PROGRESS, (Object)x);
    }

    public void setTraderLevel(int x) {
        this.f_19804_.m_135381_(TRADER_LEVEL, (Object)x);
    }

    public String getTraderType() {
        return (String)this.f_19804_.m_135370_(TYPE);
    }

    public void setupTraderType() {
        int i = this.f_19796_.m_188503_(RecruitsHireTradesRegistry.getAllTraderTypes().size() - 1);
        String type = RecruitsHireTradesRegistry.getAllTraderTypes().get(i);
        this.setTraderType(type);
    }

    public void setTraderType(String x) {
        this.f_19804_.m_135381_(TYPE, (Object)x);
    }

    public void m_5802_(BlockPos pos) {
        super.m_5802_(pos);
        if (this.restoreTimer <= 0) {
            this.restoreTradesSleeping();
        }
    }

    private void restoreTradesSleeping() {
        this.restoreTimer = 1200;
        List<RecruitsHireTrade> list = this.getTrades();
        for (RecruitsHireTrade trade : list) {
            trade.uses += this.f_19796_.m_216339_(1, 4);
            if (trade.uses <= trade.maxUses) continue;
            trade.uses = trade.maxUses;
        }
        this.setTrades(list);
    }

    private void restoreTradesLongTime() {
        this.restoreTimer = 1200;
        this.restoreTimeLongTime = 0;
        List<RecruitsHireTrade> list = this.getTrades();
        for (RecruitsHireTrade trade : list) {
            ++trade.uses;
            if (trade.uses <= trade.maxUses) continue;
            trade.uses = trade.maxUses;
        }
        this.setTrades(list);
    }

    public void addTraderProgress(int x) {
        int current = this.getTraderProgress();
        if (x == 0) {
            return;
        }
        if (this.getTraderLevel() == 5) {
            this.setTraderProgress(100);
            return;
        }
        int newProgress = current + x;
        if (newProgress >= 100) {
            newProgress -= 100;
            this.setTraderLevel(this.getTraderLevel() + 1);
            this.needsNewTrades = true;
        }
        this.setTraderProgress(newProgress);
    }

    public void updateUsesOfTrades() {
        Random random = new Random();
        List<RecruitsHireTrade> list = this.getTrades();
        for (RecruitsHireTrade trade : list) {
            trade.maxUses += Math.min(7, 2 + random.nextInt(3));
        }
        this.setTrades(list);
    }

    public List<RecruitsHireTrade> getTrades() {
        return RecruitsHireTrade.listFromNbt((CompoundTag)this.f_19804_.m_135370_(TRADES));
    }

    public void setTrades(List<RecruitsHireTrade> list) {
        this.f_19804_.m_135381_(TRADES, (Object)RecruitsHireTrade.listToNbt(list));
    }

    public void doTrade(ResourceLocation resourceLocation) {
        RecruitsHireTrade trade = null;
        List<RecruitsHireTrade> list = this.getTrades();
        for (RecruitsHireTrade canditade : list) {
            if (!canditade.resourceLocation.equals((Object)resourceLocation)) continue;
            trade = canditade;
            break;
        }
        if (trade == null) {
            return;
        }
        --trade.uses;
        this.addTraderProgress(15);
        this.setTrades(list);
    }

    public void addTrade(RecruitsHireTrade trade) {
        if (trade == null) {
            return;
        }
        List<RecruitsHireTrade> current = this.getTrades();
        boolean exists = current.stream().anyMatch(t -> Objects.equals(t.resourceLocation, trade.resourceLocation));
        if (exists) {
            return;
        }
        current.add(trade);
        this.setTrades(current);
    }

    public void removeTrade(ResourceLocation recruitType) {
        if (recruitType == null) {
            return;
        }
        List<RecruitsHireTrade> current = this.getTrades();
        boolean removed = current.removeIf(t -> Objects.equals(t.resourceLocation, recruitType));
        if (removed) {
            this.setTrades(current);
        }
    }

    public boolean hasTrade(ResourceLocation recruitType) {
        if (recruitType == null) {
            return false;
        }
        List<RecruitsHireTrade> trades = this.getTrades();
        if (trades == null || trades.isEmpty()) {
            return false;
        }
        for (RecruitsHireTrade trade : trades) {
            if (trade == null || !recruitType.equals((Object)trade.resourceLocation)) continue;
            return true;
        }
        return false;
    }

    public void isTrading(boolean trading) {
        this.isTrading = trading;
    }

    protected void addParticlesAroundSelf(ParticleOptions p_35288_) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_(p_35288_, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
        }
    }
}

