/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities;

import com.talhanation.recruits.CommandEvents;
import com.talhanation.recruits.FactionEvents;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.RecruitEvents;
import com.talhanation.recruits.compat.IWeapon;
import com.talhanation.recruits.config.RecruitsClientConfig;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.AbstractInventoryEntity;
import com.talhanation.recruits.entities.AbstractLeaderEntity;
import com.talhanation.recruits.entities.CaptainEntity;
import com.talhanation.recruits.entities.CrossBowmanEntity;
import com.talhanation.recruits.entities.IRangedRecruit;
import com.talhanation.recruits.entities.MessengerEntity;
import com.talhanation.recruits.entities.VillagerNobleEntity;
import com.talhanation.recruits.entities.ai.FleeFire;
import com.talhanation.recruits.entities.ai.FleeTNT;
import com.talhanation.recruits.entities.ai.RecruitDefendVillageFromPlayerGoal;
import com.talhanation.recruits.entities.ai.RecruitDismountEntity;
import com.talhanation.recruits.entities.ai.RecruitEatGoal;
import com.talhanation.recruits.entities.ai.RecruitFloatGoal;
import com.talhanation.recruits.entities.ai.RecruitFollowOwnerGoal;
import com.talhanation.recruits.entities.ai.RecruitHoldPosGoal;
import com.talhanation.recruits.entities.ai.RecruitHurtByTargetGoal;
import com.talhanation.recruits.entities.ai.RecruitMeleeAttackGoal;
import com.talhanation.recruits.entities.ai.RecruitMountEntity;
import com.talhanation.recruits.entities.ai.RecruitMoveToPosGoal;
import com.talhanation.recruits.entities.ai.RecruitOwnerHurtByTargetGoal;
import com.talhanation.recruits.entities.ai.RecruitOwnerHurtTargetGoal;
import com.talhanation.recruits.entities.ai.RecruitProtectEntityGoal;
import com.talhanation.recruits.entities.ai.RecruitProtectHurtByTargetGoal;
import com.talhanation.recruits.entities.ai.RecruitQuaffGoal;
import com.talhanation.recruits.entities.ai.RecruitUpkeepEntityGoal;
import com.talhanation.recruits.entities.ai.RecruitUpkeepPosGoal;
import com.talhanation.recruits.entities.ai.RecruitWanderGoal;
import com.talhanation.recruits.entities.ai.RestGoal;
import com.talhanation.recruits.entities.ai.async.AsyncManager;
import com.talhanation.recruits.entities.ai.async.AsyncTaskWithCallback;
import com.talhanation.recruits.entities.ai.compat.BlockWithWeapon;
import com.talhanation.recruits.entities.ai.navigation.RecruitPathNavigation;
import com.talhanation.recruits.entities.ai.navigation.RecruitsOpenDoorGoal;
import com.talhanation.recruits.init.ModItems;
import com.talhanation.recruits.inventory.DebugInvMenu;
import com.talhanation.recruits.inventory.RecruitHireMenu;
import com.talhanation.recruits.inventory.RecruitInventoryMenu;
import com.talhanation.recruits.network.MessageDebugScreen;
import com.talhanation.recruits.network.MessageHireGui;
import com.talhanation.recruits.network.MessageRecruitGui;
import com.talhanation.recruits.network.MessageToClientOpenTakeOverScreen;
import com.talhanation.recruits.network.MessageToClientUpdateHireScreen;
import com.talhanation.recruits.world.RecruitsDiplomacyManager;
import com.talhanation.recruits.world.RecruitsFaction;
import com.talhanation.recruits.world.RecruitsGroup;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.common.Tags;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRecruitEntity
extends AbstractInventoryEntity {
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FOLLOW_STATE = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SHOULD_FOLLOW = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOULD_BLOCK = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOULD_MOUNT = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOULD_PROTECT = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOULD_HOLD_POS = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOULD_MOVE_POS = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<BlockPos>> HOLD_POS = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Optional<BlockPos>> MOVE_POS = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Optional<BlockPos>> UPKEEP_POS = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Boolean> LISTEN = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_FOLLOWING = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> MOUNT_ID = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> PROTECT_ID = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> GROUP = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> XP = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> KILLS = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FLEEING = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> HUNGER = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> MORAL = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_ID = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> OWNED = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COST = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> UPKEEP_ID = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> COLOR = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> BIOME = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> SHOULD_REST = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOULD_RANGED = SynchedEntityData.m_135353_(AbstractRecruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int blockCoolDown;
    public boolean needsTeamUpdate = true;
    public boolean needsGroupUpdate = true;
    public boolean forcedUpkeep;
    public int dismount = 0;
    public int upkeepTimer = 0;
    public int mountTimer = 0;
    public int despawnTimer = -1;
    public boolean reachedMovePos;
    public int attackCooldown = 0;
    public int paymentTimer;
    public boolean rotate;
    public float ownerRot;
    public int formationPos = -1;
    private int maxFallDistance;
    public Vec3 holdPosVec;
    public boolean isInFormation;
    public boolean needsColorUpdate = true;
    public float moveSpeed = 1.0f;
    public TargetingConditions targetingConditions;

    public AbstractRecruitEntity(EntityType<? extends AbstractInventoryEntity> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 6;
        this.f_21344_ = this.m_6037_(world);
        this.targetingConditions = TargetingConditions.m_148352_().m_26893_().m_26888_(this::shouldAttack);
        this.m_274367_(1.0f);
        this.setMaxFallDistance(1);
    }

    @Override
    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new RecruitPathNavigation(this, level);
    }

    @Override
    @NotNull
    public PathNavigation m_21573_() {
        return super.m_21573_();
    }

    public void m_6083_() {
        super.m_6083_();
    }

    public double m_6049_() {
        return -0.35;
    }

    public int m_6056_() {
        return this.maxFallDistance;
    }

    public void setMaxFallDistance(int x) {
        this.maxFallDistance = x;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
        this.updateShield();
        if (this.m_20193_().m_5776_()) {
            return;
        }
        if (this.needsColorUpdate && this.m_5647_() != null) {
            this.updateColor(this.m_5647_().m_5758_());
        }
        if (this instanceof IRangedRecruit && this.f_19797_ % 20 == 0) {
            this.pickUpArrows();
        }
        if (this.needsTeamUpdate) {
            this.updateTeam();
        }
        if (this.needsGroupUpdate) {
            this.updateGroup();
        }
    }

    @Override
    public void m_8119_() {
        LivingEntity currentTarget;
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.despawnTimer > 0) {
            --this.despawnTimer;
        }
        if (this.despawnTimer == 0) {
            this.recruitCheckDespawn();
        }
        if (((Boolean)RecruitsServerConfig.RecruitsPayment.get()).booleanValue()) {
            if (this.paymentTimer > 0) {
                --this.paymentTimer;
            }
            if (this.paymentTimer == 0) {
                if (this.getUpkeepPos() != null || this.getUpkeepUUID() != null) {
                    this.forcedUpkeep = true;
                } else {
                    this.checkPayment((Container)this.getInventory());
                }
            }
        }
        if (this.getMountTimer() > 0) {
            this.setMountTimer(this.getMountTimer() - 1);
        }
        if (this.getUpkeepTimer() > 0) {
            this.setUpkeepTimer(this.getUpkeepTimer() - 1);
        }
        if (this.getHunger() >= 70.0f && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(0.02f);
        }
        if (this.reachedMovePos) {
            this.setFollowState(2);
            this.reachedMovePos = false;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.m_6084_() && this.f_19797_ % 20 == 0 && this.getState() != 3) {
            this.searchForTargets();
        }
        if ((currentTarget = this.m_5448_()) != null && (currentTarget.m_21224_() || currentTarget.m_213877_())) {
            this.m_6710_(null);
        }
    }

    public void searchForTargets() {
        Level level = this.m_20193_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (((Boolean)RecruitsServerConfig.UseAsyncTargetFinding.get()).booleanValue()) {
            this.searchForTargetsAsync(serverLevel);
        } else {
            this.searchForTargetsSync(serverLevel);
        }
    }

    private void searchForTargetsAsync(ServerLevel serverLevel) {
        AABB searchBox = this.m_20191_().m_82400_(40.0);
        List nearby = serverLevel.m_6443_(LivingEntity.class, searchBox, entity -> entity != this);
        Supplier<List> findTargetsTask = () -> {
            ArrayList<LivingEntity> copy = new ArrayList<LivingEntity>(nearby);
            copy.removeIf(potTarget -> !this.targetingConditions.m_26885_((LivingEntity)this, potTarget));
            copy.sort(Comparator.comparingDouble(e -> e.m_20280_((Entity)this)));
            return copy.stream().limit(10L).toList();
        };
        Consumer<List> handleTargets = targets -> {
            if (!targets.isEmpty()) {
                this.m_6710_((LivingEntity)targets.get(this.m_217043_().m_188503_(targets.size())));
            }
        };
        AsyncManager.executor.execute(new AsyncTaskWithCallback<List>(findTargetsTask, handleTargets, serverLevel));
    }

    private void searchForTargetsSync(ServerLevel serverLevel) {
        AABB searchBox = this.m_20191_().m_82400_(40.0);
        List nearby = serverLevel.m_6443_(LivingEntity.class, searchBox, entity -> entity != this);
        nearby.removeIf(potTarget -> !this.targetingConditions.m_26885_((LivingEntity)this, potTarget));
        nearby.sort(Comparator.comparingDouble(e -> e.m_20280_((Entity)this)));
        if (!nearby.isEmpty()) {
            LivingEntity target = (LivingEntity)nearby.stream().limit(10L).toList().get(this.m_217043_().m_188503_(Math.min(10, nearby.size())));
            this.m_6710_(target);
        }
    }

    private void recruitCheckDespawn() {
        if (this.isOwned()) {
            return;
        }
        Player entity = this.m_20193_().m_45930_((Entity)this, -1.0);
        if (entity != null) {
            double d0 = entity.m_20280_((Entity)this);
            int k = this.m_6095_().m_20674_().m_21612_();
            int l = k * k;
            if (this.f_19796_.m_188503_(800) == 0 && d0 > (double)l) {
                Entity entity2 = this.m_20202_();
                if (entity2 instanceof LivingEntity) {
                    LivingEntity livingMount = (LivingEntity)entity2;
                    livingMount.m_146870_();
                }
                this.m_146870_();
            }
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance diff, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag nbt) {
        this.setRandomSpawnBonus();
        this.m_6037_((Level)world.m_6018_());
        return spawnData;
    }

    public void setRandomSpawnBonus() {
        this.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("heath_bonus", this.f_19796_.m_188500_() * 0.5, AttributeModifier.Operation.MULTIPLY_BASE));
        this.m_21051_(Attributes.f_22281_).m_22125_(new AttributeModifier("attack_bonus", this.f_19796_.m_188500_() * 0.5, AttributeModifier.Operation.MULTIPLY_BASE));
        this.m_21051_(Attributes.f_22278_).m_22125_(new AttributeModifier("knockback_bonus", this.f_19796_.m_188500_() * 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
        this.m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier("speed_bonus", this.f_19796_.m_188500_() * 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
    }

    public void setDropEquipment() {
        this.m_5907_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new BlockWithWeapon(this));
        this.f_21345_.m_25352_(0, (Goal)new RecruitFloatGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RecruitQuaffGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new FleeTNT(this));
        this.f_21345_.m_25352_(1, (Goal)new FleeFire(this));
        this.f_21345_.m_25352_(6, (Goal)new RecruitsOpenDoorGoal(this, true){});
        this.f_21345_.m_25352_(1, (Goal)new RecruitProtectEntityGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new RecruitEatGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new RecruitUpkeepPosGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new RecruitUpkeepEntityGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new RecruitMountEntity(this));
        this.f_21345_.m_25352_(3, (Goal)new RecruitDismountEntity(this));
        this.f_21345_.m_25352_(3, (Goal)new RecruitMoveToPosGoal(this, 1.05));
        this.f_21345_.m_25352_(2, (Goal)new RecruitFollowOwnerGoal(this, 1.05, 300.0f, 100.0f));
        this.f_21345_.m_25352_(2, (Goal)new RecruitMeleeAttackGoal(this, 1.05, this.getMeleeStartRange()));
        this.f_21345_.m_25352_(3, (Goal)new RecruitHoldPosGoal(this, 32.0));
        this.f_21345_.m_25352_(4, (Goal)new RestGoal(this));
        this.f_21345_.m_25352_(10, (Goal)new RecruitWanderGoal(this));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(12, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new RecruitProtectHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new RecruitOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new RecruitHurtByTargetGoal(this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new RecruitOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(7, (Goal)new RecruitDefendVillageFromPlayerGoal(this));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(GROUP, Optional.empty());
        this.f_19804_.m_135372_(SHOULD_FOLLOW, (Object)false);
        this.f_19804_.m_135372_(SHOULD_BLOCK, (Object)false);
        this.f_19804_.m_135372_(SHOULD_MOUNT, (Object)false);
        this.f_19804_.m_135372_(SHOULD_PROTECT, (Object)false);
        this.f_19804_.m_135372_(SHOULD_HOLD_POS, (Object)false);
        this.f_19804_.m_135372_(SHOULD_MOVE_POS, (Object)false);
        this.f_19804_.m_135372_(FLEEING, (Object)false);
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(XP, (Object)0);
        this.f_19804_.m_135372_(KILLS, (Object)0);
        this.f_19804_.m_135372_(LEVEL, (Object)1);
        this.f_19804_.m_135372_(FOLLOW_STATE, (Object)0);
        this.f_19804_.m_135372_(HOLD_POS, Optional.empty());
        this.f_19804_.m_135372_(UPKEEP_POS, Optional.empty());
        this.f_19804_.m_135372_(MOVE_POS, Optional.empty());
        this.f_19804_.m_135372_(LISTEN, (Object)true);
        this.f_19804_.m_135372_(MOUNT_ID, Optional.empty());
        this.f_19804_.m_135372_(PROTECT_ID, Optional.empty());
        this.f_19804_.m_135372_(IS_FOLLOWING, (Object)false);
        this.f_19804_.m_135372_(HUNGER, (Object)Float.valueOf(50.0f));
        this.f_19804_.m_135372_(MORAL, (Object)Float.valueOf(50.0f));
        this.f_19804_.m_135372_(OWNER_ID, Optional.empty());
        this.f_19804_.m_135372_(UPKEEP_ID, Optional.empty());
        this.f_19804_.m_135372_(OWNED, (Object)false);
        this.f_19804_.m_135372_(COST, (Object)1);
        this.f_19804_.m_135372_(COLOR, (Object)0);
        this.f_19804_.m_135372_(BIOME, (Object)0);
        this.f_19804_.m_135372_(SHOULD_REST, (Object)false);
        this.f_19804_.m_135372_(SHOULD_RANGED, (Object)true);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("despawnTimer", this.despawnTimer);
        nbt.m_128405_("AggroState", this.getState());
        nbt.m_128405_("FollowState", this.getFollowState());
        nbt.m_128379_("ShouldFollow", this.getShouldFollow());
        nbt.m_128379_("ShouldMount", this.getShouldMount());
        nbt.m_128379_("ShouldProtect", this.getShouldProtect());
        nbt.m_128379_("ShouldBlock", this.getShouldBlock());
        if (this.getGroup() != null) {
            nbt.m_128362_("Group", this.getGroup());
        }
        nbt.m_128405_("Variant", this.getVariant());
        nbt.m_128379_("Listen", this.getListen());
        nbt.m_128379_("Fleeing", this.getFleeing());
        nbt.m_128379_("isFollowing", this.isFollowing());
        nbt.m_128405_("Xp", this.getXp());
        nbt.m_128405_("Level", this.getXpLevel());
        nbt.m_128405_("Kills", this.getKills());
        nbt.m_128350_("Hunger", this.getHunger());
        nbt.m_128350_("Moral", this.getMorale());
        nbt.m_128379_("isOwned", this.getIsOwned());
        nbt.m_128405_("Cost", this.getCost());
        nbt.m_128405_("mountTimer", this.getMountTimer());
        nbt.m_128405_("upkeepTimer", this.getUpkeepTimer());
        nbt.m_128405_("Color", this.getColor());
        nbt.m_128405_("Biome", this.getBiome());
        nbt.m_128405_("MaxFallDistance", this.m_6056_());
        nbt.m_128405_("formationPos", this.formationPos);
        nbt.m_128379_("ShouldRest", this.getShouldRest());
        nbt.m_128379_("ShouldRanged", this.getShouldRanged());
        nbt.m_128379_("isInFormation", this.isInFormation);
        nbt.m_128405_("paymentTimer", this.paymentTimer);
        if (this.getHoldPos() != null) {
            nbt.m_128347_("HoldPosX", this.getHoldPos().m_7096_());
            nbt.m_128347_("HoldPosY", this.getHoldPos().m_7098_());
            nbt.m_128347_("HoldPosZ", this.getHoldPos().m_7094_());
            nbt.m_128379_("ShouldHoldPos", this.getShouldHoldPos());
        }
        if (this.getMovePos() != null) {
            nbt.m_128347_("MovePosX", (double)this.getMovePos().m_123341_());
            nbt.m_128347_("MovePosY", (double)this.getMovePos().m_123342_());
            nbt.m_128347_("MovePosZ", (double)this.getMovePos().m_123343_());
            nbt.m_128379_("ShouldMovePos", this.getShouldMovePos());
        }
        if (this.getOwnerUUID() != null) {
            nbt.m_128362_("OwnerUUID", this.getOwnerUUID());
        }
        if (this.getMountUUID() != null) {
            nbt.m_128362_("MountUUID", this.getMountUUID());
        }
        if (this.getProtectUUID() != null) {
            nbt.m_128362_("ProtectUUID", this.getProtectUUID());
        }
        if (this.getUpkeepUUID() != null) {
            nbt.m_128362_("UpkeepUUID", this.getUpkeepUUID());
        }
        if (this.getUpkeepPos() != null) {
            nbt.m_128405_("UpkeepPosX", this.getUpkeepPos().m_123341_());
            nbt.m_128405_("UpkeepPosY", this.getUpkeepPos().m_123342_());
            nbt.m_128405_("UpkeepPosZ", this.getUpkeepPos().m_123343_());
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        Optional<UUID> uuid;
        super.m_7378_(nbt);
        this.despawnTimer = nbt.m_128441_("despawnTimer") ? nbt.m_128451_("despawnTimer") : -1;
        this.setXpLevel(nbt.m_128451_("Level"));
        this.setAggroState(nbt.m_128451_("AggroState"));
        this.setFollowState(nbt.m_128451_("FollowState"));
        this.setShouldFollow(nbt.m_128471_("ShouldFollow"));
        this.setShouldMount(nbt.m_128471_("ShouldMount"));
        this.setShouldBlock(nbt.m_128471_("ShouldBlock"));
        this.setShouldProtect(nbt.m_128471_("ShouldProtect"));
        this.setFleeing(nbt.m_128471_("Fleeing"));
        this.setListen(nbt.m_128471_("Listen"));
        this.setIsFollowing(nbt.m_128471_("isFollowing"));
        this.setXp(nbt.m_128451_("Xp"));
        this.setKills(nbt.m_128451_("Kills"));
        this.setVariant(nbt.m_128451_("Variant"));
        this.setHunger(nbt.m_128457_("Hunger"));
        this.setMoral(nbt.m_128457_("Moral"));
        this.setIsOwned(nbt.m_128471_("isOwned"));
        this.setCost(nbt.m_128451_("Cost"));
        this.setMountTimer(nbt.m_128451_("mountTimer"));
        this.setUpkeepTimer(nbt.m_128451_("UpkeepTimer"));
        this.setColor(nbt.m_128445_("Color"));
        this.setMaxFallDistance(nbt.m_128451_("MaxFallDistance"));
        this.formationPos = nbt.m_128451_("formationPos");
        this.setShouldRest(nbt.m_128471_("ShouldRest"));
        this.isInFormation = nbt.m_128471_("isInFormation");
        if (nbt.m_128441_("paymentTimer")) {
            this.paymentTimer = nbt.m_128451_("paymentTimer");
        } else {
            this.resetPaymentTimer();
        }
        if (nbt.m_128441_("HoldPosX") && nbt.m_128441_("HoldPosY") && nbt.m_128441_("HoldPosZ")) {
            this.setShouldHoldPos(nbt.m_128471_("ShouldHoldPos"));
            this.setHoldPos(new Vec3(nbt.m_128459_("HoldPosX"), nbt.m_128459_("HoldPosY"), nbt.m_128459_("HoldPosZ")));
        }
        if (nbt.m_128441_("MovePosX") && nbt.m_128441_("MovePosY") && nbt.m_128441_("MovePosZ")) {
            this.setShouldMovePos(nbt.m_128471_("ShouldMovePos"));
            this.setMovePos(new BlockPos(nbt.m_128451_("MovePosX"), nbt.m_128451_("MovePosY"), nbt.m_128451_("MovePosZ")));
        }
        if (nbt.m_128441_("OwnerUUID")) {
            uuid = Optional.of(nbt.m_128342_("OwnerUUID"));
            this.setOwnerUUID(uuid);
        }
        if (nbt.m_128441_("ProtectUUID")) {
            uuid = Optional.of(nbt.m_128342_("ProtectUUID"));
            this.setProtectUUID(uuid);
        }
        if (nbt.m_128441_("MountUUID")) {
            uuid = Optional.of(nbt.m_128342_("MountUUID"));
            this.setMountUUID(uuid);
        }
        if (nbt.m_128441_("UpkeepUUID")) {
            uuid = Optional.of(nbt.m_128342_("UpkeepUUID"));
            this.setUpkeepUUID(uuid);
        }
        if (nbt.m_128441_("UpkeepPosX") && nbt.m_128441_("UpkeepPosY") && nbt.m_128441_("UpkeepPosZ")) {
            this.setUpkeepPos(new BlockPos(nbt.m_128451_("UpkeepPosX"), nbt.m_128451_("UpkeepPosY"), nbt.m_128451_("UpkeepPosZ")));
        }
        if (nbt.m_128441_("Biome")) {
            this.setBiome(nbt.m_128445_("Biome"));
        } else {
            AbstractRecruitEntity.applyBiomeAndVariant(this);
        }
        if (this.m_20193_().m_5776_()) {
            return;
        }
        if (nbt.m_128441_("Group")) {
            Tag tag = nbt.m_128423_("Group");
            byte type = tag.m_7060_();
            if (type == 3) {
                int oldGroupIndex = nbt.m_128451_("Group");
                RecruitEvents.handleGroupBackwardCompatibility(this, oldGroupIndex);
            } else {
                this.setGroupUUID(nbt.m_128342_("Group"));
            }
        }
    }

    public int getUpkeepTimer() {
        return this.upkeepTimer;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public int getBlockCoolDown() {
        return 200;
    }

    public UUID getUpkeepUUID() {
        return ((Optional)this.f_19804_.m_135370_(UPKEEP_ID)).orElse(null);
    }

    public BlockPos getUpkeepPos() {
        return ((Optional)this.f_19804_.m_135370_(UPKEEP_POS)).orElse(null);
    }

    @Nullable
    public Player getOwner() {
        if (this.getOwnerUUID() != null) {
            UUID ownerID = this.getOwnerUUID();
            return this.m_20193_().m_46003_(ownerID);
        }
        return null;
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_ID)).orElse(null);
    }

    public UUID getProtectUUID() {
        return ((Optional)this.f_19804_.m_135370_(PROTECT_ID)).orElse(null);
    }

    public UUID getMountUUID() {
        return ((Optional)this.f_19804_.m_135370_(MOUNT_ID)).orElse(null);
    }

    public boolean getIsOwned() {
        return (Boolean)this.f_19804_.m_135370_(OWNED);
    }

    public float getMorale() {
        return ((Float)this.f_19804_.m_135370_(MORAL)).floatValue();
    }

    public float getHunger() {
        return ((Float)this.f_19804_.m_135370_(HUNGER)).floatValue();
    }

    public float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    public float getMovementSpeed() {
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    public boolean getFleeing() {
        return (Boolean)this.f_19804_.m_135370_(FLEEING);
    }

    public int getKills() {
        return (Integer)this.f_19804_.m_135370_(KILLS);
    }

    public int getXpLevel() {
        return (Integer)this.f_19804_.m_135370_(LEVEL);
    }

    public int getXp() {
        return (Integer)this.f_19804_.m_135370_(XP);
    }

    public boolean getShouldMovePos() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_MOVE_POS);
    }

    public boolean getShouldHoldPos() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_HOLD_POS);
    }

    public boolean getShouldMount() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_MOUNT);
    }

    public boolean getShouldProtect() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_PROTECT);
    }

    public boolean getShouldFollow() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_FOLLOW);
    }

    public boolean getShouldBlock() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_BLOCK);
    }

    public boolean isFollowing() {
        return (Boolean)this.f_19804_.m_135370_(IS_FOLLOWING);
    }

    public boolean getShouldRest() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_REST);
    }

    public boolean getShouldRanged() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_RANGED);
    }

    public int getState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public UUID getGroup() {
        return this.getGroupUUID().isPresent() ? this.getGroupUUID().get() : null;
    }

    public Optional<UUID> getGroupUUID() {
        return (Optional)this.f_19804_.m_135370_(GROUP);
    }

    public int getFollowState() {
        return (Integer)this.f_19804_.m_135370_(FOLLOW_STATE);
    }

    public SoundEvent m_7975_(@NotNull DamageSource ds) {
        if (this.m_21254_()) {
            return SoundEvents.f_12346_;
        }
        return (Boolean)RecruitsClientConfig.RecruitsLookLikeVillagers.get() != false ? SoundEvents.f_12506_ : SoundEvents.f_11915_;
    }

    protected SoundEvent m_5592_() {
        return (Boolean)RecruitsClientConfig.RecruitsLookLikeVillagers.get() != false ? SoundEvents.f_12505_ : SoundEvents.f_11910_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    protected float m_6431_(@NotNull Pose pos, EntityDimensions size) {
        return size.f_20378_ * 0.98f;
    }

    public int m_8132_() {
        return super.m_8132_();
    }

    public int m_5792_() {
        return 8;
    }

    public Vec3 getHoldPos() {
        return this.holdPosVec;
    }

    @Nullable
    public BlockPos getMovePos() {
        return ((Optional)this.f_19804_.m_135370_(MOVE_POS)).orElse(null);
    }

    public boolean getListen() {
        return (Boolean)this.f_19804_.m_135370_(LISTEN);
    }

    @Nullable
    public LivingEntity getProtectingMob() {
        List list = this.m_20193_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(64.0), living -> this.getProtectUUID() != null && living.m_20148_().equals(this.getProtectUUID()) && living.m_6084_());
        return list.isEmpty() ? null : (LivingEntity)list.get(0);
    }

    public int getColor() {
        return ((Byte)this.f_19804_.m_135370_(COLOR)).byteValue();
    }

    public int getBiome() {
        return ((Byte)this.f_19804_.m_135370_(BIOME)).byteValue();
    }

    public DyeColor getDyeColor() {
        return DyeColor.m_41053_((int)this.getColor());
    }

    public void setUpkeepTimer(int x) {
        this.upkeepTimer = x;
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void setColor(byte color) {
        this.f_19804_.m_135381_(COLOR, (Object)color);
    }

    public void setBiome(byte biome) {
        this.f_19804_.m_135381_(BIOME, (Object)biome);
    }

    public void setUpkeepUUID(Optional<UUID> id) {
        this.f_19804_.m_135381_(UPKEEP_ID, id);
    }

    public void setCost(int cost) {
        this.f_19804_.m_135381_(COST, (Object)cost);
    }

    public void setUpkeepPos(BlockPos pos) {
        this.f_19804_.m_135381_(UPKEEP_POS, Optional.of(pos));
    }

    public void setIsOwned(boolean bool) {
        this.f_19804_.m_135381_(OWNED, (Object)bool);
    }

    public void setOwnerUUID(Optional<UUID> id) {
        this.f_19804_.m_135381_(OWNER_ID, id);
    }

    public void setProtectUUID(Optional<UUID> id) {
        this.f_19804_.m_135381_(PROTECT_ID, id);
    }

    public void setMountUUID(Optional<UUID> id) {
        this.f_19804_.m_135381_(MOUNT_ID, id);
    }

    public void setMoral(float value) {
        this.f_19804_.m_135381_(MORAL, (Object)Float.valueOf(value));
        this.applyMoralEffects();
    }

    public void setHunger(float value) {
        float currentHunger = this.getHunger();
        if (value < 0.0f && currentHunger - value <= 0.0f) {
            this.f_19804_.m_135381_(HUNGER, (Object)Float.valueOf(0.0f));
        } else {
            this.f_19804_.m_135381_(HUNGER, (Object)Float.valueOf(value));
        }
    }

    public void setFleeing(boolean bool) {
        this.f_19804_.m_135381_(FLEEING, (Object)bool);
    }

    public void setMountTimer(int x) {
        this.mountTimer = x;
    }

    public void disband(@Nullable Player player, boolean keepTeam, boolean increaseCost) {
        String name = this.m_7755_().getString();
        if (player != null) {
            player.m_213846_((Component)this.TEXT_DISBAND(name));
        }
        this.m_6710_(null);
        this.setIsOwned(false);
        if (increaseCost) {
            this.recalculateCost();
        }
        if (this.m_20193_().m_5776_()) {
            return;
        }
        RecruitEvents.recruitsPlayerUnitManager.removeRecruits(this.getOwnerUUID(), 1);
        this.setOwnerUUID(Optional.empty());
        if (this.m_5647_() != null && !keepTeam) {
            FactionEvents.removeRecruitFromTeam(this, this.m_5647_(), (ServerLevel)this.m_20193_());
        }
        if (this.getGroup() != null) {
            RecruitEvents.recruitsGroupsManager.removeMember(this.getGroup(), this.m_20148_(), (ServerLevel)this.m_20193_());
            this.setGroupUUID(null);
        }
    }

    public void addXpLevel(int level) {
        int currentLevel = this.getXpLevel();
        int newLevel = currentLevel + level;
        if (newLevel > (Integer)RecruitsServerConfig.RecruitsMaxXpLevel.get()) {
            newLevel = (Integer)RecruitsServerConfig.RecruitsMaxXpLevel.get();
        } else {
            this.makeLevelUpSound();
            this.addLevelBuffs();
        }
        this.f_19804_.m_135381_(LEVEL, (Object)newLevel);
    }

    public void setKills(int kills) {
        this.f_19804_.m_135381_(KILLS, (Object)kills);
    }

    public void setXpLevel(int XpLevel) {
        this.f_19804_.m_135381_(LEVEL, (Object)XpLevel);
    }

    public void setXp(int xp) {
        this.f_19804_.m_135381_(XP, (Object)xp);
    }

    public void addXp(int xp) {
        int currentXp = this.getXp();
        int newXp = currentXp + xp;
        this.f_19804_.m_135381_(XP, (Object)newXp);
    }

    public void setShouldHoldPos(boolean bool) {
        this.f_19804_.m_135381_(SHOULD_HOLD_POS, (Object)bool);
    }

    public void setShouldMovePos(boolean bool) {
        this.f_19804_.m_135381_(SHOULD_MOVE_POS, (Object)bool);
    }

    public void setShouldProtect(boolean bool) {
        this.f_19804_.m_135381_(SHOULD_PROTECT, (Object)bool);
    }

    public void setShouldMount(boolean bool) {
        this.f_19804_.m_135381_(SHOULD_MOUNT, (Object)bool);
    }

    public void setShouldFollow(boolean bool) {
        this.f_19804_.m_135381_(SHOULD_FOLLOW, (Object)bool);
    }

    public void setShouldBlock(boolean bool) {
        this.f_19804_.m_135381_(SHOULD_BLOCK, (Object)bool);
    }

    public void setIsFollowing(boolean bool) {
        this.f_19804_.m_135381_(IS_FOLLOWING, (Object)bool);
    }

    public void setGroupUUID(UUID uuid) {
        this.f_19804_.m_135381_(GROUP, uuid == null ? Optional.empty() : Optional.of(uuid));
    }

    public void setShouldRest(boolean bool) {
        if (bool) {
            this.setFollowState(0);
        }
        this.f_19804_.m_135381_(SHOULD_REST, (Object)bool);
    }

    public void setShouldRanged(boolean should) {
        this.f_19804_.m_135381_(SHOULD_RANGED, (Object)should);
    }

    public void setAggroState(int state) {
        switch (state) {
            case 0: 
            case 3: {
                this.m_6710_(null);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.setFollowState(0);
            }
        }
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public void setFollowState(int state) {
        switch (state) {
            case 0: 
            case 6: {
                this.setShouldFollow(false);
                this.setShouldHoldPos(false);
                this.setShouldProtect(false);
                this.setShouldMovePos(false);
                break;
            }
            case 1: {
                this.setShouldFollow(true);
                this.setShouldHoldPos(false);
                this.setShouldProtect(false);
                this.setShouldMovePos(false);
                break;
            }
            case 2: {
                this.setShouldFollow(false);
                this.setShouldHoldPos(true);
                this.clearHoldPos();
                this.setHoldPos(this.m_20182_());
                this.setShouldProtect(false);
                this.setShouldMovePos(false);
                break;
            }
            case 3: {
                this.setShouldFollow(false);
                this.setShouldHoldPos(true);
                this.setShouldProtect(false);
                this.setShouldMovePos(false);
                break;
            }
            case 4: {
                this.setShouldFollow(false);
                this.setShouldHoldPos(true);
                this.clearHoldPos();
                this.setHoldPos(this.getOwner().m_20182_());
                this.setShouldProtect(false);
                this.setShouldMovePos(false);
                state = 3;
                break;
            }
            case 5: {
                this.setShouldFollow(false);
                this.setShouldHoldPos(false);
                this.setShouldProtect(true);
                this.setShouldMovePos(false);
            }
        }
        this.f_19804_.m_135381_(FOLLOW_STATE, (Object)state);
    }

    public void setHoldPos(Vec3 holdPos) {
        this.holdPosVec = holdPos;
    }

    public void setMovePos(BlockPos holdPos) {
        this.f_19804_.m_135381_(MOVE_POS, Optional.of(holdPos));
        this.reachedMovePos = false;
    }

    public void clearHoldPos() {
        this.f_19804_.m_135381_(HOLD_POS, Optional.empty());
    }

    public void clearMovePos() {
        this.f_19804_.m_135381_(MOVE_POS, Optional.empty());
    }

    public void setListen(boolean bool) {
        this.f_19804_.m_135381_(LISTEN, (Object)bool);
    }

    public void setEquipment() {
        int size;
        int i;
        List<List<String>> equipmentSets = this.getEquipment();
        if (!equipmentSets.isEmpty() && (i = this.f_19796_.m_216339_(0, size = equipmentSets.size())) >= 0) {
            List<String> equipmentSet = equipmentSets.get(i);
            while (equipmentSet.size() < 6) {
                equipmentSet.add("");
            }
            String mainHandStr = equipmentSet.get(0);
            String offHandStr = equipmentSet.get(1);
            String feetStr = equipmentSet.get(2);
            String legsStr = equipmentSet.get(3);
            String chestStr = equipmentSet.get(4);
            String headStr = equipmentSet.get(5);
            Optional holderHead = ForgeRegistries.ITEMS.getHolder(ResourceLocation.m_135820_((String)headStr));
            holderHead.ifPresent(itemHolder -> this.m_8061_(EquipmentSlot.HEAD, ((Item)itemHolder.m_203334_()).m_7968_()));
            Optional holderChest = ForgeRegistries.ITEMS.getHolder(ResourceLocation.m_135820_((String)chestStr));
            holderChest.ifPresent(itemHolder -> this.m_8061_(EquipmentSlot.CHEST, ((Item)itemHolder.m_203334_()).m_7968_()));
            Optional holderLegs = ForgeRegistries.ITEMS.getHolder(ResourceLocation.m_135820_((String)legsStr));
            holderLegs.ifPresent(itemHolder -> this.m_8061_(EquipmentSlot.LEGS, ((Item)itemHolder.m_203334_()).m_7968_()));
            Optional holderFeet = ForgeRegistries.ITEMS.getHolder(ResourceLocation.m_135820_((String)feetStr));
            holderFeet.ifPresent(itemHolder -> this.m_8061_(EquipmentSlot.FEET, ((Item)itemHolder.m_203334_()).m_7968_()));
            Optional holderMainHand = ForgeRegistries.ITEMS.getHolder(ResourceLocation.m_135820_((String)mainHandStr));
            holderMainHand.ifPresent(itemHolder -> this.m_8061_(EquipmentSlot.MAINHAND, ((Item)itemHolder.m_203334_()).m_7968_()));
            Optional holderOffHand = ForgeRegistries.ITEMS.getHolder(ResourceLocation.m_135820_((String)offHandStr));
            holderOffHand.ifPresent(itemHolder -> this.m_8061_(EquipmentSlot.OFFHAND, ((Item)itemHolder.m_203334_()).m_7968_()));
        }
    }

    public void m_6710_(@Nullable LivingEntity p_21544_) {
        super.m_6710_(p_21544_);
        this.setUpkeepTimer(500);
    }

    public List<List<String>> getEquipment() {
        return null;
    }

    public double getMeleeStartRange() {
        return 32.0;
    }

    public abstract void initSpawn();

    public static void applySpawnValues(AbstractRecruitEntity recruit) {
        recruit.setHunger(50.0f);
        recruit.setMoral(50.0f);
        recruit.setListen(true);
        recruit.setXpLevel(1);
        AbstractRecruitEntity.applyBiomeAndVariant(recruit);
    }

    public static void applyBiomeAndVariant(AbstractRecruitEntity recruit) {
        Holder biome = recruit.m_20193_().m_204166_(recruit.m_20097_());
        int biomeByte = 2;
        int variant = recruit.f_19796_.m_216339_(0, 14);
        if (biome.m_203565_(Biomes.f_48194_) || biome.containsTag(Tags.Biomes.IS_DESERT) || biome.containsTag(Tags.Biomes.IS_SANDY) && !biome.containsTag(Tags.Biomes.IS_WET_OVERWORLD)) {
            biomeByte = 0;
            variant = recruit.f_19796_.m_216339_(15, 19);
        } else if (biome.m_203656_(Tags.Biomes.IS_CONIFEROUS) && biome.m_203656_(Tags.Biomes.IS_COLD_OVERWORLD) && !biome.m_203656_(Tags.Biomes.IS_SNOWY)) {
            biomeByte = 6;
            variant = recruit.f_19796_.m_216339_(5, 14);
        } else if (biome.m_203656_(Tags.Biomes.IS_WET_OVERWORLD) && !biome.m_203656_(Tags.Biomes.IS_SANDY) && !biome.m_203656_(Tags.Biomes.IS_SWAMP)) {
            biomeByte = 1;
            variant = recruit.f_19796_.m_216339_(15, 19);
        } else if (biome.m_203656_(Tags.Biomes.IS_HOT_OVERWORLD) && biome.m_203656_(Tags.Biomes.IS_SPARSE_OVERWORLD)) {
            biomeByte = 3;
            variant = recruit.f_19796_.m_216339_(15, 19);
        } else if (biome.m_203656_(Tags.Biomes.IS_SNOWY)) {
            biomeByte = 4;
            variant = recruit.f_19796_.m_216339_(5, 10);
        } else if (biome.m_203656_(Tags.Biomes.IS_SWAMP)) {
            biomeByte = 5;
            variant = recruit.f_19796_.m_216339_(5, 14);
        }
        recruit.setBiome((byte)biomeByte);
        recruit.setVariant(variant);
    }

    public boolean isEffectedByCommand(UUID player_uuid) {
        return this.isEffectedByCommand(player_uuid, null);
    }

    public boolean isEffectedByCommand(UUID player_uuid, UUID group) {
        if (!(this.isOwned() && this.m_6084_() && this.getListen())) {
            return false;
        }
        if (!this.getOwnerUUID().equals(player_uuid)) {
            return false;
        }
        if (group == null) {
            return true;
        }
        return this.getGroup() != null && this.getGroup().equals(group);
    }

    public boolean isOwned() {
        return this.getIsOwned();
    }

    public boolean isOwnedBy(Player player) {
        return player.m_20148_() == this.getOwnerUUID() || player == this.getOwner();
    }

    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        boolean isPlayerTarget;
        String name = this.m_7755_().getString();
        Team ownerTeam = this.m_5647_();
        boolean bl = isPlayerTarget = this.m_5448_() != null && this.m_5448_().equals((Object)player);
        if (isPlayerTarget) {
            return InteractionResult.PASS;
        }
        if (this.m_20193_().f_46443_) {
            boolean flag = this.isOwnedBy(player) || !this.canBeHired();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (player.m_7500_() && player.m_21120_(hand).m_41720_().equals(ModItems.RECRUIT_SPAWN_EGG.get())) {
            this.openDebugScreen(player);
            return InteractionResult.SUCCESS;
        }
        AbstractRecruitEntity abstractRecruitEntity = this;
        if (abstractRecruitEntity instanceof VillagerNobleEntity) {
            VillagerNobleEntity noble = (VillagerNobleEntity)abstractRecruitEntity;
            if (!noble.isTrading) {
                noble.openTradeGUI(player);
                return InteractionResult.SUCCESS;
            }
        }
        if (this.isOwned() && player.m_20148_().equals(this.getOwnerUUID())) {
            if (player.m_6047_()) {
                this.openGUI(player);
                this.f_21344_.m_26573_();
                return InteractionResult.SUCCESS;
            }
            if (!player.m_6047_()) {
                this.setUpkeepTimer(this.getUpkeepCooldown());
                if (this.getShouldMount()) {
                    this.setShouldMount(false);
                }
                int state = this.getFollowState();
                switch (state) {
                    default: {
                        this.setFollowState(1);
                        player.m_213846_((Component)this.TEXT_FOLLOW(name));
                        break;
                    }
                    case 1: {
                        this.setFollowState(4);
                        player.m_213846_((Component)this.TEXT_HOLD_YOUR_POS(name));
                        break;
                    }
                    case 3: {
                        this.setFollowState(0);
                        player.m_213846_((Component)this.TEXT_WANDER(name));
                    }
                }
                if (this instanceof AbstractLeaderEntity) {
                    CommandEvents.checkPatrolLeaderState(this);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (this.isOwned() && this.m_5647_() != null && !player.m_20148_().equals(this.getOwnerUUID()) && FactionEvents.recruitsFactionManager.getTeamByStringID(this.m_5647_().m_5758_()).getTeamLeaderUUID().equals(player.m_20148_())) {
            Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageToClientOpenTakeOverScreen(this.m_20148_()));
        } else if (!this.isOwned() && !isPlayerTarget && this.canBeHired()) {
            this.openHireGUI(player);
            this.dialogue(name, player);
            this.f_21344_.m_26573_();
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean hire(Player player, RecruitsGroup group) {
        String stringId;
        String name = this.m_7755_().getString() + ": ";
        Team ownerTeam = player.m_5647_();
        String string = stringId = ownerTeam != null ? ownerTeam.m_5758_() : "";
        if (!RecruitEvents.recruitsPlayerUnitManager.canPlayerRecruit(stringId, player.m_20148_())) {
            player.m_213846_(this.INFO_RECRUITING_MAX(name));
            return false;
        }
        this.makeHireSound();
        this.resetPaymentTimer();
        this.setOwnerUUID(Optional.of(player.m_20148_()));
        this.setIsOwned(true);
        this.f_21344_.m_26573_();
        this.m_6710_(null);
        this.setFollowState(2);
        this.setAggroState(0);
        this.setGroupUUID(group.getUUID());
        this.despawnTimer = -1;
        if (!this.m_20193_().m_5776_()) {
            RecruitEvents.recruitsPlayerUnitManager.addRecruits(player.m_20148_(), 1);
            if (group != null) {
                RecruitEvents.recruitsGroupsManager.addMember(group.getUUID(), this.m_20148_(), (ServerLevel)this.m_20193_());
                RecruitEvents.recruitsGroupsManager.broadCastGroupsToPlayer(player);
            }
            if (ownerTeam != null) {
                FactionEvents.addRecruitToTeam(this, ownerTeam, (ServerLevel)this.m_20193_());
            }
        }
        int i = this.f_19796_.m_188503_(4);
        switch (i) {
            default: {
                player.m_213846_((Component)this.TEXT_RECRUITED1(name));
                break;
            }
            case 2: {
                player.m_213846_((Component)this.TEXT_RECRUITED2(name));
                break;
            }
            case 3: {
                player.m_213846_((Component)this.TEXT_RECRUITED3(name));
            }
        }
        return true;
    }

    public void dialogue(String name, Player player) {
        int i = this.f_19796_.m_188503_(4);
        switch (i) {
            case 1: {
                player.m_213846_((Component)this.TEXT_HELLO_1(name));
                break;
            }
            case 2: {
                player.m_213846_((Component)this.TEXT_HELLO_2(name));
                break;
            }
            case 3: {
                player.m_213846_((Component)this.TEXT_HELLO_3(name));
            }
        }
    }

    public boolean m_6469_(@NotNull DamageSource dmg, float amt) {
        LivingEntity living;
        if (this.m_6673_(dmg)) {
            return false;
        }
        Entity entity = dmg.m_7639_();
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amt = (amt + 1.0f) / 2.0f;
        }
        if (this.getMorale() > 0.0f) {
            this.setMoral(this.getMorale() - 0.25f);
        }
        if (this.m_21254_()) {
            this.m_7909_(amt);
        }
        if (entity instanceof LivingEntity && RecruitEvents.canAttack((LivingEntity)this, living = (LivingEntity)entity)) {
            LivingEntity livingEntity;
            if (this.getFollowState() == 5) {
                List list = this.m_20193_().m_45976_(AbstractRecruitEntity.class, this.m_20191_().m_82400_(32.0));
                livingEntity = list.iterator();
                while (livingEntity.hasNext()) {
                    AbstractRecruitEntity recruit = (AbstractRecruitEntity)((Object)livingEntity.next());
                    if (!recruit.m_20148_().equals(recruit.getProtectUUID()) || !recruit.m_6084_() || recruit.equals(living)) continue;
                    recruit.m_6710_(living);
                }
            }
            if (this.m_5448_() != null) {
                double d1 = this.m_20280_((Entity)this.m_5448_());
                double d2 = this.m_20280_((Entity)living);
                if (d2 < d1) {
                    this.m_6710_(living);
                }
            } else {
                this.m_6710_(living);
            }
            if (this.getShouldProtect() && (livingEntity = this.getProtectingMob()) instanceof AbstractRecruitEntity) {
                AbstractRecruitEntity patrolLeader = (AbstractRecruitEntity)livingEntity;
                patrolLeader.m_6710_(living);
            }
        }
        return super.m_6469_(dmg, amt);
    }

    public boolean m_7327_(@NotNull Entity entity) {
        boolean flag;
        int i;
        float f = (float)this.m_21133_(Attributes.f_22281_);
        if (entity instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entity).m_6336_());
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            entity.m_20254_(i * 4);
        }
        if (flag = entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f)) {
            this.m_19970_((LivingEntity)this, entity);
            this.m_21335_(entity);
        }
        this.addXp(1);
        if (this.getHunger() > 0.0f) {
            this.setHunger(this.getHunger() - 0.1f);
        }
        this.checkLevel();
        if (this.getMorale() < 100.0f) {
            this.setMoral(this.getMorale() + 0.25f);
        }
        this.damageMainHandItem();
        return true;
    }

    public void addLevelBuffs() {
        int level = this.getXpLevel();
        if (level <= 10) {
            this.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("heath_bonus_level", 2.0, AttributeModifier.Operation.ADDITION));
            this.m_21051_(Attributes.f_22281_).m_22125_(new AttributeModifier("attack_bonus_level", 0.03, AttributeModifier.Operation.ADDITION));
            this.m_21051_(Attributes.f_22278_).m_22125_(new AttributeModifier("knockback_bonus_level", 0.0012, AttributeModifier.Operation.ADDITION));
            this.m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier("speed_bonus_level", 0.0025, AttributeModifier.Operation.ADDITION));
        }
        if (level > 10) {
            this.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("heath_bonus_level", 2.0, AttributeModifier.Operation.ADDITION));
        }
    }

    public void addLevelBuffsForLevel(int level) {
        for (int i = 0; i < level; ++i) {
            if (level <= 10) {
                this.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("heath_bonus_level", 2.0, AttributeModifier.Operation.ADDITION));
                this.m_21051_(Attributes.f_22281_).m_22125_(new AttributeModifier("attack_bonus_level", 0.03, AttributeModifier.Operation.ADDITION));
                this.m_21051_(Attributes.f_22278_).m_22125_(new AttributeModifier("knockback_bonus_level", 0.0012, AttributeModifier.Operation.ADDITION));
                this.m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier("speed_bonus_level", 0.0025, AttributeModifier.Operation.ADDITION));
            }
            if (level <= 10) continue;
            this.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("heath_bonus_level", 2.0, AttributeModifier.Operation.ADDITION));
        }
    }

    public boolean m_20031_(@NotNull Team team) {
        if (!this.m_20193_().m_5776_() && this.m_5647_() != null) {
            RecruitsDiplomacyManager.DiplomacyStatus status = FactionEvents.recruitsDiplomacyManager.getRelation(this.m_5647_().m_5758_(), team.m_5758_());
            return status == RecruitsDiplomacyManager.DiplomacyStatus.ALLY;
        }
        return super.m_20031_(team);
    }

    @Override
    public void m_6667_(DamageSource dmg) {
        Component deathMessage = this.m_21231_().m_19293_();
        super.m_6667_(dmg);
        if (this.f_20890_ && !this.m_20193_().m_5776_()) {
            if (this.m_20193_().m_46469_().m_46207_(GameRules.f_46142_) && this.getOwner() instanceof ServerPlayer) {
                this.getOwner().m_213846_(deathMessage);
            }
            if (this.isOwned()) {
                RecruitEvents.recruitsPlayerUnitManager.removeRecruits(this.getOwnerUUID(), 1);
                FactionEvents.removeRecruitFromTeam(this, this.m_5647_(), (ServerLevel)this.m_20193_());
            }
            if (this.m_5647_() != null) {
                FactionEvents.recruitsFactionManager.getTeamByStringID(this.m_5647_().m_5758_()).addNPCs(-1);
            }
            if (this.getGroup() != null) {
                RecruitEvents.recruitsGroupsManager.removeMember(this.getGroup(), this.m_20148_(), (ServerLevel)this.m_20193_());
            }
        }
    }

    public void updateMorale() {
        float currentMorale;
        float newMorale = currentMorale = this.getMorale();
        if (this.isStarving() && this.isOwned() && currentMorale > 0.0f) {
            newMorale -= 2.0f;
        }
        if (this.isOwned() && !this.isSaturated() && currentMorale > 35.0f) {
            newMorale -= 1.0f;
        }
        if ((this.isSaturated() || (double)this.m_21223_() >= (double)this.m_21233_() * 0.85) && currentMorale < 65.0f) {
            newMorale += 2.0f;
        }
        if (newMorale < 0.0f) {
            newMorale = 0.0f;
        }
        this.setMoral(newMorale);
    }

    public void applyMoralEffects() {
        boolean highMoral;
        boolean confused = 0.0f <= this.getMorale() && this.getMorale() < 20.0f;
        boolean lowMoral = 20.0f <= this.getMorale() && this.getMorale() < 40.0f;
        boolean bl = highMoral = 90.0f <= this.getMorale() && this.getMorale() <= 100.0f;
        if (confused) {
            if (!this.m_21023_(MobEffects.f_19613_)) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 3, false, false, true));
            }
            if (!this.m_21023_(MobEffects.f_19597_)) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 2, false, false, true));
            }
            if (!this.m_21023_(MobEffects.f_19604_)) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 1, false, false, true));
            }
        }
        if (lowMoral) {
            if (!this.m_21023_(MobEffects.f_19613_)) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 1, false, false, true));
            }
            if (!this.m_21023_(MobEffects.f_19597_)) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 1, false, false, true));
            }
        }
        if (highMoral) {
            if (!this.m_21023_(MobEffects.f_19600_)) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 0, false, false, true));
            }
            if (!this.m_21023_(MobEffects.f_19606_)) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 0, false, false, true));
            }
        }
    }

    public void updateHunger() {
        float hunger = this.getHunger();
        hunger = this.getFollowState() == 2 ? (hunger -= 0.033333335f) : (hunger -= 0.05f);
        if (hunger < 0.0f) {
            hunger = 0.0f;
        }
        this.setHunger(hunger);
    }

    public boolean needsToGetFood() {
        int timer = this.getUpkeepTimer();
        boolean needsToEat = this.needsToEat();
        boolean hasFood = this.hasFoodInInv();
        boolean isChest = this.getUpkeepPos() != null;
        boolean isEntity = this.getUpkeepUUID() != null;
        return (this.forcedUpkeep || !hasFood && timer == 0 && needsToEat && (isChest || isEntity)) && !this.getShouldProtect();
    }

    public boolean hasFoodInInv() {
        return this.getInventory().f_19147_.stream().anyMatch(ItemStack::m_41614_);
    }

    public boolean needsToEat() {
        if (this.getHunger() <= 50.0f) {
            return true;
        }
        if (this.getHunger() <= 70.0f && this.m_21223_() != this.m_21233_() && this.m_5448_() == null && this.getIsOwned()) {
            return true;
        }
        return (double)this.m_21223_() <= (double)this.m_21233_() * 0.3 && this.m_5448_() == null;
    }

    public boolean needsToPotion() {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            return (double)this.m_21223_() <= (double)this.m_21233_() * 0.6 || target.m_21223_() > this.m_21223_();
        }
        return false;
    }

    public boolean isStarving() {
        return this.getHunger() <= 1.0f;
    }

    public boolean isSaturated() {
        return this.getHunger() >= 90.0f;
    }

    public void checkLevel() {
        int currentXp = this.getXp();
        if (currentXp >= (Integer)RecruitsServerConfig.RecruitsMaxXpForLevelUp.get()) {
            this.addXpLevel(1);
            this.setXp(0);
            this.m_5634_(10.0f);
            this.recalculateCost();
            if (this.getMorale() < 100.0f) {
                this.setMoral(this.getMorale() + 5.0f);
            }
        }
    }

    private void recalculateCost() {
        int currCost = this.getCost();
        int armorBonus = this.m_21230_() * 2;
        int weaponBonus = 4;
        int speedBonus = (int)(this.m_6113_() * 2.0f);
        int shieldBonus = this.m_21206_().m_41720_() instanceof ShieldItem ? 10 : 0;
        int newCost = Math.abs(shieldBonus + speedBonus + weaponBonus + armorBonus + currCost + this.getXpLevel() * 2);
        this.setCost(newCost);
    }

    public void makeLevelUpSound() {
        this.m_20193_().m_6263_(null, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), SoundEvents.f_12275_, this.m_5720_(), 1.0f, 0.8f + 0.4f * this.f_19796_.m_188501_());
        if (((Boolean)RecruitsClientConfig.RecruitsLookLikeVillagers.get()).booleanValue()) {
            this.m_20193_().m_6263_(null, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), SoundEvents.f_12504_, this.m_5720_(), 1.0f, 0.8f + 0.4f * this.f_19796_.m_188501_());
        }
    }

    public void makeHireSound() {
        if (((Boolean)RecruitsClientConfig.RecruitsLookLikeVillagers.get()).booleanValue()) {
            this.m_5496_(SoundEvents.f_12503_, 1.0f, 0.8f + 0.4f * this.f_19796_.m_188501_());
        }
    }

    public boolean m_6573_(@NotNull Player player) {
        return false;
    }

    public int getCost() {
        return (Integer)this.f_19804_.m_135370_(COST);
    }

    protected void m_6472_(@NotNull DamageSource damageSource, float damage) {
        ItemStack feetArmor;
        boolean hasFeetArmor;
        ItemStack legsArmor;
        boolean hasLegsArmor;
        ItemStack chestArmor;
        boolean hasChestArmor;
        boolean hasHeadArmor;
        if (this.m_9236_().m_5776_()) {
            return;
        }
        ItemStack headArmor = this.m_6844_(EquipmentSlot.HEAD);
        boolean bl = hasHeadArmor = !headArmor.m_41619_();
        if (!(damageSource.m_276093_(DamageTypes.f_268631_) && damageSource.m_276093_(DamageTypes.f_268468_) && headArmor.m_41720_().m_41475_() || !(headArmor.m_41720_() instanceof ArmorItem))) {
            headArmor.m_41622_(1, (LivingEntity)this, recruit -> recruit.m_21166_(EquipmentSlot.HEAD));
        }
        if (this.m_6844_(EquipmentSlot.HEAD).m_41619_() && hasHeadArmor) {
            this.inventory.m_6836_(0, ItemStack.f_41583_);
            this.getInventory().m_6596_();
            this.m_5496_(SoundEvents.f_12018_, 0.8f, 0.8f + this.m_20193_().f_46441_.m_188501_() * 0.4f);
            this.tryToReequip(EquipmentSlot.HEAD);
        }
        boolean bl2 = hasChestArmor = !(chestArmor = this.m_6844_(EquipmentSlot.CHEST)).m_41619_();
        if (!(damageSource.m_276093_(DamageTypes.f_268631_) && damageSource.m_276093_(DamageTypes.f_268468_) && chestArmor.m_41720_().m_41475_() || !(chestArmor.m_41720_() instanceof ArmorItem))) {
            chestArmor.m_41622_(1, (LivingEntity)this, recruit -> recruit.m_21166_(EquipmentSlot.CHEST));
        }
        if (this.m_6844_(EquipmentSlot.CHEST).m_41619_() && hasChestArmor) {
            this.inventory.m_6836_(1, ItemStack.f_41583_);
            this.getInventory().m_6596_();
            this.m_5496_(SoundEvents.f_12018_, 0.8f, 0.8f + this.m_20193_().f_46441_.m_188501_() * 0.4f);
            this.tryToReequip(EquipmentSlot.CHEST);
        }
        boolean bl3 = hasLegsArmor = !(legsArmor = this.m_6844_(EquipmentSlot.LEGS)).m_41619_();
        if (!(damageSource.m_276093_(DamageTypes.f_268631_) && damageSource.m_276093_(DamageTypes.f_268468_) && legsArmor.m_41720_().m_41475_() || !(legsArmor.m_41720_() instanceof ArmorItem))) {
            legsArmor.m_41622_(1, (LivingEntity)this, recruit -> recruit.m_21166_(EquipmentSlot.LEGS));
        }
        if (this.m_6844_(EquipmentSlot.LEGS).m_41619_() && hasLegsArmor) {
            this.inventory.m_6836_(2, ItemStack.f_41583_);
            this.getInventory().m_6596_();
            this.m_5496_(SoundEvents.f_12018_, 0.8f, 0.8f + this.m_20193_().f_46441_.m_188501_() * 0.4f);
            this.tryToReequip(EquipmentSlot.LEGS);
        }
        boolean bl4 = hasFeetArmor = !(feetArmor = this.m_6844_(EquipmentSlot.FEET)).m_41619_();
        if (!(damageSource.m_276093_(DamageTypes.f_268631_) && damageSource.m_276093_(DamageTypes.f_268468_) && feetArmor.m_41720_().m_41475_() || !(feetArmor.m_41720_() instanceof ArmorItem))) {
            feetArmor.m_41622_(1, (LivingEntity)this, p_43296_ -> {});
        }
        if (this.m_6844_(EquipmentSlot.FEET).m_41619_() && hasFeetArmor) {
            this.inventory.m_6836_(3, ItemStack.f_41583_);
            this.getInventory().m_6596_();
            this.m_5496_(SoundEvents.f_12018_, 0.8f, 0.8f + this.m_20193_().f_46441_.m_188501_() * 0.4f);
            this.tryToReequip(EquipmentSlot.FEET);
        }
    }

    public void damageMainHandItem() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        ItemStack handItem = this.m_6844_(EquipmentSlot.MAINHAND);
        boolean hasHandItem = !handItem.m_41619_();
        this.m_21205_().m_41622_(1, (LivingEntity)this, recruit -> recruit.m_21166_(EquipmentSlot.MAINHAND));
        if (this.m_21205_().m_41619_() && hasHandItem) {
            this.inventory.m_6836_(5, ItemStack.f_41583_);
            this.getInventory().m_6596_();
            this.m_5496_(SoundEvents.f_12018_, 0.8f, 0.8f + this.m_20193_().f_46441_.m_188501_() * 0.4f);
            this.tryToReequip(EquipmentSlot.MAINHAND);
        }
    }

    public void tryToReequip(EquipmentSlot equipmentSlot) {
        for (int i = 6; i < 15; ++i) {
            ItemStack itemStack = this.getInventory().m_8020_(i);
            if (!this.canEquipItemToSlot(itemStack, equipmentSlot)) continue;
            this.m_8061_(equipmentSlot, itemStack);
            this.inventory.m_6836_(this.getInventorySlotIndex(equipmentSlot), itemStack);
            this.inventory.m_8016_(i);
            Equipable equipable = Equipable.m_269088_((ItemStack)itemStack);
            if (equipable == null) continue;
            this.m_20193_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), equipable.m_150681_(), this.m_5720_(), 1.0f, 1.0f);
        }
    }

    public void tryToReequipShield() {
        for (ItemStack itemStack : this.getInventory().f_19147_) {
            if (!(itemStack.m_41720_() instanceof ShieldItem)) continue;
            this.m_8061_(EquipmentSlot.OFFHAND, itemStack);
            this.inventory.m_6836_(this.getInventorySlotIndex(EquipmentSlot.OFFHAND), itemStack);
            Equipable equipable = Equipable.m_269088_((ItemStack)itemStack);
            if (equipable != null) {
                this.m_20193_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), equipable.m_150681_(), this.m_5720_(), 1.0f, 1.0f);
            }
            itemStack.m_41774_(1);
        }
    }

    protected void m_7909_(float damage) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.m_21206_().m_41622_(1, (LivingEntity)this, recruit -> recruit.m_21166_(EquipmentSlot.OFFHAND));
        if (this.m_21206_().m_41619_()) {
            this.inventory.m_6836_(4, ItemStack.f_41583_);
            this.getInventory().m_6596_();
            this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.m_20193_().f_46441_.m_188501_() * 0.4f);
            this.tryToReequipShield();
        }
    }

    public boolean m_214076_(@NotNull ServerLevel level, @NotNull LivingEntity living) {
        Villager villager;
        super.m_214076_(level, living);
        this.addXp(5);
        this.setKills(this.getKills() + 1);
        if (this.getMorale() < 100.0f) {
            this.setMoral(this.getMorale() + 1.0f);
        }
        if (living instanceof Player) {
            this.addXp(45);
            if (this.getMorale() < 100.0f) {
                this.setMoral(this.getMorale() + 9.0f);
            }
        }
        if (living instanceof Raider) {
            this.addXp(5);
            if (this.getMorale() < 100.0f) {
                this.setMoral(this.getMorale() + 2.0f);
            }
        }
        if (living instanceof Villager && (villager = (Villager)living).m_6162_()) {
            if (this.getMorale() > 0.0f) {
                this.setMoral(this.getMorale() - 10.0f);
            } else if (this.getMorale() > 0.0f) {
                this.setMoral(this.getMorale() - 2.0f);
            }
        }
        if (living instanceof WitherBoss) {
            this.addXp(99);
            if (this.getMorale() < 100.0f) {
                this.setMoral(this.getMorale() + 9.0f);
            }
        }
        if (living instanceof IronGolem) {
            this.addXp(49);
            if (this.getMorale() > 0.0f) {
                this.setMoral(this.getMorale() - 1.0f);
            }
        }
        if (living instanceof EnderDragon) {
            this.addXp(999);
            if (this.getMorale() < 100.0f) {
                this.setMoral(this.getMorale() + 49.0f);
            }
        }
        this.checkLevel();
        return true;
    }

    protected void m_6728_(@NotNull LivingEntity living) {
        super.m_6728_(living);
        if (living.m_21205_().canDisableShield(this.f_20935_, (LivingEntity)this, living)) {
            this.disableShield();
        }
    }

    public void disableShield() {
        this.blockCoolDown = this.getBlockCoolDown();
        this.m_5810_();
        this.m_20193_().m_7605_((Entity)this, (byte)30);
    }

    public boolean canBlock() {
        return this.blockCoolDown == 0;
    }

    public void updateShield() {
        if (this.blockCoolDown > 0) {
            --this.blockCoolDown;
        }
    }

    public int getMountTimer() {
        return this.mountTimer;
    }

    @Override
    public void openGUI(Player player) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return AbstractRecruitEntity.this.m_7755_();
                }

                @NotNull
                public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
                    return new RecruitInventoryMenu(i, AbstractRecruitEntity.this, playerInventory);
                }
            }, packetBuffer -> packetBuffer.m_130077_(this.m_20148_()));
        } else {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageRecruitGui(player, this.m_20148_()));
        }
    }

    public void openDebugScreen(Player player) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return AbstractRecruitEntity.this.m_7755_();
                }

                public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
                    return new DebugInvMenu(i, AbstractRecruitEntity.this, playerInventory);
                }
            }, packetBuffer -> packetBuffer.m_130077_(this.m_20148_()));
        } else {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugScreen(player, this.m_20148_()));
        }
    }

    public static void openTakeOverGUI(Player player) {
    }

    public boolean canBeHired() {
        return true;
    }

    public boolean m_6779_(@Nonnull LivingEntity target) {
        MessengerEntity messenger;
        if (target instanceof MessengerEntity && (messenger = (MessengerEntity)target).isAtMission()) {
            return false;
        }
        if (((List)RecruitsServerConfig.TargetBlackList.get()).contains(target.m_20078_())) {
            return false;
        }
        return RecruitEvents.canAttack((LivingEntity)this, target);
    }

    public boolean shouldAttack(LivingEntity target) {
        return switch (this.getState()) {
            case 3 -> false;
            case 0 -> {
                if (this.shouldAttackOnNeutral(target) && this.m_6779_(target)) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if ((this.shouldAttackOnNeutral(target) || this.shouldAttackOnAggressive(target)) && this.m_6779_(target)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (!RecruitEvents.isAlly(this.m_5647_(), target.m_5647_()) && this.m_6779_(target)) {
                    yield true;
                }
                yield false;
            }
            default -> this.m_6779_(target);
        };
    }

    private boolean shouldAttackOnNeutral(LivingEntity target) {
        if (this.isMonster(target) || this.isAttackingOwnerOrSelf(this, target)) {
            return true;
        }
        if (target instanceof Villager) {
            return false;
        }
        return RecruitEvents.isEnemy(this.m_5647_(), target.m_5647_());
    }

    private boolean shouldAttackOnAggressive(LivingEntity target) {
        if (target instanceof Villager) {
            return false;
        }
        return !(!(target instanceof AbstractRecruitEntity) && !(target instanceof Player) || !RecruitEvents.isNeutral(this.m_5647_(), target.m_5647_()) && !RecruitEvents.isEnemy(this.m_5647_(), target.m_5647_()));
    }

    private boolean isMonster(LivingEntity target) {
        return target instanceof Enemy;
    }

    private boolean isAttackingOwnerOrSelf(AbstractRecruitEntity recruit, LivingEntity target) {
        return target.m_21188_() != null && (target.m_21188_().equals((Object)recruit) || target.m_21188_().equals((Object)recruit.getOwner()));
    }

    public boolean m_7307_(Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            return !RecruitEvents.canHarmTeam((LivingEntity)this, livingTarget);
        }
        return super.m_7307_(target);
    }

    public void updateTeam() {
        Player owner;
        if (this.isOwned() && !this.m_20193_().m_5776_() && (owner = this.getOwner()) != null) {
            Team recruitTeam = this.m_5647_();
            Team ownerTeam = owner.m_5647_();
            if (ownerTeam == null) {
                if (recruitTeam != null) {
                    FactionEvents.removeRecruitFromTeam(this, recruitTeam, (ServerLevel)this.m_20193_());
                    FactionEvents.addNPCToData((ServerLevel)this.m_20193_(), recruitTeam.m_5758_(), -1);
                }
                this.needsTeamUpdate = false;
            } else if (recruitTeam == null) {
                FactionEvents.addRecruitToTeam(this, ownerTeam, (ServerLevel)this.m_20193_());
                FactionEvents.addNPCToData((ServerLevel)this.m_20193_(), ownerTeam.m_5758_(), 1);
                this.needsTeamUpdate = false;
            } else if (recruitTeam == ownerTeam) {
                this.updateColor(ownerTeam.m_5758_());
                this.needsTeamUpdate = false;
            } else {
                FactionEvents.removeRecruitFromTeam(this, recruitTeam, (ServerLevel)this.m_20193_());
                FactionEvents.addNPCToData((ServerLevel)this.m_20193_(), recruitTeam.m_5758_(), -1);
                FactionEvents.addRecruitToTeam(this, ownerTeam, (ServerLevel)this.m_20193_());
                FactionEvents.addNPCToData((ServerLevel)this.m_20193_(), ownerTeam.m_5758_(), 1);
                this.needsTeamUpdate = false;
            }
        }
    }

    private void updateColor(String name) {
        RecruitsFaction recruitsFaction;
        if (!this.m_20193_().m_5776_() && (recruitsFaction = FactionEvents.recruitsFactionManager.getTeamByStringID(name)) != null && recruitsFaction.getUnitColor() != this.getColor()) {
            this.setColor(recruitsFaction.getUnitColor());
            this.needsColorUpdate = false;
        }
    }

    public void updateGroup() {
        RecruitsGroup group;
        if (this.m_20193_().m_5776_()) {
            return;
        }
        this.needsGroupUpdate = false;
        if (this.getGroup() == null) {
            return;
        }
        UUID raw = this.getGroup();
        UUID resolved = RecruitEvents.recruitsGroupsManager.resolveGroup(raw);
        UUID finalGroup = RecruitEvents.recruitsGroupsManager.resolveRecruit(this.m_20148_(), resolved);
        if (!finalGroup.equals(raw)) {
            this.setGroupUUID(finalGroup);
        }
        if ((group = RecruitEvents.recruitsGroupsManager.getGroup(finalGroup)) == null) {
            this.setGroupUUID(null);
            return;
        }
        if (!group.members.contains(this.m_20148_())) {
            this.setGroupUUID(null);
            return;
        }
        if (group.disbandContext != null && group.disbandContext.disband) {
            this.disband(null, group.disbandContext.keepTeam, group.disbandContext.increaseCost);
            this.needsTeamUpdate = true;
            return;
        }
        if (!this.getOwnerUUID().equals(group.getPlayerUUID())) {
            this.assignToPlayer(group.getPlayerUUID(), group.getUUID());
        }
        this.needsTeamUpdate = true;
    }

    public void openHireGUI(Player player) {
        if (player instanceof ServerPlayer) {
            this.f_21344_.m_26573_();
            Team ownerTeam = player.m_5647_();
            String stringId = ownerTeam != null ? ownerTeam.m_5758_() : "";
            boolean canHire = RecruitEvents.recruitsPlayerUnitManager.canPlayerRecruit(stringId, player.m_20148_());
            Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageToClientUpdateHireScreen(FactionEvents.getCurrency(), canHire));
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return AbstractRecruitEntity.this.m_7755_();
                }

                public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
                    return new RecruitHireMenu(i, playerInventory.f_35978_, AbstractRecruitEntity.this, playerInventory);
                }
            }, packetBuffer -> packetBuffer.m_130077_(this.m_20148_()));
        } else {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageHireGui(player, this.m_20148_()));
        }
    }

    public void assignToPlayer(UUID newOwner, UUID newGroupUUID) {
        RecruitsGroup currentGroup = RecruitEvents.recruitsGroupsManager.getGroup(this.getGroup());
        if (currentGroup != null) {
            currentGroup.removeMember(this.m_20148_());
        }
        this.setGroupUUID(newGroupUUID);
        RecruitsGroup newGroup = RecruitEvents.recruitsGroupsManager.getGroup(newGroupUUID);
        if (newGroup == null) {
            return;
        }
        this.disband(null, false, false);
        this.setOwnerUUID(Optional.of(newOwner));
        if (this.getOwner() != null) {
            this.hire(this.getOwner(), newGroup);
            this.setFollowState(1);
        }
    }

    public void shouldMount(boolean should, UUID mount_uuid) {
        if (!this.m_20159_()) {
            this.setShouldMount(should);
            if (mount_uuid != null) {
                this.setMountUUID(Optional.of(mount_uuid));
            } else {
                this.setMountUUID(Optional.empty());
            }
        }
        if (should) {
            this.dismount = 0;
        }
    }

    public void shouldProtect(boolean should, UUID protect_uuid) {
        this.setShouldProtect(should);
        if (protect_uuid != null) {
            this.setProtectUUID(Optional.of(protect_uuid));
        } else {
            this.setProtectUUID(Optional.empty());
        }
    }

    public void clearUpkeepPos() {
        this.f_19804_.m_135381_(UPKEEP_POS, Optional.empty());
    }

    public void clearUpkeepEntity() {
        this.f_19804_.m_135381_(UPKEEP_ID, Optional.empty());
    }

    public boolean hasUpkeep() {
        return this.getUpkeepPos() != null || this.getUpkeepUUID() != null;
    }

    /*
     * Unable to fully structure code
     */
    public void upkeepReequip(@NotNull Container container) {
        for (i = 0; i < container.m_6643_(); ++i) {
            block8: {
                itemstack = container.m_8020_(i);
                if (this.canEatItemStack(itemstack) || !this.m_7243_(itemstack)) break block8;
                if (this.canEquipItem(itemstack)) {
                    equipment = itemstack.m_41777_();
                    equipment.m_41764_(1);
                    this.equipItem(equipment);
                    itemstack.m_41774_(1);
                }
                if (!((var6_6 = this) instanceof CrossBowmanEntity)) ** GOTO lbl-1000
                crossBowmanEntity = (CrossBowmanEntity)var6_6;
                if (Main.isMusketModLoaded && IWeapon.isMusketModWeapon(crossBowmanEntity.m_21205_()) && itemstack.m_41778_().contains("cartridge")) {
                    if (this.canTakeCartridge()) {
                        equipment = itemstack.m_41777_();
                        this.inventory.m_19173_(equipment);
                        itemstack.m_41774_(equipment.m_41613_());
                    }
                } else if (this instanceof IRangedRecruit && itemstack.m_204117_(ItemTags.f_13161_) && this.canTakeArrows()) {
                    equipment = itemstack.m_41777_();
                    this.inventory.m_19173_(equipment);
                    itemstack.m_41774_(equipment.m_41613_());
                }
            }
            if (!(this instanceof CaptainEntity) || !Main.isSmallShipsLoaded) continue;
            if (itemstack.m_41778_().contains("cannon_ball")) {
                if (!this.canTakeCannonBalls()) continue;
                equipment = itemstack.m_41777_();
                this.inventory.m_19173_(equipment);
                itemstack.m_41774_(equipment.m_41613_());
                continue;
            }
            if (itemstack.m_204117_(ItemTags.f_13168_)) {
                if (!this.canTakePlanks()) continue;
                equipment = itemstack.m_41777_();
                this.inventory.m_19173_(equipment);
                itemstack.m_41774_(equipment.m_41613_());
                continue;
            }
            if (!itemstack.m_150930_(Items.f_42749_) || !this.canTakeIronNuggets()) continue;
            equipment = itemstack.m_41777_();
            this.inventory.m_19173_(equipment);
            itemstack.m_41774_(equipment.m_41613_());
        }
    }

    public int getUpkeepCooldown() {
        return 3000;
    }

    public ArmPose getArmPose() {
        return ArmPose.NEUTRAL;
    }

    private MutableComponent TEXT_RECRUITED1(String name) {
        return Component.m_237110_((String)"chat.recruits.text.recruited1", (Object[])new Object[]{name});
    }

    private MutableComponent TEXT_RECRUITED2(String name) {
        return Component.m_237110_((String)"chat.recruits.text.recruited2", (Object[])new Object[]{name});
    }

    private MutableComponent TEXT_RECRUITED3(String name) {
        return Component.m_237110_((String)"chat.recruits.text.recruited3", (Object[])new Object[]{name});
    }

    private Component INFO_RECRUITING_MAX(String name) {
        return Component.m_237110_((String)"chat.recruits.info.reached_max", (Object[])new Object[]{name});
    }

    private MutableComponent TEXT_DISBAND(String name) {
        return Component.m_237110_((String)"chat.recruits.text.disband", (Object[])new Object[]{name});
    }

    private MutableComponent TEXT_WANDER(String name) {
        return Component.m_237110_((String)"chat.recruits.text.wander", (Object[])new Object[]{name});
    }

    private MutableComponent TEXT_HOLD_YOUR_POS(String name) {
        return Component.m_237110_((String)"chat.recruits.text.holdPos", (Object[])new Object[]{name});
    }

    private MutableComponent TEXT_FOLLOW(String name) {
        return Component.m_237110_((String)"chat.recruits.text.follow", (Object[])new Object[]{name});
    }

    private MutableComponent TEXT_HELLO_1(String name) {
        return Component.m_237110_((String)"chat.recruits.text.hello_1", (Object[])new Object[]{name});
    }

    private MutableComponent TEXT_HELLO_2(String name) {
        return Component.m_237110_((String)"chat.recruits.text.hello_2", (Object[])new Object[]{name});
    }

    private MutableComponent TEXT_HELLO_3(String name) {
        return Component.m_237110_((String)"chat.recruits.text.hello_3", (Object[])new Object[]{name});
    }

    private MutableComponent TEXT_NO_PAYMENT(String name) {
        return Component.m_237110_((String)"chat.recruits.text.noPaymentInUpkeep", (Object[])new Object[]{name});
    }

    private void pickUpArrows() {
        this.m_20193_().m_6443_(AbstractArrow.class, this.m_20191_().m_82400_(7.0), arrow -> arrow.f_36703_ && arrow.f_36705_ == AbstractArrow.Pickup.ALLOWED && this.getInventory().m_19183_(Items.f_42412_.m_7968_())).forEach(arrow -> {
            this.getInventory().m_19173_(Items.f_42412_.m_7968_());
            arrow.m_20219_(this.m_20182_());
            arrow.m_146870_();
        });
    }

    public boolean m_20329_(Entity entity) {
        this.setMountUUID(Optional.of(entity.m_20148_()));
        return super.m_20329_(entity);
    }

    public boolean m_6785_(double p_21542_) {
        return false;
    }

    public boolean canEatItemStack(ItemStack stack) {
        ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (((List)RecruitsServerConfig.FoodBlackList.get()).contains(location.toString())) {
            return false;
        }
        return stack.m_41614_();
    }

    public void checkPayment(Container container) {
        if (((Boolean)RecruitsServerConfig.RecruitsPayment.get()).booleanValue() && this.isOwned()) {
            if (this.isPaymentInContainer(container)) {
                this.doPayment(container);
            } else if (this.isPaymentInContainer((Container)this.getInventory())) {
                this.doPayment((Container)this.getInventory());
            } else {
                this.doNoPaymentAction();
                if (this.getOwner() != null) {
                    this.getOwner().m_213846_((Component)this.TEXT_NO_PAYMENT(this.m_7755_().getString()));
                }
            }
            this.resetPaymentTimer();
        }
    }

    public void doNoPaymentAction() {
        NoPaymentAction action = (NoPaymentAction)((Object)RecruitsServerConfig.RecruitsNoPaymentAction.get());
        switch (action) {
            case MORALE_LOSS: {
                float current = this.getMorale();
                float newMorale = (float)Math.max(0.0, (double)current * 0.7);
                this.setMoral(newMorale);
                break;
            }
            case DISBAND_KEEP_TEAM: {
                this.disband(this.getOwner(), true, true);
                break;
            }
            case DISBAND: {
                this.disband(this.getOwner(), false, true);
                break;
            }
            case DESPAWN: {
                this.m_146870_();
            }
        }
    }

    public void resetPaymentTimer() {
        int interval = (Integer)RecruitsServerConfig.RecruitsPaymentInterval.get();
        this.paymentTimer = 1200 * interval;
    }

    public static enum ArmPose {
        ATTACKING,
        BLOCKING,
        BOW_AND_ARROW,
        CROSSBOW_HOLD,
        CROSSBOW_CHARGE,
        CELEBRATING,
        NEUTRAL;

    }

    public static enum NoPaymentAction {
        MORALE_LOSS,
        DISBAND,
        DISBAND_KEEP_TEAM,
        DESPAWN;


        public static NoPaymentAction fromString(String name) {
            try {
                return NoPaymentAction.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return MORALE_LOSS;
            }
        }
    }
}

