/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.talhanation.recruits.client.render.layer.RecruitHumanBiomeLayer;
import com.talhanation.recruits.client.render.layer.RecruitHumanCompanionLayer;
import com.talhanation.recruits.client.render.layer.RecruitHumanTeamColorLayer;
import com.talhanation.recruits.compat.IWeapon;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.CrossBowmanEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class RecruitHumanRenderer
extends MobRenderer<AbstractRecruitEntity, HumanoidModel<AbstractRecruitEntity>> {
    private static final ResourceLocation[] TEXTURE = new ResourceLocation[]{new ResourceLocation("recruits", "textures/entity/human/human_0.png"), new ResourceLocation("recruits", "textures/entity/human/human_1.png"), new ResourceLocation("recruits", "textures/entity/human/human_2.png"), new ResourceLocation("recruits", "textures/entity/human/human_3.png"), new ResourceLocation("recruits", "textures/entity/human/human_4.png"), new ResourceLocation("recruits", "textures/entity/human/human_5.png"), new ResourceLocation("recruits", "textures/entity/human/human_6.png"), new ResourceLocation("recruits", "textures/entity/human/human_7.png"), new ResourceLocation("recruits", "textures/entity/human/human_8.png"), new ResourceLocation("recruits", "textures/entity/human/human_9.png"), new ResourceLocation("recruits", "textures/entity/human/human_10.png"), new ResourceLocation("recruits", "textures/entity/human/human_11.png"), new ResourceLocation("recruits", "textures/entity/human/human_12.png"), new ResourceLocation("recruits", "textures/entity/human/human_13.png"), new ResourceLocation("recruits", "textures/entity/human/human_14.png"), new ResourceLocation("recruits", "textures/entity/human/human_15.png"), new ResourceLocation("recruits", "textures/entity/human/human_16.png"), new ResourceLocation("recruits", "textures/entity/human/human_17.png"), new ResourceLocation("recruits", "textures/entity/human/human_18.png"), new ResourceLocation("recruits", "textures/entity/human/human_19.png")};

    public ResourceLocation getTextureLocation(AbstractRecruitEntity recruit) {
        return TEXTURE[recruit.getVariant()];
    }

    public RecruitHumanRenderer(EntityRendererProvider.Context mgr) {
        super(mgr, (EntityModel)new HumanoidModel(mgr.m_174023_(ModelLayers.f_171162_)), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(mgr.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(mgr.m_174023_(ModelLayers.f_171165_)), mgr.m_266367_()));
        this.m_115326_(new RecruitHumanTeamColorLayer((LivingEntityRenderer<AbstractRecruitEntity, HumanoidModel<AbstractRecruitEntity>>)this));
        this.m_115326_(new RecruitHumanBiomeLayer((LivingEntityRenderer<AbstractRecruitEntity, HumanoidModel<AbstractRecruitEntity>>)this));
        this.m_115326_(new RecruitHumanCompanionLayer((LivingEntityRenderer<AbstractRecruitEntity, HumanoidModel<AbstractRecruitEntity>>)this));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, mgr.m_234598_()));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, mgr.m_174027_(), mgr.m_234598_()));
    }

    public void render(AbstractRecruitEntity recruit, float p_117789_, float p_117790_, PoseStack p_117791_, MultiBufferSource p_117792_, int p_117793_) {
        this.setModelProperties(recruit);
        super.m_7392_((Mob)recruit, p_117789_, p_117790_, p_117791_, p_117792_, p_117793_);
    }

    private void setModelProperties(AbstractRecruitEntity recruit) {
        HumanoidModel model = (HumanoidModel)this.m_7200_();
        model.m_8009_(true);
        model.f_102817_ = recruit.m_6047_();
        HumanoidModel.ArmPose humanoidmodel$armpose = RecruitHumanRenderer.getArmPose(recruit, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose humanoidmodel$armpose1 = RecruitHumanRenderer.getArmPose(recruit, InteractionHand.OFF_HAND);
        if (humanoidmodel$armpose.m_102897_()) {
            HumanoidModel.ArmPose armPose = humanoidmodel$armpose1 = recruit.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
        }
        if (recruit.m_5737_() == HumanoidArm.RIGHT) {
            model.f_102816_ = humanoidmodel$armpose;
            model.f_102815_ = humanoidmodel$armpose1;
        } else {
            model.f_102816_ = humanoidmodel$armpose1;
            model.f_102815_ = humanoidmodel$armpose;
        }
    }

    private static HumanoidModel.ArmPose getArmPose(AbstractRecruitEntity recruit, InteractionHand hand) {
        HumanoidModel.ArmPose forgeArmPose;
        CrossBowmanEntity crossBowman;
        boolean isMusket;
        ItemStack itemstack = recruit.m_21120_(hand);
        boolean bl = isMusket = IWeapon.isMusketModWeapon(itemstack) && recruit instanceof CrossBowmanEntity && (crossBowman = (CrossBowmanEntity)recruit).m_5912_();
        if (itemstack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (recruit.m_7655_() == hand && recruit.m_21212_() > 0) {
            UseAnim useanim = itemstack.m_41780_();
            if (useanim == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useanim == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useanim == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useanim == UseAnim.CROSSBOW && hand == recruit.m_7655_() || isMusket) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useanim == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
        } else if (!recruit.f_20911_ && itemstack.m_150930_(Items.f_42717_) && CrossbowItem.m_40932_((ItemStack)itemstack) || isMusket) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        if ((forgeArmPose = IClientItemExtensions.of((ItemStack)itemstack).getArmPose((LivingEntity)recruit, hand, itemstack)) != null) {
            return forgeArmPose;
        }
        return HumanoidModel.ArmPose.ITEM;
    }
}

