/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.worldmap;

import com.mojang.blaze3d.vertex.PoseStack;
import com.talhanation.recruits.client.ClientManager;
import com.talhanation.recruits.client.gui.faction.TeamEditScreen;
import com.talhanation.recruits.world.RecruitsClaim;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.level.ChunkPos;

public class ClaimRenderer {
    public static void renderClaimsOverlay(GuiGraphics guiGraphics, RecruitsClaim selectedClaim, double offsetX, double offsetZ, double scale) {
        if (ClientManager.recruitsClaims.isEmpty()) {
            return;
        }
        for (RecruitsClaim claim : ClientManager.recruitsClaims) {
            ClaimRenderer.renderClaimFill(guiGraphics, claim, offsetX, offsetZ, scale);
        }
        for (RecruitsClaim claim : ClientManager.recruitsClaims) {
            ClaimRenderer.renderClaimPassiveOutline(guiGraphics, claim, offsetX, offsetZ, scale);
        }
        for (RecruitsClaim claim : ClientManager.recruitsClaims) {
            ClaimRenderer.renderClaimName(guiGraphics, claim, offsetX, offsetZ, scale);
        }
        if (selectedClaim != null) {
            ClaimRenderer.renderClaimSelectedOutline(guiGraphics, selectedClaim, offsetX, offsetZ, scale);
        }
    }

    private static void renderClaimFill(GuiGraphics guiGraphics, RecruitsClaim claim, double offsetX, double offsetZ, double scale) {
        if (claim.getClaimedChunks().isEmpty()) {
            return;
        }
        int color = ClaimRenderer.getClaimColor(claim);
        int fillColor = 0xBE000000 | color & 0xFFFFFF;
        for (ChunkPos chunk : claim.getClaimedChunks()) {
            ClaimRenderer.renderChunk(guiGraphics, chunk, fillColor, offsetX, offsetZ, scale);
        }
    }

    private static void renderChunk(GuiGraphics guiGraphics, ChunkPos chunk, int color, double offsetX, double offsetZ, double scale) {
        double worldX = (double)chunk.f_45578_ * 16.0;
        double worldZ = (double)chunk.f_45579_ * 16.0;
        int x1 = (int)Math.floor(offsetX + worldX * scale);
        int z1 = (int)Math.floor(offsetZ + worldZ * scale);
        int x2 = (int)Math.floor(offsetX + (worldX + 16.0) * scale);
        int z2 = (int)Math.floor(offsetZ + (worldZ + 16.0) * scale);
        if (x2 <= x1) {
            x2 = x1 + 1;
        }
        if (z2 <= z1) {
            z2 = z1 + 1;
        }
        guiGraphics.m_280509_(x1, z1, x2, z2, color);
    }

    private static void renderClaimPassiveOutline(GuiGraphics guiGraphics, RecruitsClaim claim, double offsetX, double offsetZ, double scale) {
        if (claim.getClaimedChunks().isEmpty()) {
            return;
        }
        HashSet<ChunkPos> chunkSet = new HashSet<ChunkPos>(claim.getClaimedChunks());
        int baseColor = ClaimRenderer.getClaimColor(claim);
        int outlineColor = 0xC8000000 | baseColor & 0xFFFFFF;
        int thickness = Math.max(1, (int)Math.round(scale * 0.5));
        for (ChunkPos chunk : claim.getClaimedChunks()) {
            boolean hasTop = chunkSet.contains(new ChunkPos(chunk.f_45578_, chunk.f_45579_ - 1));
            boolean hasBottom = chunkSet.contains(new ChunkPos(chunk.f_45578_, chunk.f_45579_ + 1));
            boolean hasLeft = chunkSet.contains(new ChunkPos(chunk.f_45578_ - 1, chunk.f_45579_));
            boolean hasRight = chunkSet.contains(new ChunkPos(chunk.f_45578_ + 1, chunk.f_45579_));
            double worldX1 = (double)chunk.f_45578_ * 16.0;
            double worldZ1 = (double)chunk.f_45579_ * 16.0;
            int x1 = (int)Math.floor(offsetX + worldX1 * scale);
            int z1 = (int)Math.floor(offsetZ + worldZ1 * scale);
            int x2 = (int)Math.floor(offsetX + (worldX1 + 16.0) * scale);
            int z2 = (int)Math.floor(offsetZ + (worldZ1 + 16.0) * scale);
            if (x2 <= x1) {
                x2 = x1 + 1;
            }
            if (z2 <= z1) {
                z2 = z1 + 1;
            }
            if (!hasTop) {
                guiGraphics.m_280509_(x1, z1, x2, z1 + thickness, outlineColor);
            }
            if (!hasBottom) {
                guiGraphics.m_280509_(x1, z2 - thickness, x2, z2, outlineColor);
            }
            if (!hasLeft) {
                guiGraphics.m_280509_(x1, z1, x1 + thickness, z2, outlineColor);
            }
            if (hasRight) continue;
            guiGraphics.m_280509_(x2 - thickness, z1, x2, z2, outlineColor);
        }
    }

    private static void renderClaimSelectedOutline(GuiGraphics guiGraphics, RecruitsClaim claim, double offsetX, double offsetZ, double scale) {
        if (claim.getClaimedChunks().isEmpty()) {
            return;
        }
        HashSet<CallSite> chunkSet = new HashSet<CallSite>();
        for (ChunkPos chunk : claim.getClaimedChunks()) {
            chunkSet.add((CallSite)((Object)(chunk.f_45578_ + "," + chunk.f_45579_)));
        }
        int borderColor = -1;
        int borderThickness = Math.max(1, (int)(2.0 * scale / 2.0));
        for (ChunkPos chunk : claim.getClaimedChunks()) {
            boolean hasTop = chunkSet.contains(chunk.f_45578_ + "," + (chunk.f_45579_ - 1));
            boolean hasBottom = chunkSet.contains(chunk.f_45578_ + "," + (chunk.f_45579_ + 1));
            boolean hasLeft = chunkSet.contains(chunk.f_45578_ - 1 + "," + chunk.f_45579_);
            boolean hasRight = chunkSet.contains(chunk.f_45578_ + 1 + "," + chunk.f_45579_);
            if (hasTop && hasBottom && hasLeft && hasRight) continue;
            double worldX1 = (double)chunk.f_45578_ * 16.0;
            double worldZ1 = (double)chunk.f_45579_ * 16.0;
            double worldX2 = worldX1 + 16.0;
            double worldZ2 = worldZ1 + 16.0;
            int x1 = (int)Math.floor(offsetX + worldX1 * scale);
            int z1 = (int)Math.floor(offsetZ + worldZ1 * scale);
            int x2 = (int)Math.floor(offsetX + worldX2 * scale);
            int z2 = (int)Math.floor(offsetZ + worldZ2 * scale);
            if (!hasTop) {
                guiGraphics.m_280509_(x1, z1, x2, z1 + borderThickness, borderColor);
            }
            if (!hasBottom) {
                guiGraphics.m_280509_(x1, z2 - borderThickness, x2, z2, borderColor);
            }
            if (!hasLeft) {
                guiGraphics.m_280509_(x1, z1, x1 + borderThickness, z2, borderColor);
            }
            if (hasRight) continue;
            guiGraphics.m_280509_(x2 - borderThickness, z1, x2, z2, borderColor);
        }
    }

    public static void renderClaimName(GuiGraphics guiGraphics, RecruitsClaim claim, double offsetX, double offsetZ, double scale) {
        if (claim.getClaimedChunks().isEmpty() || scale < 1.0) {
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        String name = claim.getName();
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (ChunkPos pos : claim.getClaimedChunks()) {
            minX = Math.min(minX, pos.f_45578_);
            maxX = Math.max(maxX, pos.f_45578_);
            minZ = Math.min(minZ, pos.f_45579_);
            maxZ = Math.max(maxZ, pos.f_45579_);
        }
        double centerWorldX = (double)(minX + maxX + 1) * 16.0 / 2.0;
        double centerWorldZ = (double)(minZ + maxZ + 1) * 16.0 / 2.0;
        double pixelX = offsetX + centerWorldX * scale;
        double pixelZ = offsetZ + centerWorldZ * scale;
        float textScale = (float)Math.min(1.0, scale / 1.25);
        int textWidth = font.m_92895_(name);
        Objects.requireNonNull(font);
        int textHeight = 9;
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_85837_(pixelX - (double)((float)textWidth * textScale) / 2.0, pixelZ - (double)((float)textHeight * textScale) / 2.0, 0.0);
        pose.m_85841_(textScale, textScale, 1.0f);
        guiGraphics.m_280056_(font, name, 0, 0, 0xFFFFFF, false);
        pose.m_85849_();
    }

    public static int getClaimColor(RecruitsClaim claim) {
        if (claim.getOwnerFaction() == null) {
            return -7829368;
        }
        byte colorKey = claim.getOwnerFaction().getUnitColor();
        return TeamEditScreen.unitColors.get(colorKey).getRGB();
    }

    public static RecruitsClaim getClaimAtPosition(double mouseX, double mouseY, double offsetX, double offsetZ, double scale) {
        double worldX = (mouseX - offsetX) / scale;
        double worldZ = (mouseY - offsetZ) / scale;
        int chunkX = (int)Math.floor(worldX / 16.0);
        int chunkZ = (int)Math.floor(worldZ / 16.0);
        ChunkPos mouseChunk = new ChunkPos(chunkX, chunkZ);
        for (RecruitsClaim claim : ClientManager.recruitsClaims) {
            if (!claim.containsChunk(mouseChunk)) continue;
            return claim;
        }
        return null;
    }

    public static void renderBufferZone(GuiGraphics guiGraphics, double offsetX, double offsetZ, double scale) {
        if (ClientManager.ownFaction == null) {
            return;
        }
        HashSet<CallSite> renderedBufferChunks = new HashSet<CallSite>();
        int bufferColor = 0x44FF4444;
        HashSet<CallSite> ownClaimedChunks = new HashSet<CallSite>();
        for (RecruitsClaim claim : ClientManager.recruitsClaims) {
            if (claim.getOwnerFaction() == null || !claim.getOwnerFaction().getStringID().equals(ClientManager.ownFaction.getStringID())) continue;
            for (ChunkPos chunk : claim.getClaimedChunks()) {
                ownClaimedChunks.add((CallSite)((Object)(chunk.f_45578_ + "," + chunk.f_45579_)));
            }
        }
        for (RecruitsClaim foreignClaim : ClientManager.recruitsClaims) {
            if (foreignClaim.getOwnerFaction() == null || foreignClaim.getOwnerFaction().getStringID().equals(ClientManager.ownFaction.getStringID())) continue;
            for (ChunkPos claimChunk : foreignClaim.getClaimedChunks()) {
                for (int dx = -3; dx <= 3; ++dx) {
                    for (int dz = -3; dz <= 3; ++dz) {
                        int bufferZ;
                        int bufferX;
                        String chunkKey;
                        if (dx == 0 && dz == 0 || renderedBufferChunks.contains(chunkKey = (bufferX = claimChunk.f_45578_ + dx) + "," + (bufferZ = claimChunk.f_45579_ + dz)) || ownClaimedChunks.contains(chunkKey)) continue;
                        renderedBufferChunks.add((CallSite)((Object)chunkKey));
                        ChunkPos bufferChunk = new ChunkPos(bufferX, bufferZ);
                        ClaimRenderer.renderChunk(guiGraphics, bufferChunk, bufferColor, offsetX, offsetZ, scale);
                    }
                }
            }
        }
    }

    public static void renderAreaPreview(GuiGraphics guiGraphics, List<ChunkPos> areaChunks, double offsetX, double offsetZ, double scale) {
        if (areaChunks == null || areaChunks.isEmpty()) {
            return;
        }
        int previewColor = 0x33FFFFFF;
        for (ChunkPos chunk : areaChunks) {
            ClaimRenderer.renderChunk(guiGraphics, chunk, previewColor, offsetX, offsetZ, scale);
        }
    }
}

