/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.worldmap;

import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.client.gui.RecruitsScreenBase;
import com.talhanation.recruits.client.gui.faction.TeamEditScreen;
import com.talhanation.recruits.client.gui.player.PlayersList;
import com.talhanation.recruits.client.gui.player.SelectPlayerScreen;
import com.talhanation.recruits.client.gui.widgets.RecruitsCheckBox;
import com.talhanation.recruits.client.gui.widgets.SelectedPlayerWidget;
import com.talhanation.recruits.client.gui.worldmap.WorldMapScreen;
import com.talhanation.recruits.network.MessageUpdateClaim;
import com.talhanation.recruits.world.RecruitsClaim;
import com.talhanation.recruits.world.RecruitsPlayerInfo;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class ClaimEditScreen
extends RecruitsScreenBase {
    private static final Component TITLE = Component.m_237115_((String)"gui.recruits.claim_edit.title");
    private static final Component BUTTON_SAVE = Component.m_237115_((String)"gui.recruits.button.save");
    protected static final Component BUTTON_BACK = Component.m_237115_((String)"gui.recruits.button.back");
    protected static final Component CHECKBOX_ALLOW_BREAKING = Component.m_237115_((String)"gui.recruits.checkbox.allowBlockBreaking");
    protected static final Component CHECKBOX_ALLOW_PLACING = Component.m_237115_((String)"gui.recruits.checkbox.allowBlockPlacing");
    protected static final Component CHECKBOX_ALLOW_INTERACTING = Component.m_237115_((String)"gui.recruits.checkbox.allowBlockInteracting");
    private final RecruitsClaim claim;
    private final Player player;
    private EditBox editNameBox;
    private boolean allowBlockBreaking;
    private boolean allowBlockPlacing;
    private boolean allowBlockInteracting;
    private RecruitsCheckBox blockBreakingCheckBox;
    private RecruitsCheckBox blockPlacingCheckBox;
    private RecruitsCheckBox blockInteractionCheckBox;
    private SelectedPlayerWidget selectedPlayerWidget;
    private RecruitsPlayerInfo playerInfo;
    private Button saveButton;
    private Button backButton;
    private Button deleteButton;
    private String claimName;
    private String savedName;
    private WorldMapScreen parent;
    public int x;
    public int y;
    int panelWidth = 150;
    int panelHeight = 200;
    int panelX = -75;
    int panelY = -115;
    int claimMiniX = -70;
    int claimMiniY = -60;

    public ClaimEditScreen(WorldMapScreen screen, RecruitsClaim claim, Player player) {
        super(TITLE, 1, 1);
        this.parent = screen;
        this.claim = claim;
        this.player = player;
        this.playerInfo = claim.getPlayerInfo();
    }

    @Override
    protected void m_7856_() {
        this.allowBlockBreaking = this.claim.isBlockBreakingAllowed();
        this.allowBlockPlacing = this.claim.isBlockPlacementAllowed();
        this.allowBlockInteracting = this.claim.isBlockInteractionAllowed();
        if (this.savedName == null) {
            this.savedName = this.claim.getName();
        }
        this.x = this.f_96543_ / 2;
        this.y = this.f_96544_ / 2;
        this.setWidgets();
    }

    private void setWidgets() {
        this.m_169413_();
        this.editNameBox = new EditBox(this.f_96547_, this.x - 70, this.y - 110, 140, 20, (Component)Component.m_237113_((String)""));
        this.editNameBox.m_94202_(-1);
        this.editNameBox.m_94205_(-1);
        this.editNameBox.m_94182_(true);
        this.editNameBox.m_94199_(32);
        this.editNameBox.m_94144_(this.savedName);
        this.editNameBox.m_94151_(this::onTextInput);
        this.m_142416_((GuiEventListener)this.editNameBox);
        if (this.playerInfo != null) {
            this.selectedPlayerWidget = new SelectedPlayerWidget(this.f_96547_, this.x - 70, this.y - 87, 140, 20, (Component)Component.m_237113_((String)"x"), () -> {
                this.playerInfo = null;
                this.selectedPlayerWidget.setPlayer(null, null);
                this.setWidgets();
            });
            this.selectedPlayerWidget.setPlayer(this.claim.playerInfo.getUUID(), this.claim.playerInfo.getName());
            this.m_142416_((GuiEventListener)this.selectedPlayerWidget);
        } else {
            Button selectPlayerButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.x - 70, this.y - 87, 140, 20, SelectPlayerScreen.TITLE, button -> this.f_96541_.m_91152_((Screen)new SelectPlayerScreen(this, this.player, SelectPlayerScreen.TITLE, SelectPlayerScreen.BUTTON_SELECT, SelectPlayerScreen.BUTTON_SELECT_TOOLTIP, true, PlayersList.FilterType.ANY_TEAM, playerInfo -> {
                this.playerInfo = playerInfo;
                this.claim.setPlayer((RecruitsPlayerInfo)playerInfo);
                this.f_96541_.m_91152_((Screen)this);
            }))));
            this.m_142416_((GuiEventListener)selectPlayerButton);
        }
        int checkBoxWidth = 140;
        int checkBoxHeight = 20;
        this.blockPlacingCheckBox = new RecruitsCheckBox(this.x - 70, this.y + 20, checkBoxWidth, checkBoxHeight, CHECKBOX_ALLOW_PLACING, this.allowBlockPlacing, bool -> {
            this.allowBlockPlacing = bool;
        });
        this.m_142416_((GuiEventListener)this.blockPlacingCheckBox);
        this.blockBreakingCheckBox = new RecruitsCheckBox(this.x - 70, this.y + 40, checkBoxWidth, checkBoxHeight, CHECKBOX_ALLOW_BREAKING, this.allowBlockBreaking, bool -> {
            this.allowBlockBreaking = bool;
        });
        this.m_142416_((GuiEventListener)this.blockBreakingCheckBox);
        this.blockInteractionCheckBox = new RecruitsCheckBox(this.x - 70, this.y + 60, checkBoxWidth, checkBoxHeight, CHECKBOX_ALLOW_INTERACTING, this.allowBlockInteracting, bool -> {
            this.allowBlockInteracting = bool;
        });
        this.m_142416_((GuiEventListener)this.blockInteractionCheckBox);
        this.backButton = new ExtendedButton(this.x + 5, this.y + 90, 70, 20, BUTTON_BACK, button -> this.f_96541_.m_91152_((Screen)this.parent));
        this.m_142416_((GuiEventListener)this.backButton);
        this.saveButton = new ExtendedButton(this.x - 75, this.y + 90, 70, 20, BUTTON_SAVE, button -> {
            this.claim.setName(this.editNameBox.m_94155_());
            this.claim.setPlayer(this.playerInfo);
            this.claim.setOwnerFaction(this.playerInfo.getRecruitsTeam());
            this.claim.attackingParties.clear();
            this.claim.setBlockInteractionAllowed(this.allowBlockInteracting);
            this.claim.setBlockPlacementAllowed(this.allowBlockPlacing);
            this.claim.setBlockBreakingAllowed(this.allowBlockBreaking);
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageUpdateClaim(this.claim));
            this.f_96541_.m_91152_((Screen)this.parent);
        });
        this.m_142416_((GuiEventListener)this.saveButton);
        this.checkSaveActive();
    }

    public void checkSaveActive() {
        this.saveButton.f_93623_ = this.playerInfo != null;
    }

    private void onTextInput(String string) {
        this.savedName = string;
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.renderBackground(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.m_280509_(this.panelX - 1 + this.x, this.panelY - 1 + this.y, this.panelX + this.x + this.panelWidth + 1, this.panelY + this.y + this.panelHeight + 1, -11184811);
        guiGraphics.m_280509_(this.panelX + this.x, this.panelY + this.y, this.panelX + this.x + this.panelWidth, this.panelY + this.y + this.panelHeight, -14540254);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.renderForeground(guiGraphics, mouseX, mouseY, delta);
        this.renderClaimMiniMapAreaFramed(guiGraphics, this.claimMiniX + this.x, this.claimMiniY + this.y, 140, 70, this.claim);
    }

    private void renderClaimMiniMapAreaFramed(GuiGraphics guiGraphics, int x, int y, int width, int height, RecruitsClaim claim) {
        List<ChunkPos> chunks = claim.getClaimedChunks();
        if (chunks.isEmpty()) {
            return;
        }
        if (claim.getOwnerFaction() == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        int minX = chunks.stream().mapToInt(c -> c.f_45578_).min().orElse(0);
        int maxX = chunks.stream().mapToInt(c -> c.f_45578_).max().orElse(0);
        int minZ = chunks.stream().mapToInt(c -> c.f_45579_).min().orElse(0);
        int maxZ = chunks.stream().mapToInt(c -> c.f_45579_).max().orElse(0);
        int chunkWidth = maxX - minX + 1;
        int chunkHeight = maxZ - minZ + 1;
        float scaleX = (float)width / (float)chunkWidth;
        float scaleZ = (float)height / (float)chunkHeight;
        float cellSize = Math.min(scaleX, scaleZ);
        float usedWidth = (float)chunkWidth * cellSize;
        float usedHeight = (float)chunkHeight * cellSize;
        float offsetX = (float)x + ((float)width - usedWidth) / 2.0f;
        float offsetY = (float)y + ((float)height - usedHeight) / 2.0f;
        int scale = (int)mc.m_91268_().m_85449_();
        int screenHeight = mc.m_91268_().m_85442_();
        RenderSystem.enableScissor((int)(x * scale), (int)(screenHeight - (y + height) * scale), (int)(width * scale), (int)(height * scale));
        int alpha = 190;
        int rgb = TeamEditScreen.unitColors.get(claim.getOwnerFaction().getUnitColor()).getRGB();
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int argb = alpha << 24 | r << 16 | g << 8 | b;
        for (ChunkPos pos : chunks) {
            float px = offsetX + (float)(pos.f_45578_ - minX) * cellSize;
            float py = offsetY + (float)(pos.f_45579_ - minZ) * cellSize;
            guiGraphics.m_280509_((int)px, (int)py, (int)(px + cellSize), (int)(py + cellSize), argb);
            ChunkPos[] dirs = new ChunkPos[]{new ChunkPos(pos.f_45578_, pos.f_45579_ - 1), new ChunkPos(pos.f_45578_, pos.f_45579_ + 1), new ChunkPos(pos.f_45578_ - 1, pos.f_45579_), new ChunkPos(pos.f_45578_ + 1, pos.f_45579_)};
            boolean top = !claim.containsChunk(dirs[0]);
            boolean bottom = !claim.containsChunk(dirs[1]);
            boolean left = !claim.containsChunk(dirs[2]);
            boolean right = !claim.containsChunk(dirs[3]);
            int borderColor = -1;
            if (top) {
                guiGraphics.m_280509_((int)px, (int)py, (int)(px + cellSize), (int)py + 1, borderColor);
            }
            if (bottom) {
                guiGraphics.m_280509_((int)px, (int)(py + cellSize - 1.0f), (int)(px + cellSize), (int)(py + cellSize), borderColor);
            }
            if (left) {
                guiGraphics.m_280509_((int)px, (int)py, (int)px + 1, (int)(py + cellSize), borderColor);
            }
            if (!right) continue;
            guiGraphics.m_280509_((int)(px + cellSize - 1.0f), (int)py, (int)(px + cellSize), (int)(py + cellSize), borderColor);
        }
        ChunkPos center = claim.getCenter();
        float cx = offsetX + ((float)(center.f_45578_ - minX) + 0.5f) * cellSize;
        float cz = offsetY + ((float)(center.f_45579_ - minZ) + 0.5f) * cellSize;
        int textWidth = font.m_92895_(claim.getName());
        guiGraphics.m_280056_(font, claim.getName(), (int)(cx - (float)textWidth / 2.0f), (int)(cz - 6.0f), 0xFFFFFF, false);
        RenderSystem.disableScissor();
    }
}

