/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.worldmap;

import com.talhanation.recruits.client.gui.worldmap.ChunkImage;
import com.talhanation.recruits.client.gui.worldmap.ChunkTile;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class ChunkTileManager {
    private static ChunkTileManager instance;
    private final Map<String, ChunkTile> loadedTiles = new HashMap<String, ChunkTile>();
    private final Minecraft mc = Minecraft.m_91087_();
    private File worldMapDir;
    private int currentTileX = Integer.MAX_VALUE;
    private int currentTileZ = Integer.MAX_VALUE;
    private final Map<String, Long> lastUpdateTimes = new HashMap<String, Long>();
    private long lastNeighborUpdateTime = 0L;
    private int lastUpdatedNeighborIndex = 0;

    public static ChunkTileManager getInstance() {
        if (instance == null) {
            instance = new ChunkTileManager();
        }
        return instance;
    }

    public void initialize(Level level) {
        if (level == null) {
            return;
        }
        String worldName = ChunkTileManager.detectStorageId();
        this.worldMapDir = new File(this.mc.f_91069_, "recruits/worldmap/" + worldName);
        this.worldMapDir.mkdirs();
    }

    public void updateCurrentTile() {
        if (this.mc.f_91073_ == null || this.mc.f_91074_ == null) {
            return;
        }
        int chunkX = this.mc.f_91074_.m_146902_().f_45578_;
        int chunkZ = this.mc.f_91074_.m_146902_().f_45579_;
        int tileX = ChunkTile.chunkToTileCoord(chunkX);
        int tileZ = ChunkTile.chunkToTileCoord(chunkZ);
        String currentTileKey = tileX + "_" + tileZ;
        long currentTime = System.currentTimeMillis();
        Long lastUpdate = this.lastUpdateTimes.get(currentTileKey);
        if (tileX != this.currentTileX || tileZ != this.currentTileZ || lastUpdate == null || currentTime - lastUpdate > 1000L) {
            this.updateTile(tileX, tileZ);
            this.currentTileX = tileX;
            this.currentTileZ = tileZ;
        }
        if (currentTime - this.lastNeighborUpdateTime >= 500L) {
            this.updateOneNeighborTile(tileX, tileZ);
            this.lastNeighborUpdateTime = currentTime;
        }
    }

    private void updateOneNeighborTile(int centerX, int centerZ) {
        int[] neighbor;
        String neighborKey;
        Long neighborLastUpdate;
        int[][] neighbors = new int[][]{{centerX - 1, centerZ - 1}, {centerX, centerZ - 1}, {centerX + 1, centerZ - 1}, {centerX - 1, centerZ}, {centerX + 1, centerZ}, {centerX - 1, centerZ + 1}, {centerX, centerZ + 1}, {centerX + 1, centerZ + 1}};
        if (this.lastUpdatedNeighborIndex >= neighbors.length) {
            this.lastUpdatedNeighborIndex = 0;
        }
        if ((neighborLastUpdate = this.lastUpdateTimes.get(neighborKey = (neighbor = neighbors[this.lastUpdatedNeighborIndex])[0] + "_" + neighbor[1])) == null || System.currentTimeMillis() - neighborLastUpdate > 10000L) {
            this.updateTile(neighbor[0], neighbor[1]);
        }
        ++this.lastUpdatedNeighborIndex;
    }

    private void updateTile(int tileX, int tileZ) {
        ChunkTile tile = this.getOrCreateTile(tileX, tileZ);
        File tileFile = this.getTileFile(tileX, tileZ);
        if (tileFile.exists()) {
            tile.mergeWithExistingTile(tileFile);
        }
        this.updateOnlyLoadedChunks(tile);
        tile.saveToFile(tileFile);
        this.lastUpdateTimes.put(tileX + "_" + tileZ, System.currentTimeMillis());
    }

    private void updateOnlyLoadedChunks(ChunkTile tile) {
        if (this.mc.f_91073_ == null || this.mc.f_91074_ == null) {
            return;
        }
        int startChunkX = ChunkTile.tileToChunkCoord(tile.getTileX());
        int startChunkZ = ChunkTile.tileToChunkCoord(tile.getTileZ());
        for (int cz = 0; cz < 10; ++cz) {
            for (int cx = 0; cx < 10; ++cx) {
                ChunkPos chunkPos = new ChunkPos(startChunkX + cx, startChunkZ + cz);
                if (!this.isChunkLoaded(chunkPos)) continue;
                ChunkImage chunkImage = new ChunkImage(this.mc.f_91073_, chunkPos);
                tile.updateFromChunkImage(chunkImage, cx, cz);
                chunkImage.close();
            }
        }
    }

    private boolean isChunkLoaded(ChunkPos chunkPos) {
        if (this.mc.f_91073_ == null || this.mc.f_91074_ == null) {
            return false;
        }
        try {
            return this.mc.f_91073_.m_7726_().m_62227_(chunkPos.f_45578_, chunkPos.f_45579_, false) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public ChunkTile getOrCreateTile(int tileX, int tileZ) {
        String key = tileX + "_" + tileZ;
        ChunkTile tile = this.loadedTiles.get(key);
        if (tile == null) {
            tile = new ChunkTile(tileX, tileZ);
            tile.loadOrCreate(this.getTileFile(tileX, tileZ));
            this.loadedTiles.put(key, tile);
        }
        tile.markAccessed();
        return tile;
    }

    private static String detectStorageId() {
        try {
            String levelName;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.m_91092_() != null && (levelName = mc.m_91092_().m_129910_().m_5462_()) != null && !levelName.isEmpty()) {
                return levelName.replaceAll("[^a-zA-Z0-9_\\-\\.]", "_");
            }
            ServerData sd = mc.m_91089_();
            if (sd != null && sd.f_105363_ != null && !sd.f_105363_.isEmpty()) {
                return sd.f_105363_.replaceAll("[^a-zA-Z0-9_\\-\\.]", "_");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "unknown";
    }

    private File getTileFile(int tileX, int tileZ) {
        return new File(this.worldMapDir, tileX + "_" + tileZ + ".png");
    }

    public void close() {
        for (ChunkTile tile : this.loadedTiles.values()) {
            tile.saveToFile(this.getTileFile(tile.getTileX(), tile.getTileZ()));
            tile.close();
        }
        this.loadedTiles.clear();
    }

    public Map<String, ChunkTile> getLoadedTiles() {
        return this.loadedTiles;
    }
}

