/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.worldmap;

import com.mojang.blaze3d.platform.NativeImage;
import com.talhanation.recruits.client.gui.worldmap.ChunkImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class ChunkTile {
    private final int tileX;
    private final int tileZ;
    private NativeImage image;
    private DynamicTexture texture;
    private ResourceLocation textureId;
    private boolean needsUpdate = false;
    public static final int TILE_SIZE = 10;
    public static final int PIXELS_PER_CHUNK = 16;
    public static final int TILE_PIXEL_SIZE = 160;

    public ChunkTile(int tileX, int tileZ) {
        this.tileX = tileX;
        this.tileZ = tileZ;
    }

    public void loadOrCreate(File tileFile) {
        Minecraft mc = Minecraft.m_91087_();
        try {
            if (tileFile.exists() && tileFile.length() > 0L) {
                byte[] fileData = Files.readAllBytes(tileFile.toPath());
                this.image = NativeImage.m_271751_((byte[])fileData);
                if (this.image.m_84982_() != 160 || this.image.m_85084_() != 160) {
                    this.image.close();
                    this.image = null;
                }
            }
        }
        catch (IOException ignored) {
            this.image = null;
        }
        if (this.image == null) {
            this.image = new NativeImage(NativeImage.Format.RGBA, 160, 160, false);
            for (int i = 0; i < 25600; ++i) {
                this.image.m_84988_(i % 160, i / 160, 0);
            }
            this.needsUpdate = true;
        }
        this.texture = new DynamicTexture(this.image);
        this.textureId = mc.m_91097_().m_118490_("chunktile_" + this.tileX + "_" + this.tileZ, this.texture);
    }

    public void updateFromChunkImage(ChunkImage chunkImage, int chunkXInTile, int chunkZInTile) {
        if (this.image == null || chunkImage == null || !chunkImage.isMeaningful()) {
            return;
        }
        NativeImage chunkImg = chunkImage.getNativeImage();
        int startX = chunkXInTile * 16;
        int startZ = chunkZInTile * 16;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                this.image.m_84988_(startX + x, startZ + z, chunkImg.m_84985_(x, z));
            }
        }
        this.texture.m_117985_();
        this.needsUpdate = true;
    }

    public void mergeWithExistingTile(File existingTileFile) {
        if (!existingTileFile.exists() || this.image == null) {
            return;
        }
        try {
            byte[] existingData = Files.readAllBytes(existingTileFile.toPath());
            NativeImage existingImage = NativeImage.m_271751_((byte[])existingData);
            if (existingImage.m_84982_() == 160 && existingImage.m_85084_() == 160) {
                for (int i = 0; i < 25600; ++i) {
                    int x = i % 160;
                    int y = i / 160;
                    int currentPixel = this.image.m_84985_(x, y);
                    if ((currentPixel >> 24 & 0xFF) != 0) continue;
                    this.image.m_84988_(x, y, existingImage.m_84985_(x, y));
                }
                this.needsUpdate = true;
            }
            existingImage.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void saveToFile(File tileFile) {
        if (this.image == null || !this.needsUpdate) {
            return;
        }
        try {
            tileFile.getParentFile().mkdirs();
            this.image.m_85056_(tileFile);
            this.needsUpdate = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void render(GuiGraphics guiGraphics, int x, int y, int size) {
        if (this.textureId != null) {
            guiGraphics.m_280163_(this.textureId, x, y, 0.0f, 0.0f, size, size, size, size);
        }
    }

    public void close() {
        try {
            if (this.image != null) {
                this.image.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.textureId != null) {
            Minecraft.m_91087_().m_91097_().m_118513_(this.textureId);
        }
        try {
            if (this.texture != null) {
                this.texture.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getTileX() {
        return this.tileX;
    }

    public int getTileZ() {
        return this.tileZ;
    }

    public NativeImage getImage() {
        return this.image;
    }

    public ResourceLocation getTextureId() {
        return this.textureId;
    }

    public void markAccessed() {
    }

    public void markNeedsUpdate() {
        this.needsUpdate = true;
    }

    public static int chunkToTileCoord(int chunkCoord) {
        return Math.floorDiv(chunkCoord, 10);
    }

    public static int tileToChunkCoord(int tileCoord) {
        return tileCoord * 10;
    }
}

