/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import com.talhanation.recruits.client.gui.component.BannerRenderer;
import com.talhanation.recruits.client.gui.faction.TeamEditScreen;
import com.talhanation.recruits.client.gui.overlay.ClaimOverlayManager;
import com.talhanation.recruits.world.RecruitsClaim;
import com.talhanation.recruits.world.RecruitsFaction;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class ClaimOverlayRenderer {
    private final Map<RecruitsFaction, BannerRenderer> bannerCache = new HashMap<RecruitsFaction, BannerRenderer>();
    private final Map<RecruitsFaction, Integer> factionColorCache = new HashMap<RecruitsFaction, Integer>();
    private static final int PANEL_HEIGHT_FULL = 45;
    private static final int PANEL_HEIGHT_COMPACT = 15;
    private static final int BACKGROUND_ALPHA = 15;
    private static final ResourceLocation SIEGE_ICON = new ResourceLocation("recruits:textures/gui/image/enemy.png");
    private boolean dataChanged = true;

    public void render(GuiGraphics guiGraphics, Minecraft minecraft, RecruitsClaim claim, ClaimOverlayManager.OverlayState state, float alpha, int panelWidth) {
        if (claim == null || state == ClaimOverlayManager.OverlayState.HIDDEN) {
            return;
        }
        Font font = minecraft.f_91062_;
        int screenWidth = minecraft.m_91268_().m_85445_();
        int x = (screenWidth - panelWidth) / 2;
        int y = 10;
        int panelHeight = state == ClaimOverlayManager.OverlayState.FULL ? 45 : 15;
        int bgAlpha = (int)(15.0f * alpha);
        int factionColor = this.getFactionColor(claim.getOwnerFaction());
        int backgroundColor = bgAlpha << 24 | factionColor & 0xFFFFFF;
        guiGraphics.m_280509_(x, y, x + panelWidth, y + panelHeight, backgroundColor);
        if (claim.isUnderSiege) {
            this.renderSiegeContent(guiGraphics, claim, x, y, panelWidth, panelHeight, font, alpha);
        } else if (state == ClaimOverlayManager.OverlayState.FULL) {
            this.renderNormalFullContent(guiGraphics, claim, x, y, panelWidth, panelHeight, font, alpha);
        } else {
            this.renderNormalCompactContent(guiGraphics, claim, x, y, panelWidth, panelHeight, font, alpha);
        }
        this.dataChanged = false;
    }

    private void renderNormalFullContent(GuiGraphics guiGraphics, RecruitsClaim claim, int x, int y, int width, int height, Font font, float alpha) {
        RecruitsFaction faction = claim.getOwnerFaction();
        int textAlpha = (int)(255.0f * alpha);
        int textColor = textAlpha << 24 | 0xFFFFFF;
        int bannerX = 5;
        int bannerY = 13;
        BannerRenderer banner = this.getBannerRenderer(faction);
        if (banner != null) {
            banner.renderBanner(guiGraphics, x + bannerX, y + bannerY, 48, 48, 20);
        }
        String claimName = this.truncateText(font, claim.getName(), width - 80);
        guiGraphics.m_280056_(font, claimName, x + 60, y + 10, textColor, false);
        if (claim.getPlayerInfo() != null) {
            String claimOwner = this.truncateText(font, claim.getPlayerInfo().getName(), width - 80);
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            float scale = 0.5f;
            int originalX = x + 60;
            int originalY = y + 20;
            poseStack.m_252880_((float)originalX, (float)originalY, 0.0f);
            poseStack.m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280056_(font, faction.getTeamDisplayName(), 0, 0, 0xAAAAAA, false);
            guiGraphics.m_280056_(font, claimOwner, 0, 10, 0xAAAAAA, false);
            poseStack.m_85849_();
        }
    }

    private void renderNormalCompactContent(GuiGraphics guiGraphics, RecruitsClaim claim, int x, int y, int width, int height, Font font, float alpha) {
        int textAlpha = (int)(255.0f * alpha);
        int textColor = textAlpha << 24 | 0xFFFFFF;
        String displayText = this.truncateText(font, claim.getName() + " - " + claim.getOwnerFaction().getTeamDisplayName(), width - 20);
        int textWidth = font.m_92895_(displayText);
        int textX = x + (width - textWidth) / 2;
        int textY = y + (height - 9) / 2;
        guiGraphics.m_280056_(font, displayText, textX, textY, textColor, false);
    }

    private void renderSiegeContent(GuiGraphics guiGraphics, RecruitsClaim claim, int x, int y, int width, int height, Font font, float alpha) {
        int textAlpha = (int)(255.0f * alpha);
        int normalTextColor = textAlpha << 24 | 0xFFFFFF;
        String name = this.truncateText(font, claim.getName(), width - 40);
        int nameWidth = font.m_92895_(name);
        int nameX = x + (width - nameWidth) / 2;
        guiGraphics.m_280056_(font, name, nameX, y + 2, normalTextColor, false);
        int bannerSize = 48;
        int bannerY = y + 15;
        BannerRenderer ownerBanner = this.getBannerRenderer(claim.getOwnerFaction());
        if (ownerBanner != null) {
            ownerBanner.renderBanner(guiGraphics, x + 5, bannerY, bannerSize, bannerSize, 15);
        }
        String ownerFactionName = this.truncateText(font, claim.getOwnerFaction().getTeamDisplayName(), 60);
        int ownerFactionNameWidth = font.m_92895_(ownerFactionName);
        guiGraphics.m_280056_(font, ownerFactionName, x + 15 - ownerFactionNameWidth / 2, y + 2, 0xAAAAAA, false);
        if (!claim.attackingParties.isEmpty()) {
            BannerRenderer attackerBanner = this.getBannerRenderer(claim.attackingParties.get(0));
            if (attackerBanner != null) {
                attackerBanner.renderBanner(guiGraphics, x - 25 + width, bannerY, bannerSize, bannerSize, 15);
            }
            String attackerName = this.truncateText(font, claim.attackingParties.get(0).getTeamDisplayName(), 60);
            int attackerNameWidth = font.m_92895_(name);
            int attackerNameX = x - 15 + width - attackerNameWidth / 2;
            guiGraphics.m_280056_(font, attackerName, attackerNameX, y + 2, 0xAAAAAA, false);
        }
        int barWidth = 100;
        int barHeight = 4;
        int barX = x + width / 2 - barWidth / 2;
        int barY = y + 35;
        guiGraphics.m_280509_(barX, barY, barX + barWidth, barY + barHeight, -16777216);
        if (claim.getMaxHealth() > 0) {
            float ratio = (float)claim.getHealth() / (float)claim.getMaxHealth();
            guiGraphics.m_280509_(barX, barY, barX + (int)((float)barWidth * ratio), barY + barHeight, -16711936);
        }
        int iconSize = 18;
        guiGraphics.m_280163_(SIEGE_ICON, x + width / 2 - iconSize / 2, y + 14, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
    }

    private String truncateText(Font font, String text, int maxWidth) {
        if (font.m_92895_(text) <= maxWidth) {
            return text;
        }
        while (font.m_92895_(text + "...") > maxWidth && text.length() > 3) {
            text = text.substring(0, text.length() - 1);
        }
        return text + "...";
    }

    private BannerRenderer getBannerRenderer(RecruitsFaction faction) {
        if (faction == null) {
            return null;
        }
        if (this.dataChanged) {
            this.bannerCache.remove(faction);
        }
        return this.bannerCache.computeIfAbsent(faction, BannerRenderer::new);
    }

    private int getFactionColor(RecruitsFaction faction) {
        if (faction == null) {
            return 0x808080;
        }
        return this.factionColorCache.computeIfAbsent(faction, f -> {
            int alpha = 7;
            int rgb = TeamEditScreen.unitColors.get(faction.getUnitColor()).getRGB();
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            return alpha << 24 | r << 16 | g << 8 | b;
        });
    }

    private int getHealthColor(float percent) {
        if (percent > 0.6f) {
            return -2147418368;
        }
        if (percent > 0.3f) {
            return -2130706688;
        }
        return -2130771968;
    }

    public void markDataChanged() {
        this.dataChanged = true;
    }

    public void clearCache() {
        this.bannerCache.clear();
        this.factionColorCache.clear();
        this.dataChanged = true;
    }
}

