/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.group;

import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.client.ClientManager;
import com.talhanation.recruits.client.gui.group.EditOrAddGroupScreen;
import com.talhanation.recruits.client.gui.group.IGroupSelection;
import com.talhanation.recruits.client.gui.group.RecruitsGroupEntry;
import com.talhanation.recruits.client.gui.group.RecruitsGroupList;
import com.talhanation.recruits.client.gui.widgets.ListScreenBase;
import com.talhanation.recruits.client.gui.widgets.ListScreenListBase;
import com.talhanation.recruits.network.MessageApplyNoGroup;
import com.talhanation.recruits.network.MessageUpdateGroup;
import com.talhanation.recruits.world.RecruitsGroup;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;

@OnlyIn(value=Dist.CLIENT)
public class RecruitsGroupListScreen
extends ListScreenBase
implements IGroupSelection {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("recruits", "textures/gui/select_player.png");
    protected static final Component TITLE = Component.m_237115_((String)"gui.recruits.groups.title");
    protected static final Component ADD_BUTTON = Component.m_237115_((String)"gui.recruits.groups.add");
    protected static final Component EDIT_BUTTON = Component.m_237115_((String)"gui.recruits.groups.edit");
    protected static final Component REMOVE_BUTTON = Component.m_237115_((String)"gui.recruits.groups.remove");
    protected static final int HEADER_SIZE = 16;
    protected static final int FOOTER_SIZE = 32;
    protected static final int SEARCH_HEIGHT = 16;
    protected static final int UNIT_SIZE = 18;
    protected static final int CELL_HEIGHT = 36;
    protected RecruitsGroupList groupList;
    protected EditBox searchBox;
    protected String lastSearch;
    protected int units;
    protected Screen parent;
    private RecruitsGroup selected;
    private Button editButton;
    private Button removeButton;
    private Button addButton;
    private final Player player;
    private int gapTop;
    private int gapBottom;
    private long lastClickTime = 0L;
    private static final long DOUBLE_CLICK_THRESHOLD = 200L;

    public RecruitsGroupListScreen(Player player) {
        super(TITLE, 236, 0);
        this.player = player;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.gapTop = (int)((double)this.f_96544_ * 0.1);
        this.gapBottom = (int)((double)this.f_96544_ * 0.1);
        this.guiLeft += 2;
        this.guiTop = this.gapTop;
        int minUnits = Mth.m_14167_((float)3.1111112f);
        this.units = Math.max(minUnits, (this.f_96544_ - 16 - 32 - this.gapTop - this.gapBottom - 16) / 18);
        if (this.groupList != null) {
            this.groupList.m_93437_(this.f_96543_, this.f_96544_, this.guiTop + 16 + 16, this.guiTop + 16 + this.units * 18);
        } else {
            this.groupList = new RecruitsGroupList(this.f_96543_, this.f_96544_, this.guiTop + 16 + 16, this.guiTop + 16 + this.units * 18, 36, this, null);
        }
        String string = this.searchBox != null ? this.searchBox.m_94155_() : "";
        this.searchBox = new EditBox(this.f_96547_, this.guiLeft + 8, this.guiTop + 16, 220, 16, (Component)Component.m_237113_((String)""));
        this.searchBox.m_94199_(16);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94144_(string);
        this.searchBox.m_94151_(this::checkSearchStringUpdate);
        this.m_7787_((GuiEventListener)this.searchBox);
        this.m_7787_((GuiEventListener)this.groupList);
        int buttonY = this.guiTop + 16 + 5 + this.units * 18;
        this.addButton = this.createAddGroupButton(this.guiLeft + 7, buttonY);
        this.m_142416_((GuiEventListener)this.addButton);
        this.editButton = this.createEditGroupButton(this.guiLeft + 87, buttonY);
        this.m_142416_((GuiEventListener)this.editButton);
        this.removeButton = this.createRemoveGroupButton(this.guiLeft + 167, buttonY);
        this.m_142416_((GuiEventListener)this.removeButton);
        this.checkButtons();
    }

    public void m_86600_() {
        super.m_86600_();
        ClientManager.updateGroups();
        if (this.searchBox != null) {
            this.searchBox.m_94120_();
        }
        if (this.groupList != null) {
            this.groupList.tick();
        }
    }

    private Button createRemoveGroupButton(int x, int y) {
        return new ExtendedButton(x, y, 60, 20, REMOVE_BUTTON, button -> {
            if (this.selected != null) {
                ClientManager.groups.removeIf(predicate -> this.selected.getUUID().equals(predicate.getUUID()));
                this.selected.removed = true;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageApplyNoGroup(this.player.m_20148_(), this.selected.getUUID()));
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageUpdateGroup(this.selected));
                this.selected = null;
                this.m_7856_();
            }
        });
    }

    public void checkButtons() {
        this.editButton.f_93623_ = this.selected != null;
        this.removeButton.f_93623_ = this.selected != null;
        this.addButton.f_93623_ = this.selected == null;
    }

    private Button createAddGroupButton(int x, int y) {
        return new ExtendedButton(x, y, 60, 20, ADD_BUTTON, btn -> this.f_96541_.m_91152_((Screen)new EditOrAddGroupScreen(this)));
    }

    private Button createEditGroupButton(int x, int y) {
        return new ExtendedButton(x, y, 60, 20, EDIT_BUTTON, btn -> {
            if (this.selected != null) {
                this.f_96541_.m_91152_((Screen)new EditOrAddGroupScreen(this, this.selected));
            }
        });
    }

    public boolean m_7933_(int p_96552_, int p_96553_, int p_96554_) {
        boolean flag = super.m_7933_(p_96552_, p_96553_, p_96554_);
        this.selected = null;
        this.groupList.m_7522_(null);
        this.checkButtons();
        return flag;
    }

    public void m_7379_() {
        super.m_7379_();
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, 16);
        for (int i = 0; i < this.units; ++i) {
            guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop + 16 + 18 * i, 0, 16, this.xSize, 18);
        }
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop + 16 + 18 * this.units, 0, 34, this.xSize, 32);
        guiGraphics.m_280218_(TEXTURE, this.guiLeft + 10, this.guiTop + 16 + 6 - 2, this.xSize, 0, 12, 12);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.m_280614_(this.f_96547_, this.m_96636_(), this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)TITLE) / 2, this.guiTop + 5, 0x404040, false);
        if (!this.groupList.isEmpty()) {
            this.groupList.m_88315_(guiGraphics, mouseX, mouseY, delta);
        } else if (!this.searchBox.m_94155_().isEmpty()) {
            int n = this.f_96543_ / 2;
            int n2 = this.guiTop + 16 + this.units * 18 / 2;
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280137_(this.f_96547_, "EMPTY_SEARCH", n, n2 - 9 / 2, -1);
        }
        if (!this.searchBox.m_93696_() && this.searchBox.m_94155_().isEmpty()) {
            guiGraphics.m_280488_(this.f_96547_, "", this.searchBox.m_252754_(), this.searchBox.m_252907_(), -1);
        }
        this.searchBox.m_88315_(guiGraphics, mouseX, mouseY, delta);
    }

    private void checkSearchStringUpdate(String string) {
        if (!(string = string.toLowerCase(Locale.ROOT)).equals(this.lastSearch)) {
            this.groupList.setFilter(string);
            this.lastSearch = string;
        }
    }

    public boolean m_6375_(double x, double y, int button) {
        if (this.groupList != null && this.groupList.m_5953_(x, y)) {
            this.groupList.m_6375_(x, y, button);
            RecruitsGroupEntry entry = this.groupList.getGroupEntryAtPosition(x, y);
            this.selected = entry != null ? entry.getGroup() : null;
            boolean isDoubleClick = false;
            long now = System.currentTimeMillis();
            if (button == 0) {
                if (now - this.lastClickTime <= 200L) {
                    isDoubleClick = true;
                }
                this.lastClickTime = now;
            }
            if (isDoubleClick && this.selected != null) {
                this.onDoubleClick(this.selected);
            }
        }
        this.checkButtons();
        return super.m_6375_(x, y, button);
    }

    private void onDoubleClick(RecruitsGroup group) {
        this.f_96541_.m_91152_((Screen)new EditOrAddGroupScreen(this, group));
    }

    @Override
    public RecruitsGroup getSelected() {
        return this.selected;
    }

    @Override
    public ListScreenListBase<RecruitsGroupEntry> getGroupList() {
        return this.groupList;
    }

    public Component m_96636_() {
        return TITLE;
    }
}

