/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.group;

import com.google.common.collect.Lists;
import com.talhanation.recruits.client.ClientManager;
import com.talhanation.recruits.client.gui.group.IGroupSelection;
import com.talhanation.recruits.client.gui.group.RecruitsGroupEntry;
import com.talhanation.recruits.client.gui.widgets.ListScreenListBase;
import com.talhanation.recruits.world.RecruitsGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class RecruitsGroupList
extends ListScreenListBase<RecruitsGroupEntry> {
    protected IGroupSelection screen;
    protected final List<RecruitsGroupEntry> entries;
    protected String filter;
    protected List<UUID> blackList = new ArrayList<UUID>();

    public RecruitsGroupList(int width, int height, int x, int y, int size, IGroupSelection screen, List<UUID> blackList) {
        super(width, height, x, y, size);
        this.screen = screen;
        this.entries = Lists.newArrayList();
        this.filter = "";
        this.m_93488_(false);
        this.m_93496_(false);
        this.m_93471_(true);
        if (blackList != null) {
            this.blackList.addAll(blackList);
        }
    }

    public void tick() {
        if (ClientManager.groups != null) {
            this.updateEntryList();
        }
    }

    public void updateEntryList() {
        this.entries.clear();
        for (RecruitsGroup group : ClientManager.groups) {
            if (this.blackList.contains(group.getUUID())) continue;
            this.entries.add(new RecruitsGroupEntry(this.screen, group));
        }
        this.updateFilter();
    }

    public void updateFilter() {
        this.m_93516_();
        ArrayList<RecruitsGroupEntry> filteredEntries = new ArrayList<RecruitsGroupEntry>(this.entries);
        if (!this.filter.isEmpty()) {
            filteredEntries.removeIf(groupEntry -> groupEntry.getGroup() == null || !groupEntry.getGroup().getName().toLowerCase(Locale.ROOT).contains(this.filter));
        }
        this.m_5988_(filteredEntries);
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.updateFilter();
    }

    @Nullable
    public RecruitsGroupEntry getGroupEntryAtPosition(double x, double y) {
        return (RecruitsGroupEntry)this.m_93412_(x, y);
    }

    public boolean isEmpty() {
        return this.m_6702_().isEmpty();
    }
}

