/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.faction;

import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.FactionEvents;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.client.gui.RecruitsScreenBase;
import com.talhanation.recruits.client.gui.faction.TeamEditScreen;
import com.talhanation.recruits.client.gui.player.PlayersList;
import com.talhanation.recruits.client.gui.player.SelectPlayerScreen;
import com.talhanation.recruits.network.MessageAddPlayerToTeam;
import com.talhanation.recruits.network.MessageRemoveFromTeam;
import com.talhanation.recruits.world.RecruitsFaction;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class TeamManageScreen
extends RecruitsScreenBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("recruits", "textures/gui/gui_big.png");
    private static final Component TITLE = Component.m_237115_((String)"gui.recruits.team.manage");
    private static final MutableComponent BACK = Component.m_237115_((String)"gui.recruits.button.back");
    private static final MutableComponent ADD_PLAYER = Component.m_237115_((String)"gui.recruits.team.addPlayer");
    private static final MutableComponent REMOVE_PLAYER = Component.m_237115_((String)"gui.recruits.team.removePlayer");
    private static final MutableComponent TOOLTIP_WIP = Component.m_237115_((String)"gui.recruits.wip");
    private static final MutableComponent TOOLTIP_ADD_PLAYER = Component.m_237115_((String)"gui.recruits.team.tooltip.add");
    private static final MutableComponent TOOLTIP_REMOVE_PLAYER = Component.m_237115_((String)"gui.recruits.team.tooltip.remove");
    private static final MutableComponent PLAYER_PROMOTION = Component.m_237115_((String)"gui.recruits.team.playerPromotion");
    private static final Component EDIT_BUTTON = Component.m_237115_((String)"gui.recruits.team.edit");
    private final Player player;
    private final RecruitsFaction recruitsFaction;
    private final Screen parent;

    public TeamManageScreen(Screen parent, Player player, RecruitsFaction recruitsFaction) {
        super(TITLE, 195, 160);
        this.parent = parent;
        this.player = player;
        this.recruitsFaction = recruitsFaction;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.setButtons();
    }

    private void setButtons() {
        this.m_169413_();
        Button addPlayer = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + 32, this.guiTop + this.ySize - 120 - 7, 130, 20, (Component)ADD_PLAYER, btn -> this.f_96541_.m_91152_((Screen)new SelectPlayerScreen(this, this.player, (Component)TOOLTIP_ADD_PLAYER, (Component)ADD_PLAYER, (Component)Component.m_237113_((String)""), false, PlayersList.FilterType.TEAM_JOIN_REQUEST, playerInfo -> {
            this.recruitsFaction.removeJoinRequest(playerInfo.getName());
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageAddPlayerToTeam(this.recruitsFaction.getStringID(), playerInfo.getName()));
        }))));
        addPlayer.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_ADD_PLAYER));
        Button removePlayer = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + 32, this.guiTop + this.ySize - 98 - 7, 130, 20, (Component)REMOVE_PLAYER, btn -> this.f_96541_.m_91152_((Screen)new SelectPlayerScreen(this, this.player, (Component)TOOLTIP_REMOVE_PLAYER, (Component)REMOVE_PLAYER, (Component)Component.m_237113_((String)""), false, PlayersList.FilterType.SAME_TEAM, playerInfo -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageRemoveFromTeam(playerInfo.getName()))))));
        removePlayer.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_REMOVE_PLAYER));
        ExtendedButton editButton = new ExtendedButton(this.guiLeft + 32, this.guiTop + this.ySize - 76 - 7, 130, 20, EDIT_BUTTON, button -> {
            TeamEditScreen.leaderInfo = null;
            FactionEvents.openTeamEditScreen(this.player);
        });
        this.m_142416_((GuiEventListener)editButton);
        Button playerPromotion = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + 32, this.guiTop + this.ySize - 54 - 7, 130, 20, (Component)PLAYER_PROMOTION, btn -> {}));
        playerPromotion.f_93623_ = false;
        playerPromotion.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_WIP));
        Button back = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + 32, this.guiTop + this.ySize - 32 - 7, 130, 20, (Component)BACK, btn -> this.f_96541_.m_91152_(this.parent)));
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.m_280614_(this.f_96547_, TITLE, this.guiLeft + this.xSize / 2 - this.f_96547_.m_92852_((FormattedText)TITLE) / 2, this.guiTop + 7, 0x404040, false);
    }
}

