/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.diplomacy;

import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.client.ClientManager;
import com.talhanation.recruits.client.gui.diplomacy.DiplomacyEditScreen;
import com.talhanation.recruits.client.gui.diplomacy.DiplomacyTeamEntry;
import com.talhanation.recruits.client.gui.diplomacy.DiplomacyTeamList;
import com.talhanation.recruits.client.gui.diplomacy.RecruitsDiplomacyButton;
import com.talhanation.recruits.client.gui.widgets.ListScreenBase;
import com.talhanation.recruits.world.RecruitsDiplomacyManager;
import com.talhanation.recruits.world.RecruitsFaction;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;

@OnlyIn(value=Dist.CLIENT)
public class DiplomacyTeamListScreen
extends ListScreenBase {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("recruits", "textures/gui/select_with_filter.png");
    protected static final Component TITLE = Component.m_237115_((String)"gui.recruits.diplomacy.teams_list");
    protected static final Component SET_STANCE = Component.m_237115_((String)"gui.recruits.button.setRelation");
    protected static final Component SHOW_STANCE = Component.m_237115_((String)"gui.recruits.button.showRelation");
    protected static final Component TOAST_SEND_JOIN_REQUEST_TITLE = Component.m_237115_((String)"gui.recruits.toast.sendJoinRequestTitle");
    protected static final Component BACK_BUTTON = Component.m_237115_((String)"gui.recruits.button.back");
    protected static final int HEADER_SIZE = 32;
    protected static final int FOOTER_SIZE = 32;
    protected static final int SEARCH_HEIGHT = 16;
    protected static final int UNIT_SIZE = 18;
    protected static final int CELL_HEIGHT = 36;
    protected DiplomacyTeamList list;
    protected EditBox searchBox;
    protected String lastSearch;
    protected int units;
    protected Screen parent;
    private RecruitsFaction selected;
    private Button backButton;
    private Button setStanceButton;
    private final boolean isLeader;
    private int gapBottom;
    private int gapTop;
    private Button alliesButton;
    private Button neutralsButton;
    private Button enemiesButton;
    private DiplomacyTeamList.DiplomacyFilter diplomacyFilter;
    private long lastClickTime = 0L;
    private static final long DOUBLE_CLICK_THRESHOLD = 250L;

    public DiplomacyTeamListScreen(Screen parent, boolean isLeader) {
        super(TITLE, 236, 0);
        this.parent = parent;
        this.isLeader = isLeader;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.gapTop = (int)((double)this.f_96544_ * 0.1);
        this.gapBottom = (int)((double)this.f_96544_ * 0.1);
        this.guiLeft += 2;
        this.guiTop = this.gapTop;
        int minUnits = Mth.m_14167_((float)3.1111112f);
        this.units = Math.max(minUnits, (this.f_96544_ - 32 - 32 - this.gapTop - this.gapBottom - 16) / 18);
        this.ySize = 32 + this.units * 18 + 32;
        if (this.diplomacyFilter == null) {
            this.diplomacyFilter = DiplomacyTeamList.DiplomacyFilter.ALL;
        }
        if (this.list != null) {
            this.list.m_93437_(this.f_96543_, this.f_96544_, this.guiTop + 32 + 16, this.guiTop + 32 + this.units * 18);
        } else {
            this.list = new DiplomacyTeamList(this.f_96543_, this.f_96544_, this.guiTop + 32 + 16, this.guiTop + 32 + this.units * 18, 36, this);
        }
        String string = this.searchBox != null ? this.searchBox.m_94155_() : "";
        this.searchBox = new EditBox(this.f_96547_, this.guiLeft + 8, this.guiTop + 32 - 4, 156, 20, (Component)Component.m_237113_((String)""));
        this.searchBox.m_94199_(16);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94144_(string);
        this.searchBox.m_94151_(this::checkSearchStringUpdate);
        this.m_7787_((GuiEventListener)this.searchBox);
        this.m_7787_((GuiEventListener)this.list);
        this.m_264313_((GuiEventListener)this.searchBox);
        int buttonY = this.guiTop + 32 + 5 + this.units * 18;
        this.backButton = new ExtendedButton(this.guiLeft + 129, buttonY, 100, 20, BACK_BUTTON, button -> this.f_96541_.m_91152_(this.parent));
        this.m_142416_((GuiEventListener)this.backButton);
        this.setStanceButton = new ExtendedButton(this.guiLeft + 7, buttonY, 100, 20, this.isLeader ? SET_STANCE : SHOW_STANCE, button -> {
            this.f_96541_.m_91152_((Screen)new DiplomacyEditScreen(this, this.selected));
            this.selected = null;
        });
        this.setStanceButton.f_93623_ = this.selected != null && ClientManager.ownFaction != null && ClientManager.ownFaction.getTeamLeaderUUID().equals(this.f_96541_.f_91074_.m_20148_());
        this.m_142416_((GuiEventListener)this.setStanceButton);
        int buttonX = 165;
        int buttonY2 = 28;
        this.alliesButton = new RecruitsDiplomacyButton(RecruitsDiplomacyManager.DiplomacyStatus.ALLY, this.guiLeft + buttonX, this.guiTop + buttonY2, 21, 21, (Component)Component.m_237113_((String)""), button -> {
            this.diplomacyFilter = this.diplomacyFilter != DiplomacyTeamList.DiplomacyFilter.ALLIES ? DiplomacyTeamList.DiplomacyFilter.ALLIES : DiplomacyTeamList.DiplomacyFilter.ALL;
            this.listUpdateFilter();
        });
        this.neutralsButton = new RecruitsDiplomacyButton(RecruitsDiplomacyManager.DiplomacyStatus.NEUTRAL, this.guiLeft + buttonX + 21, this.guiTop + buttonY2, 21, 21, (Component)Component.m_237113_((String)""), button -> {
            this.diplomacyFilter = this.diplomacyFilter != DiplomacyTeamList.DiplomacyFilter.NEUTRALS ? DiplomacyTeamList.DiplomacyFilter.NEUTRALS : DiplomacyTeamList.DiplomacyFilter.ALL;
            this.listUpdateFilter();
        });
        this.enemiesButton = new RecruitsDiplomacyButton(RecruitsDiplomacyManager.DiplomacyStatus.ENEMY, this.guiLeft + buttonX + 21 + 21, this.guiTop + buttonY2, 21, 21, (Component)Component.m_237113_((String)""), button -> {
            this.diplomacyFilter = this.diplomacyFilter != DiplomacyTeamList.DiplomacyFilter.ENEMIES ? DiplomacyTeamList.DiplomacyFilter.ENEMIES : DiplomacyTeamList.DiplomacyFilter.ALL;
            this.listUpdateFilter();
        });
        this.listUpdateFilter();
        this.m_142416_((GuiEventListener)this.alliesButton);
        this.m_142416_((GuiEventListener)this.enemiesButton);
        this.m_142416_((GuiEventListener)this.neutralsButton);
    }

    private void listUpdateFilter() {
        this.alliesButton.f_93623_ = this.diplomacyFilter == DiplomacyTeamList.DiplomacyFilter.ALLIES;
        this.enemiesButton.f_93623_ = this.diplomacyFilter == DiplomacyTeamList.DiplomacyFilter.ENEMIES;
        this.neutralsButton.f_93623_ = this.diplomacyFilter == DiplomacyTeamList.DiplomacyFilter.NEUTRALS;
        this.list.diplomacyFilter = this.diplomacyFilter;
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.searchBox != null) {
            this.searchBox.m_94120_();
        }
        if (this.list != null) {
            this.list.tick();
        }
    }

    public boolean m_7933_(int p_96552_, int p_96553_, int p_96554_) {
        boolean flag = super.m_7933_(p_96552_, p_96553_, p_96554_);
        this.selected = null;
        this.list.m_7522_(null);
        this.setStanceButton.f_93623_ = false;
        return flag;
    }

    public void m_7379_() {
        super.m_7379_();
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, 32);
        for (int i = 0; i < this.units; ++i) {
            guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop + 32 + 18 * i, 0, 32, this.xSize, 18);
        }
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop + 32 + 18 * this.units, 0, 50, this.xSize, 32);
        guiGraphics.m_280218_(TEXTURE, this.guiLeft + 10, this.guiTop + 32 + 6 - 2, this.xSize, 0, 12, 12);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.m_280614_(this.f_96547_, this.m_96636_(), this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)TITLE) / 2, this.guiTop + 5, 0x404040, false);
        if (!this.list.isEmpty()) {
            this.list.m_88315_(guiGraphics, mouseX, mouseY, delta);
        } else if (!this.searchBox.m_94155_().isEmpty()) {
            int n = this.f_96543_ / 2;
            int n2 = this.guiTop + 32 + this.units * 18 / 2;
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280137_(this.f_96547_, "EMPTY_SEARCH", n, n2 - 9 / 2, -1);
        }
        if (!this.searchBox.m_93696_() && this.searchBox.m_94155_().isEmpty()) {
            guiGraphics.m_280056_(this.f_96547_, "", this.searchBox.m_252754_(), this.searchBox.m_252907_(), -1, false);
        }
        this.searchBox.m_88315_(guiGraphics, mouseX, mouseY, delta);
    }

    private void checkSearchStringUpdate(String string) {
        if (!(string = string.toLowerCase(Locale.ROOT)).equals(this.lastSearch)) {
            this.list.setFilter(string);
            this.lastSearch = string;
        }
    }

    public boolean m_6375_(double x, double y, int button) {
        if (this.list != null) {
            this.list.m_6375_(x, y, button);
        }
        boolean flag = super.m_6375_(x, y, button);
        boolean isDoubleClick = false;
        long now = System.currentTimeMillis();
        if (button == 0) {
            if (now - this.lastClickTime <= 250L) {
                isDoubleClick = true;
            }
            this.lastClickTime = now;
        }
        if (this.list.m_7222_() != null) {
            this.selected = ((DiplomacyTeamEntry)this.list.m_7222_()).team;
            this.setStanceButton.f_93623_ = true;
        }
        if (isDoubleClick && this.selected != null) {
            this.onDoubleClick(this.selected);
        }
        return flag;
    }

    private void onDoubleClick(RecruitsFaction faction) {
        this.f_96541_.m_91152_((Screen)new DiplomacyEditScreen(this, faction));
        this.selected = null;
    }

    public RecruitsFaction getSelected() {
        return this.selected;
    }

    public Component m_96636_() {
        return TITLE;
    }
}

