/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.diplomacy;

import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.client.ClientManager;
import com.talhanation.recruits.client.gui.RecruitsScreenBase;
import com.talhanation.recruits.client.gui.component.BannerRenderer;
import com.talhanation.recruits.client.gui.diplomacy.RecruitsDiplomacyButton;
import com.talhanation.recruits.network.MessageChangeDiplomacyStatus;
import com.talhanation.recruits.world.RecruitsDiplomacyManager;
import com.talhanation.recruits.world.RecruitsFaction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;

public class DiplomacyEditScreen
extends RecruitsScreenBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("recruits", "textures/gui/gui_big.png");
    private static final Component TITLE = Component.m_237115_((String)"gui.recruits.diplomacy_edit.title");
    protected static final Component BUTTON_CONFIRM = Component.m_237115_((String)"gui.recruits.button.confirm");
    protected static final Component BUTTON_BACK = Component.m_237115_((String)"gui.recruits.button.back");
    private Screen parent;
    private RecruitsFaction otherTeam;
    private RecruitsDiplomacyButton allyButton;
    private RecruitsDiplomacyButton neutralButton;
    private RecruitsDiplomacyButton enemyButton;
    public RecruitsDiplomacyManager.DiplomacyStatus othersStance;
    public RecruitsDiplomacyManager.DiplomacyStatus ownStance;
    public RecruitsDiplomacyManager.DiplomacyStatus newStance;
    protected final BannerRenderer bannerOwn;
    protected final BannerRenderer bannerOther;
    private boolean stanceChanged;
    private Button confirmButton;
    private Button backButton;
    private boolean isLeader;
    int x3 = 120;
    int y3 = 90;
    int x4 = 60;
    int y4 = 90;
    int x5 = -70;
    int y5 = -30;
    int x6 = 70;
    int y6 = -30;
    int x7 = 35;
    int y7 = -100;
    int x8 = -25;
    int y8 = -100;
    int x1 = 15;
    int y1 = 75;
    int x2 = 160;
    int y2 = 75;

    public DiplomacyEditScreen(Screen parent, @NotNull RecruitsFaction otherTeam) {
        super(TITLE, 195, 160);
        this.otherTeam = otherTeam;
        this.parent = parent;
        this.bannerOwn = new BannerRenderer(ClientManager.ownFaction);
        this.bannerOther = new BannerRenderer(otherTeam);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        if (ClientManager.ownFaction == null) {
            return;
        }
        this.isLeader = ClientManager.ownFaction.teamLeaderID.equals(Minecraft.m_91087_().f_91074_.m_20148_());
        this.othersStance = ClientManager.getRelation(this.otherTeam.getStringID(), ClientManager.ownFaction.getStringID());
        this.ownStance = ClientManager.getRelation(ClientManager.ownFaction.getStringID(), this.otherTeam.getStringID());
        this.hoverAreas.clear();
        this.newStance = this.ownStance;
        this.setButtons();
    }

    public void m_86600_() {
        super.m_86600_();
        this.othersStance = ClientManager.getRelation(this.otherTeam.getStringID(), ClientManager.ownFaction.getStringID());
        this.ownStance = ClientManager.getRelation(ClientManager.ownFaction.getStringID(), this.otherTeam.getStringID());
    }

    private void setButtons() {
        this.m_169413_();
        this.allyButton = new RecruitsDiplomacyButton(RecruitsDiplomacyManager.DiplomacyStatus.ALLY, 60 + this.guiLeft + 6, this.guiTop + this.ySize - 6 - 125, 21, 21, (Component)Component.m_237113_((String)""), button -> {
            this.newStance = RecruitsDiplomacyManager.DiplomacyStatus.ALLY;
            this.stanceChanged = this.newStance != this.ownStance;
            this.setButtons();
        });
        this.m_142416_((GuiEventListener)this.allyButton);
        this.neutralButton = new RecruitsDiplomacyButton(RecruitsDiplomacyManager.DiplomacyStatus.NEUTRAL, 60 + this.guiLeft + 27, this.guiTop + this.ySize - 6 - 125, 21, 21, (Component)Component.m_237113_((String)""), button -> {
            this.newStance = RecruitsDiplomacyManager.DiplomacyStatus.NEUTRAL;
            this.stanceChanged = this.newStance != this.ownStance;
            this.setButtons();
        });
        this.m_142416_((GuiEventListener)this.neutralButton);
        this.enemyButton = new RecruitsDiplomacyButton(RecruitsDiplomacyManager.DiplomacyStatus.ENEMY, 60 + this.guiLeft + 48, this.guiTop + this.ySize - 6 - 125, 21, 21, (Component)Component.m_237113_((String)""), button -> {
            this.newStance = RecruitsDiplomacyManager.DiplomacyStatus.ENEMY;
            this.stanceChanged = this.newStance != this.ownStance;
            this.setButtons();
        });
        this.m_142416_((GuiEventListener)this.enemyButton);
        this.allyButton.f_93623_ = this.newStance == RecruitsDiplomacyManager.DiplomacyStatus.ALLY;
        this.neutralButton.f_93623_ = this.newStance == RecruitsDiplomacyManager.DiplomacyStatus.NEUTRAL;
        this.enemyButton.f_93623_ = this.newStance == RecruitsDiplomacyManager.DiplomacyStatus.ENEMY;
        this.allyButton.f_93624_ = this.isLeader;
        this.neutralButton.f_93624_ = this.isLeader;
        this.enemyButton.f_93624_ = this.isLeader;
        this.confirmButton = new ExtendedButton(this.guiLeft + 6, this.guiTop + this.ySize - 18 - 7, 90, 20, BUTTON_CONFIRM, button -> {
            this.changeDiplomacyStatus(this.newStance, this.otherTeam);
            this.ownStance = this.newStance;
            this.stanceChanged = false;
            this.setButtons();
        });
        this.confirmButton.f_93623_ = this.stanceChanged;
        this.confirmButton.f_93624_ = this.isLeader;
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.backButton = new ExtendedButton(this.guiLeft + 98, this.guiTop + this.ySize - 18 - 7, 90, 20, BUTTON_BACK, button -> this.f_96541_.m_91152_(this.parent));
        this.m_142416_((GuiEventListener)this.backButton);
    }

    private void changeDiplomacyStatus(RecruitsDiplomacyManager.DiplomacyStatus status, RecruitsFaction otherTeam) {
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageChangeDiplomacyStatus(ClientManager.ownFaction, otherTeam, status));
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (ClientManager.ownFaction == null) {
            return;
        }
        guiGraphics.m_280614_(this.f_96547_, TITLE, this.guiLeft + this.xSize / 2 - this.f_96547_.m_92852_((FormattedText)TITLE) / 2, this.guiTop + 7, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, ClientManager.ownFaction.getTeamDisplayName(), this.x5 + this.guiLeft + this.xSize / 2 - this.f_96547_.m_92895_(ClientManager.ownFaction.getTeamDisplayName()) / 2, this.guiTop + 7 - this.y5, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, this.otherTeam.getTeamDisplayName(), this.x6 + this.guiLeft + this.xSize / 2 - this.f_96547_.m_92895_(this.otherTeam.getTeamDisplayName()) / 2, this.guiTop + 7 - this.y6, 0x404040, false);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getDiplomacyStatusIcon(this.othersStance));
        guiGraphics.m_280163_(this.getDiplomacyStatusIcon(this.othersStance), this.guiLeft + this.x3, this.guiTop + this.ySize - this.y3, 0.0f, 0.0f, 21, 21, 21, 21);
        guiGraphics.m_280056_(this.f_96547_, this.othersStance.name(), this.x7 + this.guiLeft + this.xSize / 2 - this.f_96547_.m_92895_(this.othersStance.name()) / 2, this.guiTop + 7 - this.y7, 0x404040, false);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getDiplomacyStatusIcon(this.newStance));
        guiGraphics.m_280163_(this.getDiplomacyStatusIcon(this.newStance), this.guiLeft + this.x4, this.guiTop + this.ySize - this.y4, 0.0f, 0.0f, 21, 21, 21, 21);
        guiGraphics.m_280056_(this.f_96547_, this.newStance.name(), this.x8 + this.guiLeft + this.xSize / 2 - this.f_96547_.m_92895_(this.newStance.name()) / 2, this.guiTop + 7 - this.y8, 0x404040, false);
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.bannerOwn.renderBanner(guiGraphics, this.guiLeft + this.x1, this.guiTop + this.ySize - this.y1, this.f_96543_, this.f_96544_, 40);
        this.bannerOther.renderBanner(guiGraphics, this.guiLeft + this.x2, this.guiTop + this.ySize - this.y2, this.f_96543_, this.f_96544_, 40);
    }

    public ResourceLocation getDiplomacyStatusIcon(RecruitsDiplomacyManager.DiplomacyStatus status) {
        return switch (status) {
            default -> new ResourceLocation("recruits", "textures/gui/image/neutral.png");
            case RecruitsDiplomacyManager.DiplomacyStatus.ALLY -> new ResourceLocation("recruits", "textures/gui/image/ally.png");
            case RecruitsDiplomacyManager.DiplomacyStatus.ENEMY -> new ResourceLocation("recruits", "textures/gui/image/enemy.png");
        };
    }

    public void m_7379_() {
        super.m_7379_();
    }
}

