/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.client.gui.RecruitsScreenBase;
import com.talhanation.recruits.client.gui.component.ActivateableButton;
import com.talhanation.recruits.entities.ScoutEntity;
import com.talhanation.recruits.network.MessageScoutTask;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ScoutScreen
extends RecruitsScreenBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("recruits", "textures/gui/gui_big.png");
    private static final Component TITLE = Component.m_237115_((String)"gui.recruits.more_screen.title");
    private final Player player;
    private final ScoutEntity scout;
    private ScoutEntity.State task;
    private static final MutableComponent SCOUTING = Component.m_237115_((String)"gui.recruits.inv.text.scoutScoutTask");
    private static final MutableComponent TOOLTIP_SCOUTING = Component.m_237115_((String)"gui.recruits.inv.tooltip.scoutScoutTask");
    private ActivateableButton buttonScouting;

    public ScoutScreen(ScoutEntity scout, Player player) {
        super(TITLE, 195, 160);
        this.player = player;
        this.scout = scout;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.task = ScoutEntity.State.fromIndex(this.scout.getTaskState());
        this.setButtons();
    }

    private void setButtons() {
        this.m_169413_();
        this.buttonScouting = new ActivateableButton(this.guiLeft + 32, this.guiTop + this.ySize - 120 - 7, 130, 20, (Component)SCOUTING, btn -> {
            if (this.scout != null) {
                if (this.task != ScoutEntity.State.SCOUTING) {
                    this.task = ScoutEntity.State.SCOUTING;
                    Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageScoutTask(this.scout.m_20148_(), 1));
                } else {
                    this.task = ScoutEntity.State.IDLE;
                    Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageScoutTask(this.scout.m_20148_(), 0));
                }
                this.setButtons();
            }
        });
        this.buttonScouting.f_93623_ = this.task == ScoutEntity.State.SCOUTING;
        this.buttonScouting.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_SCOUTING));
        this.m_142416_((GuiEventListener)this.buttonScouting);
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.task != null) {
            Object text = "";
            text = this.task == ScoutEntity.State.IDLE ? "No Active Task" : "Active Task: " + this.task.name();
            guiGraphics.m_280056_(this.f_96547_, (String)text, this.guiLeft + this.xSize / 2 - this.f_96547_.m_92895_((String)text) / 2, this.guiTop + 17, 0x404040, false);
        }
    }
}

