/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits;

import com.talhanation.recruits.FactionEvents;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.BowmanEntity;
import com.talhanation.recruits.entities.CrossBowmanEntity;
import com.talhanation.recruits.entities.HorsemanEntity;
import com.talhanation.recruits.entities.ICompanion;
import com.talhanation.recruits.entities.NomadEntity;
import com.talhanation.recruits.entities.RecruitEntity;
import com.talhanation.recruits.entities.RecruitShieldmanEntity;
import com.talhanation.recruits.entities.VillagerNobleEntity;
import com.talhanation.recruits.entities.ai.villager.VillagerBecomeNobleGoal;
import com.talhanation.recruits.init.ModBlocks;
import com.talhanation.recruits.init.ModEntityTypes;
import com.talhanation.recruits.init.ModProfessions;
import com.talhanation.recruits.world.RecruitsGroup;
import com.talhanation.recruits.world.RecruitsHireTradesRegistry;
import com.talhanation.recruits.world.RecruitsPatrolSpawn;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VillagerEvents {
    protected final Random random = new Random();
    public HashMap<VillagerProfession, EntityType<? extends AbstractRecruitEntity>> entitiesByProfession = new HashMap<VillagerProfession, EntityType<? extends AbstractRecruitEntity>>(){
        {
            this.put((VillagerProfession)ModProfessions.RECRUIT.get(), (EntityType)ModEntityTypes.RECRUIT.get());
            this.put((VillagerProfession)ModProfessions.BOWMAN.get(), (EntityType)ModEntityTypes.BOWMAN.get());
            this.put((VillagerProfession)ModProfessions.SHIELDMAN.get(), (EntityType)ModEntityTypes.RECRUIT_SHIELDMAN.get());
            this.put((VillagerProfession)ModProfessions.HORSEMAN.get(), (EntityType)ModEntityTypes.HORSEMAN.get());
            this.put((VillagerProfession)ModProfessions.NOMAD.get(), (EntityType)ModEntityTypes.NOMAD.get());
            this.put((VillagerProfession)ModProfessions.CROSSBOWMAN.get(), (EntityType)ModEntityTypes.CROSSBOWMAN.get());
        }
    };

    private static void spawnRecruits(ServerLevel level, BlockPos villagePos) {
        Random random = new Random();
        BlockPos spawnPos = RecruitsPatrolSpawn.func_221244_a(villagePos, 20, random, level);
        if (spawnPos != null && RecruitsPatrolSpawn.func_226559_a_(spawnPos, level) && spawnPos.m_123331_((Vec3i)villagePos) > 10.0) {
            BlockPos upPos = new BlockPos(spawnPos.m_123341_(), spawnPos.m_123342_() + 2, spawnPos.m_123343_());
            int i = random.nextInt(4);
            switch (i) {
                default: {
                    VillagerEvents.spawnSmallGuardRecruits(upPos, level, random);
                    break;
                }
                case 1: {
                    VillagerEvents.spawnMediumGuardRecruits(upPos, level, random);
                    break;
                }
                case 2: {
                    VillagerEvents.spawnLargeGuardRecruits(upPos, level, random);
                }
            }
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        RecruitsHireTradesRegistry.registerTrades();
    }

    @SubscribeEvent
    public void onPlayerJoiningServer(EntityJoinLevelEvent event) {
        Entity entity;
        if (event.getLevel().m_5776_() && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            if (Minecraft.m_91087_().f_91074_.m_20148_().equals(player.m_20148_())) {
                RecruitsHireTradesRegistry.registerTrades();
            }
        }
    }

    @SubscribeEvent
    public void onVillagerJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!((Boolean)RecruitsServerConfig.NobleVillagerSpawn.get()).booleanValue()) {
            return;
        }
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            villager.f_21345_.m_25352_(0, (Goal)new VillagerBecomeNobleGoal(villager));
        }
    }

    @SubscribeEvent
    public void onVillagerLivingUpdate(LivingEvent.LivingTickEvent event) {
        IronGolem ironGolemEntity;
        Villager villager;
        VillagerProfession profession;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Villager && this.entitiesByProfession.containsKey(profession = (villager = (Villager)entity).m_7141_().m_35571_())) {
            EntityType<? extends AbstractRecruitEntity> recruitType = this.entitiesByProfession.get(profession);
            VillagerEvents.createRecruit(villager, recruitType);
        }
        if (entity instanceof IronGolem && !(ironGolemEntity = (IronGolem)entity).m_28876_() && ((Boolean)RecruitsServerConfig.OverrideIronGolemSpawn.get()).booleanValue()) {
            List list1 = entity.m_20193_().m_45976_(AbstractRecruitEntity.class, ironGolemEntity.m_20191_().m_82400_(32.0));
            list1.removeIf(recruit -> recruit instanceof VillagerNobleEntity);
            if (list1.size() > 1) {
                ironGolemEntity.m_142687_(Entity.RemovalReason.KILLED);
            } else {
                int i = this.random.nextInt(6);
                if (i == 1) {
                    VillagerEvents.createBowmanIronGolem((LivingEntity)ironGolemEntity);
                }
                if (i == 2) {
                    VillagerEvents.createCrossbowmanIronGolem((LivingEntity)ironGolemEntity);
                } else if (i == 0) {
                    this.createRecruitShieldmanIronGolem((LivingEntity)ironGolemEntity);
                } else {
                    VillagerEvents.createRecruitIronGolem((LivingEntity)ironGolemEntity);
                }
            }
        }
    }

    private static void createRecruit(Villager villager, EntityType<? extends AbstractRecruitEntity> recruitType) {
        AbstractRecruitEntity abstractRecruit = (AbstractRecruitEntity)recruitType.m_20615_(villager.m_20193_());
        if (abstractRecruit != null) {
            abstractRecruit.m_20359_((Entity)villager);
            abstractRecruit.initSpawn();
            for (ItemStack itemStack : villager.m_35311_().f_19147_) {
                abstractRecruit.getInventory().m_19173_(itemStack);
            }
            if (abstractRecruit instanceof ICompanion) {
                for (int i = 0; i < 4; ++i) {
                    abstractRecruit.addXp((Integer)RecruitsServerConfig.RecruitsMaxXpForLevelUp.get());
                    abstractRecruit.checkLevel();
                }
            }
            villager.m_20193_().m_7967_((Entity)abstractRecruit);
            Component name = villager.m_7770_();
            if (name != null) {
                abstractRecruit.m_6593_(name);
            }
            if (((Boolean)RecruitsServerConfig.RecruitTablesPOIReleasing.get()).booleanValue()) {
                villager.m_35428_(MemoryModuleType.f_26360_);
            }
            villager.m_35428_(MemoryModuleType.f_26359_);
            villager.m_35428_(MemoryModuleType.f_26362_);
            villager.m_146870_();
        }
    }

    public static void createNobleVillager(Villager villager) {
        Level level = villager.m_20193_();
        VillagerNobleEntity nobleEntity = (VillagerNobleEntity)((EntityType)ModEntityTypes.VILLAGER_NOBLE.get()).m_20615_(level);
        if (nobleEntity != null && !level.m_5776_()) {
            Optional meetingMemory;
            Optional homeMemory;
            nobleEntity.m_20359_((Entity)villager);
            nobleEntity.initSpawn();
            nobleEntity.setFollowState(0);
            for (ItemStack itemStack : villager.m_35311_().f_19147_) {
                nobleEntity.getInventory().m_19173_(itemStack);
            }
            Component name = villager.m_7770_();
            if (name != null) {
                nobleEntity.m_6593_(name);
            }
            if ((homeMemory = villager.m_6274_().m_21952_(MemoryModuleType.f_26359_)).isPresent()) {
                nobleEntity.m_21250_(((GlobalPos)homeMemory.get()).m_122646_());
                nobleEntity.setShouldRest(true);
            }
            if ((meetingMemory = villager.m_6274_().m_21952_(MemoryModuleType.f_26362_)).isPresent()) {
                nobleEntity.setHoldPos(((GlobalPos)meetingMemory.get()).m_122646_().m_252807_());
            }
            villager.m_20193_().m_7967_((Entity)nobleEntity);
            if (((Boolean)RecruitsServerConfig.RecruitTablesPOIReleasing.get()).booleanValue()) {
                villager.m_35428_(MemoryModuleType.f_26360_);
            }
            villager.m_35428_(MemoryModuleType.f_26359_);
            villager.m_35428_(MemoryModuleType.f_26362_);
            villager.m_146870_();
        }
    }

    public static void createHiredRecruitFromVillager(ServerLevel serverLevel, Villager villager, EntityType<? extends AbstractRecruitEntity> recruitType, Player player, RecruitsGroup group) {
        AbstractRecruitEntity abstractRecruit = (AbstractRecruitEntity)recruitType.m_20615_(villager.m_20193_());
        if (abstractRecruit != null && abstractRecruit.hire(player, group)) {
            abstractRecruit.m_20359_((Entity)villager);
            abstractRecruit.initSpawn();
            abstractRecruit.setFollowState(1);
            for (ItemStack itemStack : villager.m_35311_().f_19147_) {
                abstractRecruit.getInventory().m_19173_(itemStack);
            }
            abstractRecruit.setGroupUUID(group.getUUID());
            if (abstractRecruit instanceof ICompanion) {
                for (int i = 0; i < 4; ++i) {
                    abstractRecruit.addXp((Integer)RecruitsServerConfig.RecruitsMaxXpForLevelUp.get());
                    abstractRecruit.checkLevel();
                }
            }
            villager.m_20193_().m_7967_((Entity)abstractRecruit);
            Component name = villager.m_7770_();
            if (name != null && !name.getString().isEmpty()) {
                abstractRecruit.m_6593_(name);
            }
            if (((Boolean)RecruitsServerConfig.RecruitTablesPOIReleasing.get()).booleanValue()) {
                villager.m_35428_(MemoryModuleType.f_26360_);
            }
            villager.m_35428_(MemoryModuleType.f_26359_);
            villager.m_35428_(MemoryModuleType.f_26362_);
            villager.m_146870_();
            FactionEvents.doPayment(player, abstractRecruit.getCost());
        }
    }

    public static void spawnHiredRecruit(ServerLevel serverLevel, EntityType<? extends AbstractRecruitEntity> recruitType, Player player, RecruitsGroup group) {
        AbstractRecruitEntity abstractRecruit = (AbstractRecruitEntity)recruitType.m_20615_(player.m_20193_());
        if (abstractRecruit != null && abstractRecruit.hire(player, null)) {
            abstractRecruit.m_20359_((Entity)player);
            if (abstractRecruit instanceof ICompanion) {
                for (int i = 0; i < 4; ++i) {
                    abstractRecruit.addXp((Integer)RecruitsServerConfig.RecruitsMaxXpForLevelUp.get());
                    abstractRecruit.checkLevel();
                }
            }
            abstractRecruit.initSpawn();
            abstractRecruit.setFollowState(1);
            abstractRecruit.setGroupUUID(group.getUUID());
            player.m_20193_().m_7967_((Entity)abstractRecruit);
            FactionEvents.doPayment(player, abstractRecruit.getCost());
        }
    }

    @SubscribeEvent
    public void villagerTrades(VillagerTradesEvent event) {
        List list;
        Trade block_trade;
        if (!((Boolean)RecruitsServerConfig.ShouldProfessionBlocksTrade.get()).booleanValue()) {
            return;
        }
        if (event.getType() == VillagerProfession.f_35586_) {
            block_trade = new Trade((ItemLike)Items.f_42616_, 15, (ItemLike)ModBlocks.RECRUIT_SHIELD_BLOCK.get(), 1, 2, 20);
            list = (List)event.getTrades().get(2);
            list.add(block_trade);
            event.getTrades().put(2, (Object)list);
        }
        if (event.getType() == VillagerProfession.f_35599_) {
            block_trade = new Trade((ItemLike)Items.f_42616_, 8, (ItemLike)ModBlocks.RECRUIT_BLOCK.get(), 1, 2, 20);
            list = (List)event.getTrades().get(2);
            list.add(block_trade);
            event.getTrades().put(2, (Object)list);
        }
        if (event.getType() == VillagerProfession.f_35592_) {
            block_trade = new Trade((ItemLike)Items.f_42616_, 10, (ItemLike)ModBlocks.BOWMAN_BLOCK.get(), 1, 2, 20);
            list = (List)event.getTrades().get(2);
            list.add(block_trade);
            event.getTrades().put(2, (Object)list);
        }
        if (event.getType() == VillagerProfession.f_35592_) {
            block_trade = new Trade((ItemLike)Items.f_42616_, 20, (ItemLike)ModBlocks.CROSSBOWMAN_BLOCK.get(), 1, 2, 20);
            list = (List)event.getTrades().get(2);
            list.add(block_trade);
            event.getTrades().put(2, (Object)list);
        }
        if (event.getType() == VillagerProfession.f_35588_) {
            block_trade = new Trade((ItemLike)Items.f_42616_, 30, (ItemLike)ModBlocks.NOMAD_BLOCK.get(), 1, 2, 20);
            list = (List)event.getTrades().get(2);
            list.add(block_trade);
            event.getTrades().put(2, (Object)list);
        }
        if (event.getType() == VillagerProfession.f_35587_) {
            block_trade = new Trade((ItemLike)Items.f_42616_, 30, (ItemLike)ModBlocks.HORSEMAN_BLOCK.get(), 1, 2, 20);
            list = (List)event.getTrades().get(2);
            list.add(block_trade);
            event.getTrades().put(2, (Object)list);
        }
    }

    private static void createRecruitIronGolem(LivingEntity entity) {
        RecruitEntity recruit = (RecruitEntity)((EntityType)ModEntityTypes.RECRUIT.get()).m_20615_(entity.m_20193_());
        IronGolem villager = (IronGolem)entity;
        recruit.m_20359_((Entity)villager);
        recruit.initSpawn();
        villager.m_142687_(Entity.RemovalReason.DISCARDED);
        recruit.getInventory().m_6836_(8, Items.f_42406_.m_7968_());
        villager.m_142687_(Entity.RemovalReason.DISCARDED);
        villager.m_20193_().m_7967_((Entity)recruit);
    }

    private void createRecruitShieldmanIronGolem(LivingEntity entity) {
        RecruitShieldmanEntity recruitShieldman = (RecruitShieldmanEntity)((EntityType)ModEntityTypes.RECRUIT_SHIELDMAN.get()).m_20615_(entity.m_20193_());
        IronGolem villager = (IronGolem)entity;
        recruitShieldman.m_20359_((Entity)villager);
        recruitShieldman.initSpawn();
        recruitShieldman.getInventory().m_6836_(8, Items.f_42406_.m_7968_());
        villager.m_142687_(Entity.RemovalReason.DISCARDED);
        villager.m_20193_().m_7967_((Entity)recruitShieldman);
    }

    private static void createBowmanIronGolem(LivingEntity entity) {
        BowmanEntity bowman = (BowmanEntity)((EntityType)ModEntityTypes.BOWMAN.get()).m_20615_(entity.m_20193_());
        IronGolem villager = (IronGolem)entity;
        bowman.m_20359_((Entity)villager);
        bowman.initSpawn();
        bowman.getInventory().m_6836_(8, Items.f_42406_.m_7968_());
        villager.m_142687_(Entity.RemovalReason.DISCARDED);
        villager.m_20193_().m_7967_((Entity)bowman);
    }

    private static void createCrossbowmanIronGolem(LivingEntity entity) {
        CrossBowmanEntity crossBowmanEntity = (CrossBowmanEntity)((EntityType)ModEntityTypes.CROSSBOWMAN.get()).m_20615_(entity.m_20193_());
        IronGolem villager = (IronGolem)entity;
        crossBowmanEntity.m_20359_((Entity)villager);
        crossBowmanEntity.initSpawn();
        crossBowmanEntity.getInventory().m_6836_(8, Items.f_42406_.m_7968_());
        villager.m_142687_(Entity.RemovalReason.DISCARDED);
        villager.m_20193_().m_7967_((Entity)crossBowmanEntity);
    }

    private static void spawnSmallGuardRecruits(BlockPos upPos, ServerLevel world, Random random) {
        RecruitEntity guardLeader = VillagerEvents.createGuardLeader(upPos, "Village Guard Leader", world, random);
        VillagerEvents.createGuardRecruit(upPos, guardLeader, "Village Guard", world, random);
        VillagerEvents.createGuardRecruit(upPos, guardLeader, "Village Guard", world, random);
        VillagerEvents.createGuardShieldman(upPos, guardLeader, "Village Guard", world, random);
        VillagerEvents.createGuardBowman(upPos, guardLeader, world, random);
    }

    private static void spawnMediumGuardRecruits(BlockPos upPos, ServerLevel world, Random random) {
        RecruitEntity guardLeader = VillagerEvents.createGuardLeader(upPos, "Village Guard Leader", world, random);
        VillagerEvents.createGuardShieldman(upPos, guardLeader, "Village Guard", world, random);
        VillagerEvents.createGuardShieldman(upPos, guardLeader, "Village Guard", world, random);
        VillagerEvents.createGuardBowman(upPos, guardLeader, world, random);
        VillagerEvents.createGuardBowman(upPos, guardLeader, world, random);
        VillagerEvents.createPatrolCrossbowman(upPos, guardLeader, world, random);
        VillagerEvents.createPatrolCrossbowman(upPos, guardLeader, world, random);
        VillagerEvents.createGuardHorseman(upPos, guardLeader, "Village Guard", world, random);
        VillagerEvents.createGuardNomad(upPos, guardLeader, "Village Guard", world, random);
    }

    private static void spawnLargeGuardRecruits(BlockPos upPos, ServerLevel world, Random random) {
        RecruitEntity guardLeader = VillagerEvents.createGuardLeader(upPos, "Village Guard Leader", world, random);
        VillagerEvents.createGuardRecruit(upPos, guardLeader, "Village Guard", world, random);
        VillagerEvents.createGuardRecruit(upPos, guardLeader, "Village Guard", world, random);
        VillagerEvents.createGuardShieldman(upPos, guardLeader, "Village Guard", world, random);
        VillagerEvents.createGuardShieldman(upPos, guardLeader, "Village Guard", world, random);
        VillagerEvents.createGuardShieldman(upPos, guardLeader, "Village Guard", world, random);
        VillagerEvents.createGuardBowman(upPos, guardLeader, world, random);
        VillagerEvents.createGuardBowman(upPos, guardLeader, world, random);
        VillagerEvents.createGuardBowman(upPos, guardLeader, world, random);
        VillagerEvents.createPatrolCrossbowman(upPos, guardLeader, world, random);
        VillagerEvents.createPatrolCrossbowman(upPos, guardLeader, world, random);
        VillagerEvents.createPatrolCrossbowman(upPos, guardLeader, world, random);
        VillagerEvents.createGuardHorseman(upPos, guardLeader, "Village Guard", world, random);
        VillagerEvents.createGuardNomad(upPos, guardLeader, "Village Guard", world, random);
        VillagerEvents.createGuardHorseman(upPos, guardLeader, "Village Guard", world, random);
        VillagerEvents.createGuardNomad(upPos, guardLeader, "Village Guard", world, random);
    }

    public static RecruitEntity createGuardLeader(BlockPos upPos, String name, ServerLevel world, Random random) {
        RecruitEntity patrolLeader = (RecruitEntity)((EntityType)ModEntityTypes.RECRUIT.get()).m_20615_((Level)world);
        patrolLeader.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        patrolLeader.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        VillagerEvents.setGuardLeaderEquipment(patrolLeader);
        patrolLeader.m_21530_();
        patrolLeader.setXpLevel(1 + random.nextInt(2));
        patrolLeader.addLevelBuffsForLevel(patrolLeader.getXpLevel());
        patrolLeader.setHunger(100.0f);
        patrolLeader.setMoral(100.0f);
        patrolLeader.setCost(45);
        patrolLeader.setXp(random.nextInt(200));
        patrolLeader.m_6593_((Component)Component.m_237113_((String)name));
        patrolLeader.setProtectUUID(Optional.of(patrolLeader.m_20148_()));
        world.m_7967_((Entity)patrolLeader);
        return patrolLeader;
    }

    public static void setGuardLeaderEquipment(RecruitEntity recruit) {
        Random random = new Random();
        recruit.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42464_));
        recruit.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
        recruit.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42470_));
        recruit.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42471_));
        int j = random.nextInt(10);
        ItemStack item = new ItemStack((ItemLike)Items.f_42616_);
        item.m_41764_(8 + j);
        recruit.inventory.m_6836_(8, item);
        recruit.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
        recruit.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
        int k = random.nextInt(8);
        ItemStack food = switch (k) {
            default -> new ItemStack((ItemLike)Items.f_42406_);
            case 1 -> new ItemStack((ItemLike)Items.f_42580_);
            case 2 -> new ItemStack((ItemLike)Items.f_42582_);
            case 3 -> new ItemStack((ItemLike)Items.f_42659_);
        };
        food.m_41764_(32 + k);
        recruit.inventory.m_6836_(7, food);
    }

    private static void createGuardRecruit(BlockPos upPos, RecruitEntity patrolLeader, String name, ServerLevel world, Random random) {
        RecruitEntity recruitEntity = (RecruitEntity)((EntityType)ModEntityTypes.RECRUIT.get()).m_20615_((Level)world);
        recruitEntity.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        recruitEntity.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        recruitEntity.m_21530_();
        recruitEntity.setEquipment();
        recruitEntity.setXpLevel(1 + random.nextInt(2));
        recruitEntity.addLevelBuffsForLevel(recruitEntity.getXpLevel());
        recruitEntity.setHunger(80.0f);
        recruitEntity.setMoral(65.0f);
        recruitEntity.setCost(10);
        recruitEntity.setProtectUUID(Optional.of(patrolLeader.m_20148_()));
        recruitEntity.setShouldProtect(true);
        recruitEntity.setXp(random.nextInt(80));
        recruitEntity.m_6593_((Component)Component.m_237113_((String)name));
        world.m_7967_((Entity)recruitEntity);
    }

    private static void createGuardBowman(BlockPos upPos, RecruitEntity patrolLeader, ServerLevel world, Random random) {
        BowmanEntity bowman = (BowmanEntity)((EntityType)ModEntityTypes.BOWMAN.get()).m_20615_((Level)world);
        bowman.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        bowman.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        bowman.setEquipment();
        bowman.m_21530_();
        bowman.setXpLevel(1 + random.nextInt(2));
        bowman.addLevelBuffsForLevel(bowman.getXpLevel());
        bowman.setHunger(80.0f);
        bowman.setMoral(65.0f);
        bowman.setCost(16);
        bowman.setProtectUUID(Optional.of(patrolLeader.m_20148_()));
        bowman.setShouldProtect(true);
        bowman.setXp(random.nextInt(120));
        bowman.m_6593_((Component)Component.m_237113_((String)"Village Guard"));
        world.m_7967_((Entity)bowman);
    }

    private static void createGuardShieldman(BlockPos upPos, RecruitEntity patrolLeader, String name, ServerLevel world, Random random) {
        RecruitShieldmanEntity shieldmanEntity = (RecruitShieldmanEntity)((EntityType)ModEntityTypes.RECRUIT_SHIELDMAN.get()).m_20615_((Level)world);
        shieldmanEntity.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        shieldmanEntity.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        shieldmanEntity.setEquipment();
        shieldmanEntity.m_21530_();
        shieldmanEntity.setXpLevel(1 + random.nextInt(2));
        shieldmanEntity.addLevelBuffsForLevel(shieldmanEntity.getXpLevel());
        shieldmanEntity.setHunger(80.0f);
        shieldmanEntity.setMoral(65.0f);
        shieldmanEntity.setCost(24);
        shieldmanEntity.setProtectUUID(Optional.of(patrolLeader.m_20148_()));
        shieldmanEntity.setShouldProtect(true);
        shieldmanEntity.setXp(random.nextInt(120));
        shieldmanEntity.m_6593_((Component)Component.m_237113_((String)name));
        world.m_7967_((Entity)shieldmanEntity);
    }

    private static void createGuardHorseman(BlockPos upPos, RecruitEntity patrolLeader, String name, ServerLevel world, Random random) {
        HorsemanEntity horseman = (HorsemanEntity)((EntityType)ModEntityTypes.HORSEMAN.get()).m_20615_((Level)world);
        horseman.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        horseman.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        horseman.setEquipment();
        horseman.m_21530_();
        horseman.setXpLevel(1 + random.nextInt(2));
        horseman.addLevelBuffsForLevel(horseman.getXpLevel());
        horseman.setHunger(80.0f);
        horseman.setMoral(75.0f);
        horseman.setCost(20);
        horseman.setProtectUUID(Optional.of(patrolLeader.m_20148_()));
        horseman.setShouldProtect(true);
        horseman.setXp(random.nextInt(120));
        horseman.m_6593_((Component)Component.m_237113_((String)name));
        world.m_7967_((Entity)horseman);
    }

    private static void createGuardNomad(BlockPos upPos, RecruitEntity patrolLeader, String name, ServerLevel world, Random random) {
        NomadEntity nomad = (NomadEntity)((EntityType)ModEntityTypes.NOMAD.get()).m_20615_((Level)world);
        nomad.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        nomad.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        nomad.setEquipment();
        nomad.m_21530_();
        nomad.setXpLevel(1 + random.nextInt(2));
        nomad.addLevelBuffsForLevel(nomad.getXpLevel());
        nomad.setHunger(80.0f);
        nomad.setMoral(75.0f);
        nomad.setCost(25);
        nomad.setProtectUUID(Optional.of(patrolLeader.m_20148_()));
        nomad.setShouldProtect(true);
        nomad.setXp(random.nextInt(120));
        nomad.m_6593_((Component)Component.m_237113_((String)name));
        world.m_7967_((Entity)nomad);
    }

    private static void createPatrolCrossbowman(BlockPos upPos, RecruitEntity patrolLeader, ServerLevel world, Random random) {
        CrossBowmanEntity crossBowman = (CrossBowmanEntity)((EntityType)ModEntityTypes.CROSSBOWMAN.get()).m_20615_((Level)world);
        crossBowman.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        crossBowman.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        crossBowman.setEquipment();
        crossBowman.m_21530_();
        crossBowman.setXpLevel(1 + random.nextInt(3));
        crossBowman.addLevelBuffsForLevel(crossBowman.getXpLevel());
        crossBowman.setHunger(80.0f);
        crossBowman.setMoral(65.0f);
        crossBowman.setCost(32);
        crossBowman.setProtectUUID(Optional.of(patrolLeader.m_20148_()));
        crossBowman.setShouldProtect(true);
        crossBowman.setXp(random.nextInt(120));
        crossBowman.m_6593_((Component)Component.m_237113_((String)"Village Guard"));
        world.m_7967_((Entity)crossBowman);
    }

    static class Trade
    implements VillagerTrades.ItemListing {
        private final Item buyingItem;
        private final Item sellingItem;
        private final int buyingAmount;
        private final int sellingAmount;
        private final int maxUses;
        private final int givenExp;
        private final float priceMultiplier;

        public Trade(ItemLike buyingItem, int buyingAmount, ItemLike sellingItem, int sellingAmount, int maxUses, int givenExp) {
            this.buyingItem = buyingItem.m_5456_();
            this.buyingAmount = buyingAmount;
            this.sellingItem = sellingItem.m_5456_();
            this.sellingAmount = sellingAmount;
            this.maxUses = maxUses;
            this.givenExp = givenExp;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            return new MerchantOffer(new ItemStack((ItemLike)this.buyingItem, this.buyingAmount), new ItemStack((ItemLike)this.sellingItem, this.sellingAmount), this.maxUses, this.givenExp, this.priceMultiplier);
        }
    }
}

