/*
 * Decompiled with CFR 0.152.
 */
package fuzs.effectdescriptions.client.helper;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import fuzs.effectdescriptions.EffectDescriptions;
import fuzs.effectdescriptions.config.ClientConfig;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public class EffectLinesHelper {
    public static Optional<Component> getEffectDescriptionComponent(String id, boolean preventIndentation) {
        String description = Language.m_128107_().m_6722_(id + ".desc") ? id + ".desc" : (Language.m_128107_().m_6722_(id + ".description") ? id + ".description" : (Language.m_128107_().m_6722_("description." + id) ? "description." + id : null));
        if (description != null) {
            int indentation;
            MutableComponent component = Component.m_237115_((String)description);
            if (!preventIndentation && (indentation = ((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).descriptionIndentation) > 0) {
                component = Component.m_237113_((String)StringUtils.repeat((String)" ", (int)indentation)).m_7220_((Component)component);
            }
            return Optional.of(component.m_130940_(ChatFormatting.GRAY));
        }
        return Optional.empty();
    }

    public static void tryAddDisplayName(List<Component> lines, MobEffectInstance mobEffectInstance, boolean smallWidgets) {
        if (smallWidgets || ((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).alwaysAddEffectNameToTooltips) {
            MutableComponent effectComponent = Component.m_237115_((String)mobEffectInstance.m_19576_());
            if (mobEffectInstance.m_19564_() > 0) {
                effectComponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{effectComponent, Component.m_237115_((String)("potion.potency." + mobEffectInstance.m_19564_()))});
            }
            MutableComponent durationComponent = Component.m_237113_((String)"(").m_7220_(MobEffectUtil.m_267641_((MobEffectInstance)mobEffectInstance, (float)1.0f)).m_130946_(")");
            effectComponent.m_7220_(CommonComponents.f_263701_).m_7220_((Component)durationComponent);
            effectComponent.m_130940_(mobEffectInstance.m_19544_().m_19483_().m_19497_());
            lines.add((Component)effectComponent);
        }
    }

    public static void tryAddAttributes(List<Component> lines, MobEffectInstance mobEffectInstance) {
        if (!((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).addAttributesToWidgetTooltips) {
            return;
        }
        List<Pair<Attribute, AttributeModifier>> attributes = EffectLinesHelper.getAttributesFromEffects(List.of(mobEffectInstance));
        if (!attributes.isEmpty()) {
            lines.add(CommonComponents.f_237098_);
            lines.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair<Attribute, AttributeModifier> pair : attributes) {
                AttributeModifier attributeModifier = (AttributeModifier)pair.getSecond();
                double d0 = attributeModifier.m_22218_();
                double d1 = attributeModifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributeModifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributeModifier.m_22218_() : attributeModifier.m_22218_() * 100.0;
                if (d0 > 0.0) {
                    lines.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributeModifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lines.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributeModifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    private static List<Pair<Attribute, AttributeModifier>> getAttributesFromEffects(List<MobEffectInstance> effects) {
        ArrayList attributes = Lists.newArrayList();
        for (MobEffectInstance mobeffectinstance : effects) {
            for (Map.Entry entry : mobeffectinstance.m_19544_().m_19485_().entrySet()) {
                AttributeModifier attributeModifier = (AttributeModifier)entry.getValue();
                double attributeModifierValue = mobeffectinstance.m_19544_().m_7048_(mobeffectinstance.m_19564_(), attributeModifier);
                AttributeModifier newAttributeModifier = new AttributeModifier(attributeModifier.m_22214_(), attributeModifierValue, attributeModifier.m_22217_());
                attributes.add(new Pair((Object)((Attribute)entry.getKey()), (Object)newAttributeModifier));
            }
        }
        return attributes;
    }

    private static ChatFormatting getMobEffectColor(MobEffect mobEffect) {
        return switch (mobEffect.m_19483_()) {
            case MobEffectCategory.BENEFICIAL -> ChatFormatting.BLUE;
            case MobEffectCategory.HARMFUL -> ChatFormatting.RED;
            default -> ChatFormatting.GOLD;
        };
    }

    public static void tryAddModName(List<Component> lines, MobEffectInstance mobEffectInstance) {
        if (((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).addModNameToWidgetTooltips) {
            ModLoaderEnvironment.INSTANCE.getModName(BuiltInRegistries.f_256974_.m_7981_((Object)mobEffectInstance.m_19544_()).m_135827_()).map(s -> Component.m_237113_((String)s).m_130940_(ChatFormatting.BLUE)).ifPresent(lines::add);
        }
    }

    public static void tryAddInternalName(List<Component> lines, MobEffectInstance mobEffectInstance) {
        if (((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).addInternalIdToWidgetTooltips) {
            lines.add((Component)Component.m_237113_((String)BuiltInRegistries.f_256974_.m_7981_((Object)mobEffectInstance.m_19544_()).toString()).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }
}

