/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.items;

import com.talhanation.workers.Main;
import com.talhanation.workers.entities.MerchantEntity;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.common.ForgeSpawnEggItem;
import org.jetbrains.annotations.NotNull;

public class WorkersSpawnEgg
extends ForgeSpawnEggItem {
    private final Supplier<? extends EntityType<? extends Mob>> entityType;

    public WorkersSpawnEgg(Supplier<? extends EntityType<? extends Mob>> entityType, int primaryColor, int secondaryColor, Item.Properties properties) {
        super(entityType, primaryColor, secondaryColor, properties);
        this.entityType = entityType;
    }

    @NotNull
    public EntityType<?> m_43228_(CompoundTag compound) {
        CompoundTag entityTag;
        if (compound != null && compound.m_128425_("EntityTag", 10) && (entityTag = compound.m_128469_("EntityTag")).m_128425_("id", 8)) {
            return EntityType.m_20632_((String)entityTag.m_128461_("id")).orElse(this.entityType.get());
        }
        return this.entityType.get();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        EntityType<?> entitytype = this.m_43228_(stack.m_41783_());
        Entity entity = entitytype.m_20615_(world);
        CompoundTag entityTag = stack.m_41783_();
        if (entity instanceof MerchantEntity) {
            MerchantEntity merchant = (MerchantEntity)entity;
            if (entityTag != null) {
                ListTag trades;
                CompoundTag nbt = entityTag.m_128469_("EntityTag");
                if (nbt.m_128441_("Team")) {
                    boolean flag;
                    String s = nbt.m_128461_("Team");
                    PlayerTeam playerteam = merchant.m_20193_().m_6188_().m_83489_(s);
                    boolean bl = flag = playerteam != null && merchant.m_20193_().m_6188_().m_6546_(merchant.m_20149_(), playerteam);
                    if (!flag) {
                        Main.LOGGER.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", (Object)s);
                    }
                }
                String name = nbt.m_128461_("Name");
                merchant.m_6593_((Component)Component.m_237113_((String)name));
                ListTag tradeList = nbt.m_128437_("TradeInventory", 10);
                for (int i = 0; i < tradeList.size(); ++i) {
                    CompoundTag compoundnbt = tradeList.m_128728_(i);
                    int j = compoundnbt.m_128445_("TradeSlot") & 0xFF;
                    merchant.getTradeInventory().m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundnbt));
                }
                if (nbt.m_128441_("HorseUUID")) {
                    Optional<UUID> uuid = Optional.of(nbt.m_128342_("HorseUUID"));
                    merchant.setHorseUUID(uuid);
                }
                if (nbt.m_128441_("BoatUUID")) {
                    Optional<UUID> uuid = Optional.of(nbt.m_128342_("BoatUUID"));
                    merchant.setBoatUUID(uuid);
                }
                merchant.setTraveling(nbt.m_128471_("Traveling"));
                merchant.setAutoStartTravel(nbt.m_128471_("AutoStartTravel"));
                merchant.setReturning(nbt.m_128471_("Returning"));
                merchant.setCurrentWayPointIndex(nbt.m_128451_("CurrentWayPointIndex"));
                merchant.setReturningTime(nbt.m_128451_("ReturningTime"));
                merchant.setCurrentReturningTime(nbt.m_128451_("CurrentReturningTime"));
                merchant.setCreative(nbt.m_128471_("isCreative"));
                merchant.setIsDayCounted(nbt.m_128471_("isDayCounted"));
                BlockPos startPos = merchant.getNbtPosition(nbt, "CurrentWayPoint");
                if (startPos != null) {
                    merchant.setCurrentWayPoint(startPos);
                }
                ListTag waypointItems = nbt.m_128437_("WaypointItems", 10);
                for (int i = 0; i < waypointItems.size(); ++i) {
                    CompoundTag compoundnbt = waypointItems.m_128728_(i);
                    ItemStack itemStack = ItemStack.m_41712_((CompoundTag)compoundnbt);
                    merchant.WAYPOINT_ITEMS.add(itemStack);
                }
                ListTag waypoints = nbt.m_128437_("Waypoints", 10);
                for (int i = 0; i < waypoints.size(); ++i) {
                    CompoundTag compoundnbt = waypoints.m_128728_(i);
                    BlockPos pos1 = new BlockPos(compoundnbt.m_128451_("PosX"), compoundnbt.m_128451_("PosY"), compoundnbt.m_128451_("PosZ"));
                    merchant.WAYPOINTS.add(pos1);
                }
                ListTag limits = nbt.m_128437_("TradeLimits", 10);
                if (!limits.isEmpty()) {
                    for (int i = 0; i < 4; ++i) {
                        CompoundTag compoundnbt = limits.m_128728_(i);
                        int limit = compoundnbt.m_128451_("Limit");
                        merchant.getTradeLimits().set(i, limit);
                    }
                }
                if (!(trades = nbt.m_128437_("Trades", 10)).isEmpty()) {
                    for (int i = 0; i < 4; ++i) {
                        CompoundTag compoundnbt = trades.m_128728_(i);
                        int trade = compoundnbt.m_128451_("Trade");
                        merchant.getCurrentTrades().set(i, trade);
                    }
                }
                merchant.setState(nbt.m_128451_("State"));
                merchant.setTravelSpeedState(nbt.m_128451_("TravelSpeedState"));
                merchant.setSendInfo(nbt.m_128471_("InfoTravel"));
                ListTag listnbt = nbt.m_128437_("Items", 10);
                merchant.m_21530_();
                for (int i = 0; i < listnbt.size(); ++i) {
                    CompoundTag compoundnbt = listnbt.m_128728_(i);
                    int j = compoundnbt.m_128445_("Slot") & 0xFF;
                    if (j >= merchant.getInventory().m_6643_()) continue;
                    merchant.getInventory().m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundnbt));
                }
                merchant.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
                world.m_7967_((Entity)merchant);
                if (!context.m_43723_().m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6225_(context);
    }
}

