/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai;

import com.talhanation.workers.Main;
import com.talhanation.workers.Translatable;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.FishermanEntity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishermanAI
extends Goal {
    private final FishermanEntity fisherman;
    private int fishingTimer = 100;
    private int throwTimer = 0;
    private int fishingRange;
    private BlockPos fishingPos = null;
    private BlockPos coastPos;
    private Boat boat;
    private FishermanEntity.State state;
    private boolean DEBUG = false;
    private boolean messageNoFishingRod = false;
    private int timer;
    private byte fails;

    public FishermanAI(FishermanEntity fishermanEntity) {
        this.fisherman = fishermanEntity;
    }

    public boolean m_8036_() {
        return this.fisherman.getStartPos() != null;
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8056_() {
        this.coastPos = this.getCoastPos();
        if (this.coastPos == null) {
            this.coastPos = this.fisherman.getStartPos();
        }
        this.timer = 0;
        this.setWorkState(FishermanEntity.State.fromIndex(this.fisherman.getState()));
        super.m_8056_();
    }

    public void m_8037_() {
        if (this.DEBUG) {
            Main.LOGGER.info("timer: " + this.timer);
        }
        if (this.DEBUG) {
            Main.LOGGER.info("State: " + this.state);
        }
        switch (this.state) {
            case IDLE: {
                if (this.fisherman.getStartPos() == null || this.fisherman.getStatus() != AbstractWorkerEntity.Status.WORK) break;
                this.setWorkState(FishermanEntity.State.CALC_COAST);
                break;
            }
            case CALC_COAST: {
                if (this.fisherman.getStatus() != AbstractWorkerEntity.Status.WORK) {
                    this.setWorkState(FishermanEntity.State.STOPPING);
                }
                if (this.fisherman.m_20202_() != null) {
                    this.fisherman.m_8127_();
                }
                this.coastPos = this.getCoastPos();
                if (this.coastPos != null) {
                    this.setWorkState(FishermanEntity.State.MOVING_COAST);
                    break;
                }
                this.coastPos = this.fisherman.getStartPos();
                break;
            }
            case MOVING_COAST: {
                if (this.fisherman.getStatus() != AbstractWorkerEntity.Status.WORK) {
                    this.setWorkState(FishermanEntity.State.STOPPING);
                }
                if (this.fisherman.m_20202_() != null) {
                    this.fisherman.m_8127_();
                }
                if (this.coastPos == null) {
                    this.setWorkState(FishermanEntity.State.CALC_COAST);
                } else {
                    this.moveToPos(this.coastPos);
                }
                if (!this.coastPos.m_123314_((Vec3i)this.fisherman.m_20097_(), 3.0)) break;
                List list = this.fisherman.m_20193_().m_45976_(Boat.class, this.fisherman.m_20191_().m_82400_(8.0));
                list.removeIf(boat -> !boat.m_20197_().isEmpty() || boat.m_20078_().contains("smallships"));
                list.sort(Comparator.comparing(boatInList -> Float.valueOf(boatInList.m_20270_((Entity)this.fisherman))));
                if (!list.isEmpty()) {
                    this.boat = (Boat)list.get(0);
                    this.fishingRange = 40;
                    this.setWorkState(FishermanEntity.State.MOVING_TO_BOAT);
                } else {
                    this.fishingRange = 2;
                    this.setWorkState(FishermanEntity.State.FISHING);
                }
                this.fishingPos = this.findWaterBlocks();
                if (this.fishingPos != null) break;
                if (this.fisherman.m_269323_() != null) {
                    this.fisherman.tellPlayer(this.fisherman.m_269323_(), Translatable.TEXT_FISHER_NO_WATER);
                }
                this.coastPos = null;
                this.setWorkState(FishermanEntity.State.STOPPING);
                break;
            }
            case MOVING_TO_BOAT: {
                if (this.boat != null && this.boat.m_20197_().isEmpty()) {
                    if (this.fisherman.getStatus() != AbstractWorkerEntity.Status.WORK) {
                        this.setWorkState(FishermanEntity.State.STOPPING);
                    }
                    this.moveToPos(this.boat.m_20097_());
                    if (this.coastPos.m_123314_((Vec3i)this.fisherman.m_20097_(), 10.0)) {
                        this.fisherman.m_20329_((Entity)this.boat);
                    } else if (++this.timer > 200) {
                        this.setWorkState(FishermanEntity.State.STOPPING);
                        this.timer = 0;
                    }
                    if (this.boat.m_146895_() == null || !this.fisherman.equals(this.boat.m_146895_())) break;
                    this.fisherman.setSailPos(this.fishingPos);
                    this.setWorkState(FishermanEntity.State.SAILING);
                    break;
                }
                this.setWorkState(FishermanEntity.State.IDLE);
                break;
            }
            case SAILING: {
                if (this.fisherman.getStatus() != AbstractWorkerEntity.Status.WORK) {
                    this.setWorkState(FishermanEntity.State.STOPPING);
                }
                if (this.fishingPos == null) {
                    this.setWorkState(FishermanEntity.State.IDLE);
                    break;
                }
                double distance = this.fisherman.m_20275_(this.fishingPos.m_123341_(), this.fisherman.m_20186_(), this.fishingPos.m_123343_());
                if (distance < 30.0) {
                    this.setWorkState(FishermanEntity.State.FISHING);
                    break;
                }
                if (++this.timer <= 200) break;
                this.timer = 0;
                this.fails = (byte)(this.fails + 1);
                if (this.fails == 3) {
                    this.setWorkState(FishermanEntity.State.STOPPING);
                    this.timer = 0;
                    break;
                }
                if (this.fishingPos == null) {
                    if (this.fisherman.m_269323_() != null) {
                        this.fisherman.tellPlayer(this.fisherman.m_269323_(), Translatable.TEXT_FISHER_NO_WATER);
                    }
                    this.coastPos = null;
                    this.setWorkState(FishermanEntity.State.STOPPING);
                    break;
                }
                this.fishingPos = this.findWaterBlocks();
                this.fisherman.setSailPos(this.fishingPos);
                this.setWorkState(FishermanEntity.State.SAILING);
                break;
            }
            case FISHING: {
                if (this.fisherman.getStatus() != AbstractWorkerEntity.Status.WORK) {
                    this.setWorkState(FishermanEntity.State.STOPPING);
                }
                if (this.fishingPos == null) {
                    this.setWorkState(FishermanEntity.State.STOPPING);
                }
                if (!this.fisherman.hasMainToolInInv()) {
                    if (!this.messageNoFishingRod && this.fisherman.m_269323_() != null) {
                        this.fisherman.tellPlayer(this.fisherman.m_269323_(), Translatable.TEXT_NO_FISHING_ROD);
                        this.messageNoFishingRod = true;
                    }
                    this.fisherman.needsMainTool = true;
                }
                this.fishing();
                break;
            }
            case STOPPING: {
                if (this.coastPos != null) {
                    if (this.boat != null && this.boat.m_146895_() != null && this.fisherman.equals(this.boat.m_146895_())) {
                        this.fisherman.setSailPos(this.coastPos);
                    } else if (this.fisherman.needsToSleep()) {
                        this.setWorkState(FishermanEntity.State.SLEEP);
                    } else if (this.fisherman.needsToDeposit()) {
                        this.setWorkState(FishermanEntity.State.DEPOSIT);
                    } else if (this.fisherman.needsToGetFood()) {
                        this.setWorkState(FishermanEntity.State.UPKEEP);
                    } else {
                        this.moveToPos(this.coastPos);
                        this.fisherman.m_8127_();
                    }
                    double distance = this.fisherman.m_20275_(this.coastPos.m_123341_(), this.coastPos.m_123342_(), this.coastPos.m_123343_());
                    if (distance < 6.0) {
                        this.fisherman.m_8127_();
                        this.setWorkState(FishermanEntity.State.STOP);
                        break;
                    }
                    if (++this.timer <= 200) break;
                    this.fisherman.m_8127_();
                    this.setWorkState(FishermanEntity.State.STOP);
                    this.timer = 0;
                    break;
                }
                this.setWorkState(FishermanEntity.State.IDLE);
                break;
            }
            case STOP: {
                this.fisherman.m_8127_();
                if (this.fisherman.needsToSleep()) {
                    this.setWorkState(FishermanEntity.State.SLEEP);
                    break;
                }
                if (this.fisherman.needsToDeposit()) {
                    this.setWorkState(FishermanEntity.State.DEPOSIT);
                    break;
                }
                this.fisherman.walkTowards(this.coastPos, 1.0);
                double distance = this.fisherman.m_20275_(this.coastPos.m_123341_(), this.coastPos.m_123342_(), this.coastPos.m_123343_());
                if (!(distance < 5.5)) break;
                this.m_8041_();
                break;
            }
            case DEPOSIT: {
                this.fisherman.m_8127_();
                if (this.fisherman.needsToDeposit()) break;
                this.setWorkState(FishermanEntity.State.STOP);
                break;
            }
            case UPKEEP: {
                this.fisherman.m_8127_();
                if (this.fisherman.needsToGetFood()) break;
                this.setWorkState(FishermanEntity.State.STOP);
                break;
            }
            case SLEEP: {
                this.fisherman.m_8127_();
                if (this.fisherman.needsToSleep()) break;
                this.setWorkState(FishermanEntity.State.STOP);
            }
        }
    }

    private void setWorkState(@NotNull FishermanEntity.State state) {
        this.timer = 0;
        this.state = state;
        this.fisherman.setState(state.getIndex());
        if (state == FishermanEntity.State.IDLE) {
            this.fisherman.setSailPos(null);
        }
    }

    private void moveToPos(BlockPos pos) {
        if (pos != null) {
            if (!pos.m_123314_((Vec3i)this.fisherman.m_20097_(), 12.0)) {
                this.fisherman.walkTowards(pos, 1.0);
            }
            if (!pos.m_123314_((Vec3i)this.fisherman.m_20097_(), 2.0)) {
                this.fisherman.m_21566_().m_6849_((double)pos.m_123341_(), (double)this.fisherman.getStartPos().m_123342_(), (double)pos.m_123343_(), 1.0);
            }
        }
    }

    public void m_8041_() {
        this.fishingPos = null;
        this.fishingTimer = 0;
        this.resetTask();
        this.setWorkState(FishermanEntity.State.IDLE);
        super.m_8041_();
    }

    public void resetTask() {
        this.fisherman.m_21573_().m_26573_();
        this.fishingTimer = this.fisherman.m_217043_().m_188503_(600);
    }

    private BlockPos findWaterBlocks() {
        ArrayList<BlockPos> waterBlocks = new ArrayList<BlockPos>();
        Direction direction = this.fisherman.getFishingDirection();
        Direction directionR = direction.m_122427_();
        Direction directionL = direction.m_122428_();
        if (this.coastPos != null) {
            int i;
            double distance;
            BlockState targetBlock;
            BlockPos pos;
            int x;
            int length = this.getDistanceWithWater(this.coastPos, direction);
            int lengthR = this.getDistanceWithWater(this.coastPos, directionR);
            int lengthL = this.getDistanceWithWater(this.coastPos, directionL);
            int lengthB = this.getDistanceWithWater(this.coastPos, direction.m_122424_());
            block0: for (x = 0; x <= length; ++x) {
                pos = this.coastPos.m_5484_(direction, x);
                targetBlock = this.fisherman.m_20193_().m_8055_(pos);
                if (this.DEBUG) {
                    this.fisherman.m_20193_().m_7731_(pos.m_6630_(4), Blocks.f_50126_.m_49966_(), 3);
                }
                distance = this.fisherman.m_20275_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                if (!targetBlock.m_60713_(Blocks.f_49990_) || !(distance > (double)this.fishingRange)) continue;
                for (i = 0; i < 4; ++i) {
                    if (!this.fisherman.m_20193_().m_8055_(pos.m_6630_(i)).m_60795_() || i != 3) continue;
                    waterBlocks.add(pos);
                    continue block0;
                }
            }
            block2: for (x = 0; x <= lengthR; ++x) {
                pos = this.coastPos.m_5484_(directionR, x);
                targetBlock = this.fisherman.m_20193_().m_8055_(pos);
                if (this.DEBUG) {
                    this.fisherman.m_20193_().m_7731_(pos.m_6630_(4), Blocks.f_50126_.m_49966_(), 3);
                }
                distance = this.fisherman.m_20275_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                if (!targetBlock.m_60713_(Blocks.f_49990_) || !(distance > (double)this.fishingRange)) continue;
                for (i = 0; i < 4; ++i) {
                    if (!this.fisherman.m_20193_().m_8055_(pos.m_6630_(i)).m_60795_() || i != 3) continue;
                    waterBlocks.add(pos);
                    continue block2;
                }
            }
            block4: for (x = 0; x <= lengthL; ++x) {
                pos = this.coastPos.m_5484_(directionL, x);
                targetBlock = this.fisherman.m_20193_().m_8055_(pos);
                if (this.DEBUG) {
                    this.fisherman.m_20193_().m_7731_(pos.m_6630_(4), Blocks.f_50126_.m_49966_(), 3);
                }
                distance = this.fisherman.m_20275_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                if (!targetBlock.m_60713_(Blocks.f_49990_) || !(distance > (double)this.fishingRange)) continue;
                for (i = 0; i < 4; ++i) {
                    if (!this.fisherman.m_20193_().m_8055_(pos.m_6630_(i)).m_60795_() || i != 3) continue;
                    waterBlocks.add(pos);
                    continue block4;
                }
            }
            block6: for (x = 0; x <= lengthB; ++x) {
                pos = this.coastPos.m_5484_(direction.m_122424_(), x);
                targetBlock = this.fisherman.m_20193_().m_8055_(pos);
                if (this.DEBUG) {
                    this.fisherman.m_20193_().m_7731_(pos.m_6630_(4), Blocks.f_50126_.m_49966_(), 3);
                }
                distance = this.fisherman.m_20275_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                if (!targetBlock.m_60713_(Blocks.f_49990_) || !(distance > (double)this.fishingRange)) continue;
                for (i = 0; i < 4; ++i) {
                    if (!this.fisherman.m_20193_().m_8055_(pos.m_6630_(i)).m_60795_() || i != 3) continue;
                    waterBlocks.add(pos);
                    continue block6;
                }
            }
        }
        waterBlocks.sort(Comparator.comparing(this::getWaterDepth).reversed());
        if (this.fishingRange < 10) {
            if (!waterBlocks.isEmpty()) {
                ArrayList<BlockPos> validWaterSpots = new ArrayList<BlockPos>();
                for (BlockPos pos : waterBlocks) {
                    if (!this.isValidFishingSpot(pos, true)) continue;
                    validWaterSpots.add(pos);
                }
                BlockPos fishingSpot = validWaterSpots.isEmpty() && !waterBlocks.isEmpty() ? (BlockPos)waterBlocks.get(waterBlocks.size() / 2) : (BlockPos)validWaterSpots.get(0);
                if (this.DEBUG) {
                    this.fisherman.m_20193_().m_7731_(new BlockPos(fishingSpot.m_123341_(), fishingSpot.m_123342_() + 5, fishingSpot.m_123343_()), Blocks.f_50354_.m_49966_(), 3);
                }
                return fishingSpot;
            }
            return null;
        }
        if (!waterBlocks.isEmpty()) {
            BlockPos fishingSpot;
            ArrayList<BlockPos> validWaterSpots = new ArrayList<BlockPos>();
            for (BlockPos pos : waterBlocks) {
                if (!this.isValidFishingSpot(pos, false)) continue;
                validWaterSpots.add(pos);
            }
            if (validWaterSpots.isEmpty() && !waterBlocks.isEmpty()) {
                fishingSpot = (BlockPos)waterBlocks.get(waterBlocks.size() / 2);
            } else {
                validWaterSpots.sort(Comparator.comparing(this::getDistanceToFisherStartPos).reversed());
                fishingSpot = (BlockPos)validWaterSpots.get(validWaterSpots.size() / 2);
            }
            if (this.DEBUG) {
                this.fisherman.m_20193_().m_7731_(new BlockPos(fishingSpot.m_123341_(), fishingSpot.m_123342_() + 5, fishingSpot.m_123343_()), Blocks.f_50354_.m_49966_(), 3);
            }
            return fishingSpot;
        }
        return null;
    }

    private double getDistanceToFisherStartPos(BlockPos pos) {
        return this.fisherman.getStartPos().m_203198_((double)pos.m_123341_(), (double)this.fisherman.getStartPos().m_123342_(), (double)pos.m_123343_());
    }

    public void spawnFishingLoot() {
        int depth = this.fishingPos != null ? 1 + (this.getWaterDepth(this.fishingPos) + this.fishingRange) / 10 : 1;
        double time = EnchantmentHelper.m_44916_((ItemStack)this.fisherman.m_21120_(InteractionHand.MAIN_HAND));
        this.fishingTimer = (int)(500.0 - 100.0 * time + (double)(this.fisherman.m_217043_().m_188503_(1000) / depth));
        double luck = 0.1;
        double luckFromTool = EnchantmentHelper.m_44904_((ItemStack)this.fisherman.m_21120_(InteractionHand.MAIN_HAND));
        LootParams lootparams = new LootParams.Builder((ServerLevel)this.fisherman.m_20193_()).m_287286_(LootContextParams.f_81460_, (Object)this.fisherman.m_20182_()).m_287286_(LootContextParams.f_81463_, (Object)this.fisherman.m_21205_()).m_287286_(LootContextParams.f_81458_, (Object)this.fisherman).m_287239_((float)(luck + luckFromTool)).m_287235_(LootContextParamSets.f_81414_);
        LootTable loottable = this.fisherman.m_20193_().m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_78720_);
        ObjectArrayList list = loottable.m_287195_(lootparams);
        MinecraftServer server = this.fisherman.m_20194_();
        if (server == null) {
            return;
        }
        for (ItemStack itemstack : list) {
            this.fisherman.getInventory().m_19173_(itemstack);
        }
    }

    private void fishing() {
        if (this.fisherman.m_20202_() == null && !this.coastPos.m_123314_((Vec3i)this.fisherman.m_20097_(), 5.0)) {
            this.moveToPos(this.coastPos);
        }
        if (this.fishingPos != null) {
            this.fisherman.m_21563_().m_24950_((double)this.fishingPos.m_123341_(), (double)(this.fishingPos.m_123342_() + 1), (double)this.fishingPos.m_123343_(), 10.0f, (float)this.fisherman.m_8132_());
            if (this.throwTimer == 0) {
                this.fisherman.m_5496_(SoundEvents.f_11941_, 1.0f, 0.5f);
                this.fisherman.m_6674_(InteractionHand.MAIN_HAND);
                this.throwTimer = this.fisherman.m_217043_().m_188503_(400);
            }
            if (this.fishingTimer > 0) {
                --this.fishingTimer;
            }
            if (this.fishingTimer == 0) {
                this.spawnFishingLoot();
                this.fisherman.m_5496_(SoundEvents.f_11940_, 1.0f, 1.0f);
                this.fisherman.m_6674_(InteractionHand.MAIN_HAND);
                this.fisherman.increaseFarmedItems();
                this.fisherman.consumeToolDurability();
                this.resetTask();
            }
        }
        if (this.throwTimer > 0) {
            --this.throwTimer;
        }
    }

    private boolean isValidFishingSpot(BlockPos pos1, boolean coastFishing) {
        int range = coastFishing ? 2 : 4;
        for (int i = -range; i <= range; ++i) {
            for (int k = -range; k <= range; ++k) {
                BlockPos pos = pos1.m_7918_(i, 0, k);
                BlockState state = this.fisherman.m_20193_().m_8055_(pos);
                if (!state.m_60713_(Blocks.f_49990_)) continue;
                return true;
            }
        }
        return false;
    }

    private int getWaterDepth(BlockPos pos) {
        BlockState state;
        int depth = 0;
        for (int i = 0; i < 10 && (state = this.fisherman.m_20193_().m_8055_(pos.m_6625_(i))).m_60713_(Blocks.f_49990_); ++i) {
            ++depth;
        }
        return depth;
    }

    private BlockPos getCoastPos() {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int i = -10; i <= 10; ++i) {
            for (int k = -10; k <= 10; ++k) {
                BlockPos pos = this.fisherman.getStartPos().m_7918_(i, 0, k);
                BlockState state = this.fisherman.m_20193_().m_8055_(pos);
                BlockState targetBlockN = this.fisherman.m_20193_().m_8055_(pos.m_122012_());
                BlockState targetBlockE = this.fisherman.m_20193_().m_8055_(pos.m_122029_());
                BlockState targetBlockS = this.fisherman.m_20193_().m_8055_(pos.m_122019_());
                BlockState targetBlockW = this.fisherman.m_20193_().m_8055_(pos.m_122024_());
                if (!state.m_60713_(Blocks.f_49990_) || !targetBlockN.m_60713_(Blocks.f_49990_) && !targetBlockE.m_60713_(Blocks.f_49990_) && !targetBlockS.m_60713_(Blocks.f_49990_) && !targetBlockW.m_60713_(Blocks.f_49990_)) continue;
                list.add(pos);
            }
        }
        if (list.isEmpty()) {
            if (this.fisherman.m_269323_() != null) {
                this.fisherman.tellPlayer(this.fisherman.m_269323_(), Translatable.TEXT_FISHER_NO_WATER);
            }
            this.fisherman.clearStartPos();
            this.fisherman.m_8127_();
            this.m_8041_();
            return null;
        }
        list.sort(Comparator.comparing(blockPos -> blockPos.m_123331_((Vec3i)this.fisherman.getStartPos())));
        return (BlockPos)list.get(0);
    }

    private int getDistanceWithWater(BlockPos pos, Direction direction) {
        BlockState targetBlockN;
        int distance = 0;
        for (int i = 0; i < this.fishingRange && (targetBlockN = this.fisherman.m_20193_().m_8055_(pos.m_5484_(direction, i))).m_60713_(Blocks.f_49990_); ++i) {
            ++distance;
        }
        return distance;
    }

    @Nullable
    private BlockPos getWaterField() {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        int distanceNorth = Math.min(this.fishingRange, this.getDistanceWithWater(this.coastPos, Direction.NORTH));
        int distanceEast = Math.min(this.fishingRange, this.getDistanceWithWater(this.coastPos, Direction.EAST));
        int distanceSouth = Math.min(this.fishingRange, this.getDistanceWithWater(this.coastPos, Direction.SOUTH));
        int distanceWest = Math.min(this.fishingRange, this.getDistanceWithWater(this.coastPos, Direction.WEST));
        boolean isNorth = distanceNorth > distanceSouth;
        boolean isEast = distanceEast > distanceWest;
        int maxX = Math.max(distanceNorth, distanceSouth);
        int maxZ = Math.max(distanceEast, distanceWest);
        for (int x = 0; x < maxX; ++x) {
            for (int z = 0; z < maxZ; ++z) {
                int x1 = isNorth || !isEast ? x * -1 : x;
                int z1 = isNorth || isEast ? z * -1 : z;
                BlockPos pos = this.coastPos.m_7918_(x1, 0, z1);
                BlockState targetBlock = this.fisherman.m_20193_().m_8055_(pos);
                if (!targetBlock.m_60713_(Blocks.f_49990_)) continue;
                list.add(pos);
            }
        }
        list.sort(Comparator.comparing(blockPos -> blockPos.m_123331_((Vec3i)this.fisherman.getStartPos())));
        BlockPos pos = null;
        if (!list.isEmpty()) {
            int rdm = this.fisherman.m_217043_().m_188503_(list.size() / 2);
            int index = list.size() / 2 + rdm;
            if (index >= list.size()) {
                index = list.size() - 1;
            }
            pos = (BlockPos)list.get(index);
        }
        return pos;
    }
}

