/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.talhanation.workers.entities.AbstractInventoryEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;

public abstract class AbstractWorkersHumanRenderer<Type extends AbstractInventoryEntity>
extends MobRenderer<Type, PlayerModel<Type>> {
    public AbstractWorkersHumanRenderer(EntityRendererProvider.Context mgr) {
        super(mgr, (EntityModel)new PlayerModel(mgr.m_174023_(ModelLayers.f_171162_), false), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(mgr.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(mgr.m_174023_(ModelLayers.f_171165_)), mgr.m_266367_()));
        this.m_115326_((RenderLayer)new ArrowLayer(mgr, (LivingEntityRenderer)this));
        this.m_115326_((RenderLayer)new BeeStingerLayer((LivingEntityRenderer)this));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, mgr.m_234598_()));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, mgr.m_174027_(), mgr.m_234598_()));
    }

    public void render(AbstractInventoryEntity recruit, float p_117789_, float p_117790_, PoseStack p_117791_, MultiBufferSource p_117792_, int p_117793_) {
        this.setModelProperties(recruit);
        super.m_7392_((Mob)recruit, p_117789_, p_117790_, p_117791_, p_117792_, p_117793_);
    }

    private void setModelProperties(AbstractInventoryEntity recruit) {
        PlayerModel model = (PlayerModel)this.m_7200_();
        model.m_8009_(true);
        model.f_102809_.f_104207_ = true;
        model.f_103378_.f_104207_ = false;
        model.f_103376_.f_104207_ = false;
        model.f_103377_.f_104207_ = false;
        model.f_103374_.f_104207_ = false;
        model.f_103375_.f_104207_ = false;
        model.f_102817_ = recruit.m_6047_();
        HumanoidModel.ArmPose humanoidmodel$armpose = AbstractWorkersHumanRenderer.getArmPose(recruit, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose humanoidmodel$armpose1 = AbstractWorkersHumanRenderer.getArmPose(recruit, InteractionHand.OFF_HAND);
        if (humanoidmodel$armpose.m_102897_()) {
            HumanoidModel.ArmPose armPose = humanoidmodel$armpose1 = recruit.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
        }
        if (recruit.m_5737_() == HumanoidArm.RIGHT) {
            model.f_102816_ = humanoidmodel$armpose;
            model.f_102815_ = humanoidmodel$armpose1;
        } else {
            model.f_102816_ = humanoidmodel$armpose1;
            model.f_102815_ = humanoidmodel$armpose;
        }
    }

    private static HumanoidModel.ArmPose getArmPose(AbstractInventoryEntity recruit, InteractionHand hand) {
        ItemStack itemstack = recruit.m_21120_(hand);
        if (itemstack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (recruit.m_7655_() == hand && recruit.m_21212_() > 0) {
            UseAnim useanim = itemstack.m_41780_();
            if (useanim == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useanim == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useanim == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useanim == UseAnim.CROSSBOW && hand == recruit.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useanim == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
            if (recruit.m_7655_() == hand && recruit.m_21120_(hand) == Items.f_42740_.m_7968_()) {
                return HumanoidModel.ArmPose.ITEM;
            }
        } else if (!recruit.f_20911_ && itemstack.m_150930_(Items.f_42717_) && CrossbowItem.m_40932_((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }
}

