/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.module;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.apache.commons.lang3.tuple.Pair;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.building.block.QuarkVerticalSlabBlock;
import org.violetmoon.quark.content.building.block.WeatheringCopperVerticalSlabBlock;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.handler.ToolInteractionHandler;

@ZetaLoadModule(category="building")
public class VerticalSlabsModule
extends ZetaModule {
    @Config(description="Should Walls and Panes attempt to connect to the side of Vertical Slabs?")
    public static boolean allowSideConnections = true;
    public static boolean staticEnabled;
    public static TagKey<Block> verticalSlabTag;

    @LoadEvent
    public void postRegister(ZRegister.Post e) {
        ImmutableSet.of((Object)Blocks.f_50402_, (Object)Blocks.f_50600_, (Object)Blocks.f_50400_, (Object)Blocks.f_50410_, (Object)Blocks.f_50409_, (Object)Blocks.f_50468_, (Object[])new Block[]{Blocks.f_50407_, Blocks.f_50403_, Blocks.f_50385_, Blocks.f_50603_, Blocks.f_50648_, Blocks.f_50651_, Blocks.f_50401_, Blocks.f_50647_, Blocks.f_50645_, Blocks.f_50412_, Blocks.f_50398_, Blocks.f_50602_, Blocks.f_50646_, Blocks.f_50643_, Blocks.f_50383_, Blocks.f_50384_, Blocks.f_50469_, Blocks.f_50413_, Blocks.f_50601_, Blocks.f_50467_, Blocks.f_50406_, Blocks.f_50650_, Blocks.f_50644_, Blocks.f_50649_, Blocks.f_50405_, Blocks.f_50399_, Blocks.f_50404_, Blocks.f_50411_, Blocks.f_50733_, Blocks.f_50708_, Blocks.f_50738_, Blocks.f_50657_, Blocks.f_50658_, Blocks.f_152553_, Blocks.f_152557_, Blocks.f_152591_, Blocks.f_152561_, Blocks.f_220851_, Blocks.f_220849_, Blocks.f_271301_, Blocks.f_244004_, Blocks.f_244230_}).forEach(b -> new QuarkVerticalSlabBlock((Block)b, this));
        ArrayList copperVerticalSlabs = new ArrayList();
        ImmutableSet.of((Object)Pair.of((Object)Blocks.f_152570_, (Object)Blocks.f_152586_), (Object)Pair.of((Object)Blocks.f_152569_, (Object)Blocks.f_152585_), (Object)Pair.of((Object)Blocks.f_152568_, (Object)Blocks.f_152584_), (Object)Pair.of((Object)Blocks.f_152567_, (Object)Blocks.f_152583_)).forEach(p -> {
            WeatheringCopperVerticalSlabBlock cleanSlab = new WeatheringCopperVerticalSlabBlock((Block)p.getLeft(), this);
            QuarkVerticalSlabBlock waxedSlab = new QuarkVerticalSlabBlock((Block)p.getRight(), this);
            copperVerticalSlabs.add(cleanSlab);
            ToolInteractionHandler.registerWaxedBlock((ZetaModule)this, (Block)cleanSlab, (Block)waxedSlab);
        });
        WeatheringCopperVerticalSlabBlock first = (WeatheringCopperVerticalSlabBlock)((Object)copperVerticalSlabs.get(0));
        int max = copperVerticalSlabs.size();
        for (int i = 0; i < max; ++i) {
            WeatheringCopperVerticalSlabBlock next;
            WeatheringCopperVerticalSlabBlock prev = i > 0 ? (WeatheringCopperVerticalSlabBlock)((Object)copperVerticalSlabs.get(i - 1)) : null;
            WeatheringCopperVerticalSlabBlock current = (WeatheringCopperVerticalSlabBlock)((Object)copperVerticalSlabs.get(i));
            WeatheringCopperVerticalSlabBlock weatheringCopperVerticalSlabBlock = next = i < max - 1 ? (WeatheringCopperVerticalSlabBlock)((Object)copperVerticalSlabs.get(i + 1)) : null;
            if (prev != null) {
                ToolInteractionHandler.registerInteraction((ToolAction)ToolActions.AXE_SCRAPE, (Block)current, (Block)prev);
                current.prev = prev;
            }
            if (next != null) {
                current.next = next;
            }
            current.first = first;
        }
        Quark.ZETA.variantRegistry.slabs.forEach(b -> {
            if (b instanceof IVerticalSlabProvider) {
                IVerticalSlabProvider provider = (IVerticalSlabProvider)b;
                provider.getVerticalSlab((Block)b, this);
            } else {
                new QuarkVerticalSlabBlock((Block)b, this);
            }
        });
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        verticalSlabTag = BlockTags.create((ResourceLocation)new ResourceLocation("quark", "vertical_slabs"));
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.enabled;
    }

    public static BlockState messWithPaneState(LevelAccessor level, BlockPos ourPos, BlockState state) {
        if (!staticEnabled || !allowSideConnections) {
            return state;
        }
        for (Direction dir : PipeBlock.f_55154_.keySet()) {
            BlockState adjState;
            boolean should;
            BooleanProperty prop;
            boolean val;
            if (!dir.m_122434_().m_122479_() || (val = ((Boolean)state.m_61143_((Property)(prop = (BooleanProperty)PipeBlock.f_55154_.get(dir)))).booleanValue()) || !(should = VerticalSlabsModule.shouldWallConnect(adjState = level.m_8055_(ourPos.m_121945_(dir)), dir, false))) continue;
            state = (BlockState)state.m_61124_((Property)prop, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public static boolean shouldWallConnect(BlockState state, Direction dir, boolean prev) {
        Property prop;
        Optional<Property> opt;
        if (prev || !staticEnabled || !allowSideConnections) {
            return prev;
        }
        if (state.m_204336_(verticalSlabTag) && (opt = state.m_61147_().stream().filter(p -> p.m_61708_() == "type").findFirst()).isPresent() && (prop = opt.get()) instanceof EnumProperty) {
            EnumProperty ep = (EnumProperty)prop;
            Enum val = (Enum)((Object)state.m_61143_(prop));
            String name = val.name().toLowerCase(Locale.ROOT);
            Direction vsDir = Direction.m_122402_((String)name);
            return vsDir != null && vsDir.m_122434_() != dir.m_122434_();
        }
        return false;
    }

    public static interface IVerticalSlabProvider {
        public QuarkVerticalSlabBlock getVerticalSlab(Block var1, ZetaModule var2);
    }
}

