/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.util;

import io.github.tofodroid.mods.mimi.util.NoStackTraceException;
import java.util.UUID;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public abstract class TagUtils {
    public static UUID getUUIDOrDefault(ItemStack stack, String tag, UUID defaultVal) {
        try {
            return NbtUtils.m_129233_((Tag)TagUtils.getTagOrExcept(stack, tag));
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public static Integer getIntOrDefault(ItemStack stack, String tag, Integer defaultVal) {
        try {
            return ((NumericTag)TagUtils.getTagOrExcept(stack, tag)).m_7047_();
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public static Byte getByteOrDefault(ItemStack stack, String tag, Byte defaultVal) {
        try {
            return ((NumericTag)TagUtils.getTagOrExcept(stack, tag)).m_7063_();
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public static Boolean getBooleanOrDefault(ItemStack stack, String tag, Boolean defaultVal) {
        try {
            return ((NumericTag)TagUtils.getTagOrExcept(stack, tag)).m_7063_() != 0;
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public static String getStringOrDefault(ItemStack stack, String tag, String defaultVal) {
        try {
            return TagUtils.getTagOrExcept(stack, tag).m_7916_();
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public static void setOrRemoveUUID(ItemStack stack, String tag, UUID value) {
        if (value != null) {
            stack.m_41784_().m_128362_(tag, value);
        } else if (stack.m_41782_()) {
            stack.m_41783_().m_128473_(tag);
        }
    }

    public static void setOrRemoveInt(ItemStack stack, String tag, Integer value) {
        if (value != null) {
            stack.m_41784_().m_128405_(tag, value.intValue());
        } else if (stack.m_41782_()) {
            stack.m_41783_().m_128473_(tag);
        }
    }

    public static void setOrRemoveByte(ItemStack stack, String tag, Byte value) {
        if (value != null) {
            stack.m_41784_().m_128344_(tag, value.byteValue());
        } else if (stack.m_41782_()) {
            stack.m_41783_().m_128473_(tag);
        }
    }

    public static void setOrRemoveBoolean(ItemStack stack, String tag, Boolean value) {
        if (value != null) {
            stack.m_41784_().m_128379_(tag, value.booleanValue());
        } else if (stack.m_41782_()) {
            stack.m_41783_().m_128473_(tag);
        }
    }

    public static void setOrRemoveString(ItemStack stack, String tag, String value) {
        if (value != null) {
            stack.m_41784_().m_128359_(tag, value);
        } else if (stack.m_41782_()) {
            stack.m_41783_().m_128473_(tag);
        }
    }

    protected static Tag getTagOrExcept(ItemStack stack, String tag) throws NoStackTraceException {
        Tag nbt;
        if (stack != null && (nbt = stack.m_41784_().m_128423_(tag)) != null) {
            return nbt;
        }
        throw new NoStackTraceException("Tag not found");
    }

    public static Byte getByteOrDefault(ItemStack stack, String tag, Integer defaultVal) {
        return TagUtils.getByteOrDefault(stack, tag, defaultVal.byteValue());
    }

    public static Integer getIntOrDefault(ItemStack stack, String tag, Byte defaultVal) {
        return TagUtils.getIntOrDefault(stack, tag, defaultVal.intValue());
    }
}

