/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.server.midi.transmitter;

import io.github.tofodroid.mods.mimi.server.ServerExecutorProxy;
import java.util.function.Consumer;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;

public class ServerMidiInputReceiver
implements Receiver {
    private volatile Boolean open = true;
    private final Consumer<ShortMessage> handler;

    public ServerMidiInputReceiver(Consumer<ShortMessage> handler) {
        this.handler = handler;
    }

    @Override
    public synchronized void send(MidiMessage msg, long timeStamp) {
        if (this.open.booleanValue() && msg instanceof ShortMessage) {
            ServerExecutorProxy.executeOnServerThread(() -> this.handler.accept((ShortMessage)msg));
        }
    }

    @Override
    public void close() {
        this.open = false;
    }
}

